/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.ListMatcher;
import cypher.feature.parser.matchers.Matcher;
import cypher.feature.parser.matchers.ValueMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class UnorderedListMatcher
extends ListMatcher {
    public UnorderedListMatcher(List<ValueMatcher> list) {
        super(list);
    }

    @Override
    protected boolean sizeAndElements(int length, Function<Integer, Object> resultList) {
        if (this.list.size() == length) {
            ArrayList mutableCopy = new ArrayList(this.list);
            for (int i = 0; i < length; ++i) {
                Object value = resultList.apply(i);
                int index = UnorderedListMatcher.findMatch(mutableCopy, value);
                if (index < 0) {
                    return false;
                }
                mutableCopy.remove(index);
            }
            return true;
        }
        return false;
    }

    static <T> int findMatch(List<? extends Matcher<T>> list, T value) {
        for (int j = 0; j < list.size(); ++j) {
            if (!list.get(j).matches(value)) continue;
            return j;
        }
        return -1;
    }
}

