/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.MapMatcher;
import cypher.feature.parser.matchers.ValueMatcher;
import java.util.Set;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;

public class NodeMatcher
implements ValueMatcher {
    private final Set<String> labelNames;
    private final MapMatcher propertyMatcher;

    public NodeMatcher(Set<String> labelNames, MapMatcher properties) {
        this.labelNames = labelNames;
        this.propertyMatcher = properties;
    }

    @Override
    public boolean matches(Object value) {
        if (value instanceof Node) {
            Node node = (Node)value;
            int nbrOfLabels = 0;
            for (Label l : node.getLabels()) {
                if (!this.labelNames.contains(l.name())) {
                    return false;
                }
                ++nbrOfLabels;
            }
            return this.labelNames.size() == nbrOfLabels && this.propertyMatcher.matches(node.getAllProperties());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        this.labelNames.forEach(l -> sb.append(":").append((String)l));
        sb.append(" ").append(this.propertyMatcher).append(")");
        return sb.toString();
    }
}

