/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.ValueMatcher;
import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Function;

public class ListMatcher
implements ValueMatcher {
    protected final List<ValueMatcher> list;

    public ListMatcher(List<ValueMatcher> list) {
        this.list = list;
    }

    @Override
    public boolean matches(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof List) {
            List realList = (List)value;
            return this.sizeAndElements(realList.size(), realList::get);
        }
        if (value.getClass().isArray()) {
            return this.sizeAndElements(Array.getLength(value), integer -> Array.get(value, integer));
        }
        return false;
    }

    protected boolean sizeAndElements(int length, Function<Integer, Object> resultList) {
        if (this.list.size() == length) {
            for (int i = 0; i < length; ++i) {
                if (this.list.get(i).matches(resultList.apply(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.list.toString();
    }
}

