/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser.matchers;

import cypher.feature.parser.matchers.NodeMatcher;
import cypher.feature.parser.matchers.RelationshipMatcher;
import cypher.feature.parser.matchers.ValueMatcher;
import org.neo4j.graphdb.Relationship;

public class PathLinkMatcher
implements ValueMatcher {
    private final RelationshipMatcher relMatcher;
    private final NodeMatcher leftNode;
    private NodeMatcher rightNode;
    private final boolean outgoing;

    public PathLinkMatcher(RelationshipMatcher relMatcher, NodeMatcher leftNode, boolean outgoing) {
        this.relMatcher = relMatcher;
        this.leftNode = leftNode;
        this.outgoing = outgoing;
    }

    @Override
    public boolean matches(Object value) {
        if (value instanceof Relationship) {
            Relationship real = (Relationship)value;
            if (!this.relMatcher.matches(real)) {
                return false;
            }
            return !(this.outgoing ? !this.leftNode.matches(real.getStartNode()) || !this.rightNode.matches(real.getEndNode()) : !this.leftNode.matches(real.getEndNode()) || !this.rightNode.matches(real.getStartNode()));
        }
        return false;
    }

    public void setRightNode(NodeMatcher rightNode) {
        this.rightNode = rightNode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.leftNode).append(this.outgoing ? "-" : "<-");
        sb.append(this.relMatcher).append(this.outgoing ? "->" : "-");
        sb.append(this.rightNode);
        return sb.toString();
    }
}

