/*
 * Decompiled with CFR 0.152.
 */
package cypher.feature.parser;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import org.opencypher.tools.tck.parsing.generated.FeatureResultsBaseListener;
import org.opencypher.tools.tck.parsing.generated.FeatureResultsParser;

class CypherParametersCreator
extends FeatureResultsBaseListener {
    private Deque<Object> workload = new LinkedList<Object>();
    private Deque<Integer> listCounters = new LinkedList<Integer>();
    private Deque<Integer> mapCounters = new LinkedList<Integer>();
    private static final String INFINITY = "Inf";

    CypherParametersCreator() {
    }

    Object parsed() {
        return this.workload.pop();
    }

    public void enterInteger(FeatureResultsParser.IntegerContext ctx) {
        this.workload.push(Long.valueOf(ctx.getText()));
    }

    public void enterNullValue(FeatureResultsParser.NullValueContext ctx) {
        this.workload.push(null);
    }

    public void enterFloatingPoint(FeatureResultsParser.FloatingPointContext ctx) {
        String text = ctx.getText();
        if (text.contains(INFINITY)) {
            this.workload.push(Double.parseDouble(text + "inity"));
        } else {
            this.workload.push(Double.parseDouble(text));
        }
    }

    public void enterBool(FeatureResultsParser.BoolContext ctx) {
        this.workload.push(Boolean.valueOf(ctx.getText()));
    }

    public void enterString(FeatureResultsParser.StringContext ctx) {
        String text = ctx.getText();
        String substring = text.substring(1, text.length() - 1);
        String escaped = substring.replace("\\'", "'");
        this.workload.push(escaped);
    }

    public void enterList(FeatureResultsParser.ListContext ctx) {
        this.listCounters.push(0);
    }

    public void enterListElement(FeatureResultsParser.ListElementContext ctx) {
        this.listCounters.push(this.listCounters.pop() + 1);
    }

    public void exitList(FeatureResultsParser.ListContext ctx) {
        LinkedList<Object> temp = new LinkedList<Object>();
        int counter = this.listCounters.pop();
        for (int i = 0; i < counter; ++i) {
            temp.addFirst(this.workload.pop());
        }
        this.workload.push(temp);
    }

    public void enterPropertyMap(FeatureResultsParser.PropertyMapContext ctx) {
        this.mapCounters.push(0);
    }

    public void enterKeyValuePair(FeatureResultsParser.KeyValuePairContext ctx) {
        this.mapCounters.push(this.mapCounters.pop() + 1);
    }

    public void exitPropertyMap(FeatureResultsParser.PropertyMapContext ctx) {
        int counter = this.mapCounters.pop();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < counter; ++i) {
            Object value = this.workload.pop();
            String key = this.workload.pop().toString();
            map.put(key, value);
        }
        this.workload.push(map);
    }

    public void enterPropertyKey(FeatureResultsParser.PropertyKeyContext ctx) {
        this.workload.push(ctx.getText());
    }
}

