/*
 * Decompiled with CFR 0.152.
 */
package cypher.cucumber.db;

import cypher.cucumber.db.DeleteDirectory$;
import cypher.cucumber.db.GraphArchive;
import cypher.cucumber.db.GraphArchiveImporter;
import cypher.cucumber.db.GraphFileRepository;
import cypher.cucumber.db.GraphRecipe;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.io.Path;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u0013\t\u0019rI]1qQ\u0006\u00138\r[5wK2K'M]1ss*\u00111\u0001B\u0001\u0003I\nT!!\u0002\u0004\u0002\u0011\r,8-^7cKJT\u0011aB\u0001\u0007Gf\u0004\b.\u001a:\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011E\u0001!Q1A\u0005\u0002I\t!B]3q_NLGo\u001c:z+\u0005\u0019\u0002C\u0001\u000b\u0016\u001b\u0005\u0011\u0011B\u0001\f\u0003\u0005M9%/\u00199i\r&dWMU3q_NLGo\u001c:z\u0011!A\u0002A!A!\u0002\u0013\u0019\u0012a\u0003:fa>\u001c\u0018\u000e^8ss\u0002BQA\u0007\u0001\u0005\u0002m\ta\u0001P5oSRtDC\u0001\u000f\u001e!\t!\u0002\u0001C\u0003\u00123\u0001\u00071\u0003C\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004sK\u000eL\u0007/\u001a\u000b\u0003CU\u00022AI\u0013)\u001d\t!2%\u0003\u0002%\u0005\u0005YqI]1qQJ+7-\u001b9f\u0013\t1sE\u0001\u0006EKN\u001c'/\u001b9u_JT!\u0001\n\u0002\u0011\u0005%\u001adB\u0001\u0016$\u001d\tY#G\u0004\u0002-c9\u0011Q\u0006M\u0007\u0002])\u0011q\u0006C\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!!\u0002\u0004\n\u0005\r!\u0011B\u0001\u001b(\u00051\u0019\u0015\u0010\u001d5feN\u001b'/\u001b9u\u0011\u00151d\u00041\u00018\u0003\u0011q\u0017-\\3\u0011\u0005aZdBA\u0006:\u0013\tQD\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\r\u0011\u0015y\u0004\u0001\"\u0001A\u0003IaWM\u001c3G_J\u0014V-\u00193P]2LXk]3\u0015\u0005\u0005{EC\u0001\"K!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0002j_*\u0011q\tD\u0001\be\u00164G.Z2u\u0013\tIEI\u0001\u0003QCRD\u0007\"B&?\u0001\ba\u0015\u0001C5na>\u0014H/\u001a:\u0011\u0005Qi\u0015B\u0001(\u0003\u0005Q9%/\u00199i\u0003J\u001c\u0007.\u001b<f\u00136\u0004xN\u001d;fe\")\u0001K\u0010a\u0001#\u0006Q\u0011M]2iSZ,Wk]3\u0011\u0005IKfBA*W\u001d\t!B+\u0003\u0002V\u0005\u0005aqI]1qQ\u0006\u00138\r[5wK&\u0011q\u000bW\u0001\u0004+N,'BA+\u0003\u0013\tQ6L\u0001\u0005SK\u0006$wJ\u001c7z\u0015\t9\u0006\fC\u0003^\u0001\u0011\u0005a,\u0001\ft]\u0006\u00048\u000f[8u\r>\u0014X\u000b\u001d3bi&tw-V:f)\ty\u0016\r\u0006\u0002CA\")1\n\u0018a\u0002\u0019\")\u0001\u000b\u0018a\u0001EB\u0011!kY\u0005\u0003In\u0013\u0001\"\u00169eCRLgn\u001a\u0005\u0006M\u0002!IaZ\u0001\u000eY>\u001c\u0017\r^3Be\u000eD\u0017N^3\u0015\u0005!TGC\u0001\"j\u0011\u0015YU\rq\u0001M\u0011\u0015YW\r1\u0001m\u0003E\t'o\u00195jm\u0016$Um]2sSB$xN\u001d\t\u0003'6L!A\n-\t\u000b=\u0004A\u0011\u00029\u0002'Y\fG.\u001b3bi\u0016\f%o\u00195jm\u0016\u0004\u0016\r\u001e5\u0015\u0005\t\u000b\b\"\u0002:o\u0001\u0004\u0011\u0015aC1sG\"Lg/\u001a)bi\"\u0004")
public class GraphArchiveLibrary {
    private final GraphFileRepository repository;

    public GraphFileRepository repository() {
        return this.repository;
    }

    public GraphRecipe.Descriptor<GraphRecipe.CypherScript> recipe(String name) {
        return (GraphRecipe.Descriptor)this.repository().graphRecipeLoader().apply((Object)name);
    }

    public Path lendForReadOnlyUse(GraphArchive.Use.ReadOnly archiveUse, GraphArchiveImporter importer) {
        return this.locateArchive(archiveUse.archive(), importer);
    }

    public Path snapshotForUpdatingUse(GraphArchive.Use.Updating archiveUse, GraphArchiveImporter importer) {
        Path archivePath = this.locateArchive(archiveUse.archive(), importer);
        Path snapshotPath = this.repository().temporarySnapshotPath();
        Files.copy(archivePath.jfile().toPath(), snapshotPath.jfile().toPath(), new CopyOption[0]);
        return snapshotPath;
    }

    private Path locateArchive(GraphArchive.Descriptor archiveDescriptor, GraphArchiveImporter importer) {
        BoxedUnit boxedUnit;
        Path archivePath = this.repository().graphArchivePath(archiveDescriptor);
        Path statusFile = this.repository().graphArchiveImportStatusFile(archiveDescriptor);
        if (statusFile.exists()) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            DeleteDirectory$.MODULE$.now(archivePath);
            boolean x$1 = true;
            boolean x$2 = archivePath.createDirectory$default$1();
            archivePath.createDirectory(x$2, x$1);
            importer.importArchive(archiveDescriptor, archivePath);
            boxedUnit = statusFile.createFile(true);
        }
        return this.validateArchivePath(archivePath);
    }

    private Path validateArchivePath(Path archivePath) {
        if (archivePath.canRead()) {
            return archivePath;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Cannot read archive path: ").append((Object)archivePath.toString()).toString());
    }

    public GraphArchiveLibrary(GraphFileRepository repository) {
        this.repository = repository;
    }
}

