/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.synthesise.generator;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.cucumber.synthesise.generator.ParsedQuery;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.config.CypherConfiguration$;
import org.neo4j.cypher.internal.parser.AstParserFactory$;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.Neo4jCypherExceptionFactory;
import org.neo4j.graphdb.config.Setting;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005I3A!\u0003\u0006\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011\u001d\u0001\u0004A1A\u0005\nEBaA\u0013\u0001!\u0002\u0013\u0011\u0004\"B&\u0001\t\u0003a\u0005\"\u0002(\u0001\t\u0013y%!D\"bG\"Lgn\u001a)beN,'O\u0003\u0002\f\u0019\u0005Iq-\u001a8fe\u0006$xN\u001d\u0006\u0003\u001b9\t!b]=oi\",7/[:f\u0015\ty\u0001#\u0001\u0005dk\u000e,XNY3s\u0015\t\t\"#\u0001\u0004dsBDWM\u001d\u0006\u0003'Q\tQA\\3pi)T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0017a\u0002<feNLwN\u001c\t\u0003A\rj\u0011!\t\u0006\u0003EA\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003I\u0005\u0012QbQ=qQ\u0016\u0014h+\u001a:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002(SA\u0011\u0001\u0006A\u0007\u0002\u0015!)aD\u0001a\u0001?\u0005I\u0001O]3qCJ\u001cXM]\u000b\u0002YA\u0011\u0001%L\u0005\u0003]\u0005\u0012\u0011\u0002\u0015:f!\u0006\u00148/\u001a:\u0002\u0015A\u0014X\r]1sg\u0016\u0014\b%A\u0003dC\u000eDW-F\u00013!\u0011\u0019$\bP$\u000e\u0003QR!!\u000e\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00028q\u0005!Q\u000f^5m\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001b\u0003\u001b\r{gnY;se\u0016tG/T1q!\tiDI\u0004\u0002?\u0005B\u0011qHG\u0007\u0002\u0001*\u0011\u0011IF\u0001\u0007yI|w\u000e\u001e \n\u0005\rS\u0012A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011\u000e\u0011\u0005!B\u0015BA%\u000b\u0005-\u0001\u0016M]:fIF+XM]=\u0002\r\r\f7\r[3!\u0003\u0015\u0001\u0018M]:f)\t9U\nC\u0003\u0012\u000f\u0001\u0007A(A\u0004e_B\u000b'o]3\u0015\u0007\u001d\u0003\u0016\u000bC\u0003\u001f\u0011\u0001\u0007q\u0004C\u0003\u0012\u0011\u0001\u0007A\b")
public class CachingParser {
    private final CypherVersion version;
    private final PreParser preparser;
    private final ConcurrentMap<String, ParsedQuery> cache;

    private PreParser preparser() {
        return this.preparser;
    }

    private ConcurrentMap<String, ParsedQuery> cache() {
        return this.cache;
    }

    public ParsedQuery parse(String cypher) {
        return this.cache().computeIfAbsent(cypher, q -> this.doParse($this.version, (String)q));
    }

    private ParsedQuery doParse(CypherVersion version, String cypher) {
        ParsedQuery parsedQuery;
        try {
            String statement = this.preparser().preParse(cypher, version).statement();
            Statement ast = AstParserFactory$.MODULE$.apply(version).apply(statement, (CypherExceptionFactory)new Neo4jCypherExceptionFactory(statement, (Option)None$.MODULE$), (Option)None$.MODULE$).singleStatement();
            parsedQuery = new ParsedQuery(cypher, statement, ast);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\"Failed to parse query during scenario generation.\n             |Cypher version: " + version + "\n             |Query:\n             |" + cypher + "\n             |")), throwable);
        }
        return parsedQuery;
    }

    public CachingParser(CypherVersion version) {
        this.version = version;
        this.preparser = new PreParser(CypherConfiguration$.MODULE$.fromConfig(Config.defaults((Setting)GraphDatabaseInternalSettings.enable_experimental_cypher_versions, (Object)Boolean.TRUE)));
        this.cache = Caffeine.newBuilder().maximumSize(256L).build().asMap();
    }
}

