/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.glue.regular;

import cypher.features.ProcedureSignatureParser;
import java.io.Serializable;
import org.neo4j.cypher.cucumber.glue.regular.FeatureTestProcedure;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType;
import org.neo4j.cypher.internal.util.symbols.MapType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.NumberType;
import org.neo4j.cypher.internal.util.symbols.PathType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.procedure.Mode;
import org.neo4j.values.AnyValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;

public final class ProcedureBuilder$ {
    public static final ProcedureBuilder$ MODULE$ = new ProcedureBuilder$();

    public CallableProcedure.BasicProcedure createProcedure(String signatureString, AnyValue[][] output) {
        ProcedureSignature signature = this.asKernelSignature(new ProcedureSignatureParser().parse(signatureString));
        return new FeatureTestProcedure(signature, output);
    }

    private ProcedureSignature asKernelSignature(cypher.features.ProcedureSignature parsedSignature) {
        ProcedureSignature.Builder builder = ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName((String[])parsedSignature.namespace().toArray(ClassTag$.MODULE$.apply(String.class)), parsedSignature.name()));
        builder.mode(Mode.READ);
        parsedSignature.inputs().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                CypherType tpe = (CypherType)tuple2._2();
                return builder.in(name, MODULE$.asKernelType(tpe));
            }
            throw new MatchError((Object)tuple2);
        });
        Option<Seq<Tuple2<String, CypherType>>> option = parsedSignature.outputs();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq fields = (Seq)some.value();
            fields.foreach((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    CypherType tpe = (CypherType)tuple2._2();
                    return builder.out(name, MODULE$.asKernelType(tpe));
                }
                throw new MatchError((Object)tuple2);
            });
        } else if (None$.MODULE$.equals(option)) {
            builder.out(ProcedureSignature.VOID);
        } else {
            throw new MatchError(option);
        }
        return builder.build();
    }

    private Neo4jTypes.AnyType asKernelType(CypherType tpe) {
        CypherType cypherType = tpe;
        MapType mapType = package$.MODULE$.CTMap();
        CypherType cypherType2 = cypherType;
        if (!(mapType != null ? !mapType.equals(cypherType2) : cypherType2 != null)) {
            return Neo4jTypes.NTMap;
        }
        NodeType nodeType = package$.MODULE$.CTNode();
        CypherType cypherType3 = cypherType;
        if (!(nodeType != null ? !nodeType.equals(cypherType3) : cypherType3 != null)) {
            return Neo4jTypes.NTNode;
        }
        RelationshipType relationshipType = package$.MODULE$.CTRelationship();
        CypherType cypherType4 = cypherType;
        if (!(relationshipType != null ? !relationshipType.equals(cypherType4) : cypherType4 != null)) {
            return Neo4jTypes.NTRelationship;
        }
        PathType pathType = package$.MODULE$.CTPath();
        CypherType cypherType5 = cypherType;
        if (!(pathType != null ? !pathType.equals(cypherType5) : cypherType5 != null)) {
            return Neo4jTypes.NTPath;
        }
        if (cypherType instanceof ListType) {
            ListType listType = (ListType)cypherType;
            CypherType innerTpe = listType.innerType();
            return Neo4jTypes.NTList((Neo4jTypes.AnyType)this.asKernelType(innerTpe));
        }
        StringType stringType = package$.MODULE$.CTString();
        CypherType cypherType6 = cypherType;
        if (!(stringType != null ? !stringType.equals(cypherType6) : cypherType6 != null)) {
            return Neo4jTypes.NTString;
        }
        BooleanType booleanType = package$.MODULE$.CTBoolean();
        CypherType cypherType7 = cypherType;
        if (!(booleanType != null ? !booleanType.equals(cypherType7) : cypherType7 != null)) {
            return Neo4jTypes.NTBoolean;
        }
        NumberType numberType = package$.MODULE$.CTNumber();
        CypherType cypherType8 = cypherType;
        if (!(numberType != null ? !numberType.equals(cypherType8) : cypherType8 != null)) {
            return Neo4jTypes.NTNumber;
        }
        IntegerType integerType = package$.MODULE$.CTInteger();
        CypherType cypherType9 = cypherType;
        if (!(integerType != null ? !integerType.equals(cypherType9) : cypherType9 != null)) {
            return Neo4jTypes.NTInteger;
        }
        FloatType floatType = package$.MODULE$.CTFloat();
        CypherType cypherType10 = cypherType;
        if (!(floatType != null ? !floatType.equals(cypherType10) : cypherType10 != null)) {
            return Neo4jTypes.NTFloat;
        }
        throw new InternalError("Unexpected CypherType " + cypherType.getClass());
    }

    private ProcedureBuilder$() {
    }
}

