/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.cucumber.glue.regular;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.cucumber.scala.Scenario;
import java.io.Serializable;
import java.util.Collection;
import org.neo4j.cypher.cucumber.glue.regular.Expectations;
import org.neo4j.cypher.cucumber.glue.regular.TestConf;
import scala.Function1;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00194AAC\u0006\u00031!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006\u0003\u00047\u0001\u0001\u0006Ia\u000e\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u001c\t\u000b\u0019\u0003A\u0011I$\t\u000b\u0019\u0003A\u0011I+\t\u000ba\u0003A\u0011I-\t\u000ba\u0003A\u0011I.\t\u000bu\u0003A\u0011\u00020\u0003'\u0011Kh.Y7jG\u0016C\b/Z2uCRLwN\\:\u000b\u00051i\u0011a\u0002:fOVd\u0017M\u001d\u0006\u0003\u001d=\tAa\u001a7vK*\u0011\u0001#E\u0001\tGV\u001cW/\u001c2fe*\u0011!cE\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005Q)\u0012!\u00028f_RR'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011aC\u0005\u0003E-\u0011A\"\u0012=qK\u000e$\u0018\r^5p]N\fAaY8oMB\u0011\u0001%J\u0005\u0003M-\u0011\u0001\u0002V3ti\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%R\u0003C\u0001\u0011\u0001\u0011\u0015\u0019#\u00011\u0001%Q\t\u0011A\u0006\u0005\u0002.i5\taF\u0003\u00020a\u00051\u0011N\u001c6fGRT!!\r\u001a\u0002\r\u001d|wn\u001a7f\u0015\u0005\u0019\u0014aA2p[&\u0011QG\f\u0002\u0007\u0013:TWm\u0019;\u0002\u0011\u0019\f\u0017\u000e\u001c+bON\u00042\u0001O C\u001d\tIT\b\u0005\u0002;75\t1H\u0003\u0002=/\u00051AH]8pizJ!AP\u000e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015IA\u0002TKRT!AP\u000e\u0011\u0005a\u001a\u0015B\u0001#B\u0005\u0019\u0019FO]5oO\u0006Q\u0011n\u001a8pe\u0016$\u0016mZ:\u0002\u000b\u0019\f\u0017\u000e\\:\u0015\u0005![\u0005C\u0001\u000eJ\u0013\tQ5DA\u0004C_>dW-\u00198\t\u000b1+\u0001\u0019A'\u0002\u0011M\u001cWM\\1sS>\u0004\"AT*\u000e\u0003=S!\u0001\b)\u000b\u0005A\t&\"\u0001*\u0002\u0005%|\u0017B\u0001+P\u0005!\u00196-\u001a8be&|GC\u0001%W\u0011\u00159f\u00011\u00018\u0003\u0011!\u0018mZ:\u0002\r%<gn\u001c:f)\tA%\fC\u0003M\u000f\u0001\u0007Q\n\u0006\u0002I9\")q\u000b\u0003a\u0001o\u0005\t2oY3oCJLw\u000eS1t\u0003:LH+Y4\u0015\u0007!{\u0006\rC\u0003M\u0013\u0001\u0007Q\nC\u0003b\u0013\u0001\u0007q'\u0001\u0006uCJ<W\r\u001e+bOND#\u0001A2\u0011\u00055\"\u0017BA3/\u0005%\u0019\u0016N\\4mKR|g\u000e")
public final class DynamicExpectations
implements Expectations {
    private final Set<String> failTags;
    private final Set<String> ignoreTags;

    @Override
    public boolean fails(Scenario scenario) {
        return this.scenarioHasAnyTag(scenario, this.failTags);
    }

    @Override
    public boolean fails(Set<String> tags) {
        return tags.exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)this.failTags.contains((Object)elem)));
    }

    @Override
    public boolean ignore(Scenario scenario) {
        return this.scenarioHasAnyTag(scenario, this.ignoreTags);
    }

    @Override
    public boolean ignore(Set<String> tags) {
        return tags.exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)this.ignoreTags.contains((Object)elem)));
    }

    private boolean scenarioHasAnyTag(Scenario scenario, Set<String> targetTags) {
        Collection tags = scenario.getSourceTagNames();
        return !tags.isEmpty() && tags.stream().anyMatch(t -> targetTags.contains(t));
    }

    @Inject
    public DynamicExpectations(TestConf conf) {
        this.failTags = conf.expectFailureTags();
        this.ignoreTags = conf.ignoreTags();
    }
}

