/*
 * Decompiled with CFR 0.152.
 */
package cypher.features;

import cypher.features.Neo4jExecutionFailed;
import cypher.features.Phase$;
import org.neo4j.kernel.api.exceptions.Status;

public final class Neo4jExceptionToExecutionFailed$ {
    public static final Neo4jExceptionToExecutionFailed$ MODULE$ = new Neo4jExceptionToExecutionFailed$();
    private static final String INVALID_ELEMENT_ACCESS = "InvalidElementAccess";
    private static final String MAP_ELEMENT_ACCESS_BY_NON_STRING = "MapElementAccessByNonString";
    private static final String LIST_ELEMENT_ACCESS_BY_NON_INTEGER = "ListElementAccessByNonInteger";
    private static final String NESTED_AGGREGATION = "NestedAggregation";
    private static final String NEGATIVE_INTEGER_ARGUMENT = "NegativeIntegerArgument";
    private static final String DELETE_CONNECTED_NODE = "DeleteConnectedNode";
    private static final String REQUIRES_DIRECTED_RELATIONSHIP = "RequiresDirectedRelationship";
    private static final String INVALID_RELATIONSHIP_PATTERN = "InvalidRelationshipPattern";
    private static final String VARIABLE_ALREADY_BOUND = "VariableAlreadyBound";
    private static final String INVALID_ARGUMENT_TYPE = "InvalidArgumentType";
    private static final String INVALID_ARGUMENT_VALUE = "InvalidArgumentValue";
    private static final String NUMBER_OUT_OF_RANGE = "NumberOutOfRange";
    private static final String UNDEFINED_VARIABLE = "UndefinedVariable";
    private static final String VARIABLE_TYPE_CONFLICT = "VariableTypeConflict";
    private static final String RELATIONSHIP_UNIQUENESS_VIOLATION = "RelationshipUniquenessViolation";
    private static final String CREATING_VAR_LENGTH = "CreatingVarLength";
    private static final String INVALID_PARAMETER_USE = "InvalidParameterUse";
    private static final String INVALID_CLAUSE_COMPOSITION = "InvalidClauseComposition";
    private static final String FLOATING_POINT_OVERFLOW = "FloatingPointOverflow";
    private static final String PROPERTY_ACCESS_ON_NON_MAP = "PropertyAccessOnNonMap";
    private static final String INVALID_ARGUMENT_EXPRESSION = "InvalidArgumentExpression";
    private static final String INVALID_UNICODE_CHARACTER = "InvalidUnicodeCharacter";
    private static final String NON_CONSTANT_EXPRESSION = "NonConstantExpression";
    private static final String NO_SINGLE_RELATIONSHIP_TYPE = "NoSingleRelationshipType";
    private static final String INVALID_AGGREGATION = "InvalidAggregation";
    private static final String UNKNOWN_FUNCTION = "UnknownFunction";
    private static final String INVALID_NUMBER_LITERAL = "InvalidNumberLiteral";
    private static final String INVALID_UNICODE_LITERAL = "InvalidUnicodeLiteral";
    private static final String MERGE_READ_OWN_WRITES = "MergeReadOwnWrites";
    private static final String NO_EXPRESSION_ALIAS = "NoExpressionAlias";
    private static final String DIFFERENT_COLUMNS_IN_UNION = "DifferentColumnsInUnion";
    private static final String INVALID_DELETE = "InvalidDelete";
    private static final String INVALID_PROPERTY_TYPE = "InvalidPropertyType";
    private static final String COLUMN_NAME_CONFLICT = "ColumnNameConflict";
    private static final String NO_VARIABLES_IN_SCOPE = "NoVariablesInScope";
    private static final String DELETED_ENTITY_ACCESS = "DeletedEntityAccess";
    private static final String INVALID_ARGUMENT_PASSING_MODE = "InvalidArgumentPassingMode";
    private static final String INVALID_NUMBER_OF_ARGUMENTS = "InvalidNumberOfArguments";
    private static final String MISSING_PARAMETER = "MissingParameter";
    private static final String PROCEDURE_NOT_FOUND = "ProcedureNotFound";
    private static final String UNEXPECTED_SYNTAX = "UnexpectedSyntax";
    private static final String INTEGER_OVERFLOW = "IntegerOverflow";
    private static final String AMBIGUOUS_AGGREGATION_EXPRESSION = "AmbiguousAggregationExpression";
    private static final String DOTALL = "(?s)";
    private static final String POSITION_PATTERN = " \\(line .+, column .+ \\(offset: .+\\)\\).*";

    public String INVALID_ELEMENT_ACCESS() {
        return INVALID_ELEMENT_ACCESS;
    }

    public String MAP_ELEMENT_ACCESS_BY_NON_STRING() {
        return MAP_ELEMENT_ACCESS_BY_NON_STRING;
    }

    public String LIST_ELEMENT_ACCESS_BY_NON_INTEGER() {
        return LIST_ELEMENT_ACCESS_BY_NON_INTEGER;
    }

    public String NESTED_AGGREGATION() {
        return NESTED_AGGREGATION;
    }

    public String NEGATIVE_INTEGER_ARGUMENT() {
        return NEGATIVE_INTEGER_ARGUMENT;
    }

    public String DELETE_CONNECTED_NODE() {
        return DELETE_CONNECTED_NODE;
    }

    public String REQUIRES_DIRECTED_RELATIONSHIP() {
        return REQUIRES_DIRECTED_RELATIONSHIP;
    }

    public String INVALID_RELATIONSHIP_PATTERN() {
        return INVALID_RELATIONSHIP_PATTERN;
    }

    public String VARIABLE_ALREADY_BOUND() {
        return VARIABLE_ALREADY_BOUND;
    }

    public String INVALID_ARGUMENT_TYPE() {
        return INVALID_ARGUMENT_TYPE;
    }

    public String INVALID_ARGUMENT_VALUE() {
        return INVALID_ARGUMENT_VALUE;
    }

    public String NUMBER_OUT_OF_RANGE() {
        return NUMBER_OUT_OF_RANGE;
    }

    public String UNDEFINED_VARIABLE() {
        return UNDEFINED_VARIABLE;
    }

    public String VARIABLE_TYPE_CONFLICT() {
        return VARIABLE_TYPE_CONFLICT;
    }

    public String RELATIONSHIP_UNIQUENESS_VIOLATION() {
        return RELATIONSHIP_UNIQUENESS_VIOLATION;
    }

    public String CREATING_VAR_LENGTH() {
        return CREATING_VAR_LENGTH;
    }

    public String INVALID_PARAMETER_USE() {
        return INVALID_PARAMETER_USE;
    }

    public String INVALID_CLAUSE_COMPOSITION() {
        return INVALID_CLAUSE_COMPOSITION;
    }

    public String FLOATING_POINT_OVERFLOW() {
        return FLOATING_POINT_OVERFLOW;
    }

    public String PROPERTY_ACCESS_ON_NON_MAP() {
        return PROPERTY_ACCESS_ON_NON_MAP;
    }

    public String INVALID_ARGUMENT_EXPRESSION() {
        return INVALID_ARGUMENT_EXPRESSION;
    }

    public String INVALID_UNICODE_CHARACTER() {
        return INVALID_UNICODE_CHARACTER;
    }

    public String NON_CONSTANT_EXPRESSION() {
        return NON_CONSTANT_EXPRESSION;
    }

    public String NO_SINGLE_RELATIONSHIP_TYPE() {
        return NO_SINGLE_RELATIONSHIP_TYPE;
    }

    public String INVALID_AGGREGATION() {
        return INVALID_AGGREGATION;
    }

    public String UNKNOWN_FUNCTION() {
        return UNKNOWN_FUNCTION;
    }

    public String INVALID_NUMBER_LITERAL() {
        return INVALID_NUMBER_LITERAL;
    }

    public String INVALID_UNICODE_LITERAL() {
        return INVALID_UNICODE_LITERAL;
    }

    public String MERGE_READ_OWN_WRITES() {
        return MERGE_READ_OWN_WRITES;
    }

    public String NO_EXPRESSION_ALIAS() {
        return NO_EXPRESSION_ALIAS;
    }

    public String DIFFERENT_COLUMNS_IN_UNION() {
        return DIFFERENT_COLUMNS_IN_UNION;
    }

    public String INVALID_DELETE() {
        return INVALID_DELETE;
    }

    public String INVALID_PROPERTY_TYPE() {
        return INVALID_PROPERTY_TYPE;
    }

    public String COLUMN_NAME_CONFLICT() {
        return COLUMN_NAME_CONFLICT;
    }

    public String NO_VARIABLES_IN_SCOPE() {
        return NO_VARIABLES_IN_SCOPE;
    }

    public String DELETED_ENTITY_ACCESS() {
        return DELETED_ENTITY_ACCESS;
    }

    public String INVALID_ARGUMENT_PASSING_MODE() {
        return INVALID_ARGUMENT_PASSING_MODE;
    }

    public String INVALID_NUMBER_OF_ARGUMENTS() {
        return INVALID_NUMBER_OF_ARGUMENTS;
    }

    public String MISSING_PARAMETER() {
        return MISSING_PARAMETER;
    }

    public String PROCEDURE_NOT_FOUND() {
        return PROCEDURE_NOT_FOUND;
    }

    public String UNEXPECTED_SYNTAX() {
        return UNEXPECTED_SYNTAX;
    }

    public String INTEGER_OVERFLOW() {
        return INTEGER_OVERFLOW;
    }

    public String AMBIGUOUS_AGGREGATION_EXPRESSION() {
        return AMBIGUOUS_AGGREGATION_EXPRESSION;
    }

    public Neo4jExecutionFailed convert(String phase, Throwable t) {
        String string;
        Throwable throwable = t;
        if (!(throwable instanceof RuntimeException)) {
            throw t;
        }
        RuntimeException runtimeException = (RuntimeException)throwable;
        RuntimeException neo4jException = runtimeException;
        Status errorType = Status.statusCodeOf((Throwable)neo4jException);
        String errorTypeStr = errorType != null ? this.errorTypeMapping(errorType) : "";
        String msg = neo4jException.getMessage();
        String string2 = phase;
        String string3 = Phase$.MODULE$.compile();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = this.compileTimeDetail(msg);
        } else {
            String string5 = Phase$.MODULE$.runtime();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                string = this.runtimeDetail(msg);
            } else {
                throw new InternalError("Expected " + Phase$.MODULE$.compile() + " or " + Phase$.MODULE$.runtime() + " but got " + string2);
            }
        }
        String detail = string;
        return new Neo4jExecutionFailed(errorTypeStr, phase, detail, t);
    }

    private String errorTypeMapping(Status errorType) {
        Status status = errorType;
        Status.Procedure procedure = Status.Procedure.ProcedureNotFound;
        if (!(status != null ? !status.equals(procedure) : procedure != null)) {
            return "ProcedureError";
        }
        return errorType.toString();
    }

    private String runtimeDetail(String msg) {
        if (msg == null) {
            return "";
        }
        if (msg.matches("((SKIP: )|(LIMIT: )|(OF \\.\\.\\. ROWS: ))?Invalid input. ('-.+' is not a valid value|Got a negative integer)\\. Must be a ((non-negative)|(positive)) integer\\.[\\s.\\S]*")) {
            return this.NEGATIVE_INTEGER_ARGUMENT();
        }
        if (msg.matches("((SKIP: )|(LIMIT: )|(OF \\.\\.\\. ROWS: ))?Invalid input. ('.+' is not a valid value|Got a floating-point number)\\. Must be a ((non-negative)|(positive)) integer\\.[\\s.\\S]*")) {
            return this.INVALID_ARGUMENT_TYPE();
        }
        if (msg.matches("Type mismatch: expected a map but was .+")) {
            return this.PROPERTY_ACCESS_ON_NON_MAP();
        }
        if (msg.matches("Cannot access a map 'Map\\{.+\\}' by key '.+': Expected .+ to be a ((java.lang.String)|(org.neo4j.values.storable.TextValue)), but it was a .+")) {
            return this.MAP_ELEMENT_ACCESS_BY_NON_STRING();
        }
        if (msg.matches("Cannot access a list 'List\\{.+\\}' using a non-number index, got .+: Expected .+ to be a ((java.lang.Number)|(org.neo4j.values.storable.NumberValue)), but it was a .+")) {
            return this.LIST_ELEMENT_ACCESS_BY_NON_INTEGER();
        }
        if (msg.matches(".+ is not a collection or a map. Element access is only possible by performing a collection lookup using an integer index, or by performing a map lookup using a string key .+")) {
            return this.INVALID_ELEMENT_ACCESS();
        }
        if (msg.matches("\nElement access is only possible by performing a collection lookup using an integer index,\nor by performing a map lookup using a string key .+")) {
            return this.INVALID_ELEMENT_ACCESS();
        }
        if (msg.matches(".+ can not create a new node due to conflicts with( both)? existing( and missing)? unique nodes.*")) {
            return "CreateBlockedByConstraint";
        }
        if (msg.matches("Node\\(\\d+\\) already exists with label `.+` and property `.+` = .+")) {
            return "CreateBlockedByConstraint";
        }
        if (msg.matches("Cannot delete node\\<\\d+\\>, because it still has relationships. To delete this node, you must first delete its relationships.")) {
            return this.DELETE_CONNECTED_NODE();
        }
        if (msg.matches("Don't know how to compare that\\..+")) {
            return "IncomparableValues";
        }
        if (msg.matches("Cannot perform .+ on mixed types\\..+")) {
            return "IncomparableValues";
        }
        if (msg.matches("Invalid input '.+' is not a valid argument, must be a number in the range 0.0 to 1.0")) {
            return this.NUMBER_OUT_OF_RANGE();
        }
        if (msg.matches("Step argument to 'range\\(\\)' cannot be zero")) {
            return this.NUMBER_OUT_OF_RANGE();
        }
        if (msg.matches("Invalid input for function '.+': Expected a (.+), got: (.*)")) {
            return this.INVALID_ARGUMENT_VALUE();
        }
        if (msg.matches("The expression .+ should have been a node or a relationship, but got .+")) {
            return this.REQUIRES_DIRECTED_RELATIONSHIP();
        }
        if (msg.matches("((Node)|(Relationship)) with id \\d+ has been deleted in this transaction")) {
            return this.DELETED_ENTITY_ACCESS();
        }
        if (msg.matches("Expected parameter\\(s\\): .+")) {
            return this.MISSING_PARAMETER();
        }
        if (msg.matches("Cannot merge the following ((relationship)|(node)) because of null property value for .+")) {
            return this.MERGE_READ_OWN_WRITES();
        }
        if (msg.startsWith("Property values can only be of primitive types or arrays thereof")) {
            return this.INVALID_PROPERTY_TYPE();
        }
        return msg;
    }

    private String compileTimeDetail(String msg) {
        if (msg == null) {
            return "";
        }
        if (msg.matches("Invalid input. '-.+' is not a valid value. Must be a ((non-negative)|(positive)) integer\\.[\\s.\\S]*")) {
            return this.NEGATIVE_INTEGER_ARGUMENT();
        }
        if (msg.matches("Invalid input. '.+' is not a valid value. Must be a ((non-negative)|(positive)) integer\\.[\\s.\\S]*")) {
            return this.INVALID_ARGUMENT_TYPE();
        }
        if (msg.matches("Coercion of list to boolean is not allowed. Please use `NOT isEmpty\\(...\\)` instead.[\\s.\\S]*")) {
            return this.INVALID_ARGUMENT_TYPE();
        }
        if (msg.matches(this.semanticError("Can't use aggregate functions inside of aggregate functions\\."))) {
            return this.NESTED_AGGREGATION();
        }
        if (msg.matches("Can't create node `(\\w+)` with labels or properties here. The variable is already declared in this context")) {
            return this.VARIABLE_ALREADY_BOUND();
        }
        if (msg.matches("Can't create `\\w+` with properties or labels here. The variable is already declared in this context")) {
            return this.VARIABLE_ALREADY_BOUND();
        }
        if (msg.matches(this.semanticError("\\w+ already declared"))) {
            return this.VARIABLE_ALREADY_BOUND();
        }
        if (msg.matches(this.semanticError("The variable `\\w+` occurs in multiple quantified path patterns and needs to be renamed."))) {
            return this.VARIABLE_ALREADY_BOUND();
        }
        if (msg.matches(this.semanticError("The variable `\\w+` occurs both inside and outside a quantified path pattern and needs to be renamed."))) {
            return this.VARIABLE_ALREADY_BOUND();
        }
        if (msg.matches(this.semanticError("Only directed relationships are supported in ((CREATE)|(MERGE))"))) {
            return this.REQUIRES_DIRECTED_RELATIONSHIP();
        }
        if (msg.matches(this.DOTALL() + "Type mismatch: map key must be given as String, but was .+")) {
            return this.MAP_ELEMENT_ACCESS_BY_NON_STRING();
        }
        if (msg.matches(this.DOTALL() + "Type mismatch: expected .+ but was .+")) {
            return this.INVALID_ARGUMENT_TYPE();
        }
        if (msg.matches(this.semanticError("Variable `.+` not defined"))) {
            return this.UNDEFINED_VARIABLE();
        }
        if (msg.matches(this.semanticError(".+ not defined"))) {
            return this.UNDEFINED_VARIABLE();
        }
        if (msg.matches(this.semanticError("Aggregation column contains implicit grouping expressions. .+"))) {
            return this.AMBIGUOUS_AGGREGATION_EXPRESSION();
        }
        if (msg.matches(this.semanticError("PatternExpressions are not allowed to introduce new variables: .+"))) {
            return this.UNDEFINED_VARIABLE();
        }
        if (msg.matches(this.semanticError("Type mismatch: .+ defined with conflicting type .+ \\(expected .+\\)"))) {
            return this.VARIABLE_TYPE_CONFLICT();
        }
        if (msg.matches(this.semanticError("Cannot use the same relationship variable '.+' for multiple relationships"))) {
            return this.RELATIONSHIP_UNIQUENESS_VIOLATION();
        }
        if (msg.matches(this.semanticError("Cannot use the same relationship identifier '.+' for multiple relationships"))) {
            return this.RELATIONSHIP_UNIQUENESS_VIOLATION();
        }
        if (msg.matches(this.semanticError("Variable length relationships cannot be used in ((CREATE)|(MERGE))"))) {
            return this.CREATING_VAR_LENGTH();
        }
        if (msg.matches(this.semanticError("Parameter maps cannot be used in `((MATCH)|(MERGE))` patterns \\(use a literal map instead, e.g. `\\{id: \\$.+\\.id\\}`\\)"))) {
            return this.INVALID_PARAMETER_USE();
        }
        if (msg.matches(this.semanticError("Variable `.+` already declared"))) {
            return this.VARIABLE_ALREADY_BOUND();
        }
        if (msg.matches(this.semanticError("Invalid combination of UNION and UNION ALL"))) {
            return this.INVALID_CLAUSE_COMPOSITION();
        }
        if (msg.matches(this.semanticError("floating point number is too large"))) {
            return this.FLOATING_POINT_OVERFLOW();
        }
        if (msg.matches(this.semanticError("integer is too large"))) {
            return this.INTEGER_OVERFLOW();
        }
        if (msg.matches(this.semanticError("Argument to exists\\(\\.\\.\\.\\) is not a property or pattern"))) {
            return this.INVALID_ARGUMENT_EXPRESSION();
        }
        if (msg.startsWith("Invalid input '\u2014':")) {
            return this.INVALID_UNICODE_CHARACTER();
        }
        if (msg.matches(this.semanticError("Can't use aggregating expressions inside of expressions executing over lists"))) {
            return this.INVALID_AGGREGATION();
        }
        if (msg.matches(this.semanticError("Can't use aggregating expressions inside of expressions executing over collections"))) {
            return this.INVALID_AGGREGATION();
        }
        if (msg.matches(this.semanticError("It is not allowed to refer to variables in ((SKIP)|(LIMIT)|(OF \\.\\.\\. ROWS)).*"))) {
            return this.NON_CONSTANT_EXPRESSION();
        }
        if (msg.matches(this.semanticError("It is not allowed to use patterns in the expression for ((SKIP)|(LIMIT)|(OF \\.\\.\\. ROWS)).*"))) {
            return this.NON_CONSTANT_EXPRESSION();
        }
        if (msg.matches(this.semanticError("It is not allowed to refer to identifiers in ((SKIP)|(LIMIT)|(OF \\.\\.\\. ROWS))"))) {
            return this.NON_CONSTANT_EXPRESSION();
        }
        if (msg.matches("Can't use non-deterministic \\(random\\) functions inside of aggregate functions\\.")) {
            return this.NON_CONSTANT_EXPRESSION();
        }
        if (msg.matches(this.semanticError("A single (plain )?relationship type (like :\\\\w+)?must be specified for ((CREATE)|(MERGE))\\")) || msg.matches(this.semanticError("Exactly one relationship type must be specified for ((CREATE)|(MERGE))\\. Did you forget to prefix your relationship type with a \\'\\:\\'\\?"))) {
            return this.NO_SINGLE_RELATIONSHIP_TYPE();
        }
        if (msg.contains("\"MATCH (a)-[:LIKES*-2]->(c)\"")) {
            return this.INVALID_RELATIONSHIP_PATTERN();
        }
        if (msg.contains("\"MATCH (a)-[:LIKES..]->(c)\"")) {
            return this.INVALID_RELATIONSHIP_PATTERN();
        }
        if (msg.matches(this.semanticError("invalid literal number"))) {
            return this.INVALID_NUMBER_LITERAL();
        }
        if (msg.matches(this.semanticError("Unknown function '.+'"))) {
            return this.UNKNOWN_FUNCTION();
        }
        if (msg.matches(this.semanticError("Invalid input '.+': expected four hexadecimal digits specifying a unicode character"))) {
            return this.INVALID_UNICODE_LITERAL();
        }
        if (msg.matches(this.semanticError("Invalid input '.+'': expected four hexadecimal digits specifying a unicode character"))) {
            return this.INVALID_UNICODE_LITERAL();
        }
        if (msg.matches(this.semanticError("Invalid use of aggregating function count\\(\\.\\.\\.\\) in this context"))) {
            return this.INVALID_AGGREGATION();
        }
        if (msg.matches(this.semanticError("Cannot use aggregation in ORDER BY if there are no aggregate expressions in the preceding ((RETURN)|(WITH))"))) {
            return this.INVALID_AGGREGATION();
        }
        if (msg.matches(this.semanticError("Expression in .* must be aliased \\(use AS\\)"))) {
            return this.NO_EXPRESSION_ALIAS();
        }
        if (msg.matches(this.semanticError("All sub queries in an UNION must have the same return column names"))) {
            return this.DIFFERENT_COLUMNS_IN_UNION();
        }
        if (msg.matches(this.semanticError("DELETE doesn't support removing labels from a node. Try REMOVE."))) {
            return this.INVALID_DELETE();
        }
        if (msg.matches(this.semanticError("Multiple result columns with the same name are not supported"))) {
            return this.COLUMN_NAME_CONFLICT();
        }
        if (msg.matches(this.semanticError("RETURN \\* is not allowed when there are no variables in scope"))) {
            return this.NO_VARIABLES_IN_SCOPE();
        }
        if (msg.matches(this.semanticError("RETURN \\* is not allowed when there are no identifiers in scope"))) {
            return this.NO_VARIABLES_IN_SCOPE();
        }
        if (msg.matches(this.semanticError("Procedure call does not provide the required number of arguments.+"))) {
            return this.INVALID_NUMBER_OF_ARGUMENTS();
        }
        if (msg.matches(this.semanticError("Procedure call provides too many arguments.+"))) {
            return this.INVALID_NUMBER_OF_ARGUMENTS();
        }
        if (msg.matches("Expected a parameter named .+")) {
            return this.MISSING_PARAMETER();
        }
        if (msg.startsWith("Procedure call cannot take an aggregating function as argument, please add a 'WITH' to your statement.")) {
            return this.INVALID_AGGREGATION();
        }
        if (msg.startsWith("In a WITH/RETURN with DISTINCT or an aggregation, it is not possible to access variables declared before the WITH/RETURN")) {
            return this.UNDEFINED_VARIABLE();
        }
        if (msg.startsWith("Illegal aggregation expression(s) in order by")) {
            return this.AMBIGUOUS_AGGREGATION_EXPRESSION();
        }
        if (msg.startsWith("Procedure call inside a query does not support passing arguments implicitly")) {
            return this.INVALID_ARGUMENT_PASSING_MODE();
        }
        if (msg.matches("There is no procedure with the name `.+` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.")) {
            return this.PROCEDURE_NOT_FOUND();
        }
        if (msg.startsWith("Type mismatch for parameter")) {
            return this.INVALID_ARGUMENT_TYPE();
        }
        if (msg.matches(this.semanticError("Cannot use `YIELD \\*` outside standalone call"))) {
            return this.UNEXPECTED_SYNTAX();
        }
        if (msg.startsWith("A pattern expression should only be used in order to test the existence of a pattern")) {
            return this.UNEXPECTED_SYNTAX();
        }
        if (msg.startsWith("Invalid input")) {
            return this.UNEXPECTED_SYNTAX();
        }
        if (msg.startsWith("Query cannot conclude with")) {
            return this.INVALID_CLAUSE_COMPOSITION();
        }
        if (msg.startsWith("An Exists Expression cannot contain any updates")) {
            return this.INVALID_CLAUSE_COMPOSITION();
        }
        if (msg.startsWith("Only directed relationships are supported in INSERT")) {
            return this.REQUIRES_DIRECTED_RELATIONSHIP();
        }
        return msg.replaceAll(this.DOTALL() + this.POSITION_PATTERN(), "");
    }

    private String DOTALL() {
        return DOTALL;
    }

    private String POSITION_PATTERN() {
        return POSITION_PATTERN;
    }

    private String semanticError(String pattern) {
        return this.DOTALL() + pattern + this.POSITION_PATTERN();
    }

    private Neo4jExceptionToExecutionFailed$() {
    }
}

