/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public final class CursorUtils {
    private CursorUtils() {
        throw new UnsupportedOperationException();
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        assert (node >= -1L);
        return CursorUtils.nodeGetProperty(read, nodeCursor, node, propertyCursor, prop, true);
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        assert (node >= -1L);
        if (node == -1L) {
            return Values.NO_VALUE;
        }
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            if (throwOnDeleted && read.nodeDeletedInTransaction(node)) {
                throw new EntityNotFoundException(String.format("Node with id %d has been deleted in this transaction", node));
            }
            return Values.NO_VALUE;
        }
        return CursorUtils.nodeGetProperty(nodeCursor, propertyCursor, prop);
    }

    public static Value nodeGetProperty(NodeCursor nodeCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        nodeCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static Value[] entityGetProperties(EntityCursor entityCursor, PropertyCursor propertyCursor, int[] tokens) {
        assert (entityCursor.reference() != -1L);
        Value[] values = CursorUtils.emptyPropertyArray(tokens.length);
        entityCursor.properties(propertyCursor, PropertySelection.selection((int[])tokens));
        while (propertyCursor.next()) {
            int index = ArrayUtils.indexOf((int[])tokens, (int)propertyCursor.propertyKey());
            values[index] = propertyCursor.propertyValue();
        }
        return values;
    }

    public static Value[] emptyPropertyArray(int len) {
        Object[] values = new Value[len];
        Arrays.fill(values, Values.NO_VALUE);
        return values;
    }

    public static boolean nodeHasProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return false;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasProperty(nodeCursor, propertyCursor, prop);
    }

    public static boolean nodeHasProperty(NodeCursor nodeCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return false;
        }
        nodeCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static boolean nodeHasLabel(Read read, NodeCursor nodeCursor, long node, int label) {
        if (label == -1) {
            return false;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return nodeCursor.hasLabel(label);
    }

    public static boolean nodeHasLabels(Read read, NodeCursor nodeCursor, long node, int[] labels) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasLabels(nodeCursor, labels);
    }

    public static boolean nodeHasLabels(NodeCursor nodeCursor, int[] labels) {
        for (int label : labels) {
            if (label == -1) {
                return false;
            }
            if (nodeCursor.hasLabel(label)) continue;
            return false;
        }
        return true;
    }

    public static boolean nodeHasALabel(Read read, NodeCursor nodeCursor, long node) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return nodeCursor.hasLabel();
    }

    public static boolean nodeHasALabel(NodeCursor nodeCursor) {
        return nodeCursor.hasLabel();
    }

    public static boolean nodeHasAnyLabel(Read read, NodeCursor nodeCursor, long node, int[] labels) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return CursorUtils.nodeHasAnyLabel(nodeCursor, labels);
    }

    public static boolean nodeHasAnyLabel(NodeCursor cursor, int[] labels) {
        TokenSet nodeLabels = cursor.labels();
        for (int label : labels) {
            if (!nodeLabels.contains(label)) continue;
            return true;
        }
        return false;
    }

    public static boolean relationshipHasType(Read read, RelationshipScanCursor relationshipCursor, long relationship, int type) {
        if (type == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        return relationshipCursor.type() == type;
    }

    public static boolean relationshipHasTypes(Read read, RelationshipScanCursor relationshipCursor, long relationship, int[] types) {
        assert (types.length > 0);
        int typeToLookFor = types[0];
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == typeToLookFor) continue;
            return false;
        }
        if (typeToLookFor == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        return relationshipCursor.type() == typeToLookFor;
    }

    public static boolean relationshipHasTypes(RelationshipScanCursor relationshipCursor, int[] types) {
        assert (types.length > 0);
        int typeToLookFor = types[0];
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == typeToLookFor) continue;
            return false;
        }
        if (typeToLookFor == -1) {
            return false;
        }
        return relationshipCursor.type() == typeToLookFor;
    }

    public static RelationshipTraversalCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction, int[] types, CursorContext cursorContext) {
        read.singleNode(nodeId, node);
        if (!node.next()) {
            return Cursors.emptyTraversalCursor((Read)read);
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.OUTGOING -> RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types, (CursorContext)cursorContext);
            case Direction.INCOMING -> RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types, (CursorContext)cursorContext);
            case Direction.BOTH -> RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types, (CursorContext)cursorContext);
        };
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        return CursorUtils.relationshipGetProperty(read, relationshipCursor, relationship, propertyCursor, prop, true);
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        assert (relationship >= -1L);
        if (relationship == -1L) {
            return Values.NO_VALUE;
        }
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            if (throwOnDeleted && read.relationshipDeletedInTransaction(relationship)) {
                throw new EntityNotFoundException(String.format("Relationship with id %d has been deleted in this transaction", relationship));
            }
            return Values.NO_VALUE;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static Value relationshipGetProperty(RelationshipDataAccessor relationshipCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.selection((int)prop));
        return propertyCursor.next() ? propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public static boolean relationshipHasProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        if (prop == -1) {
            return false;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            return false;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static boolean relationshipHasProperty(RelationshipDataAccessor relationshipCursor, PropertyCursor propertyCursor, int prop) {
        if (prop == -1) {
            return false;
        }
        relationshipCursor.properties(propertyCursor, PropertySelection.onlyKeysSelection((int[])new int[]{prop}));
        return propertyCursor.next();
    }

    public static RelationshipTraversalCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction, CursorContext cursorContext) {
        return CursorUtils.nodeGetRelationships(read, cursors, node, nodeId, direction, null, cursorContext);
    }

    public static AnyValue propertyGet(String key, AnyValue container, Read read, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        if (container == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)container;
            return CursorUtils.nodeGetProperty(read, nodeCursor, node.id(), propertyCursor, dbAccess.propertyKey(key));
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)container;
            return CursorUtils.relationshipGetProperty(read, relationshipScanCursor, rel.id(), propertyCursor, dbAccess.propertyKey(key));
        }
        if (container instanceof MapValue) {
            MapValue map = (MapValue)container;
            return map.get(key);
        }
        if (container instanceof TemporalValue) {
            TemporalValue temporal = (TemporalValue)container;
            return temporal.get(key);
        }
        if (container instanceof DurationValue) {
            DurationValue duration = (DurationValue)container;
            return duration.get(key);
        }
        if (container instanceof PointValue) {
            PointValue point = (PointValue)container;
            return point.get(key);
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", container), null);
    }

    public static AnyValue[] propertiesGet(String[] keys, AnyValue container, Read read, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        if (container == Values.NO_VALUE) {
            return CursorUtils.emptyPropertyArray(keys.length);
        }
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)container;
            return CursorUtils.propertiesGet(CursorUtils.propertyKeys(keys, dbAccess), node.id(), read, nodeCursor, propertyCursor);
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)container;
            return CursorUtils.propertiesGet(CursorUtils.propertyKeys(keys, dbAccess), rel.id(), read, relationshipScanCursor, propertyCursor);
        }
        return CursorUtils.propertiesGet(keys, container);
    }

    public static AnyValue[] propertiesGet(String[] keys, AnyValue container) {
        if (container instanceof MapValue) {
            MapValue map = (MapValue)container;
            return CursorUtils.propertiesGet(keys, map);
        }
        if (container instanceof TemporalValue) {
            TemporalValue temporal = (TemporalValue)container;
            return CursorUtils.propertiesGet(keys, temporal);
        }
        if (container instanceof DurationValue) {
            DurationValue duration = (DurationValue)container;
            return CursorUtils.propertiesGet(keys, duration);
        }
        if (container instanceof PointValue) {
            PointValue point = (PointValue)container;
            return CursorUtils.propertiesGet(keys, point);
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", container), null);
    }

    public static Value[] propertiesGet(int[] keys, long node, Read read, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        read.singleNode(node, nodeCursor);
        if (nodeCursor.next()) {
            return CursorUtils.entityGetProperties((EntityCursor)nodeCursor, propertyCursor, keys);
        }
        if (read.nodeDeletedInTransaction(node)) {
            throw new EntityNotFoundException(String.format("Node with id %d has been deleted in this transaction", node));
        }
        return CursorUtils.emptyPropertyArray(keys.length);
    }

    public static Value[] propertiesGet(int[] keys, long rel, Read read, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        read.singleRelationship(rel, relCursor);
        if (relCursor.next()) {
            return CursorUtils.entityGetProperties((EntityCursor)relCursor, propertyCursor, keys);
        }
        if (read.relationshipDeletedInTransaction(rel)) {
            throw new EntityNotFoundException(String.format("Relationship with id %d has been deleted in this transaction", rel));
        }
        return CursorUtils.emptyPropertyArray(keys.length);
    }

    public static int[] propertyKeys(String[] keys, DbAccess dbAccess) {
        int[] tokens = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            tokens[i] = dbAccess.propertyKey(keys[i]);
        }
        return tokens;
    }

    public static AnyValue[] propertiesGet(String[] keys, MapValue map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }

    public static AnyValue[] propertiesGet(String[] keys, TemporalValue<?, ?> map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }

    public static AnyValue[] propertiesGet(String[] keys, DurationValue map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }

    public static AnyValue[] propertiesGet(String[] keys, PointValue map) {
        AnyValue[] result = new AnyValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            result[i] = map.get(keys[i]);
        }
        return result;
    }
}

