/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;

public interface Lengths
extends Measurable {
    public static final int NONE = -1;

    public boolean validatedAt(int var1);

    public boolean seenAt(int var1);

    public void markAsSeen(int var1);

    public void markAsValidated(int var1);

    public void clearSeen(int var1);

    public int maxSeen();

    public int nextSeen(int var1);

    public boolean isEmpty();

    public String renderSourceLengths();

    public boolean isWalkMode();

    public static Lengths trailMode() {
        return new TrailModeLengths();
    }

    public static Lengths walkMode() {
        return new WalkModeLengths();
    }

    public static final class TrailModeLengths
    extends BitSet
    implements Lengths {
        private static final int FACTOR = Type.values().length;
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TrailModeLengths.class) + HeapEstimator.sizeOfLongArray((int)1);

        @Override
        public boolean validatedAt(int length) {
            return this.get(length, Type.VALIDATED);
        }

        @Override
        public boolean seenAt(int length) {
            return this.get(length, Type.SEEN);
        }

        @Override
        public void markAsSeen(int length) {
            this.set(length, Type.SEEN);
        }

        @Override
        public void markAsValidated(int length) {
            this.set(length, Type.VALIDATED);
        }

        @Override
        public void clearSeen(int index) {
            this.clear(index, Type.SEEN);
        }

        @Override
        public int maxSeen() {
            return this.stream(Type.SEEN).max().orElse(-1);
        }

        @Override
        public int nextSeen(int start) {
            int offset = Type.SEEN.offset;
            int i = this.nextSetBit(start * FACTOR + offset);
            while (i != -1) {
                if (i % FACTOR == offset) {
                    return i / FACTOR;
                }
                i = this.nextSetBit(i + 1);
            }
            return -1;
        }

        @Override
        public String renderSourceLengths() {
            return this.stream(Type.SEEN).mapToObj(i -> i + (this.get(i, Type.VALIDATED) ? "\u2713" : "?")).collect(Collectors.joining(",", "{", "}"));
        }

        @Override
        public boolean isWalkMode() {
            return false;
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE;
        }

        private boolean get(int index, Type type) {
            return this.get(index * FACTOR + type.offset);
        }

        private void set(int index, Type type) {
            this.set(index * FACTOR + type.offset);
        }

        private void clear(int index, Type type) {
            this.clear(index * FACTOR + type.offset);
        }

        private IntStream stream(Type type) {
            return this.stream().filter(i -> i % FACTOR == type.offset).map(i -> i / FACTOR);
        }

        private static enum Type {
            SEEN(0),
            VALIDATED(1);

            private final int offset;

            private Type(int offset) {
                this.offset = offset;
            }
        }
    }

    public static class WalkModeLengths
    extends BitSet
    implements Lengths {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(WalkModeLengths.class);

        @Override
        public boolean validatedAt(int length) {
            return this.get(length);
        }

        @Override
        public void clearSeen(int index) {
            this.clear(index);
        }

        @Override
        public boolean seenAt(int length) {
            return this.get(length);
        }

        @Override
        public void markAsSeen(int length) {
            this.set(length);
        }

        @Override
        public void markAsValidated(int length) {
            assert (this.validatedAt(length));
        }

        @Override
        public int maxSeen() {
            return this.stream().max().orElse(-1);
        }

        @Override
        public int nextSeen(int start) {
            return this.nextSetBit(start);
        }

        @Override
        public String renderSourceLengths() {
            return this.toString();
        }

        @Override
        public boolean isWalkMode() {
            return true;
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE;
        }
    }
}

