/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.trackable.HeapTrackingArrayDeque;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.collection.trackable.HeapTrackingLongLongHashMap;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.memory.MemoryTracker;

public abstract class BFSPruningVarExpandCursor
extends DefaultCloseListenable
implements Cursor {
    final int[] types;
    final Read read;
    final int maxDepth;
    final NodeCursor nodeCursor;
    final RelationshipTraversalCursor relCursor;
    RelationshipTraversalCursor selectionCursor;
    final LongPredicate nodeFilter;
    final Predicate<RelationshipTraversalEntities> relFilter;
    final long soughtEndNode;
    protected boolean done = false;

    public static BFSPruningVarExpandCursor outgoingExpander(long startNode, int[] types, boolean includeStartNode, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor cursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long soughtEndNode, MemoryTracker memoryTracker) {
        return new OutgoingBFSPruningVarExpandCursor(startNode, types, includeStartNode, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, soughtEndNode, memoryTracker);
    }

    public static BFSPruningVarExpandCursor incomingExpander(long startNode, int[] types, boolean includeStartNode, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor cursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long endNode, MemoryTracker memoryTracker) {
        return new IncomingBFSPruningVarExpandCursor(startNode, types, includeStartNode, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, endNode, memoryTracker);
    }

    public static BFSPruningVarExpandCursor allExpander(long startNode, int[] types, boolean includeStartNode, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor cursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long soughtEndNode, MemoryTracker memoryTracker) {
        if (includeStartNode) {
            return new AllBFSPruningVarExpandCursorIncludingStartNode(startNode, types, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, soughtEndNode, memoryTracker);
        }
        return new AllBFSPruningVarExpandCursor(startNode, types, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, soughtEndNode, memoryTracker);
    }

    private BFSPruningVarExpandCursor(int[] types, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long soughtEndNode) {
        this.types = types;
        this.maxDepth = maxDepth;
        this.read = read;
        this.nodeCursor = nodeCursor;
        this.relCursor = relCursor;
        this.nodeFilter = nodeFilter;
        this.relFilter = relFilter;
        this.soughtEndNode = soughtEndNode;
        this.selectionCursor = Cursors.emptyTraversalCursor((Read)read);
    }

    protected final boolean validEndNode() {
        if (this.soughtEndNode == -1L) {
            return true;
        }
        if (this.soughtEndNode == this.endNode()) {
            this.done = true;
            return true;
        }
        return false;
    }

    public abstract long endNode();

    protected abstract void closeMore();

    public abstract int currentDepth();

    public void setTracer(KernelReadTracer tracer) {
        this.nodeCursor.setTracer(tracer);
        this.relCursor.setTracer(tracer);
    }

    public void removeTracer() {
        this.nodeCursor.removeTracer();
        this.relCursor.removeTracer();
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            if (this.selectionCursor != this.relCursor) {
                this.selectionCursor.close();
            }
            this.closeMore();
            this.selectionCursor = null;
        }
    }

    public boolean isClosed() {
        return this.selectionCursor == null;
    }

    private static class OutgoingBFSPruningVarExpandCursor
    extends DirectedBFSPruningVarExpandCursor {
        private OutgoingBFSPruningVarExpandCursor(long startNode, int[] types, boolean includeStartNode, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor cursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long soughtEndNode, MemoryTracker memoryTracker) {
            super(startNode, types, includeStartNode, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, soughtEndNode, memoryTracker);
        }

        @Override
        protected RelationshipTraversalCursor selectionCursor(RelationshipTraversalCursor relCursor, NodeCursor nodeCursor, int[] types) {
            return RelationshipSelections.outgoingCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (int[])types);
        }
    }

    private static class IncomingBFSPruningVarExpandCursor
    extends DirectedBFSPruningVarExpandCursor {
        private IncomingBFSPruningVarExpandCursor(long startNode, int[] types, boolean includeStartNode, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor cursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long soughtEndNode, MemoryTracker memoryTracker) {
            super(startNode, types, includeStartNode, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, soughtEndNode, memoryTracker);
        }

        @Override
        protected RelationshipTraversalCursor selectionCursor(RelationshipTraversalCursor relCursor, NodeCursor nodeCursor, int[] types) {
            return RelationshipSelections.incomingCursor((RelationshipTraversalCursor)relCursor, (NodeCursor)nodeCursor, (int[])types);
        }
    }

    private static class AllBFSPruningVarExpandCursorIncludingStartNode
    extends BFSPruningVarExpandCursor {
        private int currentDepth;
        private int lastSuccessfulDepth;
        private HeapTrackingLongHashSet prevFrontier;
        private HeapTrackingLongHashSet currFrontier;
        private final HeapTrackingLongHashSet seen;
        private LongIterator currentExpand;
        private final long startNode;
        private EmitState state = EmitState.SHOULD_EMIT;

        private AllBFSPruningVarExpandCursorIncludingStartNode(long startNode, int[] types, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor cursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long endNode, MemoryTracker memoryTracker) {
            super(types, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, endNode);
            this.startNode = startNode;
            this.prevFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
            this.currFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
            this.seen = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
            this.currentDepth = 0;
            this.lastSuccessfulDepth = -1;
        }

        public final boolean next() {
            if (this.done) {
                return false;
            }
            if (this.state == EmitState.SHOULD_EMIT) {
                this.expand(this.startNode);
                this.seen.add(this.startNode);
                this.state = EmitState.EMIT;
                this.lastSuccessfulDepth = this.currentDepth;
                if (this.validEndNode()) {
                    return true;
                }
            }
            if (this.state == EmitState.EMIT) {
                this.state = EmitState.EMITTED;
                ++this.currentDepth;
            }
            while (this.currentDepth <= this.maxDepth) {
                while (this.selectionCursor.next()) {
                    long other;
                    if (!this.relFilter.test(this.selectionCursor) || !this.seen.add(other = this.selectionCursor.otherNodeReference()) || !this.nodeFilter.test(other)) continue;
                    this.currFrontier.add(other);
                    this.lastSuccessfulDepth = this.currentDepth;
                    if (!this.validEndNode()) continue;
                    return true;
                }
                if (this.currentExpand != null && this.currentExpand.hasNext()) {
                    if (this.expand(this.currentExpand.next())) continue;
                    return false;
                }
                this.swapFrontiers();
                if (this.lastSuccessfulDepth < this.currentDepth) {
                    return false;
                }
                ++this.currentDepth;
            }
            return false;
        }

        @Override
        public int currentDepth() {
            return this.currentDepth;
        }

        @Override
        public long endNode() {
            return this.state == EmitState.EMIT ? this.startNode : this.selectionCursor.otherNodeReference();
        }

        private void swapFrontiers() {
            HeapTrackingLongHashSet tmp = this.prevFrontier;
            this.prevFrontier = this.currFrontier;
            this.currentExpand = this.prevFrontier.longIterator();
            this.currFrontier = tmp;
            this.currFrontier.clear();
        }

        private boolean expand(long nodeId) {
            this.read.singleNode(nodeId, this.nodeCursor);
            if (this.nodeCursor.next()) {
                this.selectionCursor = RelationshipSelections.allCursor((RelationshipTraversalCursor)this.relCursor, (NodeCursor)this.nodeCursor, (int[])this.types);
                return true;
            }
            return false;
        }

        @Override
        protected void closeMore() {
            this.seen.close();
            this.prevFrontier.close();
            this.currFrontier.close();
        }
    }

    private static class AllBFSPruningVarExpandCursor
    extends BFSPruningVarExpandCursor {
        private static final int START_NODE_EMITTED = -1;
        private static final int EMIT_START_NODE = -2;
        private static final int NO_LOOP = -3;
        private int loopCounter = -3;
        private int currentDepth;
        private HeapTrackingLongHashSet prevFrontier;
        private HeapTrackingLongHashSet currFrontier;
        private final HeapTrackingLongLongHashMap seenNodesWithAncestors;
        private LongIterator currentExpand;
        private final long startNode;

        private AllBFSPruningVarExpandCursor(long startNode, int[] types, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor cursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long soughtEndNode, MemoryTracker memoryTracker) {
            super(types, maxDepth, read, nodeCursor, cursor, nodeFilter, relFilter, soughtEndNode);
            this.startNode = startNode;
            this.prevFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
            this.currFrontier = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
            this.seenNodesWithAncestors = HeapTrackingCollections.newLongLongMap((MemoryTracker)memoryTracker);
            this.expand(startNode);
            this.currentDepth = 1;
        }

        public final boolean next() {
            if (this.done) {
                return false;
            }
            while (this.currentDepth <= this.maxDepth) {
                this.clearLoopCount();
                while (this.selectionCursor.next()) {
                    if (!this.relFilter.test(this.selectionCursor)) continue;
                    long origin = this.selectionCursor.originNodeReference();
                    long other = this.selectionCursor.otherNodeReference();
                    if (other == this.startNode) {
                        if (origin != other) continue;
                        assert (this.currentDepth == 1) : "currentDepth should always be 1 if we are expanding from the source";
                        this.loopCounter = 1;
                        continue;
                    }
                    long ancestorOfOther = this.seenNodesWithAncestors.getIfAbsent(other, -1L);
                    if (ancestorOfOther == -1L && this.nodeFilter.test(other)) {
                        long ancestor = this.currentDepth > 1 ? this.seenNodesWithAncestors.get(origin) : this.selectionCursor.reference();
                        this.seenNodesWithAncestors.put(other, ancestor);
                        this.currFrontier.add(other);
                        if (!this.validEndNode()) continue;
                        return true;
                    }
                    if (ancestorOfOther == -1L || origin == other || !this.shouldCheckForLoops()) continue;
                    if (this.currentDepth == 1) {
                        assert (origin == this.startNode) : "origin should always be the source node if we're at currentDepth = 1";
                        this.loopCounter = 2;
                        continue;
                    }
                    long ancestorOfOrigin = this.seenNodesWithAncestors.getIfAbsent(origin, -1L);
                    assert (ancestorOfOrigin != -1L) : "Every node is given an ancestor when it's found. We found origin in the previous level, so something is broken if it doesn't have an ancestor";
                    if (ancestorOfOrigin == ancestorOfOther) continue;
                    if (this.prevFrontier.contains(other)) {
                        this.loopCounter = this.currentDepth;
                        continue;
                    }
                    assert (this.currFrontier.contains(other)) : "The first node we find in a loop should lie in currFrontier or prevFrontier";
                    this.loopCounter = this.currentDepth + 1;
                }
                if (this.currentExpand != null && this.currentExpand.hasNext()) {
                    if (this.expand(this.currentExpand.next())) continue;
                    return false;
                }
                if (this.checkAndDecreaseLoopCount() && this.validEndNode()) {
                    return true;
                }
                if (!this.swapFrontiers()) {
                    if (this.loopDetected()) {
                        this.currentDepth += this.loopCounter;
                        if (this.currentDepth <= this.maxDepth) {
                            this.loopCounter = -2;
                            return this.validEndNode();
                        }
                        return false;
                    }
                    return false;
                }
                ++this.currentDepth;
            }
            return false;
        }

        @Override
        public int currentDepth() {
            return this.currentDepth;
        }

        @Override
        public long endNode() {
            return this.loopCounter == -2 ? this.startNode : this.selectionCursor.otherNodeReference();
        }

        private boolean shouldCheckForLoops() {
            return !this.loopDetected() && this.loopCounter != -1 || this.loopCounter > this.currentDepth;
        }

        private boolean swapFrontiers() {
            if (this.currFrontier.isEmpty()) {
                return false;
            }
            HeapTrackingLongHashSet tmp = this.prevFrontier;
            this.prevFrontier = this.currFrontier;
            this.currentExpand = this.prevFrontier.longIterator();
            this.currFrontier = tmp;
            this.currFrontier.clear();
            return true;
        }

        private boolean checkAndDecreaseLoopCount() {
            if (this.loopCounter == 1) {
                this.loopCounter = -2;
                return true;
            }
            if (this.loopCounter > 1) {
                --this.loopCounter;
            }
            return false;
        }

        private void clearLoopCount() {
            if (this.loopCounter == -2) {
                this.loopCounter = -1;
            }
        }

        private boolean loopDetected() {
            return this.loopCounter > -1;
        }

        private boolean expand(long nodeId) {
            this.read.singleNode(nodeId, this.nodeCursor);
            if (this.nodeCursor.next()) {
                this.selectionCursor = RelationshipSelections.allCursor((RelationshipTraversalCursor)this.relCursor, (NodeCursor)this.nodeCursor, (int[])this.types);
                return true;
            }
            return false;
        }

        @Override
        protected void closeMore() {
            this.seenNodesWithAncestors.close();
            this.prevFrontier.close();
            this.currFrontier.close();
        }
    }

    private static abstract class DirectedBFSPruningVarExpandCursor
    extends BFSPruningVarExpandCursor {
        private int currentDepth;
        private final long startNode;
        private final HeapTrackingLongHashSet seen;
        private final HeapTrackingArrayDeque<NodeState> queue;
        private EmitState state;

        private DirectedBFSPruningVarExpandCursor(long startNode, int[] types, boolean includeStartNode, int maxDepth, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, long endNode, MemoryTracker memoryTracker) {
            super(types, maxDepth, read, nodeCursor, relCursor, nodeFilter, relFilter, endNode);
            this.startNode = startNode;
            this.queue = HeapTrackingCollections.newArrayDeque((MemoryTracker)memoryTracker);
            this.seen = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker);
            if (this.currentDepth < maxDepth) {
                this.queue.offer((Object)new NodeState(startNode, this.currentDepth));
            }
            this.state = includeStartNode && (this.soughtEndNode == -1L || this.soughtEndNode == startNode) ? EmitState.SHOULD_EMIT : EmitState.NO;
        }

        public final boolean next() {
            if (this.done) {
                return false;
            }
            if (this.shouldIncludeStartNode()) {
                return true;
            }
            while (true) {
                if (this.selectionCursor.next()) {
                    long other;
                    if (!this.relFilter.test(this.selectionCursor) || !this.seen.add(other = this.selectionCursor.otherNodeReference()) || !this.nodeFilter.test(other)) continue;
                    if (this.currentDepth < this.maxDepth) {
                        this.queue.offer((Object)new NodeState(other, this.currentDepth));
                    }
                    if (!this.validEndNode()) continue;
                    return true;
                }
                NodeState next = (NodeState)this.queue.poll();
                if (next == null || !this.expand(next)) break;
            }
            return false;
        }

        @Override
        public int currentDepth() {
            return this.currentDepth;
        }

        @Override
        public long endNode() {
            return this.state == EmitState.EMIT ? this.startNode : this.selectionCursor.otherNodeReference();
        }

        @Override
        protected void closeMore() {
            this.seen.close();
            this.queue.close();
        }

        protected abstract RelationshipTraversalCursor selectionCursor(RelationshipTraversalCursor var1, NodeCursor var2, int[] var3);

        private boolean shouldIncludeStartNode() {
            if (this.state == EmitState.SHOULD_EMIT) {
                this.seen.add(this.startNode);
                this.state = EmitState.EMIT;
                return true;
            }
            if (this.state == EmitState.EMIT) {
                this.state = EmitState.EMITTED;
            }
            return false;
        }

        private boolean expand(NodeState next) {
            this.read.singleNode(next.nodeId(), this.nodeCursor);
            if (this.nodeCursor.next()) {
                this.selectionCursor = this.selectionCursor(this.relCursor, this.nodeCursor, this.types);
                this.currentDepth = next.depth() + 1;
                return true;
            }
            return false;
        }
    }

    private static enum EmitState {
        NO,
        SHOULD_EMIT,
        EMIT,
        EMITTED;

    }

    private record NodeState(long nodeId, int depth) {
    }
}

