/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.function.Function;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostStack;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalMatchModeFactory;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class PathTracer<Row>
extends PrefetchingIterator<Row> {
    private final PPBFSHooks hooks;
    private final SignpostStack stack;
    private NodeState sourceNode;
    private Function<SignpostStack, Row> toRow;
    private boolean shouldReturnSingleNodePath;
    private boolean ready = false;

    public boolean isSaturated() {
        return this.stack.target().isSaturated();
    }

    public PathTracer(MemoryTracker memoryTracker, TraversalMatchModeFactory tracker, PPBFSHooks hooks) {
        this.hooks = hooks;
        this.stack = new SignpostStack(memoryTracker, tracker.twoWaySignpostTracking(), hooks);
    }

    public void reset() {
        super.reset();
        this.ready = false;
        this.sourceNode = null;
        this.stack.reset();
    }

    public void initialize(Function<SignpostStack, Row> toRow, NodeState sourceNode, NodeState targetNode, int dgLength) {
        this.toRow = toRow;
        Preconditions.checkState((!this.ready ? 1 : 0) != 0, (String)"PathTracer was not reset before initializing");
        this.ready = true;
        this.sourceNode = sourceNode;
        this.stack.initialize(targetNode, dgLength);
        this.shouldReturnSingleNodePath = targetNode == sourceNode && dgLength == 0;
    }

    public boolean ready() {
        return this.ready;
    }

    private void popAndPrune() {
        TwoWaySignpost popped = this.stack.pop();
        if (popped == null) {
            return;
        }
        int sourceLength = this.stack.lengthFromSource();
        if (!popped.isValidatedAtLength(sourceLength) && !this.stack.isProtectedFromPruning()) {
            popped.pruneSourceLength(sourceLength);
        }
    }

    protected Row fetchNextOrNull() {
        if (!this.ready) {
            throw new IllegalStateException("PathTracer attempted to iterate without initializing.");
        }
        if (this.shouldReturnSingleNodePath && !this.isSaturated()) {
            this.shouldReturnSingleNodePath = false;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            return this.toRow.apply(this.stack);
        }
        while (this.stack.hasNext()) {
            if (!this.stack.pushNext()) {
                this.popAndPrune();
                continue;
            }
            TwoWaySignpost sourceSignpost = this.stack.headSignpost();
            if (this.stack.isValid() && !sourceSignpost.hasBeenTraced()) {
                sourceSignpost.setMinTargetDistance(this.stack.lengthToTarget(), PGPathPropagatingBFS.Phase.Tracing);
            }
            if (this.stack.canAbandonTraceBranch()) {
                this.hooks.skippingDuplicateRelationship(this.stack);
                this.stack.pop();
                continue;
            }
            if (sourceSignpost.prevNode != this.sourceNode || !this.stack.validate() || this.isSaturated()) continue;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            this.hooks.returnPath(this.stack);
            return this.toRow.apply(this.stack);
        }
        return null;
    }

    public void decrementTargetCount() {
        this.stack.target().decrementTargetCount();
    }
}

