/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal;

import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingLongHashSet;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.helpers.traversal.PathTraceStep;
import org.neo4j.internal.kernel.api.helpers.traversal.State;
import org.neo4j.memory.MemoryTracker;

abstract class BFS<STEPS>
implements AutoCloseable {
    static final int PATHS_TO_NODE_INIT_SIZE = 4;
    static final int LEVEL_INIT_CAPACITY = 16;
    static final int PATH_TRACE_DATA_INIT_CAPACITY = 64;
    long startNodeId;
    int currentDepth;
    final int[] types;
    final Read read;
    NodeCursor nodeCursor;
    RelationshipTraversalCursor relCursor;
    RelationshipTraversalCursor selectionCursor;
    final MemoryTracker memoryTracker;
    LongPredicate nodeFilter;
    Predicate<RelationshipTraversalEntities> relFilter;
    HeapTrackingLongHashSet currentLevel;
    LongIterator currentLevelItr;
    HeapTrackingLongHashSet nextLevel;
    BFS<STEPS> other;
    LongIterator intersectionIterator = null;
    final HeapTrackingLongObjectHashMap<STEPS> pathTraceData;
    final RelationshipTraversalCursorRetriever retriever;
    boolean closed = false;
    final boolean needOnlyOnePath;

    BFS(long startNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter, boolean needOnlyOnePath) {
        this.needOnlyOnePath = needOnlyOnePath;
        this.startNodeId = startNodeId;
        this.types = types;
        this.read = read;
        this.nodeCursor = nodeCursor;
        this.relCursor = relCursor;
        this.currentLevel = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker, (int)16);
        this.memoryTracker = memoryTracker;
        this.nodeFilter = nodeFilter;
        this.relFilter = relFilter;
        this.currentLevel.add(startNodeId);
        this.currentLevelItr = this.currentLevel.longIterator();
        this.nextLevel = HeapTrackingCollections.newLongSet((MemoryTracker)memoryTracker, (int)16);
        this.currentDepth = 0;
        this.pathTraceData = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker, (int)64);
        this.retriever = switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.OUTGOING -> RelationshipSelections::outgoingCursor;
            case Direction.INCOMING -> RelationshipSelections::incomingCursor;
            case Direction.BOTH -> RelationshipSelections::allCursor;
        };
    }

    abstract State searchForIntersectionInNextLevel();

    abstract LongIterator intersectionIterator();

    boolean hasSeenNode(long nodeId) {
        return this.pathTraceData.containsKey(nodeId);
    }

    void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
        this.startNodeId = startNodeId;
        this.nodeFilter = nodeFilter;
        this.relFilter = relFilter;
        this.currentLevel.clear();
        this.nextLevel.clear();
        this.pathTraceData.clear();
        this.currentLevel.add(startNodeId);
        this.currentLevelItr = this.currentLevel.longIterator();
        this.currentDepth = 0;
    }

    void resetWithStartNode(long startNodeId, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
        this.nodeCursor = nodeCursor;
        this.relCursor = relCursor;
        this.resetWithStartNode(startNodeId, nodeFilter, relFilter);
    }

    void setOther(BFS<STEPS> other) {
        this.other = other;
    }

    @Override
    public void close() {
        assert (!this.closed);
        this.pathTraceData.close();
        this.currentLevel.close();
        this.nextLevel.close();
        if (this.selectionCursor != this.relCursor && this.selectionCursor != null) {
            this.selectionCursor.close();
            this.selectionCursor = null;
        }
        this.closed = true;
    }

    void setTracer(KernelReadTracer tracer) {
        if (this.nodeCursor != null) {
            this.nodeCursor.setTracer(tracer);
        }
        if (this.relCursor != null) {
            this.relCursor.setTracer(tracer);
        }
        if (this.selectionCursor != null) {
            this.selectionCursor.setTracer(tracer);
        }
    }

    @FunctionalInterface
    static interface RelationshipTraversalCursorRetriever {
        public RelationshipTraversalCursor selectionCursor(RelationshipTraversalCursor var1, NodeCursor var2, int[] var3);
    }

    static class LazyBFS
    extends ManyPathsBFS {
        private long foundIntersectionNode = -1L;
        private long currentNode = -1L;

        public LazyBFS(long startNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter);
        }

        @Override
        public void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            this.foundIntersectionNode = -1L;
            this.currentNode = -1L;
            super.resetWithStartNode(startNodeId, nodeFilter, relFilter);
        }

        private void populateNextLevelOrStopWhenFoundFirstIntersectionNode() {
            while (this.currentLevelItr.hasNext()) {
                this.currentNode = this.currentLevelItr.next();
                this.read.singleNode(this.currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
                    throw new EntityNotFoundException(gql, "Node " + this.currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
                while (this.selectionCursor.next()) {
                    long foundNode;
                    if (!this.relFilter.test(this.selectionCursor) || !this.addNodeToNextLevelIfQualifies(this.currentNode, foundNode = this.selectionCursor.otherNodeReference()) || !this.other.currentLevel.contains(foundNode)) continue;
                    this.foundIntersectionNode = foundNode;
                    return;
                }
            }
        }

        private void advanceLevel() {
            HeapTrackingLongHashSet tmp = this.currentLevel;
            this.currentLevel = this.nextLevel;
            this.currentLevelItr = this.currentLevel.longIterator();
            this.nextLevel = tmp;
            this.nextLevel.clear();
            ++this.currentDepth;
        }

        @Override
        public State searchForIntersectionInNextLevel() {
            if (this.currentLevel.isEmpty()) {
                return State.THERE_IS_NO_INTERSECTION;
            }
            this.populateNextLevelOrStopWhenFoundFirstIntersectionNode();
            if (this.foundIntersectionNode != -1L) {
                ++this.currentDepth;
                return State.FOUND_INTERSECTION;
            }
            this.advanceLevel();
            return State.CAN_SEARCH_FOR_INTERSECTION;
        }

        private State findNextIntersectionNode() {
            while (true) {
                if (this.selectionCursor.next()) {
                    long foundNode;
                    if (!this.relFilter.test(this.selectionCursor) || !this.addNodeToNextLevelIfQualifies(this.currentNode, foundNode = this.selectionCursor.otherNodeReference()) || !this.other.currentLevel.contains(foundNode)) continue;
                    this.foundIntersectionNode = foundNode;
                    return State.FOUND_INTERSECTION;
                }
                if (!this.currentLevelItr.hasNext()) {
                    return State.EXHAUSTED_INTERSECTION;
                }
                this.currentNode = this.currentLevelItr.next();
                this.read.singleNode(this.currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
                    throw new EntityNotFoundException(gql, "Node " + this.currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
            }
        }

        @Override
        public LongIterator intersectionIterator() {
            return new LongIterator(){
                boolean consumedFirst = false;

                public long next() {
                    return foundIntersectionNode;
                }

                public boolean hasNext() {
                    if (!this.consumedFirst) {
                        this.consumedFirst = true;
                        return true;
                    }
                    pathTraceData.remove(foundIntersectionNode);
                    return this.findNextIntersectionNode() != State.EXHAUSTED_INTERSECTION;
                }
            };
        }
    }

    static class EagerBFS
    extends ManyPathsBFS {
        public EagerBFS(long startNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter);
        }

        private void fullyPopulateNextLevel() {
            while (this.currentLevelItr.hasNext()) {
                long currentNode = this.currentLevelItr.next();
                this.read.singleNode(currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
                    throw new EntityNotFoundException(gql, "Node " + currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
                while (this.selectionCursor.next()) {
                    if (!this.relFilter.test(this.selectionCursor)) continue;
                    long foundNode = this.selectionCursor.otherNodeReference();
                    this.addNodeToNextLevelIfQualifies(currentNode, foundNode);
                }
            }
        }

        private void advanceLevel() {
            HeapTrackingLongHashSet tmp = this.currentLevel;
            this.currentLevel = this.nextLevel;
            this.nextLevel = tmp;
            this.nextLevel.clear();
            ++this.currentDepth;
        }

        @Override
        public State searchForIntersectionInNextLevel() {
            if (this.currentLevel.isEmpty()) {
                return State.THERE_IS_NO_INTERSECTION;
            }
            this.fullyPopulateNextLevel();
            this.advanceLevel();
            this.currentLevelItr = this.currentLevel.longIterator();
            MutableLongSet intersection = this.currentLevel.intersect((LongSet)this.other.currentLevel);
            if (intersection.notEmpty()) {
                this.intersectionIterator = intersection.toImmutable().longIterator();
                return State.FOUND_INTERSECTION;
            }
            return State.CAN_SEARCH_FOR_INTERSECTION;
        }

        @Override
        public LongIterator intersectionIterator() {
            assert (this.intersectionIterator != null);
            return this.intersectionIterator;
        }
    }

    static abstract class ManyPathsBFS
    extends BFS<HeapTrackingArrayList<PathTraceStep>> {
        final HeapTrackingArrayList<HeapTrackingArrayList<PathTraceStep>> availableArrayLists;
        int availableArrayListsCurrentIndex = 0;
        int availableArrayListsEnd = 0;

        ManyPathsBFS(long startNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, false);
            this.availableArrayLists = HeapTrackingCollections.newArrayList((int)64, (MemoryTracker)memoryTracker);
        }

        boolean addNodeToNextLevelIfQualifies(long currentNode, long foundNode) {
            if (!this.hasSeenNode(foundNode) && this.nodeFilter.test(foundNode)) {
                HeapTrackingArrayList pathsToHere;
                this.nextLevel.add(foundNode);
                if (this.availableArrayListsCurrentIndex < this.availableArrayListsEnd) {
                    pathsToHere = (HeapTrackingArrayList)this.availableArrayLists.get(this.availableArrayListsCurrentIndex++);
                    pathsToHere.clear();
                } else {
                    pathsToHere = HeapTrackingCollections.newArrayList((int)4, (MemoryTracker)this.memoryTracker);
                    this.availableArrayLists.add((Object)pathsToHere);
                }
                pathsToHere.add((Object)new PathTraceStep(this.selectionCursor.reference(), currentNode));
                this.pathTraceData.put(foundNode, (Object)pathsToHere);
                return true;
            }
            if (!this.needOnlyOnePath && this.nextLevel.contains(foundNode)) {
                ((HeapTrackingArrayList)this.pathTraceData.get(foundNode)).add((Object)new PathTraceStep(this.selectionCursor.reference(), currentNode));
                return true;
            }
            return false;
        }

        @Override
        void resetWithStartNode(long startNodeId, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            super.resetWithStartNode(startNodeId, nodeCursor, relCursor, nodeFilter, relFilter);
            this.availableArrayListsCurrentIndex = 0;
            this.availableArrayListsEnd = this.availableArrayLists.size();
        }

        @Override
        public void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            super.resetWithStartNode(startNodeId, nodeFilter, relFilter);
            this.availableArrayListsCurrentIndex = 0;
            this.availableArrayListsEnd = this.availableArrayLists.size();
        }

        @Override
        public void close() {
            this.availableArrayLists.forEach(HeapTrackingArrayList::close);
            this.availableArrayLists.close();
            super.close();
        }
    }

    static class SinglePathBFS
    extends BFS<PathTraceStep> {
        private long foundIntersectionNode = -1L;

        SinglePathBFS(long startNodeId, int[] types, Direction direction, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            super(startNodeId, types, direction, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, true);
        }

        @Override
        State searchForIntersectionInNextLevel() {
            if (this.currentLevel.size() == 0) {
                return State.THERE_IS_NO_INTERSECTION;
            }
            this.populateNextLevelOrStopWhenFoundFirstIntersectionNode();
            if (this.foundIntersectionNode != -1L) {
                ++this.currentDepth;
                return State.FOUND_INTERSECTION;
            }
            this.advanceLevel();
            return State.CAN_SEARCH_FOR_INTERSECTION;
        }

        @Override
        LongIterator intersectionIterator() {
            return new LongIterator(){
                boolean consumedFirst = false;

                public long next() {
                    return foundIntersectionNode;
                }

                public boolean hasNext() {
                    if (!this.consumedFirst) {
                        this.consumedFirst = true;
                        return true;
                    }
                    return false;
                }
            };
        }

        private boolean addNodeToNextLevelIfQualifies(long currentNode, long foundNode) {
            if (this.hasSeenNode(foundNode) || !this.nodeFilter.test(foundNode)) {
                return false;
            }
            this.nextLevel.add(foundNode);
            this.pathTraceData.put(foundNode, (Object)new PathTraceStep(this.selectionCursor.reference(), currentNode));
            return true;
        }

        private void populateNextLevelOrStopWhenFoundFirstIntersectionNode() {
            while (this.currentLevelItr.hasNext()) {
                long currentNode = this.currentLevelItr.next();
                this.read.singleNode(currentNode, this.nodeCursor);
                if (!this.nodeCursor.next()) {
                    ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
                    throw new EntityNotFoundException(gql, "Node " + currentNode + " was unexpectedly deleted");
                }
                this.selectionCursor = this.retriever.selectionCursor(this.relCursor, this.nodeCursor, this.types);
                while (this.selectionCursor.next()) {
                    long foundNode;
                    if (!this.relFilter.test(this.selectionCursor) || !this.addNodeToNextLevelIfQualifies(currentNode, foundNode = this.selectionCursor.otherNodeReference()) || !this.other.currentLevel.contains(foundNode)) continue;
                    this.foundIntersectionNode = foundNode;
                    return;
                }
            }
        }

        private void advanceLevel() {
            HeapTrackingLongHashSet tmp = this.currentLevel;
            this.currentLevel = this.nextLevel;
            this.currentLevelItr = this.currentLevel.longIterator();
            this.nextLevel = tmp;
            this.nextLevel.clear();
            ++this.currentDepth;
        }

        @Override
        void resetWithStartNode(long startNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalEntities> relFilter) {
            this.foundIntersectionNode = -1L;
            super.resetWithStartNode(startNodeId, nodeFilter, relFilter);
        }
    }
}

