/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.io.Serializable;
import java.util.Iterator;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.map.primitive.MutableLongIntMap;
import org.github.jamm.Unmetered;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.memory.DefaultScopedMemoryTracker;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.util.SingleDegree;

public class CachingExpandInto
extends DefaultCloseListenable {
    static final long CACHING_EXPAND_INTO_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(CachingExpandInto.class) + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE;
    static final long EXPAND_INTO_SELECTION_CURSOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ExpandIntoSelectionCursor.class);
    static final long FROM_CACHE_SELECTION_CURSOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(FromCachedSelectionCursor.class);
    private static final int EXPENSIVE_DEGREE = -1;
    private final RelationshipCache relationshipCache;
    private final NodeDegreeCache degreeCache;
    @Unmetered
    private final Read read;
    @Unmetered
    private final ReadableTransactionState txState;
    @Unmetered
    private final Direction direction;
    private MemoryTracker scopedMemoryTracker;
    private static final int DEFAULT_CAPACITY = 100000;

    public CachingExpandInto(QueryContext context, Direction direction, MemoryTracker memoryTracker) {
        this(context, direction, memoryTracker, 100000);
    }

    public CachingExpandInto(QueryContext context, Direction direction, MemoryTracker memoryTracker, int capacity) {
        this.scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        this.scopedMemoryTracker.allocateHeap(CACHING_EXPAND_INTO_SHALLOW_SIZE);
        this.read = context.getRead();
        this.txState = context.getTransactionStateOrNull();
        this.direction = direction;
        this.relationshipCache = new RelationshipCache(capacity, this.scopedMemoryTracker);
        this.degreeCache = new NodeDegreeCache(capacity, this.scopedMemoryTracker);
    }

    public void closeInternal() {
        if (this.scopedMemoryTracker != null) {
            this.scopedMemoryTracker.close();
            this.scopedMemoryTracker = null;
        }
    }

    public boolean isClosed() {
        return this.scopedMemoryTracker == null;
    }

    public RelationshipTraversalCursor connectingRelationships(NodeCursor nodeCursor, RelationshipTraversalCursor traversalCursor, long firstNode, int[] types, long secondNode) {
        boolean secondNodeHasCheapDegrees;
        Direction reverseDirection = this.direction.reverse();
        if (nodeCursor.supportsFastRelationshipsTo()) {
            int txStateDegreeFirst = this.calculateDegreeInTxState(firstNode, RelationshipSelection.selection((int[])types, (Direction)this.direction));
            int txStateDegreeSecond = this.calculateDegreeInTxState(secondNode, RelationshipSelection.selection((int[])types, (Direction)reverseDirection));
            if (txStateDegreeSecond >= txStateDegreeFirst) {
                return this.fastExpandInto(nodeCursor, traversalCursor, firstNode, types, this.direction, secondNode);
            }
            return this.fastExpandInto(nodeCursor, traversalCursor, secondNode, types, reverseDirection, firstNode);
        }
        Iterator<Relationship> connections = this.relationshipCache.get(firstNode, secondNode, this.direction);
        if (connections != null) {
            return new FromCachedSelectionCursor(connections, this.read, firstNode, secondNode);
        }
        this.read.singleNode(firstNode, nodeCursor);
        if (!nodeCursor.next()) {
            return Cursors.emptyTraversalCursor((Read)this.read);
        }
        boolean firstNodeHasCheapDegrees = nodeCursor.supportsFastDegreeLookup();
        int firstDegree = this.degreeCache.getIfAbsentPut(firstNode, this.direction, (IntFunction0 & Serializable)() -> {
            if (!nodeCursor.supportsFastDegreeLookup()) {
                return -1;
            }
            return CachingExpandInto.calculateTotalDegree(nodeCursor, this.direction, types);
        });
        int secondDegree = this.degreeCache.getIfAbsentPut(secondNode, reverseDirection, (IntFunction0 & Serializable)() -> CachingExpandInto.positionCursorAndCalculateTotalDegreeIfCheap(this.read, secondNode, nodeCursor, reverseDirection, types));
        boolean bl = secondNodeHasCheapDegrees = secondDegree != -1;
        if (firstNodeHasCheapDegrees && secondNodeHasCheapDegrees) {
            return this.expandFromNodeWithLesserDegree(nodeCursor, traversalCursor, firstNode, types, secondNode, firstDegree <= secondDegree);
        }
        if (secondNodeHasCheapDegrees) {
            int txStateDegreeFirst = this.calculateDegreeInTxState(firstNode, RelationshipSelection.selection((int[])types, (Direction)this.direction));
            return this.expandFromNodeWithLesserDegree(nodeCursor, traversalCursor, firstNode, types, secondNode, txStateDegreeFirst <= secondDegree);
        }
        if (firstNodeHasCheapDegrees) {
            int txStateDegreeSecond = this.calculateDegreeInTxState(secondNode, RelationshipSelection.selection((int[])types, (Direction)reverseDirection));
            return this.expandFromNodeWithLesserDegree(nodeCursor, traversalCursor, firstNode, types, secondNode, txStateDegreeSecond > firstDegree);
        }
        int txStateDegreeFirst = this.calculateDegreeInTxState(firstNode, RelationshipSelection.selection((int[])types, (Direction)this.direction));
        int txStateDegreeSecond = this.calculateDegreeInTxState(secondNode, RelationshipSelection.selection((int[])types, (Direction)reverseDirection));
        boolean startOnFirstNode = txStateDegreeSecond == txStateDegreeFirst ? nodeCursor.nodeReference() == firstNode : txStateDegreeSecond > txStateDegreeFirst;
        return this.expandFromNodeWithLesserDegree(nodeCursor, traversalCursor, firstNode, types, secondNode, startOnFirstNode);
    }

    private RelationshipTraversalCursor fastExpandInto(NodeCursor nodeCursor, RelationshipTraversalCursor traversalCursor, long firstNode, int[] types, Direction direction, long secondNode) {
        this.read.singleNode(firstNode, nodeCursor);
        if (nodeCursor.next()) {
            nodeCursor.relationshipsTo(traversalCursor, RelationshipSelection.selection((int[])types, (Direction)direction), secondNode);
            return traversalCursor;
        }
        return Cursors.emptyTraversalCursor((Read)this.read);
    }

    private RelationshipTraversalCursor expandFromNodeWithLesserDegree(NodeCursor nodeCursor, RelationshipTraversalCursor traversalCursor, long firstNode, int[] types, long secondNode, boolean startOnFirstNode) {
        Direction relDirection;
        long toNode;
        if (startOnFirstNode) {
            CachingExpandInto.positionCursor(this.read, nodeCursor, firstNode);
            toNode = secondNode;
            relDirection = this.direction;
        } else {
            CachingExpandInto.positionCursor(this.read, nodeCursor, secondNode);
            toNode = firstNode;
            relDirection = this.direction.reverse();
        }
        return this.connectingRelationshipsCursor(RelationshipSelections.relationshipsCursor((RelationshipTraversalCursor)traversalCursor, (NodeCursor)nodeCursor, (int[])types, (Direction)relDirection), toNode, firstNode, secondNode, relDirection);
    }

    public RelationshipTraversalCursor connectingRelationships(CursorFactory cursors, NodeCursor nodeCursor, long fromNode, int[] types, long toNode, CursorContext cursorContext) {
        return this.connectingRelationships(nodeCursor, cursors.allocateRelationshipTraversalCursor(cursorContext, this.scopedMemoryTracker), fromNode, types, toNode);
    }

    private int calculateDegreeInTxState(long node, RelationshipSelection selection) {
        if (this.txState == null) {
            return 0;
        }
        NodeState nodeState = this.txState.getNodeState(node);
        if (nodeState == null) {
            return 0;
        }
        SingleDegree degrees = new SingleDegree();
        nodeState.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees.getTotal();
    }

    private static int positionCursorAndCalculateTotalDegreeIfCheap(Read read, long node, NodeCursor nodeCursor, Direction direction, int[] types) {
        if (!CachingExpandInto.positionCursor(read, nodeCursor, node)) {
            return 0;
        }
        if (!nodeCursor.supportsFastDegreeLookup()) {
            return -1;
        }
        return CachingExpandInto.calculateTotalDegree(nodeCursor, direction, types);
    }

    private static int calculateTotalDegree(NodeCursor nodeCursor, Direction direction, int[] types) {
        return nodeCursor.degree(RelationshipSelection.selection((int[])types, (Direction)direction));
    }

    private static boolean positionCursor(Read read, NodeCursor nodeCursor, long node) {
        if (!nodeCursor.isClosed() && nodeCursor.nodeReference() == node) {
            return true;
        }
        read.singleNode(node, nodeCursor);
        return nodeCursor.next();
    }

    private RelationshipTraversalCursor connectingRelationshipsCursor(RelationshipTraversalCursor allRelationships, long toNode, long firstNode, long secondNode, Direction expandDirection) {
        return new ExpandIntoSelectionCursor(allRelationships, this.scopedMemoryTracker, toNode, firstNode, secondNode, expandDirection);
    }

    private static Relationship relationship(RelationshipTraversalCursor allRelationships) {
        return new Relationship(allRelationships.relationshipReference(), allRelationships.sourceNodeReference(), allRelationships.targetNodeReference(), allRelationships.propertiesReference(), allRelationships.type());
    }

    static class RelationshipCache {
        static final long REL_CACHE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelationshipCache.class);
        private final HeapTrackingUnifiedMap<Key, HeapTrackingArrayList<Relationship>> map;
        private final int capacity;
        private final MemoryTracker memoryTracker;

        RelationshipCache(int capacity, MemoryTracker memoryTracker) {
            this.capacity = capacity;
            this.memoryTracker = memoryTracker;
            this.memoryTracker.allocateHeap(REL_CACHE_SHALLOW_SIZE);
            this.map = HeapTrackingCollections.newMap((MemoryTracker)memoryTracker);
        }

        public void add(long start, long end, Direction direction, HeapTrackingArrayList<Relationship> relationships, long heapSizeOfRelationships) {
            if (this.map.size() < this.capacity) {
                this.map.put((Object)RelationshipCache.key(start, end, direction), relationships);
                this.memoryTracker.allocateHeap(heapSizeOfRelationships);
                this.memoryTracker.allocateHeap(Key.KEY_SHALLOW_SIZE);
            }
        }

        public Iterator<Relationship> get(long start, long end, Direction direction) {
            HeapTrackingArrayList cachedValue = (HeapTrackingArrayList)this.map.get((Object)RelationshipCache.key(start, end, direction));
            return cachedValue == null ? null : cachedValue.iterator();
        }

        public static Key key(long startNode, long endNode, Direction direction) {
            long b;
            long a;
            if (direction == Direction.BOTH && startNode > endNode) {
                a = endNode;
                b = startNode;
            } else {
                a = startNode;
                b = endNode;
            }
            return new Key(a, b);
        }

        static class Key {
            static final long KEY_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Key.class);
            private final long a;
            private final long b;

            Key(long a, long b) {
                this.a = a;
                this.b = b;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                if (this.a != key.a) {
                    return false;
                }
                return this.b == key.b;
            }

            public int hashCode() {
                int result = (int)(this.a ^ this.a >>> 32);
                result = 31 * result + (int)(this.b ^ this.b >>> 32);
                return result;
            }
        }
    }

    static class NodeDegreeCache {
        private static final long FLIP_HIGH_BIT_MASK = Long.MIN_VALUE;
        static final long DEGREE_CACHE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeDegreeCache.class);
        private final int capacity;
        private final MutableLongIntMap degreeCache;

        NodeDegreeCache(MemoryTracker memoryTracker) {
            this(100000, memoryTracker);
        }

        NodeDegreeCache(int capacity, MemoryTracker memoryTracker) {
            this.capacity = capacity;
            memoryTracker.allocateHeap(DEGREE_CACHE_SHALLOW_SIZE);
            this.degreeCache = HeapTrackingCollections.newLongIntMap((MemoryTracker)memoryTracker);
        }

        public int getIfAbsentPut(long node, Direction direction, IntFunction0 update) {
            long nodeWithDirection;
            assert (node >= 0L);
            long l = nodeWithDirection = direction == Direction.INCOMING ? Long.MIN_VALUE | node : node;
            if (this.degreeCache.size() >= this.capacity) {
                if (this.degreeCache.containsKey(nodeWithDirection)) {
                    return this.degreeCache.get(nodeWithDirection);
                }
                return update.getAsInt();
            }
            if (this.degreeCache.containsKey(nodeWithDirection)) {
                return this.degreeCache.get(nodeWithDirection);
            }
            int value = update.getAsInt();
            this.degreeCache.put(nodeWithDirection, value);
            return value;
        }

        public void put(long node, Direction direction, int degree) {
            long nodeWithDirection;
            assert (node >= 0L);
            long l = nodeWithDirection = direction == Direction.INCOMING ? Long.MIN_VALUE | node : node;
            if (this.degreeCache.size() >= this.capacity) {
                if (this.degreeCache.containsKey(nodeWithDirection)) {
                    this.degreeCache.put(nodeWithDirection, degree);
                }
            } else {
                this.degreeCache.put(nodeWithDirection, degree);
            }
        }
    }

    private class FromCachedSelectionCursor
    implements RelationshipTraversalCursor {
        @Unmetered
        private Iterator<Relationship> relationships;
        private Relationship currentRelationship;
        @Unmetered
        private final Read read;
        private int token = -1;
        private final long firstNode;
        private final long secondNode;

        FromCachedSelectionCursor(Iterator<Relationship> relationships, Read read, long firstNode, long secondNode) {
            this.relationships = relationships;
            this.read = read;
            this.firstNode = firstNode;
            this.secondNode = secondNode;
            CachingExpandInto.this.scopedMemoryTracker.allocateHeap(FROM_CACHE_SELECTION_CURSOR_SHALLOW_SIZE);
        }

        public boolean next() {
            if (this.relationships != null && this.relationships.hasNext()) {
                this.currentRelationship = this.relationships.next();
                return true;
            }
            this.close();
            return false;
        }

        public void removeTracer() {
        }

        public void otherNode(NodeCursor cursor) {
            this.read.singleNode(this.otherNodeReference(), cursor);
        }

        public long originNodeReference() {
            return this.firstNode;
        }

        public void setTracer(KernelReadTracer tracer) {
        }

        public void close() {
            if (this.relationships != null && CachingExpandInto.this.scopedMemoryTracker != null) {
                this.relationships = null;
                CachingExpandInto.this.scopedMemoryTracker.releaseHeap(FROM_CACHE_SELECTION_CURSOR_SHALLOW_SIZE);
            }
        }

        public void closeInternal() {
        }

        public boolean isClosed() {
            return this.relationships == null;
        }

        public void setCloseListener(CloseListener closeListener) {
            if (closeListener != null) {
                closeListener.onClosed((AutoCloseablePlus)this);
            }
        }

        public void setToken(int token) {
            this.token = token;
        }

        public int getToken() {
            return this.token;
        }

        public long relationshipReference() {
            return this.currentRelationship.id;
        }

        public int type() {
            return this.currentRelationship.type;
        }

        public long otherNodeReference() {
            return this.secondNode;
        }

        public long sourceNodeReference() {
            return this.currentRelationship.from;
        }

        public long targetNodeReference() {
            return this.currentRelationship.to;
        }

        public Reference propertiesReference() {
            return this.currentRelationship.properties;
        }

        public void properties(PropertyCursor cursor, PropertySelection selection) {
            this.read.relationshipProperties(this.currentRelationship.id, this.currentRelationship.from, this.currentRelationship.type, this.currentRelationship.properties, selection, cursor);
        }

        public void source(NodeCursor nodeCursor) {
            this.read.singleNode(this.sourceNodeReference(), nodeCursor);
        }

        public void target(NodeCursor nodeCursor) {
            this.read.singleNode(this.targetNodeReference(), nodeCursor);
        }
    }

    private class ExpandIntoSelectionCursor
    extends DefaultCloseListenable
    implements RelationshipTraversalCursor {
        @Unmetered
        private final RelationshipTraversalCursor allRelationships;
        private final long otherNode;
        private final long firstNode;
        private final long secondNode;
        @Unmetered
        private final Direction expandDirection;
        private int degree;
        private HeapTrackingArrayList<Relationship> connections;
        private final ScopedMemoryTracker innerMemoryTracker;

        ExpandIntoSelectionCursor(RelationshipTraversalCursor allRelationships, MemoryTracker outerMemoryTracker, long otherNode, long firstNode, long secondNode, Direction expandDirection) {
            this.allRelationships = allRelationships;
            this.otherNode = otherNode;
            this.firstNode = firstNode;
            this.secondNode = secondNode;
            this.expandDirection = expandDirection;
            this.innerMemoryTracker = new DefaultScopedMemoryTracker(outerMemoryTracker);
            this.connections = HeapTrackingArrayList.newArrayListWithInitialTrackedSize((MemoryTracker)this.innerMemoryTracker, (long)(EXPAND_INTO_SELECTION_CURSOR_SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE));
        }

        public void otherNode(NodeCursor cursor) {
            this.allRelationships.otherNode(cursor);
        }

        public long originNodeReference() {
            return this.firstNode;
        }

        public void removeTracer() {
            this.allRelationships.removeTracer();
        }

        public void closeInternal() {
            this.degree = 0;
            this.connections = null;
            this.innerMemoryTracker.close();
        }

        public long relationshipReference() {
            return this.allRelationships.relationshipReference();
        }

        public int type() {
            return this.allRelationships.type();
        }

        public long otherNodeReference() {
            return this.secondNode;
        }

        public long sourceNodeReference() {
            return this.allRelationships.sourceNodeReference();
        }

        public long targetNodeReference() {
            return this.allRelationships.targetNodeReference();
        }

        public boolean next() {
            while (this.allRelationships.next()) {
                ++this.degree;
                if (this.allRelationships.otherNodeReference() != this.otherNode) continue;
                this.innerMemoryTracker.allocateHeap(Relationship.RELATIONSHIP_SHALLOW_SIZE);
                this.connections.add((Object)CachingExpandInto.relationship(this.allRelationships));
                return true;
            }
            if (this.connections == null) {
                return false;
            }
            long diff = this.innerMemoryTracker.estimatedHeapMemory() - EXPAND_INTO_SELECTION_CURSOR_SHALLOW_SIZE;
            long startNode = this.otherNode == this.secondNode ? this.firstNode : this.secondNode;
            CachingExpandInto.this.degreeCache.put(startNode, this.expandDirection, this.degree);
            CachingExpandInto.this.relationshipCache.add(this.firstNode, this.secondNode, CachingExpandInto.this.direction, this.connections, diff);
            return false;
        }

        public Reference propertiesReference() {
            return this.allRelationships.propertiesReference();
        }

        public void properties(PropertyCursor cursor, PropertySelection selection) {
            this.allRelationships.properties(cursor, selection);
        }

        public void setTracer(KernelReadTracer tracer) {
            this.allRelationships.setTracer(tracer);
        }

        public void source(NodeCursor nodeCursor) {
            this.allRelationships.source(nodeCursor);
        }

        public void target(NodeCursor nodeCursor) {
            this.allRelationships.target(nodeCursor);
        }

        public boolean isClosed() {
            return this.connections == null || CachingExpandInto.this.scopedMemoryTracker == null;
        }
    }

    private static class Relationship {
        static final long RELATIONSHIP_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Relationship.class);
        private final long id;
        private final long from;
        private final long to;
        private final int type;
        private final Reference properties;

        private Relationship(long id, long from, long to, Reference properties, int type) {
            this.id = id;
            this.from = from;
            this.to = to;
            this.properties = properties;
            this.type = type;
        }
    }
}

