/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.logical.plans.TraversalMatchMode;
import org.neo4j.cypher.internal.runtime.HeapTrackingLongImmutableSet;
import org.neo4j.cypher.internal.runtime.RelationshipContainer$;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%ca\u0002\u0012$!\u0003\r\nA\f\u0005\u0006u\u00011\ta\u000f\u0005\u0006\u0011\u00021\t!\u0013\u0005\u0006\u0011\u00021\t!\u0015\u0005\u0006/\u00021\t\u0001\u0017\u0005\u00063\u00021\tA\u0017\u0005\u0006=\u00021\taX\u0004\u0006G\u000eB\t\u0001\u001a\u0004\u0006E\rB\t!\u001a\u0005\u0006S\"!\tA\u001b\u0004\u0005W\"!A\u000e\u0003\u0005_\u0015\t\u0015\r\u0011\"\u0001`\u0011!i'B!A!\u0002\u0013\u0001\u0007\u0002C-\u000b\u0005\u000b\u0007I\u0011\u0001.\t\u00119T!\u0011!Q\u0001\nmC\u0001b\u001c\u0006\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\u0007S*!\t\u0001C:\t\u000biRA\u0011I=\t\u000b!SA\u0011I>\t\u000b!SA\u0011I?\t\u000b]SA\u0011\t-\t\r}TA\u0011IA\u0001\r\u0019\tI\u0001\u0003\u0003\u0002\f!AaL\u0006BC\u0002\u0013\u0005q\f\u0003\u0005n-\t\u0005\t\u0015!\u0003a\u0011!IfC!b\u0001\n\u0003Q\u0006\u0002\u00038\u0017\u0005\u0003\u0005\u000b\u0011B.\t\u000f%4B\u0011\u0001\u0005\u0002\u000e!1!H\u0006C!\u0003+Aa\u0001\u0013\f\u0005B\u0005e\u0001B\u0002%\u0017\t\u0003\ni\u0002C\u0003X-\u0011\u0005\u0003\f\u0003\u0004\u0000-\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003CAA\u0011AA\u0012\u0005U\u0011V\r\\1uS>t7\u000f[5q\u0007>tG/Y5oKJT!\u0001J\u0013\u0002\u000fI,h\u000e^5nK*\u0011aeJ\u0001\tS:$XM\u001d8bY*\u0011\u0001&K\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005)Z\u0013!\u00028f_RR'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001ys\u0007\u0005\u00021k5\t\u0011G\u0003\u00023g\u0005!A.\u00198h\u0015\u0005!\u0014\u0001\u00026bm\u0006L!AN\u0019\u0003\r=\u0013'.Z2u!\t\u0001\u0004(\u0003\u0002:c\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\fa!\u00199qK:$GC\u0001\u001f?!\ti\u0004!D\u0001$\u0011\u0015y\u0014\u00011\u0001A\u0003\r\u0011X\r\u001c\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bqA^5siV\fGN\u0003\u0002FS\u00051a/\u00197vKNL!a\u0012\"\u00031YK'\u000f^;bYJ+G.\u0019;j_:\u001c\b.\u001b9WC2,X-\u0001\u0004dC:\fE\r\u001a\u000b\u0003\u0015B\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013qAQ8pY\u0016\fg\u000eC\u0003@\u0005\u0001\u0007\u0001\t\u0006\u0002K%\")1k\u0001a\u0001)\u0006)!/\u001a7JIB\u00111*V\u0005\u0003-2\u0013A\u0001T8oO\u00069!/\u001a<feN,W#\u0001\u001f\u0002\tML'0Z\u000b\u00027B\u00111\nX\u0005\u0003;2\u00131!\u00138u\u0003\u0019\t7\u000fT5tiV\t\u0001\r\u0005\u0002BC&\u0011!M\u0011\u0002\n\u0019&\u001cHOV1mk\u0016\fQCU3mCRLwN\\:iSB\u001cuN\u001c;bS:,'\u000f\u0005\u0002>\u0011M\u0011\u0001B\u001a\t\u0003\u0017\u001eL!\u0001\u001b'\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tAM\u0001\u0010Ue\u0006LG.T8eKJ+G.\u0019;j_:\u001c\b.\u001b9D_:$\u0018-\u001b8feN\u0019!b\f\u001f\u0002\u000f\u0005\u001cH*[:uA\u0005)1/\u001b>fA\u0005\u00191/\u001a;\u0011\u0005u\n\u0018B\u0001:$\u0005qAU-\u00199Ue\u0006\u001c7.\u001b8h\u0019>tw-S7nkR\f'\r\\3TKR$B\u0001\u001e<xqB\u0011QOC\u0007\u0002\u0011!)a\f\u0005a\u0001A\")\u0011\f\u0005a\u00017\")q\u000e\u0005a\u0001aR\u0011AH\u001f\u0005\u0006\u007fE\u0001\r\u0001\u0011\u000b\u0003\u0015rDQa\u0010\nA\u0002\u0001#\"A\u0013@\t\u000bM\u001b\u0002\u0019\u0001+\u0002\u000b\rdwn]3\u0015\u0005\u0005\r\u0001cA&\u0002\u0006%\u0019\u0011q\u0001'\u0003\tUs\u0017\u000e\u001e\u0002\u001e/\u0006d7.T8eKJ+G.\u0019;j_:\u001c\b.\u001b9D_:$\u0018-\u001b8feN\u0019ac\f\u001f\u0015\r\u0005=\u0011\u0011CA\n!\t)h\u0003C\u0003_7\u0001\u0007\u0001\rC\u0003Z7\u0001\u00071\fF\u0002=\u0003/AQa\u0010\u000fA\u0002\u0001#2ASA\u000e\u0011\u0015yT\u00041\u0001A)\rQ\u0015q\u0004\u0005\u0006'z\u0001\r\u0001V\u0001\u0006K6\u0004H/\u001f\u000b\u0006y\u0005\u0015\u0012Q\u0007\u0005\b\u0003O\t\u0003\u0019AA\u0015\u00035iW-\\8ssR\u0013\u0018mY6feB!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020%\na!\\3n_JL\u0018\u0002BA\u001a\u0003[\u0011Q\"T3n_JLHK]1dW\u0016\u0014\bbBA\u001cC\u0001\u0007\u0011\u0011H\u0001\u0013iJ\fg/\u001a:tC2l\u0015\r^2i\u001b>$W\r\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u000bAd\u0017M\\:\u000b\u0007\u0005\rS%A\u0004m_\u001eL7-\u00197\n\t\u0005\u001d\u0013Q\b\u0002\u0013)J\fg/\u001a:tC2l\u0015\r^2i\u001b>$W\r")
public interface RelationshipContainer
extends AutoCloseable {
    public static RelationshipContainer empty(MemoryTracker memoryTracker, TraversalMatchMode traversalMatchMode) {
        return RelationshipContainer$.MODULE$.empty(memoryTracker, traversalMatchMode);
    }

    public RelationshipContainer append(VirtualRelationshipValue var1);

    public boolean canAdd(VirtualRelationshipValue var1);

    public boolean canAdd(long var1);

    public RelationshipContainer reverse();

    public int size();

    public ListValue asList();

    private static class TrailModeRelationshipContainer
    implements RelationshipContainer {
        private final ListValue asList;
        private final int size;
        private final HeapTrackingLongImmutableSet set;

        @Override
        public ListValue asList() {
            return this.asList;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public RelationshipContainer append(VirtualRelationshipValue rel) {
            return new TrailModeRelationshipContainer((ListValue)this.asList().append((AnyValue)rel), this.size() + 1, this.set.$plus(rel.id()));
        }

        @Override
        public boolean canAdd(VirtualRelationshipValue rel) {
            return !this.set.contains(rel.id());
        }

        @Override
        public boolean canAdd(long relId) {
            return !this.set.contains(relId);
        }

        @Override
        public RelationshipContainer reverse() {
            return new TrailModeRelationshipContainer(this.asList().reverse(), this.size(), this.set);
        }

        @Override
        public void close() {
            this.set.close();
        }

        public TrailModeRelationshipContainer(ListValue asList, int size, HeapTrackingLongImmutableSet set) {
            this.asList = asList;
            this.size = size;
            this.set = set;
        }
    }

    private static class WalkModeRelationshipContainer
    implements RelationshipContainer {
        private final ListValue asList;
        private final int size;

        @Override
        public ListValue asList() {
            return this.asList;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public RelationshipContainer append(VirtualRelationshipValue rel) {
            return new WalkModeRelationshipContainer((ListValue)this.asList().append((AnyValue)rel), this.size() + 1);
        }

        @Override
        public boolean canAdd(VirtualRelationshipValue rel) {
            return true;
        }

        @Override
        public boolean canAdd(long relId) {
            return true;
        }

        @Override
        public RelationshipContainer reverse() {
            return new WalkModeRelationshipContainer(this.asList().reverse(), this.size());
        }

        @Override
        public void close() {
        }

        public WalkModeRelationshipContainer(ListValue asList, int size) {
            this.asList = asList;
            this.size = size;
        }
    }
}

