/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.profiling;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.profiling.OperatorProfileEvent;
import org.neo4j.cypher.internal.profiling.ProfilingTracerData;
import org.neo4j.cypher.internal.profiling.QueryProfiler;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.cypher.result.OperatorProfile;
import org.neo4j.cypher.result.QueryProfile;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;

public class ProfilingTracer
implements QueryProfiler,
QueryProfile {
    private final Clock clock;
    private final StatisticProvider statisticProvider;
    private final Map<Integer, ProfilingTracerData> data = new HashMap<Integer, ProfilingTracerData>();

    public ProfilingTracer(StatisticProvider statisticProvider) {
        this(Clock.SYSTEM_TIMER, statisticProvider);
    }

    ProfilingTracer(Clock clock, StatisticProvider statisticProvider) {
        this.clock = clock;
        this.statisticProvider = statisticProvider;
    }

    @Override
    public OperatorProfile operatorProfile(int operatorId) {
        ProfilingTracerData value = this.data.get(operatorId);
        if (value == null) {
            return OperatorProfile.ZERO;
        }
        value.sanitize();
        return value;
    }

    @Override
    public long maxAllocatedMemory() {
        return -1L;
    }

    @Override
    public int numberOfAvailableWorkers() {
        return -1;
    }

    @Override
    public int numberOfAvailableProcessors() {
        return -1;
    }

    public long timeOf(Id operatorId) {
        return this.operatorProfile(operatorId.x()).time();
    }

    public long dbHitsOf(Id operatorId) {
        return this.operatorProfile(operatorId.x()).dbHits();
    }

    public long rowsOf(Id operatorId) {
        return this.operatorProfile(operatorId.x()).rows();
    }

    @Override
    public OperatorProfileEvent executeOperator(Id operatorId) {
        return this.executeOperator(operatorId, true);
    }

    @Override
    public OperatorProfileEvent executeOperator(Id operatorId, boolean trackAll) {
        ProfilingTracerData operatorData = this.data.get(operatorId.x());
        if (operatorData == null) {
            operatorData = new ProfilingTracerData();
            this.data.put(operatorId.x(), operatorData);
        }
        if (trackAll) {
            return new TrackingExecutionEvent(this.clock, this.statisticProvider, operatorData, operatorId.x());
        }
        return new ExecutionEvent(this.statisticProvider, operatorData, operatorId.x());
    }

    public String toString() {
        return String.format("ProfilingTracer { %s }", this.data);
    }

    public static interface Clock {
        public static final Clock SYSTEM_TIMER = System::nanoTime;

        public long nanoTime();
    }

    private static class TrackingExecutionEvent
    extends ExecutionEvent {
        private final long start;
        private final Clock clock;
        private long pageCountHitsStart;
        private long pageCountMissesStart;

        TrackingExecutionEvent(Clock clock, StatisticProvider statisticProvider, ProfilingTracerData data, int planId) {
            super(statisticProvider, data, planId);
            this.clock = clock;
            this.start = clock.nanoTime();
            this.pageCountHitsStart = statisticProvider.getPageCacheHits();
            this.pageCountMissesStart = statisticProvider.getPageCacheMisses();
        }

        @Override
        public void close() {
            long pageCacheHits = this.statisticProvider.getPageCacheHits();
            long pageCacheFaults = this.statisticProvider.getPageCacheMisses();
            long executionTime = this.clock.nanoTime() - this.start;
            this.data.update(executionTime, this.hitCount, this.rowCount, pageCacheHits - this.pageCountHitsStart, pageCacheFaults - this.pageCountMissesStart, -1L);
        }
    }

    private static class ExecutionEvent
    extends OperatorProfileEvent {
        final ProfilingTracerData data;
        final StatisticProvider statisticProvider;
        long hitCount;
        long rowCount;
        int planId;

        ExecutionEvent(StatisticProvider statisticProvider, ProfilingTracerData data, int planId) {
            this.statisticProvider = statisticProvider;
            this.data = data;
            this.planId = planId;
        }

        @Override
        public void close() {
            this.data.update(-1L, this.hitCount, this.rowCount, -1L, -1L, -1L);
        }

        @Override
        public void dbHit() {
            ++this.hitCount;
        }

        @Override
        public void dbHits(long hits) {
            this.hitCount += hits;
        }

        @Override
        public void row() {
            ++this.rowCount;
        }

        @Override
        public void row(boolean hasRow) {
            if (hasRow) {
                ++this.rowCount;
            }
        }

        @Override
        public void rows(long n) {
            this.rowCount += n;
        }
    }
}

