/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.SourceCursor;

final class ComposedSourceCursor<Outer, Intermediate, Inner>
implements SourceCursor<Outer, Inner> {
    private final SourceCursor<Outer, Intermediate> outerCursor;
    private final SourceCursor<Intermediate, Inner> innerCursor;
    private boolean innerSourceSet = false;

    public ComposedSourceCursor(SourceCursor<Outer, Intermediate> outerCursor, SourceCursor<Intermediate, Inner> innerCursor) {
        this.outerCursor = outerCursor;
        this.innerCursor = innerCursor;
    }

    @Override
    public void setSource(Outer outer) {
        this.outerCursor.setSource(outer);
        this.innerSourceSet = false;
    }

    @Override
    public boolean next() {
        while (true) {
            if (!this.innerSourceSet) {
                if (!this.outerCursor.next()) {
                    return false;
                }
                this.innerCursor.setSource(this.outerCursor.current());
                this.innerSourceSet = true;
            }
            if (this.innerCursor.next()) {
                return true;
            }
            if (!this.outerCursor.next()) {
                this.innerSourceSet = false;
                return false;
            }
            this.innerCursor.setSource(this.outerCursor.current());
        }
    }

    @Override
    public Inner current() {
        return this.innerSourceSet ? (Inner)this.innerCursor.current() : null;
    }

    public Intermediate currentIntermediate() {
        return this.outerCursor.current();
    }

    @Override
    public void reset() {
        this.outerCursor.reset();
        this.innerCursor.reset();
        this.innerSourceSet = false;
    }

    @Override
    public void close() throws Exception {
        this.outerCursor.close();
        this.innerCursor.close();
    }
}

