/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.helpers.traversal.PathTraceStep;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

abstract class PathTracingIterator<STEPS>
extends PrefetchingIterator<PathReference> {
    private final int pathLength;
    private final int intersectionNodeIndex;
    private final LongIterator intersectionIterator;
    private final PathIteratorPart innerLoopPathPart;
    private final PathIteratorPart outerLoopPathPart;
    private final long[] internalNodes;
    private final long[] internalRels;
    private boolean consumedFirstPath = false;
    private boolean finished = false;

    static PathTracingIterator<PathTraceStep> singlePathTracingIterator(LongIterator intersectionIterator, int sourceBFSDepth, int targetBFSDepth, HeapTrackingLongObjectHashMap<PathTraceStep> sourcePathTraceData, HeapTrackingLongObjectHashMap<PathTraceStep> targetPathTraceData) {
        return new SinglePathTracingIterator(intersectionIterator, sourceBFSDepth, targetBFSDepth, sourcePathTraceData, targetPathTraceData);
    }

    static PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> multiePathTracingIterator(LongIterator intersectionIterator, int sourceBFSDepth, int targetBFSDepth, HeapTrackingLongObjectHashMap<HeapTrackingArrayList<PathTraceStep>> sourcePathTraceData, HeapTrackingLongObjectHashMap<HeapTrackingArrayList<PathTraceStep>> targetPathTraceData) {
        return new MultiPathTracingIterator(intersectionIterator, sourceBFSDepth, targetBFSDepth, sourcePathTraceData, targetPathTraceData);
    }

    private PathTracingIterator(LongIterator intersectionIterator, int sourceBFSDepth, int targetBFSDepth, HeapTrackingLongObjectHashMap<STEPS> sourcePathTraceData, HeapTrackingLongObjectHashMap<STEPS> targetPathTraceData) {
        this.intersectionIterator = intersectionIterator;
        this.pathLength = sourceBFSDepth + targetBFSDepth;
        this.intersectionNodeIndex = sourceBFSDepth;
        this.internalNodes = new long[this.pathLength + 1];
        this.internalRels = new long[this.pathLength];
        PathIteratorPart sourcePathPart = this.constructPathIteratorPart(sourcePathTraceData, sourceBFSDepth, false);
        PathIteratorPart targetPathPart = this.constructPathIteratorPart(targetPathTraceData, targetBFSDepth, true);
        this.setNextIntersectionNode();
        sourcePathPart.resetPathPartToIntersection();
        targetPathPart.resetPathPartToIntersection();
        if (sourceBFSDepth > targetBFSDepth) {
            this.innerLoopPathPart = targetPathPart;
            this.outerLoopPathPart = sourcePathPart;
        } else {
            this.innerLoopPathPart = sourcePathPart;
            this.outerLoopPathPart = targetPathPart;
        }
    }

    protected abstract PathIteratorPart constructPathIteratorPart(HeapTrackingLongObjectHashMap<STEPS> var1, int var2, boolean var3);

    protected PathReference fetchNextOrNull() {
        if (this.viewNextPath()) {
            return this.currentPath();
        }
        return null;
    }

    private boolean viewNextPath() {
        if (this.finished) {
            return false;
        }
        if (!this.consumedFirstPath) {
            this.consumedFirstPath = true;
            return true;
        }
        if (this.innerLoopPathPart.viewNextPath()) {
            return true;
        }
        if (this.outerLoopPathPart.viewNextPath()) {
            this.innerLoopPathPart.resetPathPartToIntersection();
            return true;
        }
        if (this.setNextIntersectionNode()) {
            this.innerLoopPathPart.resetPathPartToIntersection();
            this.outerLoopPathPart.resetPathPartToIntersection();
            return true;
        }
        this.finished = true;
        return false;
    }

    private boolean setNextIntersectionNode() {
        if (!this.intersectionIterator.hasNext()) {
            return false;
        }
        this.internalNodes[this.intersectionNodeIndex] = this.intersectionIterator.next();
        return true;
    }

    private PathReference currentPath() {
        return VirtualValues.pathReference((long[])((long[])this.internalNodes.clone()), (long[])((long[])this.internalRels.clone()));
    }

    static class SinglePathTracingIterator
    extends PathTracingIterator<PathTraceStep> {
        SinglePathTracingIterator(LongIterator intersectionIterator, int sourceBFSDepth, int targetBFSDepth, HeapTrackingLongObjectHashMap<PathTraceStep> sourcePathTraceData, HeapTrackingLongObjectHashMap<PathTraceStep> targetPathTraceData) {
            super(intersectionIterator, sourceBFSDepth, targetBFSDepth, sourcePathTraceData, targetPathTraceData);
        }

        @Override
        protected PathIteratorPart constructPathIteratorPart(HeapTrackingLongObjectHashMap<PathTraceStep> pathTraceData, int depth, boolean reversed) {
            return new SinglePathIteratorPart(pathTraceData, depth, reversed);
        }

        private class SinglePathIteratorPart
        extends PathIteratorPart {
            public SinglePathIteratorPart(HeapTrackingLongObjectHashMap<PathTraceStep> pathTraceData, int pathPartLength, boolean reversed) {
                super(pathTraceData, pathPartLength, reversed);
            }

            @Override
            protected boolean viewNextPath() {
                return false;
            }

            @Override
            protected PathTraceStep getActivePathToNode(int pathPartIndexOfNode) {
                return (PathTraceStep)this.pathTraceData.get(this.getInternalNode(pathPartIndexOfNode));
            }

            @Override
            protected boolean hasMoreStepsToNode(int pathPartIndexOfNode) {
                return false;
            }
        }
    }

    static class MultiPathTracingIterator
    extends PathTracingIterator<HeapTrackingArrayList<PathTraceStep>> {
        MultiPathTracingIterator(LongIterator intersectionIterator, int sourceBFSDepth, int targetBFSDepth, HeapTrackingLongObjectHashMap<HeapTrackingArrayList<PathTraceStep>> sourcePathTraceData, HeapTrackingLongObjectHashMap<HeapTrackingArrayList<PathTraceStep>> targetPathTraceData) {
            super(intersectionIterator, sourceBFSDepth, targetBFSDepth, sourcePathTraceData, targetPathTraceData);
        }

        @Override
        protected PathIteratorPart constructPathIteratorPart(HeapTrackingLongObjectHashMap<HeapTrackingArrayList<PathTraceStep>> pathTraceData, int depth, boolean reversed) {
            return new MultiPathIteratorPart(pathTraceData, depth, reversed);
        }

        private class MultiPathIteratorPart
        extends PathIteratorPart {
            public MultiPathIteratorPart(HeapTrackingLongObjectHashMap<HeapTrackingArrayList<PathTraceStep>> pathTraceData, int pathPartLength, boolean reversed) {
                super(pathTraceData, pathPartLength, reversed);
            }

            @Override
            protected PathTraceStep getActivePathToNode(int pathPartIndexOfNode) {
                long node = this.getInternalNode(pathPartIndexOfNode);
                return (PathTraceStep)((HeapTrackingArrayList)this.pathTraceData.get(node)).get(this.pathsToHereActiveIndices[pathPartIndexOfNode - 1]);
            }

            @Override
            protected boolean hasMoreStepsToNode(int pathPartIndexOfNode) {
                return this.pathsToHereActiveIndices[pathPartIndexOfNode - 1] < ((HeapTrackingArrayList)this.pathTraceData.get(this.getInternalNode(pathPartIndexOfNode))).size() - 1;
            }
        }
    }

    abstract class PathIteratorPart {
        protected final int pathPartLength;
        protected final HeapTrackingLongObjectHashMap<STEPS> pathTraceData;
        protected final boolean reversed;
        protected final int[] pathsToHereActiveIndices;

        public PathIteratorPart(HeapTrackingLongObjectHashMap<STEPS> pathTraceData, int pathPartLength, boolean reversed) {
            this.pathTraceData = pathTraceData;
            this.reversed = reversed;
            this.pathPartLength = pathPartLength;
            this.pathsToHereActiveIndices = new int[pathPartLength];
        }

        protected abstract boolean hasMoreStepsToNode(int var1);

        protected abstract PathTraceStep getActivePathToNode(int var1);

        protected void updateInternalNodes(long nodeId, int pathPartIndexOfNode) {
            int internalNodesIndex = this.reversed ? PathTracingIterator.this.pathLength - pathPartIndexOfNode : pathPartIndexOfNode;
            PathTracingIterator.this.internalNodes[internalNodesIndex] = nodeId;
        }

        protected long getInternalNode(int pathPartIndexOfNode) {
            int internalNodesIndex = this.reversed ? PathTracingIterator.this.pathLength - pathPartIndexOfNode : pathPartIndexOfNode;
            return PathTracingIterator.this.internalNodes[internalNodesIndex];
        }

        protected void updateInternalRelsToNode(long relId, int pathPartIndexOfNode) {
            int internalRelsIndex = this.reversed ? PathTracingIterator.this.pathLength - 1 - (pathPartIndexOfNode - 1) : pathPartIndexOfNode - 1;
            PathTracingIterator.this.internalRels[internalRelsIndex] = relId;
        }

        protected boolean activateNextPathPartToNode(int pathPartIndexOfNode) {
            if (!this.hasMoreStepsToNode(pathPartIndexOfNode)) {
                return false;
            }
            int n = pathPartIndexOfNode - 1;
            this.pathsToHereActiveIndices[n] = this.pathsToHereActiveIndices[n] + 1;
            PathTraceStep pathToHere = this.getActivePathToNode(pathPartIndexOfNode);
            this.updateInternalRelsToNode(pathToHere.relId(), pathPartIndexOfNode);
            this.updateInternalNodes(pathToHere.prevNodeId(), pathPartIndexOfNode - 1);
            return true;
        }

        protected void activateFirstPathStepToNode(int pathPartIndexOfNode) {
            this.pathsToHereActiveIndices[pathPartIndexOfNode - 1] = 0;
            PathTraceStep pathToHere = this.getActivePathToNode(pathPartIndexOfNode);
            this.updateInternalRelsToNode(pathToHere.relId(), pathPartIndexOfNode);
            this.updateInternalNodes(pathToHere.prevNodeId(), pathPartIndexOfNode - 1);
        }

        public void resetPathPartToIntersection() {
            this.resetPathPartToNodeAtIndex(this.pathPartLength);
        }

        public void resetPathPartToNodeAtIndex(int nodeIndex) {
            assert (nodeIndex <= this.pathPartLength);
            while (nodeIndex > 0) {
                this.activateFirstPathStepToNode(nodeIndex);
                --nodeIndex;
            }
        }

        protected boolean viewNextPath() {
            if (this.pathPartLength == 0) {
                return false;
            }
            int indexToIterate = 1;
            while (!this.activateNextPathPartToNode(indexToIterate)) {
                if (++indexToIterate <= this.pathPartLength) continue;
                return false;
            }
            this.resetPathPartToNodeAtIndex(indexToIterate - 1);
            return true;
        }
    }
}

