/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.security.URIAccessRules;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDatabaseCypherService
implements GraphDatabaseQueryService {
    private final GraphDatabaseAPI graph;
    private final URIAccessRules urlAccessRule;
    private final Config config;

    public GraphDatabaseCypherService(GraphDatabaseService graph) {
        this.graph = (GraphDatabaseAPI)graph;
        DependencyResolver dependencyResolver = this.getDependencyResolver();
        this.urlAccessRule = (URIAccessRules)dependencyResolver.resolveDependency(URIAccessRules.class);
        this.config = (Config)dependencyResolver.resolveDependency(Config.class);
    }

    public DependencyResolver getDependencyResolver() {
        return this.graph.getDependencyResolver();
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) {
        return this.graph.beginTransaction(type, loginContext);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo) {
        return this.graph.beginTransaction(type, loginContext, connectionInfo);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeout, TimeUnit unit) {
        return this.graph.beginTransaction(type, loginContext, connectionInfo, timeout, unit);
    }

    public CharReadable validateURIAccess(SecurityContext securityContext, URI uri) throws URLAccessValidationError {
        return this.urlAccessRule.validateAndOpen(securityContext, uri);
    }

    public Transaction beginTx() {
        return this.graph.beginTx();
    }

    public void executeTransactionally(String query) throws QueryExecutionException {
        this.graph.executeTransactionally(query);
    }

    public Config config() {
        return this.config;
    }
}

