/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.result;

import java.util.Arrays;

public interface OperatorProfile {
    public static final long NO_DATA = -1L;
    public static final OperatorProfile NONE = new ConstOperatorProfile(-1L);
    public static final OperatorProfile ZERO = new ConstOperatorProfile(0L);

    public long time();

    public long dbHits();

    public long rows();

    public long pageCacheHits();

    public long pageCacheMisses();

    public long maxAllocatedMemory();

    public static class ConstOperatorProfile
    implements OperatorProfile {
        private final long time;
        private final long dbHits;
        private final long rows;
        private final long pageCacheHits;
        private final long pageCacheMisses;
        private final long maxAllocatedMemory;

        ConstOperatorProfile(long value) {
            this(value, value, value, value, value, value);
        }

        public ConstOperatorProfile(long time, long dbHits, long rows, long pageCacheHits, long pageCacheMisses, long maxAllocatedMemory) {
            this.time = time;
            this.dbHits = dbHits;
            this.rows = rows;
            this.pageCacheHits = pageCacheHits;
            this.pageCacheMisses = pageCacheMisses;
            this.maxAllocatedMemory = maxAllocatedMemory;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public long dbHits() {
            return this.dbHits;
        }

        @Override
        public long rows() {
            return this.rows;
        }

        @Override
        public long pageCacheHits() {
            return this.pageCacheHits;
        }

        @Override
        public long pageCacheMisses() {
            return this.pageCacheMisses;
        }

        @Override
        public long maxAllocatedMemory() {
            return this.maxAllocatedMemory;
        }

        public int hashCode() {
            return Arrays.hashCode(new long[]{this.time(), this.dbHits(), this.rows(), this.pageCacheHits(), this.pageCacheMisses(), this.maxAllocatedMemory()});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OperatorProfile)) {
                return false;
            }
            OperatorProfile that = (OperatorProfile)o;
            return this.time() == that.time() && this.dbHits() == that.dbHits() && this.rows() == that.rows() && this.pageCacheHits() == that.pageCacheHits() && this.pageCacheMisses() == that.pageCacheMisses() && this.maxAllocatedMemory() == that.maxAllocatedMemory();
        }

        public String toString() {
            return String.format("Operator Profile { time: %d, dbHits: %d, rows: %d, page cache hits: %d, page cache misses: %d, max allocated: %d }", this.time(), this.dbHits(), this.rows(), this.pageCacheHits(), this.pageCacheMisses(), this.maxAllocatedMemory());
        }
    }
}

