/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Lengths;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class NodeState
implements AutoCloseable,
Measurable {
    private static final int NO_SOURCE_DISTANCE = -1;
    private static final int SIGNPOSTS_INIT_SIZE = 2;
    private final long nodeId;
    private final State state;
    final GlobalState globalState;
    private final HeapTrackingArrayList<TwoWaySignpost> sourceSignposts;
    private HeapTrackingArrayList<TwoWaySignpost> targetSignposts;
    private final Lengths lengths;
    private int sourceDistance = -1;
    private int remainingTargetCount = 0;
    private boolean isTarget = false;
    private boolean discoveredForward = false;
    private boolean discoveredBackward = false;
    private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeState.class);

    public NodeState(GlobalState globalState, long nodeId, State state, long intoTarget) {
        this.sourceSignposts = HeapTrackingArrayList.newArrayList((int)2, (MemoryTracker)globalState.mt);
        this.nodeId = nodeId;
        this.state = state;
        this.globalState = globalState;
        this.lengths = new Lengths();
        if (this.state().isFinalState() && (intoTarget == -1L || intoTarget == nodeId)) {
            this.remainingTargetCount = (int)globalState.initialCountForTargetNodes;
            this.isTarget = true;
            globalState.incrementUnsaturatedTargets();
        }
        globalState.mt.allocateHeap(this.estimatedHeapUsage());
    }

    public void discover(TraversalDirection direction) {
        switch (direction) {
            case Forward: {
                this.discoveredForward = true;
                break;
            }
            case Backward: {
                this.discoveredBackward = true;
            }
        }
    }

    public State state() {
        return this.state;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public int nextSignpostIndexForLength(int currentIndex, int lengthFromSource) {
        for (int i = currentIndex + 1; i < this.sourceSignposts.size(); ++i) {
            if (!((TwoWaySignpost)this.sourceSignposts.get(i)).hasSourceLength(lengthFromSource)) continue;
            return i;
        }
        return -1;
    }

    public TwoWaySignpost getSourceSignpost(int index) {
        return (TwoWaySignpost)this.sourceSignposts.get(index);
    }

    public void synchronizeLengthAfterPrune(int lengthFromSource) {
        for (TwoWaySignpost sourceSignpost : this.sourceSignposts) {
            if (!sourceSignpost.hasSourceLength(lengthFromSource)) continue;
            return;
        }
        assert (!this.lengths.get(lengthFromSource, Lengths.Type.ConfirmedSource)) : "We should never remove validated length states";
        this.lengths.clear(lengthFromSource, Lengths.Type.Source);
    }

    public boolean validatedAtLength(int lengthFromSource) {
        return this.lengths.get(lengthFromSource, Lengths.Type.ConfirmedSource);
    }

    @Override
    public void close() {
        this.sourceSignposts.close();
        if (this.targetSignposts != null) {
            this.targetSignposts.close();
        }
    }

    public long id() {
        return this.nodeId;
    }

    public void addSourceSignpost(TwoWaySignpost sourceSignpost, int sourceLength) {
        Preconditions.checkArgument((sourceSignpost.forwardNode == this ? 1 : 0) != 0, (String)"Source signpost must be added to correct node");
        assert (this.sourceSignposts.stream().noneMatch(sourceSignpost::equals)) : "Duplicate source signpost added";
        if (this.sourceDistance == -1 || this.sourceDistance > sourceLength) {
            this.sourceDistance = sourceLength;
        }
        this.globalState.hooks.addSourceSignpost(sourceSignpost, sourceLength);
        if (sourceLength != -1) {
            if (!this.lengths.get(sourceLength, Lengths.Type.Source)) {
                this.lengths.set(sourceLength, Lengths.Type.Source);
                int minTargetDistance = this.minTargetDistance();
                if (minTargetDistance != -1 && sourceLength + minTargetDistance >= this.globalState.depth()) {
                    this.globalState.schedule(this, sourceLength, minTargetDistance, GlobalState.ScheduleSource.SourceSignpost);
                }
                if (this.isTarget()) {
                    this.globalState.addTarget(this);
                }
            } else assert (sourceLength == this.lengths.max(Lengths.Type.Source)) : "A node should only be seen by the BFS at increasingly deeper levels.";
        }
        this.sourceSignposts.add((Object)sourceSignpost);
    }

    public void newPropagatedSourceLength(int sourceLength, int targetLength) {
        if (!this.lengths.get(sourceLength, Lengths.Type.Source)) {
            this.lengths.set(sourceLength, Lengths.Type.Source);
            if (this.hasMinDistToTarget(targetLength)) {
                this.globalState.schedule(this, sourceLength, targetLength, GlobalState.ScheduleSource.Propagated);
            }
            if (this.isTarget()) {
                this.globalState.addTarget(this);
            }
        }
    }

    public void addTargetSignpost(TwoWaySignpost targetSignpost, int targetLength, PGPathPropagatingBFS.Phase phase) {
        this.globalState.hooks.addTargetSignpost(targetSignpost, targetLength);
        Preconditions.checkArgument((targetSignpost.prevNode == this ? 1 : 0) != 0, (String)"Target signpost must be added to correct node");
        if (!$assertionsDisabled && this.targetSignposts != null) {
            if (!this.targetSignposts.stream().noneMatch(targetSignpost::equals)) {
                throw new AssertionError((Object)"Duplicate target signpost added");
            }
        }
        boolean firstTrace = false;
        if (this.targetSignposts == null) {
            this.targetSignposts = HeapTrackingArrayList.newArrayList((int)2, (MemoryTracker)this.globalState.mt);
            firstTrace = true;
        }
        assert (!firstTrace || targetLength >= this.minTargetDistance()) : "The first time a node is traced should be with the shortest trail to a target";
        if (!this.hasMinDistToTarget(targetLength)) {
            int l = this.lengths.next(0, Lengths.Type.Source);
            while (l != -1) {
                if ((firstTrace || this.lengths.get(l, Lengths.Type.ConfirmedSource)) && (l > this.sourceDistance || phase == PGPathPropagatingBFS.Phase.Expansion)) {
                    int depth = this.globalState.depth();
                    if (phase == PGPathPropagatingBFS.Phase.Tracing) {
                        ++depth;
                    }
                    if (l + targetLength >= depth) {
                        this.globalState.schedule(this, l, targetLength, GlobalState.ScheduleSource.TargetSignpost);
                    }
                }
                l = this.lengths.next(l + 1, Lengths.Type.Source);
            }
        }
        this.targetSignposts.add((Object)targetSignpost);
    }

    private int realSourceDistance() {
        if (this.sourceDistance == -1) {
            return 0;
        }
        return this.sourceDistance;
    }

    public void propagateLengthPair(int lengthFromSource, int lengthToTarget) {
        this.globalState.hooks.propagateLengthPair(this, lengthFromSource, lengthToTarget);
        if (!this.hasAnyMinDistToTarget()) {
            return;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            if (tsp.minTargetDistance() != lengthToTarget) continue;
            tsp.propagate(lengthFromSource, lengthToTarget);
        }
    }

    public void validateSourceLength(int lengthFromSource, int tracedLengthToTarget) {
        this.globalState.hooks.validateSourceLength(this, lengthFromSource, tracedLengthToTarget);
        Preconditions.checkState((!this.lengths.get(lengthFromSource, Lengths.Type.ConfirmedSource) ? 1 : 0) != 0, (String)"Shouldn't validate the same length from source more than once");
        this.lengths.set(lengthFromSource, Lengths.Type.ConfirmedSource);
        if (!this.hasAnyMinDistToTarget()) {
            return;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            int lengthToTarget = tsp.minTargetDistance();
            if (lengthToTarget == -1) continue;
            Preconditions.checkState((lengthToTarget >= tracedLengthToTarget ? 1 : 0) != 0, (String)"First time tracing should be with shortest length to target");
            if (lengthToTarget <= tracedLengthToTarget) continue;
            this.globalState.schedule(this, lengthFromSource, lengthToTarget, GlobalState.ScheduleSource.Validation);
        }
    }

    public void decrementTargetCount() {
        this.globalState.hooks.decrementTargetCount(this, this.remainingTargetCount);
        --this.remainingTargetCount;
        Preconditions.checkState((this.remainingTargetCount >= 0 ? 1 : 0) != 0, (String)"Target count should never be negative");
        if (this.remainingTargetCount == 0) {
            this.globalState.decrementUnsaturatedTargets();
        }
    }

    public boolean hasBeenSeen(TraversalDirection direction) {
        return direction == TraversalDirection.Forward && this.discoveredForward || direction == TraversalDirection.Backward && this.discoveredBackward;
    }

    public boolean hasSourceSignpost(TwoWaySignpost signpost) {
        for (TwoWaySignpost tsp : this.sourceSignposts) {
            if (!tsp.equals(signpost)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTargetSignpost(TwoWaySignpost signpost) {
        if (this.targetSignposts == null) {
            return false;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            if (!tsp.equals(signpost)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMinDistToTarget(int minDistToTarget) {
        if (this.targetSignposts == null) {
            return false;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            if (tsp.minTargetDistance() != minDistToTarget) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyMinDistToTarget() {
        boolean res = this.targetSignposts != null;
        Preconditions.checkState((!res || this.targetSignposts.notEmpty() ? 1 : 0) != 0, (String)"If targetSignposts isn't null it's never supposed to be empty");
        return res;
    }

    private int minTargetDistance() {
        if (this.targetSignposts == null) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (TwoWaySignpost tsp : this.targetSignposts) {
            int curr = tsp.minTargetDistance();
            if (curr == -1 || curr >= min) continue;
            min = curr;
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    public String toString() {
        String stateName = String.valueOf(this.state.id());
        SlotOrName slotOrName = this.state.slotOrName();
        if (slotOrName instanceof SlotOrName.VarName) {
            SlotOrName.VarName name = (SlotOrName.VarName)slotOrName;
            stateName = name.name();
        }
        return "(" + this.nodeId + "," + stateName + ")";
    }

    public boolean isSaturated() {
        return this.remainingTargetCount == 0;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + Lengths.SHALLOW_SIZE;
    }

    public <T extends TwoWaySignpost> T upsertSourceSignpost(T signpost) {
        for (TwoWaySignpost existing : this.sourceSignposts) {
            if (!signpost.equals(existing)) continue;
            return (T)existing;
        }
        this.addSourceSignpost(signpost, -1);
        return signpost;
    }
}

