/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SearchMode;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class FoundNodes
implements AutoCloseable {
    private final HeapTrackingArrayList<HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>>> history;
    private HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> forwardFrontier;
    private HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> backwardFrontier;
    private BufferState bufferState = BufferState.Closed;
    private HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> frontierBuffer;
    private final MemoryTracker memoryTracker;
    private final SearchMode mode;
    private final int nfaStateCount;
    private int forwardDepth = 0;
    private int backwardDepth = 0;

    public FoundNodes(MemoryTracker memoryTracker, SearchMode mode, int nfaStateCount) {
        this.memoryTracker = memoryTracker.getScopedMemoryTracker();
        this.mode = mode;
        this.history = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);
        this.forwardFrontier = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker);
        if (mode == SearchMode.Bidirectional) {
            this.backwardFrontier = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker);
        }
        this.frontierBuffer = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker);
        this.nfaStateCount = nfaStateCount;
    }

    public void addToBuffer(NodeState nodeState) {
        Preconditions.checkState((this.bufferState == BufferState.Open ? 1 : 0) != 0, (String)"NodeState added to closed buffer");
        HeapTrackingArrayList nodeStates = (HeapTrackingArrayList)this.frontierBuffer.get(nodeState.id());
        if (nodeStates == null) {
            nodeStates = HeapTrackingArrayList.newEmptyArrayList((int)this.nfaStateCount, (MemoryTracker)this.memoryTracker);
            this.frontierBuffer.put(nodeState.id(), (Object)nodeStates);
        }
        nodeStates.set(nodeState.state().id(), (Object)nodeState);
    }

    public NodeState get(long nodeId, int stateId) {
        NodeState nodeState = this.getFromLevel(this.frontierBuffer, nodeId, stateId);
        if (nodeState != null) {
            return nodeState;
        }
        nodeState = this.getFromLevel(this.forwardFrontier, nodeId, stateId);
        if (nodeState != null) {
            return nodeState;
        }
        if (this.mode == SearchMode.Bidirectional && (nodeState = this.getFromLevel(this.backwardFrontier, nodeId, stateId)) != null) {
            return nodeState;
        }
        for (int i = this.history.size() - 1; i >= 0; --i) {
            nodeState = this.getFromLevel((HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>>)((HeapTrackingLongObjectHashMap)this.history.get(i)), nodeId, stateId);
            if (nodeState == null) continue;
            return nodeState;
        }
        return null;
    }

    private NodeState getFromLevel(HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> level, long nodeId, int stateId) {
        if (level.isEmpty()) {
            return null;
        }
        HeapTrackingArrayList nodeStates = (HeapTrackingArrayList)level.get(nodeId);
        if (nodeStates == null) {
            return null;
        }
        return (NodeState)nodeStates.get(stateId);
    }

    public void openBuffer() {
        Preconditions.checkState((this.bufferState == BufferState.Closed ? 1 : 0) != 0, (String)"Buffer opened when it was not closed");
        this.frontierBuffer = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker, (int)Math.max(1, this.frontierBuffer.size()));
        this.bufferState = BufferState.Open;
    }

    public void commitBuffer(TraversalDirection direction) {
        Preconditions.checkState((this.bufferState == BufferState.Open ? 1 : 0) != 0, (String)"Buffer closed when it was not open");
        switch (direction) {
            case Forward: {
                if (this.forwardFrontier.notEmpty()) {
                    this.history.add(this.forwardFrontier);
                }
                ++this.forwardDepth;
                this.forwardFrontier = this.frontierBuffer;
                break;
            }
            case Backward: {
                if (this.backwardFrontier.notEmpty()) {
                    this.history.add(this.backwardFrontier);
                }
                ++this.backwardDepth;
                this.backwardFrontier = this.frontierBuffer;
            }
        }
        this.bufferState = BufferState.Closed;
    }

    public HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> frontier(TraversalDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case TraversalDirection.Forward -> this.forwardFrontier;
            case TraversalDirection.Backward -> this.backwardFrontier;
        };
    }

    public TraversalDirection getNextExpansionDirection() {
        if (this.mode == SearchMode.Unidirectional) {
            return TraversalDirection.Forward;
        }
        if (this.forwardFrontier.isEmpty()) {
            return TraversalDirection.Backward;
        }
        if (this.backwardFrontier.isEmpty()) {
            return TraversalDirection.Forward;
        }
        if (this.backwardFrontier.size() < this.forwardFrontier.size()) {
            return TraversalDirection.Backward;
        }
        return TraversalDirection.Forward;
    }

    public boolean hasMore() {
        Preconditions.checkState((this.bufferState == BufferState.Closed ? 1 : 0) != 0, (String)"Should not check frontier state when buffer open");
        if (this.mode == SearchMode.Unidirectional) {
            return this.forwardFrontier.notEmpty();
        }
        return this.forwardFrontier.notEmpty() && this.backwardFrontier.notEmpty();
    }

    @Override
    public void close() {
        this.memoryTracker.close();
    }

    public int forwardDepth() {
        return this.forwardDepth;
    }

    public int backwardDepth() {
        return this.backwardDepth;
    }

    public int totalDepth() {
        return this.forwardDepth + this.backwardDepth;
    }

    private static enum BufferState {
        Open,
        Closed;

    }
}

