/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.memory.MemoryTracker;

public final class FoundNodes
implements AutoCloseable {
    private final HeapTrackingArrayList<HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>>> history;
    private HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> frontier;
    private HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> frontierBuffer;
    private final MemoryTracker memoryTracker;
    private final int nfaStateCount;

    public FoundNodes(MemoryTracker memoryTracker, int nfaStateCount) {
        this.memoryTracker = memoryTracker.getScopedMemoryTracker();
        this.history = HeapTrackingArrayList.newArrayList((MemoryTracker)this.memoryTracker);
        this.frontier = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker);
        this.frontierBuffer = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker);
        this.nfaStateCount = nfaStateCount;
    }

    public void addToBuffer(NodeState nodeState) {
        HeapTrackingArrayList nodeStates = (HeapTrackingArrayList)this.frontierBuffer.get(nodeState.id());
        if (nodeStates == null) {
            nodeStates = HeapTrackingArrayList.newEmptyArrayList((int)this.nfaStateCount, (MemoryTracker)this.memoryTracker);
            this.frontierBuffer.put(nodeState.id(), (Object)nodeStates);
        }
        nodeStates.set(nodeState.state().id(), (Object)nodeState);
    }

    public NodeState get(long nodeId, int stateId) {
        NodeState nodeState;
        HeapTrackingArrayList nodeStates = (HeapTrackingArrayList)this.frontierBuffer.get(nodeId);
        if (nodeStates != null && (nodeState = (NodeState)nodeStates.get(stateId)) != null) {
            return nodeState;
        }
        nodeStates = (HeapTrackingArrayList)this.frontier.get(nodeId);
        if (nodeStates != null && (nodeState = (NodeState)nodeStates.get(stateId)) != null) {
            return nodeState;
        }
        for (int i = this.history.size() - 1; i >= 0; --i) {
            NodeState nodeState2;
            nodeStates = (HeapTrackingArrayList)((HeapTrackingLongObjectHashMap)this.history.get(i)).get(nodeId);
            if (nodeStates == null || (nodeState2 = (NodeState)nodeStates.get(stateId)) == null) continue;
            return nodeState2;
        }
        return null;
    }

    public void shuffleFrontiers() {
        this.history.add(this.frontier);
        this.frontier = this.frontierBuffer;
        this.frontierBuffer = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)this.memoryTracker, (int)this.frontier.size());
    }

    public HeapTrackingLongObjectHashMap<HeapTrackingArrayList<NodeState>> frontier() {
        return this.frontier;
    }

    public boolean hasMore() {
        return this.frontier.notEmpty() || this.frontierBuffer.notEmpty();
    }

    @Override
    public void close() {
        this.memoryTracker.close();
    }

    public int depth() {
        return this.history.size();
    }
}

