/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.helpers.UnionTokenIndexCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;

public abstract class UnionNodeLabelIndexCursor
extends UnionTokenIndexCursor<NodeLabelIndexCursor> {
    public static UnionNodeLabelIndexCursor ascendingUnionNodeLabelIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] labels, NodeLabelIndexCursor[] cursors) throws KernelException {
        assert (labels.length == cursors.length);
        for (int i = 0; i < labels.length; ++i) {
            read.nodeLabelScan(tokenReadSession, cursors[i], IndexQueryConstraints.ordered((IndexOrder)IndexOrder.ASCENDING), new TokenPredicate(labels[i]), cursorContext);
        }
        return new AscendingUnionLabelIndexCursor(cursors);
    }

    public static UnionNodeLabelIndexCursor descendingUnionNodeLabelIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] labels, NodeLabelIndexCursor[] cursors) throws KernelException {
        assert (labels.length == cursors.length);
        for (int i = 0; i < labels.length; ++i) {
            read.nodeLabelScan(tokenReadSession, cursors[i], IndexQueryConstraints.ordered((IndexOrder)IndexOrder.DESCENDING), new TokenPredicate(labels[i]), cursorContext);
        }
        return new DescendingUnionLabelIndexCursor(cursors);
    }

    public static UnionNodeLabelIndexCursor unionNodeLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
        return new AscendingUnionLabelIndexCursor(cursors);
    }

    UnionNodeLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
        super((Cursor[])cursors);
    }

    @Override
    long reference(NodeLabelIndexCursor cursor) {
        return cursor.nodeReference();
    }

    private static final class AscendingUnionLabelIndexCursor
    extends UnionNodeLabelIndexCursor {
        AscendingUnionLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
            super(cursors);
        }

        @Override
        int compare(long current, long other) {
            return Long.compare(current, other);
        }

        @Override
        long extremeValue() {
            return Long.MAX_VALUE;
        }
    }

    private static final class DescendingUnionLabelIndexCursor
    extends UnionNodeLabelIndexCursor {
        DescendingUnionLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
            super(cursors);
        }

        @Override
        int compare(long current, long other) {
            return -Long.compare(current, other);
        }

        @Override
        long extremeValue() {
            return Long.MIN_VALUE;
        }
    }
}

