/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.helpers.SkippableCompositeCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;

public abstract class IntersectionNodeLabelIndexCursor
extends DefaultCloseListenable
implements SkippableCompositeCursor {
    private final NodeLabelIndexCursor[] cursors;

    public static IntersectionNodeLabelIndexCursor ascendingIntersectionNodeLabelIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] labels, NodeLabelIndexCursor[] cursors) throws KernelException {
        assert (labels.length == cursors.length);
        for (int i = 0; i < labels.length; ++i) {
            read.nodeLabelScan(tokenReadSession, cursors[i], IndexQueryConstraints.ordered((IndexOrder)IndexOrder.ASCENDING), new TokenPredicate(labels[i]), cursorContext);
        }
        return new AscendingIntersectionLabelIndexCursor(cursors);
    }

    public static IntersectionNodeLabelIndexCursor descendingIntersectionNodeLabelIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] labels, NodeLabelIndexCursor[] cursors) throws KernelException {
        assert (labels.length == cursors.length);
        for (int i = 0; i < labels.length; ++i) {
            read.nodeLabelScan(tokenReadSession, cursors[i], IndexQueryConstraints.ordered((IndexOrder)IndexOrder.DESCENDING), new TokenPredicate(labels[i]), cursorContext);
        }
        return new DescendingIntersectionLabelIndexCursor(cursors);
    }

    public static IntersectionNodeLabelIndexCursor intersectionNodeLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
        return new AscendingIntersectionLabelIndexCursor(cursors);
    }

    IntersectionNodeLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
        assert (cursors != null && cursors.length > 0);
        this.cursors = cursors;
    }

    abstract int compare(long var1, long var3);

    public boolean next() {
        for (NodeLabelIndexCursor cursor : this.cursors) {
            if (cursor.next()) continue;
            return false;
        }
        if (this.cursors.length == 1) {
            return true;
        }
        int i = 0;
        while (true) {
            long secondReference;
            NodeLabelIndexCursor first = this.cursors[i];
            NodeLabelIndexCursor second = this.cursors[i + 1];
            long firstReference = first.nodeReference();
            int compare = this.compare(firstReference, secondReference = second.nodeReference());
            if (compare == 0) {
                if (++i != this.cursors.length - 1) continue;
                return true;
            }
            if (compare < 0) {
                for (int j = 0; j <= i; ++j) {
                    NodeLabelIndexCursor cursor = this.cursors[j];
                    cursor.skipUntil(secondReference);
                    if (cursor.next()) continue;
                    return false;
                }
                i = 0;
                continue;
            }
            second.skipUntil(firstReference);
            if (!second.next()) break;
        }
        return false;
    }

    public void setTracer(KernelReadTracer tracer) {
        for (NodeLabelIndexCursor cursor : this.cursors) {
            if (cursor == null) continue;
            cursor.setTracer(tracer);
        }
    }

    public void removeTracer() {
        for (NodeLabelIndexCursor cursor : this.cursors) {
            if (cursor == null) continue;
            cursor.removeTracer();
        }
    }

    @Override
    public long reference() {
        return this.cursors[0].nodeReference();
    }

    public void closeInternal() {
    }

    public void skipUntil(long id) {
        for (NodeLabelIndexCursor cursor : this.cursors) {
            cursor.skipUntil(id);
        }
    }

    public boolean isClosed() {
        return false;
    }

    private static final class AscendingIntersectionLabelIndexCursor
    extends IntersectionNodeLabelIndexCursor {
        AscendingIntersectionLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
            super(cursors);
        }

        @Override
        int compare(long current, long other) {
            return Long.compare(current, other);
        }
    }

    private static final class DescendingIntersectionLabelIndexCursor
    extends IntersectionNodeLabelIndexCursor {
        DescendingIntersectionLabelIndexCursor(NodeLabelIndexCursor[] cursors) {
            super(cursors);
        }

        @Override
        int compare(long current, long other) {
            return -Long.compare(current, other);
        }
    }
}

