/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.Map;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.runtime.ExpressionCursors;
import org.neo4j.cypher.operations.ListCoercer;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public final class CypherCoercions {
    private static final Map<Class<? extends Neo4jTypes.AnyType>, Coercer> STATIC_CONVERTERS = Map.ofEntries(Map.entry(Neo4jTypes.NTAny.getClass(), (a, ignore2, cursors) -> a), Map.entry(Neo4jTypes.NTString.getClass(), (a, ignore2, cursors) -> CypherCoercions.asTextValueOrNull(a)), Map.entry(Neo4jTypes.NTNumber.getClass(), (a, ignore2, cursors) -> CypherCoercions.asNumberValueOrNull(a)), Map.entry(Neo4jTypes.NTInteger.getClass(), (a, ignore2, cursors) -> CypherCoercions.asIntegralValueOrNull(a)), Map.entry(Neo4jTypes.NTFloat.getClass(), (a, ignore2, cursors) -> CypherCoercions.asFloatingPointValueOrNull(a)), Map.entry(Neo4jTypes.NTBoolean.getClass(), (a, x, y) -> CypherCoercions.asBooleanValueOrNull(a)), Map.entry(Neo4jTypes.NTMap.getClass(), (a, c, cursors) -> CypherCoercions.asMapValueOrNull(a, c, cursors.nodeCursor(), cursors.relationshipScanCursor(), cursors.propertyCursor())), Map.entry(Neo4jTypes.NTNode.getClass(), (a, ignore2, cursors) -> CypherCoercions.asNodeValueOrNull(a)), Map.entry(Neo4jTypes.NTRelationship.getClass(), (a, ignore2, cursors) -> CypherCoercions.asRelationshipValueOrNull(a)), Map.entry(Neo4jTypes.NTPath.getClass(), (a, ignore2, cursors) -> CypherCoercions.asPathValueOrNull(a)), Map.entry(Neo4jTypes.NTGeometry.getClass(), (a, ignore2, cursors) -> CypherCoercions.asPointValueOrNull(a)), Map.entry(Neo4jTypes.NTPoint.getClass(), (a, ignore2, cursors) -> CypherCoercions.asPointValueOrNull(a)), Map.entry(Neo4jTypes.NTDateTime.getClass(), (a, ignore2, cursors) -> CypherCoercions.asDateTimeValueOrNull(a)), Map.entry(Neo4jTypes.NTLocalDateTime.getClass(), (a, ignore2, cursors) -> CypherCoercions.asLocalDateTimeValueOrNull(a)), Map.entry(Neo4jTypes.NTDate.getClass(), (a, ignore2, cursors) -> CypherCoercions.asDateValueOrNull(a)), Map.entry(Neo4jTypes.NTTime.getClass(), (a, ignore2, cursors) -> CypherCoercions.asTimeValueOrNull(a)), Map.entry(Neo4jTypes.NTLocalTime.getClass(), (a, ignore2, cursors) -> CypherCoercions.asLocalTimeValueOrNull(a)), Map.entry(Neo4jTypes.NTDuration.getClass(), (a, ignore2, cursors) -> CypherCoercions.asDurationValueOrNull(a)));

    private CypherCoercions() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static Value asStorableValue(AnyValue anyValue) {
        if (anyValue instanceof Value) {
            Value value = (Value)anyValue;
            return value;
        }
        if (anyValue instanceof ListValue) {
            ListValue list = (ListValue)anyValue;
            return list.toStorableArray();
        }
        throw new CypherTypeException("Property values can only be of primitive types or arrays thereof. Encountered: " + anyValue + ".");
    }

    public static Value asStorableValueOrNull(AnyValue anyValue) {
        ListValue list;
        if (anyValue instanceof Value) {
            Value value = (Value)anyValue;
            return value;
        }
        if (anyValue instanceof ListValue && ((list = (ListValue)anyValue).isEmpty() || list.itemValueRepresentation().canCreateArrayOfValueGroup())) {
            return list.toStorableArray();
        }
        return null;
    }

    public static AnyValue asTextValueOrNull(AnyValue value) {
        if (value instanceof TextValue) {
            TextValue text = (TextValue)value;
            return text;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "String");
    }

    public static AnyValue asNodeValueOrNull(AnyValue value) {
        if (value instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)value;
            return node;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Node");
    }

    public static AnyValue asRelationshipValueOrNull(AnyValue value) {
        if (value instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)value;
            return rel;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Relationship");
    }

    public static AnyValue asPathValueOrNull(AnyValue value) {
        if (value instanceof VirtualPathValue) {
            VirtualPathValue path = (VirtualPathValue)value;
            return path;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Path");
    }

    public static AnyValue asIntegralValueOrNull(AnyValue value) {
        if (value instanceof NumberValue) {
            NumberValue number = (NumberValue)value;
            return Values.longValue((long)number.longValue());
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Integer");
    }

    public static AnyValue asFloatingPointValueOrNull(AnyValue value) {
        if (value instanceof NumberValue) {
            NumberValue number = (NumberValue)value;
            return Values.doubleValue((double)number.doubleValue());
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Float");
    }

    public static AnyValue asBooleanValueOrNull(AnyValue value) {
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return booleanValue;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Boolean");
    }

    public static NumberValue asNumberValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value, "Number");
        }
        return (NumberValue)value;
    }

    public static AnyValue asNumberValueOrNull(AnyValue value) {
        if (value instanceof NumberValue) {
            NumberValue numberValue = (NumberValue)value;
            return numberValue;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Number");
    }

    public static AnyValue asPointValueOrNull(AnyValue value) {
        if (value instanceof PointValue) {
            PointValue point = (PointValue)value;
            return point;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Point");
    }

    public static AnyValue asDateValueOrNull(AnyValue value) {
        if (value instanceof DateValue) {
            DateValue date = (DateValue)value;
            return date;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Date");
    }

    public static AnyValue asTimeValueOrNull(AnyValue value) {
        if (value instanceof TimeValue) {
            TimeValue time = (TimeValue)value;
            return time;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Time");
    }

    public static AnyValue asLocalTimeValueOrNull(AnyValue value) {
        if (value instanceof LocalTimeValue) {
            LocalTimeValue time = (LocalTimeValue)value;
            return time;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "LocalTime");
    }

    public static AnyValue asLocalDateTimeValueOrNull(AnyValue value) {
        if (value instanceof LocalDateTimeValue) {
            LocalDateTimeValue time = (LocalDateTimeValue)value;
            return time;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "LocalDateTime");
    }

    public static AnyValue asDateTimeValueOrNull(AnyValue value) {
        if (value instanceof DateTimeValue) {
            DateTimeValue date = (DateTimeValue)value;
            return date;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "DateTime");
    }

    public static AnyValue asDurationValueOrNull(AnyValue value) {
        if (value instanceof DurationValue) {
            DurationValue duration = (DurationValue)value;
            return duration;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        throw CypherCoercions.cantCoerce(value, "Duration");
    }

    public static MapValue asMapValue(AnyValue value, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor) {
        if (value instanceof MapValue) {
            MapValue map = (MapValue)value;
            return map;
        }
        if (value instanceof NodeValue.DirectNodeValue) {
            NodeValue.DirectNodeValue node = (NodeValue.DirectNodeValue)value;
            return node.properties();
        }
        if (value instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)value;
            return access.nodeAsMap(node.id(), nodeCursor, propertyCursor);
        }
        if (value instanceof RelationshipValue.DirectRelationshipValue) {
            RelationshipValue.DirectRelationshipValue rel = (RelationshipValue.DirectRelationshipValue)value;
            return rel.properties();
        }
        if (value instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)value;
            return access.relationshipAsMap(rel.id(), relationshipCursor, propertyCursor);
        }
        throw CypherCoercions.cantCoerce(value, "Map");
    }

    public static AnyValue asMapValueOrNull(AnyValue value, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor) {
        return value == Values.NO_VALUE ? Values.NO_VALUE : CypherCoercions.asMapValue(value, access, nodeCursor, relationshipCursor, propertyCursor);
    }

    public static SequenceValue asSequenceValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof SequenceValue)) {
            throw CypherCoercions.cantCoerce(value, "SequenceValue");
        }
        return (SequenceValue)value;
    }

    static CypherTypeException cantCoerce(AnyValue value, String type) {
        return new CypherTypeException(String.format("Can't coerce `%s` to %s", value, type));
    }

    public static Coercer coercerFromType(Neo4jTypes.AnyType type) {
        Coercer coercer = STATIC_CONVERTERS.get(type.getClass());
        if (coercer != null) {
            return coercer;
        }
        if (type instanceof Neo4jTypes.ListType) {
            Neo4jTypes.ListType listType = (Neo4jTypes.ListType)type;
            return new ListCoercer(listType.innerType());
        }
        throw new CypherTypeException(String.format("Can't coerce to type %s", type));
    }

    @FunctionalInterface
    public static interface Coercer {
        public AnyValue apply(AnyValue var1, DbAccess var2, ExpressionCursors var3);
    }
}

