/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import org.neo4j.cypher.internal.runtime.CastSupport;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ClassTag;

public final class CastSupport$ {
    public static CastSupport$ MODULE$;

    static {
        new CastSupport$();
    }

    public <A> A castOrFail(Object value, ClassTag<A> ev) {
        Object object = value;
        Option option = ev.unapply(object);
        if (option.isEmpty() || !(option.get() instanceof Object)) {
            throw new CypherTypeException(new StringBuilder(33).append("Expected ").append(value).append(" to be a ").append(ev.runtimeClass().getName()).append(", but it was a ").append(value.getClass().getName()).toString());
        }
        Object object2 = object;
        return (A)object2;
    }

    public <A extends AnyValue> A castOrFail(AnyValue value, ClassTag<A> ev) {
        AnyValue anyValue = value;
        Option option = ev.unapply((Object)anyValue);
        if (option.isEmpty() || option.get() == null) {
            throw this.typeError(value, ev);
        }
        AnyValue anyValue2 = anyValue;
        return (A)anyValue2;
    }

    public <A extends AnyValue> CypherTypeException typeError(AnyValue value, ClassTag<A> ev) {
        throw new CypherTypeException(new StringBuilder(33).append("Expected ").append(value).append(" to be a ").append(ev.runtimeClass().getName()).append(", but it was a ").append(value.getClass().getName()).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AnyValue merge(AnyValue a, AnyValue b) {
        Tuple2 tuple2 = new Tuple2((Object)a, (Object)b);
        if (tuple2 != null && tuple2._1() instanceof TextValue && tuple2._2() instanceof TextValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof BooleanValue && tuple2._2() instanceof BooleanValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof ByteValue && tuple2._2() instanceof ByteValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof ByteValue && tuple2._2() instanceof ShortValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ByteValue && tuple2._2() instanceof IntValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ByteValue && tuple2._2() instanceof LongValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ByteValue && tuple2._2() instanceof FloatValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ByteValue && tuple2._2() instanceof DoubleValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ShortValue && tuple2._2() instanceof IntValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ShortValue && tuple2._2() instanceof LongValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ShortValue && tuple2._2() instanceof FloatValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ShortValue && tuple2._2() instanceof DoubleValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof ShortValue && tuple2._2() instanceof NumberValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof IntValue && tuple2._2() instanceof LongValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof IntValue && tuple2._2() instanceof FloatValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof IntValue && tuple2._2() instanceof DoubleValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof IntValue && tuple2._2() instanceof NumberValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof LongValue && tuple2._2() instanceof FloatValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof LongValue && tuple2._2() instanceof DoubleValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof LongValue && tuple2._2() instanceof NumberValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof FloatValue && tuple2._2() instanceof DoubleValue) {
            return b;
        }
        if (tuple2 != null && tuple2._1() instanceof FloatValue && tuple2._2() instanceof NumberValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof DoubleValue && tuple2._2() instanceof NumberValue) {
            return a;
        }
        if (tuple2 != null) {
            AnyValue p1 = (AnyValue)tuple2._1();
            AnyValue p2 = (AnyValue)tuple2._2();
            if (p1 instanceof PointValue) {
                PointValue pointValue = (PointValue)p1;
                if (p2 instanceof PointValue) {
                    PointValue pointValue2 = (PointValue)p2;
                    CoordinateReferenceSystem coordinateReferenceSystem = pointValue.getCoordinateReferenceSystem();
                    CoordinateReferenceSystem coordinateReferenceSystem2 = pointValue2.getCoordinateReferenceSystem();
                    if (coordinateReferenceSystem == null ? coordinateReferenceSystem2 != null : !coordinateReferenceSystem.equals(coordinateReferenceSystem2)) {
                        throw new CypherTypeException("Collections containing point values with different CRS can not be stored in properties.");
                    }
                    if (pointValue.coordinate().length == pointValue2.coordinate().length) return pointValue;
                    throw new CypherTypeException("Collections containing point values with different dimensions can not be stored in properties.");
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof DateValue && tuple2._2() instanceof DateValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof DateTimeValue && tuple2._2() instanceof DateTimeValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof LocalDateTimeValue && tuple2._2() instanceof LocalDateTimeValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof TimeValue && tuple2._2() instanceof TimeValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof LocalTimeValue && tuple2._2() instanceof LocalTimeValue) {
            return a;
        }
        if (tuple2 != null && tuple2._1() instanceof DurationValue && tuple2._2() instanceof DurationValue) {
            return a;
        }
        if (a == Values.NO_VALUE) throw new CypherTypeException("Collections containing null values can not be stored in properties.");
        if (b == Values.NO_VALUE) {
            throw new CypherTypeException("Collections containing null values can not be stored in properties.");
        }
        if (a instanceof ListValue) throw new CypherTypeException("Collections containing collections can not be stored in properties.");
        if (!(b instanceof ListValue)) throw new CypherTypeException("Neo4j only supports a subset of Cypher types for storage as singleton or array properties. Please refer to section cypher/syntax/values of the manual for more details.");
        throw new CypherTypeException("Collections containing collections can not be stored in properties.");
    }

    public CastSupport.Converter getConverter(AnyValue x) {
        CastSupport.Converter converter;
        AnyValue anyValue = x;
        if (anyValue instanceof CharValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Character.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.charArray((char[])((char[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof TextValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(String.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.stringArray((String[])((String[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof BooleanValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Boolean.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.booleanArray((boolean[])((boolean[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof ByteValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Byte.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.byteArray((byte[])((byte[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof ShortValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Short.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.shortArray((short[])((short[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof IntValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Integer.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.intArray((int[])((int[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof LongValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Long.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.longArray((long[])((long[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof FloatValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Float.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.floatArray((float[])((float[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof DoubleValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Double.TYPE, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.doubleArray((double[])((double[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof PointValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(PointValue.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.pointArray((PointValue[])((PointValue[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof Point) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(Point.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.pointArray((Point[])((Point[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof DurationValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(TemporalAmount.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.durationArray((TemporalAmount[])((TemporalAmount[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof DateTimeValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(ZonedDateTime.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.dateTimeArray((ZonedDateTime[])((ZonedDateTime[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof DateValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(LocalDate.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.dateArray((LocalDate[])((LocalDate[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof LocalTimeValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(LocalTime.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.localTimeArray((LocalTime[])((LocalTime[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof TimeValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(OffsetTime.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.timeArray((OffsetTime[])((OffsetTime[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else if (anyValue instanceof LocalDateTimeValue) {
            CastSupport.ArrayConverterWriter arrayConverterWriter = new CastSupport.ArrayConverterWriter(LocalDateTime.class, (Function1<Object, ArrayValue>)(Function1 & Serializable & scala.Serializable)a -> Values.localDateTimeArray((LocalDateTime[])((LocalDateTime[])a)));
            converter = new CastSupport.Converter((Function1<ListValue, ArrayValue>)(Function1 & Serializable & scala.Serializable)value -> MODULE$.transform(arrayConverterWriter, (ListValue)value));
        } else {
            throw new CypherTypeException(new StringBuilder(80).append("Property values can only be of primitive types or arrays thereof. Encountered: ").append(x).append(".").toString());
        }
        return converter;
    }

    private ArrayValue transform(CastSupport.ArrayConverterWriter writer, ListValue value) {
        value.writeTo((AnyValueWriter)writer);
        return writer.array();
    }

    private CastSupport$() {
        MODULE$ = this;
    }
}

