/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;

public class InCache {
    private final LinkedHashMap<ListValue, InCacheChecker> seen;

    public InCache() {
        this(16);
    }

    public InCache(final int maxSize) {
        this.seen = new LinkedHashMap<ListValue, InCacheChecker>(maxSize >> 2, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ListValue, InCacheChecker> eldest) {
                return super.size() > maxSize;
            }
        };
    }

    public Value check(AnyValue value, ListValue list) {
        if (list.isEmpty()) {
            return Values.FALSE;
        }
        if (value == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        InCacheChecker checker = this.seen.computeIfAbsent(list, k -> new InCacheChecker(list.iterator()));
        return checker.check(value);
    }

    private static class InCacheChecker {
        private final Set<AnyValue> seen = new HashSet<AnyValue>();
        private final Iterator<AnyValue> iterator;
        private boolean seenUndefined;

        private InCacheChecker(Iterator<AnyValue> iterator) {
            this.iterator = iterator;
        }

        private Value check(AnyValue value) {
            if (this.seen.contains(value)) {
                return Values.TRUE;
            }
            block5: while (this.iterator.hasNext()) {
                AnyValue next = this.iterator.next();
                if (next == Values.NO_VALUE) {
                    this.seenUndefined = true;
                    continue;
                }
                this.seen.add(next);
                switch (next.ternaryEquals(value)) {
                    case TRUE: {
                        return Values.TRUE;
                    }
                    case UNDEFINED: {
                        this.seenUndefined = true;
                    }
                    case FALSE: {
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unknown state");
            }
            return this.seenUndefined ? Values.NO_VALUE : Values.FALSE;
        }
    }
}

