/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;

public final class ValuePopulation {
    private ValuePopulation() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue populate(AnyValue value) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            ((NodeEntityWrappingNodeValue)value).populate();
        } else if (value instanceof RelationshipEntityWrappingValue) {
            ((RelationshipEntityWrappingValue)value).populate();
        } else if (value instanceof PathValue) {
            PathValue path = (PathValue)value;
            for (NodeValue nodeValue : path.nodes()) {
                ValuePopulation.populate(nodeValue);
            }
            for (NodeValue nodeValue : path.relationships()) {
                ValuePopulation.populate((RelationshipValue)nodeValue);
            }
        } else if (value instanceof ListValue) {
            for (AnyValue v : (ListValue)value) {
                ValuePopulation.populate(v);
            }
        } else if (value instanceof MapValue) {
            ((MapValue)value).foreach((ignore, anyValue) -> ValuePopulation.populate(anyValue));
        }
        return value;
    }

    public static NodeValue populate(NodeValue value) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            ((NodeEntityWrappingNodeValue)value).populate();
        }
        return value;
    }

    public static RelationshipValue populate(RelationshipValue value) {
        if (value instanceof RelationshipEntityWrappingValue) {
            ((RelationshipEntityWrappingValue)value).populate();
        }
        return value;
    }
}

