/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;
import org.opencypher.v9_0.util.CypherTypeException;
import org.opencypher.v9_0.util.InvalidArgumentException;

public final class CypherFunctions {
    private CypherFunctions() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static DoubleValue sin(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.sin(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sin()");
    }

    public static DoubleValue asin(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.asin(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("asin()");
    }

    public static DoubleValue haversin(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)((1.0 - Math.cos(((NumberValue)in).doubleValue())) / 2.0));
        }
        throw CypherFunctions.needsNumbers("haversin()");
    }

    public static DoubleValue cos(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.cos(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("cos()");
    }

    public static DoubleValue cot(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)(1.0 / Math.tan(((NumberValue)in).doubleValue())));
        }
        throw CypherFunctions.needsNumbers("cot()");
    }

    public static DoubleValue acos(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.acos(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("acos()");
    }

    public static DoubleValue tan(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.tan(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("tan()");
    }

    public static DoubleValue atan(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.atan(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan()");
    }

    public static DoubleValue atan2(AnyValue y, AnyValue x) {
        if (y instanceof NumberValue && x instanceof NumberValue) {
            return Values.doubleValue((double)Math.atan2(((NumberValue)y).doubleValue(), ((NumberValue)x).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan2()");
    }

    public static DoubleValue ceil(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.ceil(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("ceil()");
    }

    public static DoubleValue floor(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.floor(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("floor()");
    }

    public static DoubleValue round(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.round(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("round()");
    }

    public static NumberValue abs(AnyValue in) {
        if (in instanceof NumberValue) {
            if (in instanceof IntegralValue) {
                return Values.longValue((long)Math.abs(((NumberValue)in).longValue()));
            }
            return Values.doubleValue((double)Math.abs(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("abs()");
    }

    public static DoubleValue toDegrees(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.toDegrees(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toDegrees()");
    }

    public static DoubleValue exp(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.exp(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("exp()");
    }

    public static DoubleValue log(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.log(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log()");
    }

    public static DoubleValue log10(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.log10(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log10()");
    }

    public static DoubleValue toRadians(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.toRadians(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("toRadians()");
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue, AnyValue stepValue) {
        long step = CypherFunctions.asLong(stepValue);
        if (step == 0L) {
            throw new InvalidArgumentException("step argument to range() cannot be zero", null);
        }
        return VirtualValues.range((long)CypherFunctions.asLong(startValue), (long)CypherFunctions.asLong(endValue), (long)step);
    }

    public static LongValue signum(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.longValue((long)((long)Math.signum(((NumberValue)in).doubleValue())));
        }
        throw CypherFunctions.needsNumbers("signum()");
    }

    public static DoubleValue sqrt(AnyValue in) {
        if (in instanceof NumberValue) {
            return Values.doubleValue((double)Math.sqrt(((NumberValue)in).doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sqrt()");
    }

    public static DoubleValue rand() {
        return Values.doubleValue((double)ThreadLocalRandom.current().nextDouble());
    }

    private static long asLong(AnyValue value) {
        if (value instanceof NumberValue) {
            return ((NumberValue)value).longValue();
        }
        throw new CypherTypeException("Expected a numeric value but got: " + value.toString(), null);
    }

    private static CypherTypeException needsNumbers(String method) {
        return new CypherTypeException(String.format("%s requires numbers", method), null);
    }
}

