/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.opencypher.v9_0.util.CypherTypeException;

public final class CypherBoolean {
    private static final BooleanMapper BOOLEAN_MAPPER = new BooleanMapper();

    private CypherBoolean() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static Value xor(AnyValue lhs, AnyValue rhs) {
        return lhs == Values.TRUE ^ rhs == Values.TRUE ? Values.TRUE : Values.FALSE;
    }

    public static Value not(AnyValue in) {
        return in != Values.TRUE ? Values.TRUE : Values.FALSE;
    }

    public static Value equals(AnyValue lhs, AnyValue rhs) {
        Boolean compare = lhs.ternaryEquals(rhs);
        if (compare == null) {
            return Values.NO_VALUE;
        }
        return compare != false ? Values.TRUE : Values.FALSE;
    }

    public static Value notEquals(AnyValue lhs, AnyValue rhs) {
        Boolean compare = lhs.ternaryEquals(rhs);
        if (compare == null) {
            return Values.NO_VALUE;
        }
        return compare != false ? Values.FALSE : Values.TRUE;
    }

    public static Value coerceToBoolean(AnyValue value) {
        return (Value)value.map((ValueMapper)BOOLEAN_MAPPER);
    }

    private static final class BooleanMapper
    implements ValueMapper<Value> {
        private BooleanMapper() {
        }

        public Value mapPath(PathValue value) {
            return value.size() > 0 ? Values.TRUE : Values.FALSE;
        }

        public Value mapNode(VirtualNodeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapRelationship(VirtualRelationshipValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapMap(MapValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapNoValue() {
            return Values.NO_VALUE;
        }

        public Value mapSequence(SequenceValue value) {
            return value.length() > 0 ? Values.TRUE : Values.FALSE;
        }

        public Value mapText(TextValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapBoolean(BooleanValue value) {
            return value;
        }

        public Value mapNumber(NumberValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapDateTime(DateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapLocalDateTime(LocalDateTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapDate(DateValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapTime(TimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapLocalTime(LocalTimeValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapDuration(DurationValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }

        public Value mapPoint(PointValue value) {
            throw new CypherTypeException("Don't know how to treat that as a boolean: " + value, null);
        }
    }
}

