/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.cypher.internal.expressions.NormalForm;
import org.neo4j.cypher.internal.expressions.functions.VectorSimilarityCosine;
import org.neo4j.cypher.internal.expressions.functions.VectorSimilarityEuclidean;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.runtime.ExpressionCursors;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.RuntimeNotifier;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.RuntimeUnsatisfiableRelationshipTypeExpression;
import org.neo4j.cypher.internal.util.symbols.AnyType;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.ClosedDynamicUnionType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.DateType;
import org.neo4j.cypher.internal.util.symbols.DurationType;
import org.neo4j.cypher.internal.util.symbols.Float32Type;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.GeometryType;
import org.neo4j.cypher.internal.util.symbols.Integer16Type;
import org.neo4j.cypher.internal.util.symbols.Integer32Type;
import org.neo4j.cypher.internal.util.symbols.Integer8Type;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType;
import org.neo4j.cypher.internal.util.symbols.LocalDateTimeType;
import org.neo4j.cypher.internal.util.symbols.LocalTimeType;
import org.neo4j.cypher.internal.util.symbols.MapType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.NothingType;
import org.neo4j.cypher.internal.util.symbols.NullType;
import org.neo4j.cypher.internal.util.symbols.NumberType;
import org.neo4j.cypher.internal.util.symbols.PathType;
import org.neo4j.cypher.internal.util.symbols.PointType;
import org.neo4j.cypher.internal.util.symbols.PropertyValueCypher5Type;
import org.neo4j.cypher.internal.util.symbols.PropertyValueType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.VectorType;
import org.neo4j.cypher.internal.util.symbols.ZonedDateTimeType;
import org.neo4j.cypher.internal.util.symbols.ZonedTimeType;
import org.neo4j.cypher.operations.CursorUtils;
import org.neo4j.cypher.operations.CypherRuntimeParser;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.cypher.operations.VectorUtils;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarity;
import org.neo4j.kernel.api.vector.GQLVectorDistanceFunction;
import org.neo4j.kernel.api.vector.GQLVectorNorm;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.token.api.TokenType;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.collection.Set;
import scala.jdk.javaapi.CollectionConverters;

public final class CypherFunctions {
    private static final String[] POINT_KEYS = new String[]{"crs", "x", "y", "z", "longitude", "latitude", "height", "srid"};
    public static final CypherTypeValueMapper CYPHER_TYPE_NAME_VALUE_MAPPER = new CypherTypeValueMapper();
    private static final Map<Class<? extends CypherType>, List<ValueRepresentation>> TYPE_TO_REPRESENTATIONS = Map.ofEntries(Map.entry(BooleanType.class, List.of(ValueRepresentation.BOOLEAN)), Map.entry(StringType.class, List.of(ValueRepresentation.UTF8_TEXT, ValueRepresentation.UTF16_TEXT)), Map.entry(IntegerType.class, List.of(ValueRepresentation.INT8, ValueRepresentation.INT16, ValueRepresentation.INT32, ValueRepresentation.INT64)), Map.entry(FloatType.class, List.of(ValueRepresentation.FLOAT32, ValueRepresentation.FLOAT64)), Map.entry(NumberType.class, List.of(ValueRepresentation.INT8, ValueRepresentation.INT16, ValueRepresentation.INT32, ValueRepresentation.INT64, ValueRepresentation.FLOAT32, ValueRepresentation.FLOAT64)), Map.entry(DateType.class, List.of(ValueRepresentation.DATE)), Map.entry(LocalTimeType.class, List.of(ValueRepresentation.LOCAL_TIME)), Map.entry(ZonedTimeType.class, List.of(ValueRepresentation.ZONED_TIME)), Map.entry(LocalDateTimeType.class, List.of(ValueRepresentation.LOCAL_DATE_TIME)), Map.entry(ZonedDateTimeType.class, List.of(ValueRepresentation.ZONED_DATE_TIME)), Map.entry(DurationType.class, List.of(ValueRepresentation.DURATION)), Map.entry(PointType.class, List.of(ValueRepresentation.GEOMETRY)), Map.entry(GeometryType.class, List.of(ValueRepresentation.GEOMETRY)));
    private static final Map<Class<? extends CypherType>, List<ValueRepresentation>> LIST_INNER_TYPE_TO_REPRESENTATIONS = Map.ofEntries(Map.entry(BooleanType.class, List.of(ValueRepresentation.BOOLEAN_ARRAY)), Map.entry(StringType.class, List.of(ValueRepresentation.TEXT_ARRAY)), Map.entry(IntegerType.class, List.of(ValueRepresentation.INT8_ARRAY, ValueRepresentation.INT16_ARRAY, ValueRepresentation.INT32_ARRAY, ValueRepresentation.INT64_ARRAY)), Map.entry(FloatType.class, List.of(ValueRepresentation.FLOAT32_ARRAY, ValueRepresentation.FLOAT64_ARRAY)), Map.entry(NumberType.class, List.of(ValueRepresentation.INT8_ARRAY, ValueRepresentation.INT16_ARRAY, ValueRepresentation.INT32_ARRAY, ValueRepresentation.INT64_ARRAY, ValueRepresentation.FLOAT32_ARRAY, ValueRepresentation.FLOAT64_ARRAY)), Map.entry(DateType.class, List.of(ValueRepresentation.DATE_ARRAY)), Map.entry(LocalTimeType.class, List.of(ValueRepresentation.LOCAL_TIME_ARRAY)), Map.entry(ZonedTimeType.class, List.of(ValueRepresentation.ZONED_TIME_ARRAY)), Map.entry(LocalDateTimeType.class, List.of(ValueRepresentation.LOCAL_DATE_TIME_ARRAY)), Map.entry(ZonedDateTimeType.class, List.of(ValueRepresentation.ZONED_DATE_TIME_ARRAY)), Map.entry(DurationType.class, List.of(ValueRepresentation.DURATION_ARRAY)), Map.entry(GeometryType.class, List.of(ValueRepresentation.GEOMETRY_ARRAY)), Map.entry(PointType.class, List.of(ValueRepresentation.GEOMETRY_ARRAY)));

    private CypherFunctions() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue sin(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.sin(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sin", in);
    }

    public static AnyValue sinh(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.sinh(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sinh", in);
    }

    public static AnyValue asin(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.asin(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("asin", in);
    }

    public static AnyValue haversin(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)((1.0 - Math.cos(number.doubleValue())) / 2.0));
        }
        throw CypherFunctions.needsNumbers("haversin", in);
    }

    public static AnyValue cos(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.cos(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("cos", in);
    }

    public static AnyValue cosh(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.cosh(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("cosh", in);
    }

    public static AnyValue cot(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)(1.0 / Math.tan(number.doubleValue())));
        }
        throw CypherFunctions.needsNumbers("cot", in);
    }

    public static AnyValue coth(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            double inDouble = number.doubleValue();
            if (Double.isInfinite(inDouble)) {
                if (Math.signum(inDouble) == -1.0) {
                    return Values.doubleValue((double)-1.0);
                }
                return Values.doubleValue((double)1.0);
            }
            if (inDouble == 0.0) {
                return Values.NaN;
            }
            return Values.doubleValue((double)(Math.cosh(inDouble) / Math.sinh(inDouble)));
        }
        throw CypherFunctions.needsNumbers("coth", in);
    }

    public static AnyValue acos(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.acos(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("acos", in);
    }

    public static AnyValue tan(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.tan(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("tan", in);
    }

    public static AnyValue tanh(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.tanh(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("tanh", in);
    }

    public static AnyValue atan(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.atan(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("atan", in);
    }

    public static AnyValue atan2(AnyValue y, AnyValue x) {
        if (y == Values.NO_VALUE || x == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (y instanceof NumberValue) {
            NumberValue yNumber = (NumberValue)y;
            if (x instanceof NumberValue) {
                NumberValue xNumber = (NumberValue)x;
                return Values.doubleValue((double)Math.atan2(yNumber.doubleValue(), xNumber.doubleValue()));
            }
        }
        if (y instanceof NumberValue) {
            throw CypherFunctions.needsNumbers("atan2", x);
        }
        throw CypherFunctions.needsNumbers("atan2", y);
    }

    public static AnyValue ceil(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.ceil(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("ceil", in);
    }

    public static AnyValue floor(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.floor(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("floor", in);
    }

    public static AnyValue round(AnyValue in) {
        return CypherFunctions.round(in, (AnyValue)Values.ZERO_INT, (AnyValue)Values.stringValue((String)"HALF_UP"), (AnyValue)Values.booleanValue((boolean)false));
    }

    public static AnyValue round(AnyValue in, AnyValue precision) {
        return CypherFunctions.round(in, precision, (AnyValue)Values.stringValue((String)"HALF_UP"), (AnyValue)Values.booleanValue((boolean)false));
    }

    public static AnyValue round(AnyValue in, AnyValue precisionValue, AnyValue modeValue) {
        return CypherFunctions.round(in, precisionValue, modeValue, (AnyValue)Values.booleanValue((boolean)true));
    }

    public static AnyValue round(AnyValue in, AnyValue precisionValue, AnyValue modeValue, AnyValue explicitModeValue) {
        RoundingMode mode;
        if (in == Values.NO_VALUE || precisionValue == Values.NO_VALUE || modeValue == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (!(modeValue instanceof StringValue)) {
            throw CypherFunctions.notAModeString("round", modeValue);
        }
        try {
            mode = RoundingMode.valueOf(((StringValue)modeValue).stringValue());
        }
        catch (IllegalArgumentException e) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N26).build()).build();
            throw new InvalidArgumentException(gql, "Unknown rounding mode. Valid values are: CEILING, FLOOR, UP, DOWN, HALF_EVEN, HALF_UP, HALF_DOWN, UNNECESSARY.");
        }
        if (in instanceof NumberValue) {
            NumberValue inNumber = (NumberValue)in;
            if (precisionValue instanceof NumberValue) {
                int precision = CypherFunctions.asIntExact(precisionValue, () -> "Invalid input for precision value in function 'round()'", "round");
                boolean explicitMode = ((BooleanValue)explicitModeValue).booleanValue();
                if (precision < 0) {
                    throw InvalidArgumentException.negRoundPrecision((int)precision);
                }
                double value = inNumber.doubleValue();
                if (Double.isInfinite(value) || Double.isNaN(value)) {
                    return Values.doubleValue((double)value);
                }
                if (precision == 0 && !explicitMode) {
                    return Values.doubleValue((double)Math.round(value));
                }
                BigDecimal bigDecimal = BigDecimal.valueOf(value);
                int newScale = Math.min(bigDecimal.scale(), precision);
                return Values.doubleValue((double)bigDecimal.setScale(newScale, mode).doubleValue());
            }
        }
        throw CypherFunctions.needsNumbers("round", in);
    }

    public static AnyValue abs(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            if (in instanceof IntegralValue) {
                return Values.longValue((long)Math.abs(number.longValue()));
            }
            return Values.doubleValue((double)Math.abs(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("abs", in);
    }

    public static AnyValue isNaN(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof FloatingPointValue) {
            FloatingPointValue f = (FloatingPointValue)in;
            return Values.booleanValue((boolean)f.isNaN());
        }
        if (in instanceof NumberValue) {
            return BooleanValue.FALSE;
        }
        throw CypherFunctions.needsNumbers("isNaN", in);
    }

    public static AnyValue toDegrees(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.toDegrees(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("degrees", in);
    }

    public static AnyValue exp(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.exp(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("exp", in);
    }

    public static AnyValue log(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.log(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log", in);
    }

    public static AnyValue log10(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.log10(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("log10", in);
    }

    public static AnyValue toRadians(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.toRadians(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("radians", in);
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue) {
        return VirtualValues.range((long)CypherFunctions.asLong(startValue, () -> "Invalid input for start value in function 'range()'", "range"), (long)CypherFunctions.asLong(endValue, () -> "Invalid input for end value in function 'range()'", "range"), (long)1L);
    }

    public static ListValue range(AnyValue startValue, AnyValue endValue, AnyValue stepValue) {
        long step = CypherFunctions.asLong(stepValue, () -> "Invalid input for step value in function 'range()'", "range");
        if (step == 0L) {
            throw InvalidArgumentException.zeroStepRange();
        }
        return VirtualValues.range((long)CypherFunctions.asLong(startValue, () -> "Invalid input for start value in function 'range()'", "range"), (long)CypherFunctions.asLong(endValue, () -> "Invalid input for end value in function 'range()'", "range"), (long)step);
    }

    public static AnyValue signum(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.longValue((long)((long)Math.signum(number.doubleValue())));
        }
        throw CypherFunctions.needsNumbers("sign", in);
    }

    public static AnyValue sqrt(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)Math.sqrt(number.doubleValue()));
        }
        throw CypherFunctions.needsNumbers("sqrt", in);
    }

    public static DoubleValue rand() {
        return Values.doubleValue((double)ThreadLocalRandom.current().nextDouble());
    }

    public static TextValue randomUuid() {
        return Values.stringValue((String)UUID.randomUUID().toString());
    }

    public static Value distance(AnyValue lhs, AnyValue rhs) {
        if (lhs instanceof PointValue && rhs instanceof PointValue) {
            return CypherFunctions.calculateDistance((PointValue)lhs, (PointValue)rhs);
        }
        return Values.NO_VALUE;
    }

    public static Value withinBBox(AnyValue point, AnyValue lowerLeft, AnyValue upperRight) {
        if (point instanceof PointValue && lowerLeft instanceof PointValue && upperRight instanceof PointValue) {
            return CypherFunctions.withinBBox((PointValue)point, (PointValue)lowerLeft, (PointValue)upperRight);
        }
        return Values.NO_VALUE;
    }

    public static Value withinBBox(PointValue point, PointValue lowerLeft, PointValue upperRight) {
        CoordinateReferenceSystem crs = point.getCoordinateReferenceSystem();
        if (crs.equals((Object)lowerLeft.getCoordinateReferenceSystem()) && crs.equals((Object)upperRight.getCoordinateReferenceSystem())) {
            return Values.booleanValue((boolean)crs.getCalculator().withinBBox(point, lowerLeft, upperRight));
        }
        return Values.NO_VALUE;
    }

    public static Value int8Vector(AnyValue in, AnyValue dimension) {
        if (in == Values.NO_VALUE || dimension == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return VectorUtils.assertDimension(VectorUtils.int8Vector(sequence), dimension);
        }
        if (in instanceof TextValue) {
            TextValue textValue = (TextValue)in;
            return VectorUtils.assertDimension(CypherRuntimeParser.parseInt8Vector(textValue.stringValue()), dimension);
        }
        throw VectorUtils.invalidVector(in);
    }

    public static Value int16Vector(AnyValue in, AnyValue dimension) {
        if (in == Values.NO_VALUE || dimension == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return VectorUtils.assertDimension(VectorUtils.int16Vector(sequence), dimension);
        }
        if (in instanceof TextValue) {
            TextValue textValue = (TextValue)in;
            return VectorUtils.assertDimension(CypherRuntimeParser.parseInt16Vector(textValue.stringValue()), dimension);
        }
        throw VectorUtils.invalidVector(in);
    }

    public static Value int32Vector(AnyValue in, AnyValue dimension) {
        if (in == Values.NO_VALUE || dimension == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return VectorUtils.assertDimension(VectorUtils.int32Vector(sequence), dimension);
        }
        if (in instanceof TextValue) {
            TextValue textValue = (TextValue)in;
            return VectorUtils.assertDimension(CypherRuntimeParser.parseInt32Vector(textValue.stringValue()), dimension);
        }
        throw VectorUtils.invalidVector(in);
    }

    public static Value int64Vector(AnyValue in, AnyValue dimension) {
        if (in == Values.NO_VALUE || dimension == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return VectorUtils.assertDimension(VectorUtils.int64Vector(sequence), dimension);
        }
        if (in instanceof TextValue) {
            TextValue textValue = (TextValue)in;
            return VectorUtils.assertDimension(CypherRuntimeParser.parseInt64Vector(textValue.stringValue()), dimension);
        }
        throw VectorUtils.invalidVector(in);
    }

    public static Value float32Vector(AnyValue in, AnyValue dimension) {
        if (in == Values.NO_VALUE || dimension == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return VectorUtils.assertDimension(VectorUtils.float32Vector(sequence), dimension);
        }
        if (in instanceof TextValue) {
            TextValue textValue = (TextValue)in;
            return VectorUtils.assertDimension(CypherRuntimeParser.parseFloat32Vector(textValue.stringValue()), dimension);
        }
        throw VectorUtils.invalidVector(in);
    }

    public static Value float64Vector(AnyValue in, AnyValue dimension) {
        if (in == Values.NO_VALUE || dimension == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return VectorUtils.assertDimension(VectorUtils.float64Vector(sequence), dimension);
        }
        if (in instanceof TextValue) {
            TextValue textValue = (TextValue)in;
            return VectorUtils.assertDimension(CypherRuntimeParser.parseFloat64Vector(textValue.stringValue()), dimension);
        }
        throw VectorUtils.invalidVector(in);
    }

    public static Value vectorSimilarityEuclidean(AnyValue lhs, AnyValue rhs) {
        return CypherFunctions.vectorSimilarity(VectorSimilarity.EUCLIDEAN, lhs, rhs);
    }

    public static Value vectorSimilarityCosine(AnyValue lhs, AnyValue rhs) {
        return CypherFunctions.vectorSimilarity(VectorSimilarity.COSINE, lhs, rhs);
    }

    public static AnyValue vectorDistance(AnyValue vector1, AnyValue vector2, AnyValue distanceMetric) {
        if (vector1 == Values.NO_VALUE || vector2 == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (vector1 instanceof VectorValue) {
            VectorValue v1 = (VectorValue)vector1;
            if (vector2 instanceof VectorValue) {
                VectorValue v2 = (VectorValue)vector2;
                if (distanceMetric instanceof TextValue) {
                    TextValue textDistanceMetric = (TextValue)distanceMetric;
                    if (v1.dimensions() != v2.dimensions()) {
                        throw new InvalidArgumentException(GqlHelper.getGql22N38_22N04((String)"vector_distance()", (String)("`vector1` of dimension " + v1.dimensions() + " and `vector2` of dimension " + v2.dimensions()), (String)"vector1 and vector2", List.of("vector arguments must be the same dimension")), "The argument `vector1` and `vector2` in the `vector_distance()` function must be of the same dimension.");
                    }
                    return switch (textDistanceMetric.stringValue()) {
                        case "COSINE" -> Values.doubleValue((double)GQLVectorDistanceFunction.COSINE.distance((VectorCandidate)v1, (VectorCandidate)v2));
                        case "EUCLIDEAN" -> Values.doubleValue((double)GQLVectorDistanceFunction.EUCLIDEAN.distance((VectorCandidate)v1, (VectorCandidate)v2));
                        case "EUCLIDEAN_SQUARED" -> Values.doubleValue((double)GQLVectorDistanceFunction.EUCLIDEAN_SQUARED.distance((VectorCandidate)v1, (VectorCandidate)v2));
                        case "MANHATTAN" -> Values.doubleValue((double)GQLVectorDistanceFunction.MANHATTAN.distance((VectorCandidate)v1, (VectorCandidate)v2));
                        case "DOT" -> Values.doubleValue((double)GQLVectorDistanceFunction.DOT.distance((VectorCandidate)v1, (VectorCandidate)v2));
                        case "HAMMING" -> Values.doubleValue((double)GQLVectorDistanceFunction.HAMMING.distance((VectorCandidate)v1, (VectorCandidate)v2));
                        default -> throw InternalException.internalError((String)CypherFunctions.class.getSimpleName(), (String)("Expected known distance metric, got: " + String.valueOf(distanceMetric)));
                    };
                }
                throw InternalException.internalError((String)CypherFunctions.class.getSimpleName(), (String)("Expected known distance metric, got: " + distanceMetric.prettyPrint()));
            }
        }
        if (!(vector1 instanceof VectorValue)) {
            throw CypherFunctions.notAVector("vector_distance", vector1);
        }
        throw CypherFunctions.notAVector("vector_distance", vector2);
    }

    public static AnyValue vectorNorm(AnyValue vector, AnyValue distanceMetric) {
        if (vector == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (vector instanceof VectorValue) {
            VectorValue v = (VectorValue)vector;
            if (distanceMetric instanceof TextValue) {
                TextValue textDistanceMetric = (TextValue)distanceMetric;
                return switch (textDistanceMetric.stringValue()) {
                    case "EUCLIDEAN" -> Values.doubleValue((double)GQLVectorNorm.EUCLIDEAN.norm((VectorCandidate)v));
                    case "MANHATTAN" -> Values.doubleValue((double)GQLVectorNorm.MANHATTAN.norm((VectorCandidate)v));
                    default -> throw InternalException.internalError((String)CypherFunctions.class.getSimpleName(), (String)("Expected known distance metric, got: " + String.valueOf(distanceMetric)));
                };
            }
            throw InternalException.internalError((String)CypherFunctions.class.getSimpleName(), (String)("Expected known distance metric, got: " + distanceMetric.prettyPrint()));
        }
        throw CypherFunctions.notAVector("vector_norm", vector);
    }

    public static Value vectorSimilarity(VectorSimilarity similarity, AnyValue lhs, AnyValue rhs) {
        float[] b;
        String functionName;
        VectorSimilarityFunction function = similarity.latestImplementation();
        switch (similarity) {
            default: {
                throw new MatchException(null, null);
            }
            case EUCLIDEAN: {
                String string = VectorSimilarityEuclidean.name();
                break;
            }
            case COSINE: {
                String string = functionName = VectorSimilarityCosine.name();
            }
        }
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        float[] a = CypherFunctions.toFloatArrayVector(function, functionName, lhs, "a");
        if (a.length != (b = CypherFunctions.toFloatArrayVector(function, functionName, rhs, "b")).length) {
            throw new InvalidArgumentException(CypherFunctions.invalidSimilarityFunctionInputErrorMessage(function, "The supplied vectors do not have the same number of dimensions"));
        }
        return Values.doubleValue((double)function.compare(a, b));
    }

    private static float[] toFloatArrayVector(VectorSimilarityFunction function, String functionName, AnyValue arg, String argName) {
        VectorCandidate candidate = VectorCandidate.maybeFrom((AnyValue)arg);
        if (candidate == null) {
            throw CypherTypeException.functionArgumentWrongType((String)"Expected argument %s to be a LIST<INTEGER | FLOAT>".formatted(argName), (String)functionName, (String)arg.prettify(), List.of("LIST<INTEGER | FLOAT>"), (String)CypherTypeValueMapper.valueType(arg));
        }
        float[] floatArray = function.maybeToValidVector(candidate);
        if (floatArray == null) {
            throw InvalidArgumentException.invalidFunctionArgument((String)functionName, (String)CypherFunctions.invalidSimilarityFunctionInputErrorMessage(function, "Argument %s is not a valid vector for this similarity function".formatted(argName)));
        }
        return floatArray;
    }

    private static String invalidSimilarityFunctionInputErrorMessage(VectorSimilarityFunction function, String reason) {
        return "Invalid input for 'vector.similarity.%s()': %s.".formatted(function.functionName().toLowerCase(), reason);
    }

    public static AnyValue startNode(AnyValue anyValue, DbAccess access, RelationshipScanCursor cursor) {
        if (anyValue == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (anyValue instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)anyValue;
            return CypherFunctions.startNode(rel, access, cursor);
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'startNode()': Expected %s to be a RelationshipValue", anyValue), (String)"startNode", (String)anyValue.prettify(), List.of("RELATIONSHIP"), (String)CypherTypeValueMapper.valueType(anyValue));
    }

    public static VirtualNodeValue startNode(VirtualRelationshipValue relationship, DbAccess access, RelationshipScanCursor cursor) {
        return VirtualValues.node((long)relationship.startNodeId(CypherFunctions.consumer(access, cursor)));
    }

    public static AnyValue endNode(AnyValue anyValue, DbAccess access, RelationshipScanCursor cursor) {
        if (anyValue == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (anyValue instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)anyValue;
            return CypherFunctions.endNode(rel, access, cursor);
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'endNode()': Expected %s to be a RelationshipValue", anyValue), (String)"endNode", (String)anyValue.prettify(), List.of("RELATIONSHIP"), (String)CypherTypeValueMapper.valueType(anyValue));
    }

    public static VirtualNodeValue endNode(VirtualRelationshipValue relationship, DbAccess access, RelationshipScanCursor cursor) {
        return VirtualValues.node((long)relationship.endNodeId(CypherFunctions.consumer(access, cursor)));
    }

    public static VirtualNodeValue otherNode(AnyValue anyValue, DbAccess access, VirtualNodeValue node, RelationshipScanCursor cursor) {
        assert (anyValue != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (anyValue instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)anyValue;
            return CypherFunctions.otherNode(rel, access, node, cursor);
        }
        throw CypherTypeException.expectedRelValue((String)anyValue.toString(), (String)anyValue.prettyPrint(), (String)CypherTypeValueMapper.valueType(anyValue));
    }

    public static VirtualNodeValue otherNode(VirtualRelationshipValue relationship, DbAccess access, VirtualNodeValue node, RelationshipScanCursor cursor) {
        return VirtualValues.node((long)relationship.otherNodeId(node.id(), CypherFunctions.consumer(access, cursor)));
    }

    public static AnyValue propertyGet(String key, AnyValue container, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        if (container == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)container;
            return dbAccess.nodeProperty(node.id(), dbAccess.propertyKey(key), nodeCursor, propertyCursor, true);
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)container;
            return dbAccess.relationshipProperty(rel, dbAccess.propertyKey(key), relationshipScanCursor, propertyCursor, true);
        }
        if (container instanceof MapValue) {
            MapValue map = (MapValue)container;
            return map.get(key);
        }
        if (container instanceof TemporalValue) {
            TemporalValue temporal = (TemporalValue)container;
            return temporal.get(key);
        }
        if (container instanceof DurationValue) {
            DurationValue duration = (DurationValue)container;
            return duration.get(key);
        }
        if (container instanceof PointValue) {
            PointValue point = (PointValue)container;
            return point.get(key);
        }
        throw CypherTypeException.expectedMap((String)container.toString(), (String)container.prettyPrint(), (String)CypherTypeValueMapper.valueType(container));
    }

    public static AnyValue[] propertiesGet(String[] keys, AnyValue container, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)container;
            return dbAccess.nodeProperties(node.id(), CursorUtils.propertyKeys(keys, dbAccess), nodeCursor, propertyCursor);
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)container;
            return dbAccess.relationshipProperties(rel, CursorUtils.propertyKeys(keys, dbAccess), relationshipScanCursor, propertyCursor);
        }
        return CursorUtils.propertiesGet(keys, container);
    }

    public static AnyValue containerIndex(AnyValue container, AnyValue index, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        if (container == Values.NO_VALUE || index == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)container;
            return dbAccess.nodeProperty(node.id(), CypherFunctions.propertyKeyId(dbAccess, index), nodeCursor, propertyCursor, true);
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)container;
            return dbAccess.relationshipProperty(rel, CypherFunctions.propertyKeyId(dbAccess, index), relationshipScanCursor, propertyCursor, true);
        }
        if (container instanceof MapValue) {
            MapValue map = (MapValue)container;
            return CypherFunctions.mapAccess(map, index);
        }
        if (container instanceof SequenceValue) {
            SequenceValue seq = (SequenceValue)container;
            return CypherFunctions.listAccess(seq, index);
        }
        throw CypherTypeException.notCollectionOrMap((String)container.toString(), (String)container.prettyPrint(), (String)CypherTypeValueMapper.valueType(container), (Object)index);
    }

    public static Value containerIndexExists(AnyValue container, AnyValue index, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        if (container == Values.NO_VALUE || index == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)container;
            return Values.booleanValue((boolean)dbAccess.nodeHasProperty(node.id(), CypherFunctions.propertyKeyId(dbAccess, index), nodeCursor, propertyCursor));
        }
        if (container instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)container;
            return Values.booleanValue((boolean)dbAccess.relationshipHasProperty(rel, CypherFunctions.propertyKeyId(dbAccess, index), relationshipScanCursor, propertyCursor));
        }
        if (container instanceof MapValue) {
            MapValue map = (MapValue)container;
            return Values.booleanValue((boolean)map.containsKey(CypherFunctions.asString(index, () -> "Cannot use non string value as or in map keys. It was " + index.toString())));
        }
        throw CypherTypeException.notMap((String)container.toString(), (String)container.prettyPrint(), (String)CypherTypeValueMapper.valueType(container), (Object)index);
    }

    public static AnyValue head(AnyValue container) {
        if (container == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)container;
            return sequence.head();
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'head()': Expected %s to be a list", container), (String)"head", (String)container.prettify(), List.of("LIST<ANY>"), (String)CypherTypeValueMapper.valueType(container));
    }

    public static AnyValue tail(AnyValue container) {
        if (container == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof ListValue) {
            ListValue list = (ListValue)container;
            return list.tail();
        }
        if (container instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)container;
            return VirtualValues.fromArray((ArrayValue)array).tail();
        }
        return VirtualValues.EMPTY_LIST;
    }

    public static AnyValue last(AnyValue container) {
        if (container == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (container instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)container;
            return sequence.last();
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'last()': Expected %s to be a list", container), (String)"last", (String)container.prettify(), List.of("LIST<ANY>"), (String)CypherTypeValueMapper.valueType(container));
    }

    public static AnyValue left(AnyValue in, AnyValue endPos) {
        if (in == Values.NO_VALUE || endPos == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof TextValue) {
            TextValue text = (TextValue)in;
            long len = CypherFunctions.asLong(endPos, () -> "Invalid input for length value in function 'left()'", "left");
            return text.substring(0, (int)Math.min(len, Integer.MAX_VALUE));
        }
        throw CypherFunctions.notAString("left", in);
    }

    public static AnyValue ltrim(AnyValue trimSource) {
        if (trimSource == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (trimSource instanceof TextValue) {
            return ((TextValue)trimSource).ltrim();
        }
        throw CypherFunctions.notAString("ltrim", trimSource);
    }

    public static AnyValue ltrim(AnyValue trimSource, AnyValue trimCharacterString) {
        if (trimSource == Values.NO_VALUE || trimCharacterString == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (trimSource instanceof TextValue) {
            TextValue trimSourceText = (TextValue)trimSource;
            if (trimCharacterString instanceof TextValue) {
                TextValue trimCharacterStringText = (TextValue)trimCharacterString;
                return trimSourceText.ltrim(trimCharacterStringText);
            }
            throw CypherFunctions.notAString("ltrim", trimCharacterString);
        }
        throw CypherFunctions.notAString("ltrim", trimSource);
    }

    public static AnyValue rtrim(AnyValue trimSource) {
        if (trimSource == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (trimSource instanceof TextValue) {
            return ((TextValue)trimSource).rtrim();
        }
        throw CypherFunctions.notAString("rtrim", trimSource);
    }

    public static AnyValue rtrim(AnyValue trimSource, AnyValue trimCharacterString) {
        if (trimSource == Values.NO_VALUE || trimCharacterString == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (trimSource instanceof TextValue) {
            TextValue trimSourceText = (TextValue)trimSource;
            if (trimCharacterString instanceof TextValue) {
                TextValue trimCharacterStringText = (TextValue)trimCharacterString;
                return trimSourceText.rtrim(trimCharacterStringText);
            }
            throw CypherFunctions.notAString("rtrim", trimCharacterString);
        }
        throw CypherFunctions.notAString("rtrim", trimSource);
    }

    public static AnyValue btrim(AnyValue trimSource) {
        if (trimSource == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (trimSource instanceof TextValue) {
            return ((TextValue)trimSource).trim();
        }
        throw CypherFunctions.notAString("btrim", trimSource);
    }

    public static AnyValue btrim(AnyValue trimSource, AnyValue trimCharacterString) {
        if (trimSource == Values.NO_VALUE || trimCharacterString == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (trimSource instanceof TextValue) {
            TextValue trimSourceText = (TextValue)trimSource;
            if (trimCharacterString instanceof TextValue) {
                TextValue trimCharacterStringText = (TextValue)trimCharacterString;
                return trimSourceText.trim(trimCharacterStringText);
            }
            throw CypherFunctions.notAString("btrim", trimCharacterString);
        }
        throw CypherFunctions.notAString("btrim", trimSource);
    }

    public static AnyValue trim(AnyValue trimSpecification, AnyValue trimSource) {
        if (trimSource == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (!(trimSource instanceof TextValue)) {
            throw CypherFunctions.notAString("trim", trimSource);
        }
        if (trimSpecification instanceof TextValue) {
            TextValue trimSpec = (TextValue)trimSpecification;
            return switch (trimSpec.stringValue()) {
                case "LEADING" -> CypherFunctions.ltrim(trimSource);
                case "TRAILING" -> CypherFunctions.rtrim(trimSource);
                default -> CypherFunctions.btrim(trimSource);
            };
        }
        throw CypherFunctions.notAString("trim", trimSpecification);
    }

    public static AnyValue trim(AnyValue trimSpecification, AnyValue trimSource, AnyValue trimCharacterString) {
        if (trimSource == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (!(trimSource instanceof TextValue)) {
            throw CypherFunctions.notAString("trim", trimSource);
        }
        if (trimSpecification instanceof TextValue) {
            TextValue trimCharString;
            TextValue trimSpec = (TextValue)trimSpecification;
            if (trimCharacterString instanceof TextValue && (trimCharString = (TextValue)trimCharacterString).length() != 1) {
                throw new InvalidArgumentException(GqlHelper.getGql22N38_22N04((String)"trim()", (String)trimCharString.prettyPrint(), (String)"trimCharacterString", List.of("argument to be of length 1")), "The argument `trimCharacterString` in the `trim()` function must be of length 1.");
            }
            return switch (trimSpec.stringValue()) {
                case "LEADING" -> CypherFunctions.ltrim(trimSource, trimCharacterString);
                case "TRAILING" -> CypherFunctions.rtrim(trimSource, trimCharacterString);
                default -> CypherFunctions.btrim(trimSource, trimCharacterString);
            };
        }
        throw CypherFunctions.notAString("trim", trimSpecification);
    }

    public static AnyValue replace(AnyValue original, AnyValue search, AnyValue replaceWith) {
        if (original == Values.NO_VALUE || search == Values.NO_VALUE || replaceWith == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (original instanceof TextValue) {
            TextValue textValue = (TextValue)original;
            return textValue.replace(CypherFunctions.asString(search), CypherFunctions.asString(replaceWith));
        }
        throw CypherFunctions.notAString("replace", original);
    }

    public static AnyValue replace(AnyValue original, AnyValue search, AnyValue replaceWith, AnyValue limit) {
        if (original == Values.NO_VALUE || search == Values.NO_VALUE || replaceWith == Values.NO_VALUE || limit == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (original instanceof TextValue) {
            TextValue textValue = (TextValue)original;
            int intLimit = CypherFunctions.asIntExact(limit, () -> "Invalid input for limit value in function 'replace()'", "replace", false);
            if (intLimit < 0) {
                throw InvalidArgumentException.argumentOutOfRange((String)"replace", (String)"limit", (long)0L, (long)Long.MAX_VALUE, (long)intLimit);
            }
            return textValue.replaceWithLimit(CypherFunctions.asString(search), CypherFunctions.asString(replaceWith), intLimit);
        }
        throw CypherFunctions.notAString("replace", original);
    }

    public static AnyValue reverse(AnyValue original) {
        if (original == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (original instanceof TextValue) {
            TextValue text = (TextValue)original;
            return text.reverse();
        }
        if (original instanceof SequenceValue) {
            SequenceValue list = (SequenceValue)original;
            return list.reverse();
        }
        throw CypherTypeException.functionArgumentWrongType((String)"Invalid input for function 'reverse()': Expected a string or a list; consider converting the value to a string with toString() or creating a list.", (String)"reverse", (String)original.prettify(), List.of("STRING", "LIST<ANY>"), (String)CypherTypeValueMapper.valueType(original));
    }

    public static AnyValue right(AnyValue original, AnyValue length) {
        if (original == Values.NO_VALUE || length == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            long len = CypherFunctions.asLong(length, () -> "Invalid input for length value in function 'right()'", "right");
            if (len < 0L) {
                throw new IndexOutOfBoundsException("negative length");
            }
            long startVal = (long)asText.length() - len;
            return asText.substring((int)Math.max(0L, startVal));
        }
        throw CypherFunctions.notAString("right", original);
    }

    public static AnyValue concatenate(AnyValue lhs, AnyValue rhs) {
        ArrayValue array;
        if (lhs == Values.NO_VALUE && rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof ArrayValue) {
            array = (ArrayValue)lhs;
            lhs = VirtualValues.fromArray((ArrayValue)array);
        }
        if (rhs instanceof ArrayValue) {
            array = (ArrayValue)rhs;
            rhs = VirtualValues.fromArray((ArrayValue)array);
        }
        if (lhs == Values.NO_VALUE && (rhs instanceof ListValue || rhs instanceof TextValue)) {
            return Values.NO_VALUE;
        }
        if (rhs == Values.NO_VALUE && (lhs instanceof ListValue || lhs instanceof TextValue)) {
            return Values.NO_VALUE;
        }
        boolean lhsIsListValue = lhs instanceof ListValue;
        if (lhsIsListValue && rhs instanceof ListValue) {
            return ((ListValue)lhs).appendAll((ListValue)rhs);
        }
        if (lhs instanceof TextValue && rhs instanceof TextValue) {
            return ((TextValue)lhs).plus((TextValue)rhs);
        }
        throw CypherTypeException.concatenationTypeMismatch((String)rhs.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(rhs), (String)CypherTypeValueMapper.valueType(lhs));
    }

    public static AnyValue normalize(AnyValue input) {
        return CypherFunctions.normalize(input, (AnyValue)Values.stringValue((String)"NFC"));
    }

    public static AnyValue normalize(AnyValue input, AnyValue normalForm) {
        Normalizer.Form form;
        if (input == Values.NO_VALUE || normalForm == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        try {
            form = Normalizer.Form.valueOf(CypherFunctions.asTextValue(normalForm).stringValue());
        }
        catch (IllegalArgumentException e) {
            throw InvalidArgumentException.unknownNormalForm((String)String.valueOf(normalForm));
        }
        String normalized = Normalizer.normalize(CypherFunctions.asTextValue(input).stringValue(), form);
        return Values.stringValue((String)normalized);
    }

    public static AnyValue split(AnyValue original, AnyValue separator) {
        if (original == Values.NO_VALUE || separator == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            if (asText.isEmpty()) {
                return VirtualValues.list((AnyValue[])new AnyValue[]{Values.EMPTY_STRING});
            }
            if (separator instanceof SequenceValue) {
                SequenceValue separatorList = (SequenceValue)separator;
                ArrayList<String> separators = new ArrayList<String>();
                for (AnyValue s : separatorList) {
                    if (s == Values.NO_VALUE) {
                        return Values.NO_VALUE;
                    }
                    separators.add(CypherFunctions.asString(s));
                }
                return asText.split(separators);
            }
            return asText.split(CypherFunctions.asString(separator));
        }
        throw CypherFunctions.notAString("split", original);
    }

    public static AnyValue substring(AnyValue original, AnyValue start) {
        if (original == Values.NO_VALUE || start == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asIntExact(start, () -> "Invalid input for start value in function 'substring()'", "substring"));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static AnyValue substring(AnyValue original, AnyValue start, AnyValue length) {
        if (original == Values.NO_VALUE || start == Values.NO_VALUE || length == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (original instanceof TextValue) {
            TextValue asText = (TextValue)original;
            return asText.substring(CypherFunctions.asIntExact(start, () -> "Invalid input for start value in function 'substring()'", "substring"), CypherFunctions.asIntExact(length, () -> "Invalid input for length value in function 'substring()'", "substring"));
        }
        throw CypherFunctions.notAString("substring", original);
    }

    public static AnyValue toLower(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof TextValue) {
            return ((TextValue)in).toLower();
        }
        throw CypherFunctions.notAString("toLower", in);
    }

    public static AnyValue toUpper(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof TextValue) {
            return ((TextValue)in).toUpper();
        }
        throw CypherFunctions.notAString("toUpper", in);
    }

    public static Value id(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof VirtualNodeValue) {
            return Values.longValue((long)((VirtualNodeValue)item).id());
        }
        if (item instanceof VirtualRelationshipValue) {
            return Values.longValue((long)((VirtualRelationshipValue)item).id());
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'id()': Expected %s to be a node or relationship, but it was `%s`", item, item.getTypeName()), (String)"id", (String)item.prettify(), List.of("NODE", "RELATIONSHIP"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static AnyValue elementId(AnyValue entity, ElementIdMapper idMapper) {
        VirtualRelationshipValue relationship;
        VirtualNodeValue node;
        if (entity == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (entity instanceof NodeValue) {
            NodeValue node2 = (NodeValue)entity;
            return Values.stringValue((String)node2.elementId());
        }
        if (entity instanceof VirtualNodeValue && (node = (VirtualNodeValue)entity).id() < 0L) {
            return Values.stringValue((String)String.valueOf(node.id()));
        }
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node3 = (VirtualNodeValue)entity;
            return Values.stringValue((String)idMapper.nodeElementId(node3.id()));
        }
        if (entity instanceof RelationshipValue) {
            RelationshipValue relationship2 = (RelationshipValue)entity;
            return Values.stringValue((String)relationship2.elementId());
        }
        if (entity instanceof VirtualRelationshipValue && (relationship = (VirtualRelationshipValue)entity).id() < 0L) {
            return Values.stringValue((String)String.valueOf(relationship.id()));
        }
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship3 = (VirtualRelationshipValue)entity;
            return Values.stringValue((String)idMapper.relationshipElementId(relationship3.id()));
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'elementId()': Expected %s to be a node or relationship, but it was `%s`", entity, entity.getTypeName()), (String)"elementId", (String)entity.prettify(), List.of("NODE", "RELATIONSHIP"), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static AnyValue elementIdToNodeId(AnyValue elementId, ElementIdMapper idMapper) {
        if (elementId == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (elementId instanceof TextValue) {
            TextValue str = (TextValue)elementId;
            try {
                return Values.longValue((long)idMapper.nodeId(str.stringValue()));
            }
            catch (IllegalArgumentException e) {
                return Values.NO_VALUE;
            }
        }
        return Values.NO_VALUE;
    }

    public static AnyValue elementIdToRelationshipId(AnyValue elementId, ElementIdMapper idMapper) {
        if (elementId == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (elementId instanceof TextValue) {
            TextValue str = (TextValue)elementId;
            try {
                return Values.longValue((long)idMapper.relationshipId(str.stringValue()));
            }
            catch (IllegalArgumentException e) {
                return Values.NO_VALUE;
            }
        }
        return Values.NO_VALUE;
    }

    public static AnyValue elementIdListToNodeIdList(AnyValue collection, ElementIdMapper idMapper) {
        if (collection == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (collection instanceof SequenceValue) {
            SequenceValue elementIds = (SequenceValue)collection;
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)elementIds.intSize());
            for (AnyValue elementId : elementIds) {
                AnyValue value = CypherFunctions.elementIdToNodeId(elementId, idMapper);
                builder.add(value);
            }
            return builder.build();
        }
        return Values.NO_VALUE;
    }

    public static AnyValue elementIdListToRelationshipIdList(AnyValue collection, ElementIdMapper idMapper) {
        if (collection == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (collection instanceof SequenceValue) {
            SequenceValue elementIds = (SequenceValue)collection;
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)elementIds.intSize());
            for (AnyValue elementId : elementIds) {
                AnyValue value = CypherFunctions.elementIdToRelationshipId(elementId, idMapper);
                builder.add(value);
            }
            return builder.build();
        }
        return Values.NO_VALUE;
    }

    public static TextValue nodeElementId(long id, ElementIdMapper idMapper) {
        assert (id > -1L);
        return Values.stringValue((String)idMapper.nodeElementId(id));
    }

    public static TextValue relationshipElementId(long id, ElementIdMapper idMapper) {
        assert (id > -1L);
        return Values.stringValue((String)idMapper.relationshipElementId(id));
    }

    public static AnyValue labels(AnyValue item, DbAccess access, NodeCursor nodeCursor) {
        NodeEntityWrappingNodeValue node;
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof NodeEntityWrappingNodeValue && (node = (NodeEntityWrappingNodeValue)item).id() < 0L) {
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)node.labels().intSize());
            node.labels().forEach(arg_0 -> ((ListValueBuilder)builder).add(arg_0));
            return builder.build();
        }
        if (item instanceof VirtualNodeValue) {
            VirtualNodeValue node2 = (VirtualNodeValue)item;
            return access.getLabelsForNode(node2.id(), nodeCursor);
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'labels()': Expected a Node, got: " + String.valueOf(item)), (String)"labels", (String)item.prettify(), List.of("NODE"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static boolean hasLabel(AnyValue entity, int labelToken, DbAccess access, NodeCursor nodeCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            return access.isLabelSetOnNode(labelToken, node.id(), nodeCursor);
        }
        throw CypherTypeException.expectedNode((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasLabels(AnyValue entity, int[] labelTokens, DbAccess access, NodeCursor nodeCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            return access.areLabelsSetOnNode(labelTokens, node.id(), nodeCursor);
        }
        throw CypherTypeException.expectedNode((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
    }

    private static boolean hasLabel(VirtualNodeValue node, TextValue textLabel, NodeCursor nodeCursor, QueryContext queryContext) throws IllegalTokenNameException {
        String validName = TokenWrite.checkValidTokenName((String)textLabel.stringValue(), (TokenType)TokenType.LABEL);
        int tokenId = queryContext.nodeLabel(validName);
        if (tokenId == -1) {
            return false;
        }
        return queryContext.isLabelSetOnNode(tokenId, node.id(), nodeCursor);
    }

    public static String evaluateSingleDynamicRelType(AnyValue value) {
        if (value == Values.NO_VALUE) {
            throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)"NULL", (String)"NULL");
        }
        if (value instanceof TextValue) {
            TextValue textValue = (TextValue)value;
            return textValue.stringValue();
        }
        if (value instanceof SequenceValue) {
            SequenceValue sequenceValue = (SequenceValue)value;
            if (sequenceValue.actualSize() != 1L) {
                throw new IllegalArgumentException(String.format("Exactly one relationship type must be specified, but %d were found.", sequenceValue.actualSize()));
            }
            AnyValue t = sequenceValue.value(0L);
            if (t instanceof TextValue) {
                TextValue textValue = (TextValue)t;
                return textValue.stringValue();
            }
            throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)t.prettyPrint(), (String)CypherTypeValueMapper.valueType(t));
        }
        throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
    }

    public static int getOrCreateDynamicRelType(AnyValue value, QueryContext queryContext) {
        return queryContext.getOrCreateRelTypeId(CypherFunctions.evaluateSingleDynamicRelType(value));
    }

    public static int getOrCreateDynamicRelType(AnyValue value, TokenWrite token) throws KernelException {
        return token.relationshipTypeGetOrCreateForName(CypherFunctions.evaluateSingleDynamicRelType(value));
    }

    public static boolean hasDynamicLabelsOrTypes(AnyValue entity, AnyValue[] labelOrTypes, NodeCursor nodeCursor, RelationshipScanCursor relCursor, QueryContext queryContext, RuntimeNotifier notifier) throws IllegalTokenNameException {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            return CypherFunctions.hasDynamicLabels((AnyValue)node, labelOrTypes, nodeCursor, queryContext);
        }
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)entity;
            return CypherFunctions.hasDynamicType((AnyValue)relationship, labelOrTypes, relCursor, queryContext, notifier);
        }
        throw CypherTypeException.invalidTypeForLabelExpression((String)entity.toString(), (String)entity.prettify(), (String)entity.getTypeName(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasDynamicLabels(AnyValue entity, AnyValue[] labelNames, NodeCursor nodeCursor, QueryContext queryContext) throws IllegalTokenNameException {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        boolean allMatch = true;
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            for (AnyValue labelName : labelNames) {
                if (labelName instanceof TextValue) {
                    TextValue textLabel = (TextValue)labelName;
                    if (CypherFunctions.hasLabel(node, textLabel, nodeCursor, queryContext)) continue;
                    allMatch = false;
                    continue;
                }
                if (labelName instanceof SequenceValue) {
                    SequenceValue labelSequence = (SequenceValue)labelName;
                    for (AnyValue l : labelSequence) {
                        if (l instanceof TextValue) {
                            TextValue textLabel = (TextValue)l;
                            if (CypherFunctions.hasLabel(node, textLabel, nodeCursor, queryContext)) continue;
                            allMatch = false;
                            continue;
                        }
                        throw CypherTypeException.expectedStringNotNull((String)"Expected node label to be a string or list of strings.", (String)(l == Values.NO_VALUE ? "NULL" : l.prettyPrint()), (String)CypherTypeValueMapper.valueType(l));
                    }
                    continue;
                }
                throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected node label to be a string or list of strings.", (String)(labelName == Values.NO_VALUE ? "NULL" : labelName.prettyPrint()), (String)CypherTypeValueMapper.valueType(labelName));
            }
        } else {
            throw CypherTypeException.expectedNode((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
        }
        return allMatch;
    }

    public static String[] getDynamicLabels(AnyValue labelName) {
        if (labelName instanceof TextValue) {
            TextValue textLabel = (TextValue)labelName;
            return new String[]{textLabel.stringValue()};
        }
        if (labelName instanceof SequenceValue) {
            SequenceValue labelSequence = (SequenceValue)labelName;
            String[] list = new String[labelSequence.intSize()];
            int i = 0;
            for (AnyValue l : labelSequence) {
                if (l instanceof TextValue) {
                    TextValue textLabel = (TextValue)l;
                    list[i++] = textLabel.stringValue();
                    continue;
                }
                throw CypherTypeException.expectedStringNotNull((String)"Expected node label to be a string or list of strings.", (String)(l == Values.NO_VALUE ? "NULL" : l.prettyPrint()), (String)CypherTypeValueMapper.valueType(l));
            }
            return list;
        }
        throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected node label to be a string or list of strings.", (String)(labelName == Values.NO_VALUE ? "NULL" : labelName.prettyPrint()), (String)CypherTypeValueMapper.valueType(labelName));
    }

    public static GetSingleDynamicTypeResult getSingleDynamicType(AnyValue typeName, RuntimeNotifier notifier) throws IllegalTokenNameException {
        if (typeName instanceof TextValue) {
            TextValue textType = (TextValue)typeName;
            return new GetSingleDynamicTypeResult.SingleDynamicType(TokenWrite.checkValidTokenName((String)textType.stringValue(), (TokenType)TokenType.RELATIONSHIP_TYPE));
        }
        if (typeName instanceof SequenceValue) {
            SequenceValue typeSequence = (SequenceValue)typeName;
            ArrayList<String> conflicts = null;
            String singleValue = null;
            for (AnyValue l : typeSequence) {
                if (l instanceof TextValue) {
                    TextValue textType = (TextValue)l;
                    String validValue = TokenWrite.checkValidTokenName((String)textType.stringValue(), (TokenType)TokenType.RELATIONSHIP_TYPE);
                    if (singleValue == null) {
                        singleValue = validValue;
                        continue;
                    }
                    if (singleValue.equals(validValue)) continue;
                    if (conflicts == null) {
                        conflicts = new ArrayList<String>();
                        conflicts.add(singleValue);
                    }
                    conflicts.add(validValue);
                    continue;
                }
                throw CypherTypeException.expectedStringNotNull((String)"Expected relationship type to be a string or list of strings.", (String)l.prettyPrint(), (String)CypherTypeValueMapper.valueType(l));
            }
            if (singleValue == null) {
                return new GetSingleDynamicTypeResult.EmptyDynamicTypeList();
            }
            if (conflicts == null) {
                return new GetSingleDynamicTypeResult.SingleDynamicType(singleValue);
            }
            notifier.newRuntimeNotification((InternalNotification)new RuntimeUnsatisfiableRelationshipTypeExpression(conflicts));
            return new GetSingleDynamicTypeResult.ConflictingDynamicTypes();
        }
        throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)(typeName == Values.NO_VALUE ? "NULL" : typeName.prettyPrint()), (String)CypherTypeValueMapper.valueType(typeName));
    }

    public static String[] getDynamicTypes(AnyValue labelName) throws IllegalTokenNameException {
        if (labelName instanceof TextValue) {
            TextValue textType = (TextValue)labelName;
            return new String[]{TokenWrite.checkValidTokenName((String)textType.stringValue(), (TokenType)TokenType.RELATIONSHIP_TYPE)};
        }
        if (labelName instanceof SequenceValue) {
            SequenceValue labelSequence = (SequenceValue)labelName;
            String[] list = new String[labelSequence.intSize()];
            int i = 0;
            for (AnyValue l : labelSequence) {
                if (l instanceof TextValue) {
                    TextValue textType = (TextValue)l;
                    list[i++] = TokenWrite.checkValidTokenName((String)textType.stringValue(), (TokenType)TokenType.RELATIONSHIP_TYPE);
                    continue;
                }
                throw CypherTypeException.expectedStringNotNull((String)"Expected relationship type to be a string or list of strings.", (String)l.prettyPrint(), (String)CypherTypeValueMapper.valueType(l));
            }
            return list;
        }
        throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)(labelName == Values.NO_VALUE ? "NULL" : labelName.prettyPrint()), (String)CypherTypeValueMapper.valueType(labelName));
    }

    public static boolean hasALabel(AnyValue entity, DbAccess access, NodeCursor nodeCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue virtualNodeValue = (VirtualNodeValue)entity;
            return access.isALabelSetOnNode(virtualNodeValue.id(), nodeCursor);
        }
        throw CypherTypeException.expectedNode((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasALabelOrType(AnyValue entity, DbAccess access, NodeCursor nodeCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            return access.isALabelSetOnNode(node.id(), nodeCursor);
        }
        if (entity instanceof VirtualRelationshipValue) {
            return true;
        }
        throw CypherTypeException.invalidTypeForLabelExpression((String)entity.toString(), (String)entity.prettify(), (String)entity.getTypeName(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasLabelsOrTypes(AnyValue entity, DbAccess access, int[] labels, NodeCursor nodeCursor, int[] types, RelationshipScanCursor relationshipScanCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            return access.areLabelsSetOnNode(labels, node.id(), nodeCursor);
        }
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)entity;
            return access.areTypesSetOnRelationship(types, relationship, relationshipScanCursor);
        }
        throw CypherTypeException.invalidTypeForLabelExpression((String)entity.toString(), (String)entity.prettify(), (String)entity.getTypeName(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasAnyLabel(AnyValue entity, int[] labels, DbAccess access, NodeCursor nodeCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            return access.isAnyLabelSetOnNode(labels, node.id(), nodeCursor);
        }
        throw CypherTypeException.expectedNode((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasAnyDynamicLabelsOrTypes(AnyValue entity, AnyValue[] labelsOrTypes, NodeCursor nodeCursor, RelationshipScanCursor relCursor, QueryContext queryContext) throws IllegalTokenNameException {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            return CypherFunctions.hasAnyDynamicLabel((AnyValue)node, labelsOrTypes, nodeCursor, queryContext);
        }
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)entity;
            return CypherFunctions.hasAnyDynamicType((AnyValue)relationship, labelsOrTypes, relCursor, queryContext);
        }
        throw CypherTypeException.invalidTypeForLabelExpression((String)entity.toString(), (String)entity.prettify(), (String)entity.getTypeName(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasAnyDynamicLabel(AnyValue entity, AnyValue[] labels, NodeCursor nodeCursor, QueryContext queryContext) throws IllegalTokenNameException {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        boolean anyMatch = false;
        if (entity instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)entity;
            for (AnyValue labelName : labels) {
                if (labelName instanceof TextValue) {
                    TextValue textLabel = (TextValue)labelName;
                    if (!CypherFunctions.hasLabel(node, textLabel, nodeCursor, queryContext)) continue;
                    anyMatch = true;
                    continue;
                }
                if (labelName instanceof SequenceValue) {
                    SequenceValue labelSequence = (SequenceValue)labelName;
                    for (AnyValue l : labelSequence) {
                        if (l instanceof TextValue) {
                            TextValue textLabel = (TextValue)l;
                            if (!CypherFunctions.hasLabel(node, textLabel, nodeCursor, queryContext)) continue;
                            anyMatch = true;
                            continue;
                        }
                        throw CypherTypeException.expectedStringNotNull((String)"Expected node label to be a string or list of strings.", (String)(l == Values.NO_VALUE ? "NULL" : l.prettyPrint()), (String)CypherTypeValueMapper.valueType(l));
                    }
                    continue;
                }
                throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected node label to be a string or list of strings.", (String)(labelName == Values.NO_VALUE ? "NULL" : labelName.prettyPrint()), (String)CypherTypeValueMapper.valueType(labelName));
            }
        } else {
            throw CypherTypeException.expectedNode((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
        }
        return anyMatch;
    }

    public static AnyValue type(AnyValue item, DbAccess access, RelationshipScanCursor relCursor, Read read) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof RelationshipValue) {
            RelationshipValue relationship = (RelationshipValue)item;
            return relationship.type();
        }
        if (item instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)item;
            int typeToken = relationship.relationshipTypeId(relationshipVisitor -> {
                long relationshipId = relationshipVisitor.id();
                access.singleRelationship(relationshipId, relCursor);
                if (relCursor.next() || read.relationshipDeletedInTransaction(relationshipId)) {
                    relationshipVisitor.visit(relCursor.sourceNodeReference(), relCursor.targetNodeReference(), relCursor.type());
                }
            });
            if (typeToken == -1) {
                return Values.NO_VALUE;
            }
            return Values.stringValue((String)access.relationshipTypeName(typeToken));
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'type()': Expected a Relationship, got: " + String.valueOf(item)), (String)"type", (String)item.prettify(), List.of("RELATIONSHIP"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static boolean hasType(AnyValue entity, int typeToken, DbAccess access, RelationshipScanCursor relCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)entity;
            if (typeToken == -1) {
                return false;
            }
            return typeToken == relationship.relationshipTypeId(CypherFunctions.consumer(access, relCursor));
        }
        throw CypherTypeException.expectedRel((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasTypes(AnyValue entity, int[] typeTokens, DbAccess access, RelationshipScanCursor relCursor) {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)entity;
            return access.areTypesSetOnRelationship(typeTokens, relationship, relCursor);
        }
        throw CypherTypeException.expectedRel((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
    }

    private static boolean hasType(VirtualRelationshipValue relationship, TextValue textValue, RelationshipScanCursor relCursor, DbAccess queryContext) throws IllegalTokenNameException {
        String validName = TokenWrite.checkValidTokenName((String)textValue.stringValue(), (TokenType)TokenType.RELATIONSHIP_TYPE);
        int tokenId = queryContext.relationshipType(validName);
        return queryContext.isTypeSetOnRelationship(tokenId, relationship.id(), relCursor);
    }

    public static boolean hasDynamicType(AnyValue entity, AnyValue[] dynamicTypes, RelationshipScanCursor relCursor, DbAccess queryContext, RuntimeNotifier notifier) throws IllegalTokenNameException {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        TextValue singleValue = null;
        ArrayList<String> conflictingTypes = null;
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)entity;
            for (AnyValue value : dynamicTypes) {
                if (value instanceof TextValue) {
                    TextValue textValue = (TextValue)value;
                    TokenWrite.checkValidTokenName((String)textValue.stringValue(), (TokenType)TokenType.RELATIONSHIP_TYPE);
                    if (conflictingTypes != null) {
                        conflictingTypes.add(textValue.stringValue());
                        continue;
                    }
                    if (singleValue == null) {
                        singleValue = textValue;
                        continue;
                    }
                    if (singleValue.equals((Value)textValue)) continue;
                    conflictingTypes = new ArrayList<String>();
                    conflictingTypes.add(singleValue.stringValue());
                    conflictingTypes.add(textValue.stringValue());
                    continue;
                }
                if (value instanceof SequenceValue) {
                    SequenceValue sequenceValue = (SequenceValue)value;
                    for (AnyValue t : sequenceValue) {
                        if (t instanceof TextValue) {
                            TextValue textValue = (TextValue)t;
                            TokenWrite.checkValidTokenName((String)textValue.stringValue(), (TokenType)TokenType.RELATIONSHIP_TYPE);
                            if (conflictingTypes != null) {
                                conflictingTypes.add(textValue.stringValue());
                                continue;
                            }
                            if (singleValue == null) {
                                singleValue = textValue;
                                continue;
                            }
                            if (singleValue.equals((Value)textValue)) continue;
                            conflictingTypes = new ArrayList();
                            conflictingTypes.add(singleValue.stringValue());
                            conflictingTypes.add(textValue.stringValue());
                            continue;
                        }
                        throw CypherTypeException.expectedStringNotNull((String)"Expected relationship type to be a string or list of strings.", (String)(t == Values.NO_VALUE ? "NULL" : t.prettyPrint()), (String)CypherTypeValueMapper.valueType(t));
                    }
                    continue;
                }
                throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)(value == Values.NO_VALUE ? "NULL" : value.prettyPrint()), (String)CypherTypeValueMapper.valueType(value));
            }
            if (singleValue == null) {
                return true;
            }
            if (conflictingTypes != null) {
                notifier.newRuntimeNotification((InternalNotification)new RuntimeUnsatisfiableRelationshipTypeExpression(conflictingTypes));
                return false;
            }
            return CypherFunctions.hasType(relationship, singleValue, relCursor, queryContext);
        }
        throw CypherTypeException.expectedRel((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
    }

    public static boolean hasAnyDynamicType(AnyValue entity, AnyValue[] dynamicTypes, RelationshipScanCursor relCursor, QueryContext queryContext) throws IllegalTokenNameException {
        assert (entity != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (entity instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue relationship = (VirtualRelationshipValue)entity;
            for (AnyValue typ : dynamicTypes) {
                if (typ instanceof TextValue) {
                    TextValue textValue = (TextValue)typ;
                    if (!CypherFunctions.hasType(relationship, textValue, relCursor, queryContext)) continue;
                    return true;
                }
                if (typ instanceof SequenceValue) {
                    SequenceValue typeSeq = (SequenceValue)typ;
                    for (AnyValue t : typeSeq) {
                        if (t instanceof TextValue) {
                            TextValue textValue = (TextValue)t;
                            if (!CypherFunctions.hasType(relationship, textValue, relCursor, queryContext)) continue;
                            return true;
                        }
                        throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)(t == Values.NO_VALUE ? "NULL" : t.prettyPrint()), (String)CypherTypeValueMapper.valueType(t));
                    }
                    continue;
                }
                throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected relationship type to be a string or list of strings.", (String)(typ == Values.NO_VALUE ? "NULL" : typ.prettyPrint()), (String)CypherTypeValueMapper.valueType(typ));
            }
        } else {
            throw CypherTypeException.expectedRel((String)entity.toString(), (String)entity.prettyPrint(), (String)CypherTypeValueMapper.valueType(entity));
        }
        return false;
    }

    public static AnyValue nodes(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof PathValue) {
            return VirtualValues.list((AnyValue[])((PathValue)in).nodes());
        }
        if (in instanceof VirtualPathValue) {
            long[] ids = ((VirtualPathValue)in).nodeIds();
            ListValueBuilder builder = ListValueBuilder.newListBuilder((int)ids.length);
            for (long id : ids) {
                builder.add((AnyValue)VirtualValues.node((long)id));
            }
            return builder.build();
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'nodes()': Expected %s to be a path", in), (String)"nodes", (String)in.prettify(), List.of("PATH"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue relationships(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof VirtualPathValue) {
            VirtualPathValue path = (VirtualPathValue)in;
            return path.relationshipsAsList();
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'relationships()': Expected %s to be a path", in), (String)"relationships", (String)in.prettify(), List.of("PATH"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static Value point(AnyValue in, DbAccess access, ExpressionCursors cursors) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)in;
            return CypherFunctions.asPoint(access, node, cursors.nodeCursor(), cursors.propertyCursor());
        }
        if (in instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)in;
            return CypherFunctions.asPoint(access, rel, cursors.relationshipScanCursor(), cursors.propertyCursor());
        }
        if (in instanceof MapValue) {
            MapValue map = (MapValue)in;
            if (CypherFunctions.containsNull(map)) {
                return Values.NO_VALUE;
            }
            return PointValue.fromMap((MapValue)map);
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'point()': Expected a map but got %s", in), (String)"point", (String)in.prettify(), List.of("MAP"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue keys(AnyValue in, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)in;
            return CypherFunctions.extractKeys(access, access.nodePropertyIds(node.id(), nodeCursor, propertyCursor));
        }
        if (in instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)in;
            return CypherFunctions.extractKeys(access, access.relationshipPropertyIds(rel, relationshipScanCursor, propertyCursor));
        }
        if (in instanceof MapValue) {
            return ((MapValue)in).keys();
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'keys()': Expected a node, a relationship or a literal map but got %s", in), (String)"keys", (String)in.prettify(), List.of("NODE", "RELATIONSHIP", "LITERAL MAP"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue properties(AnyValue in, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)in;
            return access.nodeAsMap(node.id(), nodeCursor, propertyCursor, new MapValueBuilder(), (IntSet)IntSets.immutable.empty());
        }
        if (in instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)in;
            return access.relationshipAsMap(rel, relationshipCursor, propertyCursor, new MapValueBuilder(), (IntSet)IntSets.immutable.empty());
        }
        if (in instanceof MapValue) {
            return in;
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'properties()': Expected a node, a relationship or a literal map but got %s", in), (String)"properties", (String)in.prettify(), List.of("NODE", "RELATIONSHIP", "LITERAL MAP"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue properties(AnyValue in, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor, MapValueBuilder alreadyReadProperties, IntSet alreadyReadPropertyTokens) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)in;
            return access.nodeAsMap(node.id(), nodeCursor, propertyCursor, alreadyReadProperties, alreadyReadPropertyTokens);
        }
        if (in instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)in;
            return access.relationshipAsMap(rel.id(), relationshipCursor, propertyCursor, alreadyReadProperties, alreadyReadPropertyTokens);
        }
        if (in instanceof MapValue) {
            return in;
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'properties()': Expected a node, a relationship or a literal map but got %s", in), (String)"properties", (String)in.toString(), List.of("NODE", "RELATIONSHIP", "LITERAL MAP"), (String)in.getTypeName());
    }

    public static AnyValue characterLength(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof TextValue) {
            return CypherFunctions.size(item);
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'character_length()': Expected a String, got: " + String.valueOf(item)), (String)"character_length", (String)item.prettify(), List.of("STRING"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static AnyValue vectorDimension(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof VectorValue) {
            VectorValue vector = (VectorValue)item;
            return Values.longValue((long)vector.dimensions());
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'vector_dimension_count()': Expected a VECTOR, got: " + String.valueOf(item)), (String)"vector_dimension_count", (String)item.prettify(), List.of("VECTOR"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static AnyValue size(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof TextValue) {
            TextValue textValue = (TextValue)item;
            return Values.longValue((long)textValue.length());
        }
        if (item instanceof SequenceValue) {
            SequenceValue list = (SequenceValue)item;
            return Values.longValue((long)list.actualSize());
        }
        if (item instanceof VectorValue) {
            VectorValue vector = (VectorValue)item;
            return Values.longValue((long)vector.dimensions());
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'size()': Expected a String, Vector or List, got: " + String.valueOf(item)), (String)"size", (String)item.prettify(), List.of("STRING", "VECTOR", "LIST<ANY>"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static AnyValue sizeCypher5(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof TextValue) {
            TextValue textValue = (TextValue)item;
            return Values.longValue((long)textValue.length());
        }
        if (item instanceof SequenceValue) {
            SequenceValue list = (SequenceValue)item;
            return Values.longValue((long)list.actualSize());
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'size()': Expected a String or List, got: " + String.valueOf(item)), (String)"size", (String)item.prettify(), List.of("STRING", "LIST<ANY>"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static AnyValue isEmpty(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof SequenceValue) {
            return Values.booleanValue((boolean)((SequenceValue)item).isEmpty());
        }
        if (item instanceof MapValue) {
            return Values.booleanValue((boolean)((MapValue)item).isEmpty());
        }
        if (item instanceof TextValue) {
            return Values.booleanValue((boolean)((TextValue)item).isEmpty());
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'isEmpty()': Expected a List, Map, or String, got: " + String.valueOf(item)), (String)"isEmpty", (String)item.prettify(), List.of("LIST<ANY>", "MAP", "STRING"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static AnyValue length(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof VirtualPathValue) {
            return Values.longValue((long)((VirtualPathValue)item).size());
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'length()': Expected a Path, got: " + String.valueOf(item)), (String)"length", (String)item.prettify(), List.of("PATH"), (String)CypherTypeValueMapper.valueType(item));
    }

    public static Value toBoolean(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof BooleanValue) {
            return (BooleanValue)in;
        }
        if (in instanceof TextValue) {
            return switch (((TextValue)in).trim().stringValue().toLowerCase(Locale.ROOT)) {
                case "true" -> Values.TRUE;
                case "false" -> Values.FALSE;
                default -> Values.NO_VALUE;
            };
        }
        if (in instanceof IntegralValue) {
            IntegralValue integer = (IntegralValue)in;
            return integer.longValue() == 0L ? Values.FALSE : Values.TRUE;
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'toBoolean()': Expected a Boolean, Integer or String, got: " + String.valueOf(in)), (String)"toBoolean", (String)in.prettify(), List.of("BOOLEAN", "INTEGER", "STRING"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static Value toBooleanOrNull(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof BooleanValue || in instanceof TextValue || in instanceof IntegralValue) {
            return CypherFunctions.toBoolean(in);
        }
        return Values.NO_VALUE;
    }

    public static AnyValue toBooleanList(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sv = (SequenceValue)in;
            return (AnyValue)StreamSupport.stream(sv.spliterator(), false).map(entry -> entry == Values.NO_VALUE ? Values.NO_VALUE : CypherFunctions.toBooleanOrNull(entry)).collect(ListValueBuilder.collector());
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'toBooleanList()': Expected a List, got: %s", in), (String)"toBooleanList", (String)in.prettify(), List.of("LIST<ANY>"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static Value toFloat(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof DoubleValue) {
            DoubleValue d = (DoubleValue)in;
            return d;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.doubleValue((double)number.doubleValue());
        }
        if (in instanceof TextValue) {
            TextValue text = (TextValue)in;
            return CypherRuntimeParser.parseAsDoubleOrElseNoValue(text.stringValue());
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'toFloat()': Expected a String, Float or Integer, got: " + String.valueOf(in)), (String)"toFloat", (String)in.prettify(), List.of("STRING", "FLOAT", "INTEGER"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static Value toFloatOrNull(AnyValue in) {
        if (in instanceof NumberValue || in instanceof TextValue) {
            return CypherFunctions.toFloat(in);
        }
        return Values.NO_VALUE;
    }

    public static AnyValue toFloatList(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sv = (SequenceValue)in;
            return (AnyValue)StreamSupport.stream(sv.spliterator(), false).map(entry -> entry == Values.NO_VALUE ? Values.NO_VALUE : CypherFunctions.toFloatOrNull(entry)).collect(ListValueBuilder.collector());
        }
        if (in instanceof VectorValue) {
            VectorValue v = (VectorValue)in;
            ListValueBuilder list = ListValueBuilder.newListBuilder((int)v.dimensions());
            for (int i = 0; i < v.dimensions(); ++i) {
                list.add((AnyValue)Values.doubleValue((double)v.doubleValue(i)));
            }
            return list.build();
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'toFloatList()': Expected a List or Vector, got: %s", in), (String)"toFloatList", (String)in.prettify(), List.of("LIST<ANY>", "VECTOR"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue toFloatListCypher5(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sv = (SequenceValue)in;
            return (AnyValue)StreamSupport.stream(sv.spliterator(), false).map(entry -> entry == Values.NO_VALUE ? Values.NO_VALUE : CypherFunctions.toFloatOrNull(entry)).collect(ListValueBuilder.collector());
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'toFloatList()': Expected a List, got: %s", in), (String)"toFloatList", (String)in.prettify(), List.of("LIST<ANY>"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static Value toInteger(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof IntegralValue) {
            IntegralValue integer = (IntegralValue)in;
            return integer;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.longValue((long)number.longValue());
        }
        if (in instanceof TextValue) {
            TextValue text = (TextValue)in;
            return CypherRuntimeParser.parseAsLongOrElseNoValue(text.stringValue());
        }
        if (in instanceof BooleanValue) {
            BooleanValue bool = (BooleanValue)in;
            if (bool.booleanValue()) {
                return Values.longValue((long)1L);
            }
            return Values.longValue((long)0L);
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'toInteger()': Expected a String, Float, Integer or Boolean, got: " + String.valueOf(in)), (String)"toInteger", (String)in.prettify(), List.of("STRING", "FLOAT", "INTEGER", "BOOLEAN"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static Value toIntegerOrNull(AnyValue in) {
        if (in instanceof NumberValue || in instanceof BooleanValue) {
            return CypherFunctions.toInteger(in);
        }
        if (in instanceof TextValue) {
            TextValue textValue = (TextValue)in;
            try {
                return CypherRuntimeParser.parseAsLongOrElseNoValue(textValue.stringValue());
            }
            catch (CypherTypeException e) {
                return Values.NO_VALUE;
            }
        }
        return Values.NO_VALUE;
    }

    public static AnyValue toIntegerList(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof IntegralArray) {
            IntegralArray array = (IntegralArray)in;
            return VirtualValues.fromArray((ArrayValue)array);
        }
        if (in instanceof FloatingPointArray) {
            FloatingPointArray array = (FloatingPointArray)in;
            return CypherFunctions.toIntegerList(array);
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return CypherFunctions.toIntegerList(sequence);
        }
        if (in instanceof VectorValue) {
            VectorValue v = (VectorValue)in;
            ListValueBuilder list = ListValueBuilder.newListBuilder((int)v.dimensions());
            for (int i = 0; i < v.dimensions(); ++i) {
                list.add((AnyValue)Values.longValue((long)((long)v.doubleValue(i))));
            }
            return list.build();
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'toIntegerList()': Expected a List or Vector, got: %s", in), (String)"toIntegerList", (String)in.prettify(), List.of("LIST<ANY>", "VECTOR"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue toIntegerListCypher5(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof IntegralArray) {
            IntegralArray array = (IntegralArray)in;
            return VirtualValues.fromArray((ArrayValue)array);
        }
        if (in instanceof FloatingPointArray) {
            FloatingPointArray array = (FloatingPointArray)in;
            return CypherFunctions.toIntegerList(array);
        }
        if (in instanceof SequenceValue) {
            SequenceValue sequence = (SequenceValue)in;
            return CypherFunctions.toIntegerList(sequence);
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'toIntegerList()': Expected a List, got: %s", in), (String)"toIntegerList", (String)in.prettify(), List.of("LIST<ANY>"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static Value toString(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof TextValue) {
            TextValue text = (TextValue)in;
            return text;
        }
        if (in instanceof NumberValue) {
            NumberValue number = (NumberValue)in;
            return Values.stringValue((String)number.prettyPrint());
        }
        if (in instanceof BooleanValue) {
            BooleanValue b = (BooleanValue)in;
            return Values.stringValue((String)b.prettyPrint());
        }
        if (in instanceof TemporalValue || in instanceof DurationValue || in instanceof PointValue) {
            return Values.stringValue((String)in.toString());
        }
        throw CypherTypeException.functionArgumentWrongType((String)("Invalid input for function 'toString()': Expected a String, Float, Integer, Boolean, Temporal or Duration, got: " + String.valueOf(in)), (String)"toString", (String)in.prettify(), List.of("STRING", "FLOAT", "INTEGER", "BOOLEAN", "TEMPORAL", "DURATION"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue toStringOrNull(AnyValue in) {
        if (in instanceof TextValue || in instanceof NumberValue || in instanceof BooleanValue || in instanceof TemporalValue || in instanceof DurationValue || in instanceof PointValue) {
            return CypherFunctions.toString(in);
        }
        return Values.NO_VALUE;
    }

    public static AnyValue toStringList(AnyValue in) {
        if (in == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (in instanceof SequenceValue) {
            SequenceValue sv = (SequenceValue)in;
            return (AnyValue)StreamSupport.stream(sv.spliterator(), false).map(entry -> entry == Values.NO_VALUE ? Values.NO_VALUE : CypherFunctions.toStringOrNull(entry)).collect(ListValueBuilder.collector());
        }
        throw CypherTypeException.functionArgumentWrongType((String)String.format("Invalid input for function 'toStringList()': Expected a List, got: %s", in), (String)"toStringList", (String)in.prettify(), List.of("LIST<ANY>"), (String)CypherTypeValueMapper.valueType(in));
    }

    public static AnyValue fromSlice(AnyValue collection, AnyValue fromValue) {
        if (collection == Values.NO_VALUE || fromValue == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        int from = CypherFunctions.asIntExact(fromValue);
        ListValue list = VirtualValues.asList((AnyValue)collection);
        if (from >= 0) {
            return list.drop((long)from);
        }
        return list.drop(list.actualSize() + (long)from);
    }

    public static AnyValue toSlice(AnyValue collection, AnyValue toValue) {
        if (collection == Values.NO_VALUE || toValue == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        int from = CypherFunctions.asIntExact(toValue);
        ListValue list = VirtualValues.asList((AnyValue)collection);
        if (from >= 0) {
            return list.take(from);
        }
        return list.take(list.intSize() + from);
    }

    public static AnyValue fullSlice(AnyValue collection, AnyValue fromValue, AnyValue toValue) {
        if (collection == Values.NO_VALUE || fromValue == Values.NO_VALUE || toValue == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        int from = CypherFunctions.asIntExact(fromValue);
        int to = CypherFunctions.asIntExact(toValue);
        ListValue list = VirtualValues.asList((AnyValue)collection);
        int size = list.intSize();
        if (from >= 0 && to >= 0) {
            return list.slice(from, to);
        }
        if (from >= 0) {
            return list.slice(from, size + to);
        }
        if (to >= 0) {
            return list.slice(size + from, to);
        }
        return list.slice(size + from, size + to);
    }

    public static TextValue asTextValue(AnyValue value) {
        return CypherFunctions.asTextValue(value, null);
    }

    public static TextValue asTextValue(AnyValue value, Supplier<String> contextForErrorMessage) {
        if (!(value instanceof TextValue)) {
            String errorMessage = contextForErrorMessage == null ? String.format("Expected %s to be a %s, but it was a %s", value, TextValue.class.getName(), value.getClass().getName()) : String.format("%s: Expected %s to be a %s, but it was a %s", contextForErrorMessage.get(), value, TextValue.class.getName(), value.getClass().getName());
            throw CypherTypeException.expectedString((String)errorMessage, (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
        }
        return (TextValue)value;
    }

    private static ListValue extractKeys(DbAccess access, int[] keyIds) {
        String[] keysNames = new String[keyIds.length];
        for (int i = 0; i < keyIds.length; ++i) {
            keysNames[i] = access.getPropertyKeyName(keyIds[i]);
        }
        return VirtualValues.fromArray((ArrayValue)Values.stringArray((String[])keysNames));
    }

    private static Value asPoint(DbAccess access, VirtualNodeValue nodeValue, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value = access.nodeProperty(nodeValue.id(), access.propertyKey(key), nodeCursor, propertyCursor, true);
            if (value == Values.NO_VALUE) continue;
            builder.add(key, (AnyValue)value);
        }
        return PointValue.fromMap((MapValue)builder.build());
    }

    private static Value asPoint(DbAccess access, VirtualRelationshipValue relationshipValue, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        MapValueBuilder builder = new MapValueBuilder();
        for (String key : POINT_KEYS) {
            Value value = access.relationshipProperty(relationshipValue, access.propertyKey(key), relationshipScanCursor, propertyCursor, true);
            if (value == Values.NO_VALUE) continue;
            builder.add(key, (AnyValue)value);
        }
        return PointValue.fromMap((MapValue)builder.build());
    }

    private static boolean containsNull(MapValue map) {
        boolean[] hasNull = new boolean[]{false};
        map.foreach((s, value) -> {
            if (value == Values.NO_VALUE) {
                hasNull[0] = true;
            }
        });
        return hasNull[0];
    }

    private static AnyValue listAccess(SequenceValue container, AnyValue index) {
        NumberValue number = CypherFunctions.asNumberValue(index, () -> "Cannot access a list '" + container.toString() + "' using a non-number index, got " + index.toString());
        if (!(number instanceof IntegralValue)) {
            throw CypherTypeException.nonIntegerListIndex((String)String.valueOf(number), (String)number.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)number));
        }
        long idx = number.longValue();
        if (idx < 0L) {
            idx = container.actualSize() + idx;
        }
        if (idx >= container.actualSize() || idx < 0L) {
            return Values.NO_VALUE;
        }
        return container.value(idx);
    }

    private static int propertyKeyId(DbAccess dbAccess, AnyValue index) {
        return dbAccess.propertyKey(CypherFunctions.asString(index, () -> "Cannot use a property key with non string name. It was " + index.toString()));
    }

    private static AnyValue mapAccess(MapValue container, AnyValue index) {
        return container.get(CypherFunctions.asString(index, () -> "Cannot access a map '" + container.toString() + "' by key '" + index.toString() + "'"));
    }

    public static String asString(AnyValue value) {
        return CypherFunctions.asTextValue(value).stringValue();
    }

    public static List<String> nodeLabelsAsStringList(AnyValue value) {
        if (value instanceof TextValue) {
            TextValue text = (TextValue)value;
            return Collections.singletonList(text.stringValue());
        }
        if (value instanceof SequenceValue) {
            SequenceValue sequenceValue = (SequenceValue)value;
            ArrayList<String> result = new ArrayList<String>();
            for (AnyValue s : sequenceValue) {
                if (s instanceof TextValue) {
                    TextValue t = (TextValue)s;
                    result.add(t.stringValue());
                    continue;
                }
                throw CypherTypeException.expectedStringNotNull((String)"Expected node label to be a string or list of strings.", (String)(s == Values.NO_VALUE ? "NULL" : s.prettyPrint()), (String)CypherTypeValueMapper.valueType(s));
            }
            return result;
        }
        throw CypherTypeException.expectedStringOrListOfStringsNotNull((String)"Expected node label to be a string or list of strings.", (String)(value == Values.NO_VALUE ? "NULL" : value.prettyPrint()), (String)CypherTypeValueMapper.valueType(value));
    }

    private static String asString(AnyValue value, Supplier<String> contextForErrorMessage) {
        return CypherFunctions.asTextValue(value, contextForErrorMessage).stringValue();
    }

    private static NumberValue asNumberValue(AnyValue value, Supplier<String> contextForErrorMessage) {
        if (!(value instanceof NumberValue)) {
            String msg = String.format("%s: Expected %s to be a %s, but it was a %s", contextForErrorMessage.get(), value, NumberValue.class.getName(), value.getClass().getName());
            throw CypherTypeException.expectedNumber((String)msg, (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
        }
        return (NumberValue)value;
    }

    private static Value calculateDistance(PointValue p1, PointValue p2) {
        if (p1.getCoordinateReferenceSystem().equals((Object)p2.getCoordinateReferenceSystem())) {
            return Values.doubleValue((double)p1.getCoordinateReferenceSystem().getCalculator().distance(p1, p2));
        }
        return Values.NO_VALUE;
    }

    private static long asLong(AnyValue value, Supplier<String> contextForErrorMessage, String functionName) {
        return CypherFunctions.asLong(value, contextForErrorMessage, functionName, true);
    }

    private static long asLong(AnyValue value, Supplier<String> contextForErrorMessage, String functionName, Boolean allowFloats) {
        if (value instanceof NumberValue) {
            NumberValue numberValue = (NumberValue)value;
            if (allowFloats.booleanValue() || !(numberValue instanceof FloatingPointValue)) {
                return numberValue.longValue();
            }
        }
        String numericTypeString = allowFloats != false ? "a numeric" : "an integer";
        String errorMsg = contextForErrorMessage == null ? "Expected " + numericTypeString + " value but got: " + String.valueOf(value) : contextForErrorMessage.get() + ": Expected " + numericTypeString + " value but got: " + String.valueOf(value);
        if (!functionName.isEmpty()) {
            throw CypherTypeException.functionArgumentWrongType((String)errorMsg, (String)functionName, (String)value.prettify(), allowFloats != false ? List.of("INTEGER", "FLOAT") : List.of("INTEGER"), (String)CypherTypeValueMapper.valueType(value));
        }
        throw CypherTypeException.expectedNumber((String)errorMsg, (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
    }

    public static int asIntExact(AnyValue value) {
        return CypherFunctions.asIntExact(value, null, null, true);
    }

    public static int asIntExact(AnyValue value, Supplier<String> contextForErrorMessage, String functionName) {
        return CypherFunctions.asIntExact(value, contextForErrorMessage, functionName, true);
    }

    public static int asIntExact(AnyValue value, Supplier<String> contextForErrorMessage, String functionName, Boolean allowFloats) {
        long longValue = CypherFunctions.asLong(value, contextForErrorMessage, functionName, allowFloats);
        int intValue = (int)longValue;
        if ((long)intValue != longValue) {
            Object errorMsg = String.format("Expected an integer between %d and %d, but got: %d", Integer.MIN_VALUE, Integer.MAX_VALUE, longValue);
            if (contextForErrorMessage != null) {
                errorMsg = contextForErrorMessage.get() + ": " + (String)errorMsg;
            }
            throw new IllegalArgumentException((String)errorMsg);
        }
        return intValue;
    }

    public static long nodeId(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (value instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)value;
            return node.id();
        }
        throw CypherTypeException.expectedVirtualNode((String)value.prettyPrint(), (String)value.getClass().getName(), (String)CypherTypeValueMapper.valueType(value));
    }

    public static long nodeIdOrParameterWrongTypeError(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (value instanceof VirtualNodeValue) {
            VirtualNodeValue node = (VirtualNodeValue)value;
            return node.id();
        }
        throw ParameterWrongTypeException.expectedNodeFoundInstead((String)value.toString(), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
    }

    public static long relIdOrParameterWrongTypeError(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (value instanceof VirtualRelationshipValue) {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)value;
            return rel.id();
        }
        throw ParameterWrongTypeException.expectedNodeFoundInstead((String)value.toString(), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType(value));
    }

    public static AnyValue isNormalized(AnyValue input, NormalForm normalForm) {
        if (input == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (input instanceof TextValue) {
            Normalizer.Form form;
            TextValue asText = (TextValue)input;
            try {
                form = Normalizer.Form.valueOf(normalForm.description());
            }
            catch (IllegalArgumentException e) {
                throw InvalidArgumentException.unknownNormalForm((String)String.valueOf(normalForm));
            }
            boolean normalized = Normalizer.isNormalized(asText.stringValue(), form);
            return Values.booleanValue((boolean)normalized);
        }
        return Values.NO_VALUE;
    }

    /*
     * Unable to fully structure code
     */
    public static BooleanValue isTyped(AnyValue item, CypherType typeName) {
        block13: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        if (!(typeName instanceof NothingType)) break block14;
                                                        result = false;
                                                        break block13;
                                                    }
                                                    if (!(item instanceof NoValue)) break block15;
                                                    result = typeName instanceof NullType != false || typeName.isNullable() != false;
                                                    break block13;
                                                }
                                                if (!(typeName instanceof NullType)) break block16;
                                                result = false;
                                                break block13;
                                            }
                                            if (!(typeName instanceof AnyType)) break block17;
                                            result = true;
                                            break block13;
                                        }
                                        if (!(typeName instanceof ListType)) break block18;
                                        listType = (ListType)typeName;
                                        result = item instanceof SequenceValue != false && CypherFunctions.checkInnerListIsTyped(list = (SequenceValue)item, listType) != false;
                                        break block13;
                                    }
                                    if (!typeName.hasValueRepresentation() || typeName instanceof ClosedDynamicUnionType) break block19;
                                    result = CypherFunctions.possibleValueRepresentations(typeName).contains(item.valueRepresentation());
                                    if (result && typeName instanceof VectorType) {
                                        vectorType = (VectorType)typeName;
                                        if (item instanceof VectorValue) {
                                            vectorValue = (VectorValue)item;
                                            if (vectorType.dimension().isDefined()) {
                                                dimension = (Long)vectorType.dimension().get();
                                                if ((long)vectorValue.dimensions() != dimension) {
                                                    result = false;
                                                    ** GOTO lbl77
                                                }
                                            }
                                        }
                                    }
                                    break block13;
                                }
                                if (!(typeName instanceof NodeType)) break block20;
                                result = item instanceof VirtualNodeValue;
                                break block13;
                            }
                            if (!(typeName instanceof RelationshipType)) break block21;
                            result = item instanceof VirtualRelationshipValue;
                            break block13;
                        }
                        if (!(typeName instanceof MapType)) break block22;
                        result = item instanceof MapValue;
                        break block13;
                    }
                    if (!(typeName instanceof PathType)) break block23;
                    result = item instanceof VirtualPathValue;
                    break block13;
                }
                if (!(typeName instanceof VectorType)) break block24;
                vectorType = (VectorType)typeName;
                if (!(item instanceof VectorValue)) ** GOTO lbl-1000
                vectorVal = (VectorValue)item;
                if (vectorType.dimension().contains((Object)vectorVal.dimensions()) || !vectorType.dimension().isDefined()) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                result = v0;
                break block13;
            }
            if (typeName instanceof PropertyValueCypher5Type) {
                result = CypherFunctions.hasPropertyValueRepresentation(item.valueRepresentation(), false) != false || item instanceof ListValue != false && ((listValue = (ListValue)item).isEmpty() != false || CypherFunctions.hasPropertyValueRepresentation(listValue.itemValueRepresentation(), true) != false);
            } else if (typeName instanceof PropertyValueType) {
                result = CypherFunctions.hasPropertyValueRepresentation(item.valueRepresentation(), false) != false || item instanceof ListValue != false && ((listValue = (ListValue)item).isEmpty() != false || CypherFunctions.hasPropertyValueRepresentation(listValue.itemValueRepresentation(), true) != false);
            } else if (typeName instanceof ClosedDynamicUnionType) {
                unionType = (ClosedDynamicUnionType)typeName;
                result = false;
                for (CypherType innerType : CollectionConverters.asJava((Set)unionType.innerTypes())) {
                    if (CypherFunctions.isTyped(item, innerType) != Values.TRUE) continue;
                    result = true;
                    break;
                }
            } else {
                throw new IllegalArgumentException(String.format("Unexpected type: %s", new Object[]{typeName.toCypherTypeString()}));
            }
        }
        return Values.booleanValue((boolean)result);
    }

    public static Value valueType(AnyValue in) {
        return Values.stringValue((String)CypherType.normalizeTypes((CypherType)((CypherType)in.map((ValueMapper)CYPHER_TYPE_NAME_VALUE_MAPPER))).description());
    }

    private static boolean hasPropertyValueRepresentation(ValueRepresentation valueRepresentation, Boolean inList) {
        return !valueRepresentation.equals((Object)ValueRepresentation.ANYTHING) && !valueRepresentation.equals((Object)ValueRepresentation.UNKNOWN) && !valueRepresentation.equals((Object)ValueRepresentation.NO_VALUE) && (!CypherFunctions.isVectorValueRepresentation(valueRepresentation) || inList == false);
    }

    private static boolean isVectorValueRepresentation(ValueRepresentation valueRepresentation) {
        return valueRepresentation.equals((Object)ValueRepresentation.FLOAT64_VECTOR) || valueRepresentation.equals((Object)ValueRepresentation.FLOAT32_VECTOR) || valueRepresentation.equals((Object)ValueRepresentation.INT64_VECTOR) || valueRepresentation.equals((Object)ValueRepresentation.INT32_VECTOR) || valueRepresentation.equals((Object)ValueRepresentation.INT16_VECTOR) || valueRepresentation.equals((Object)ValueRepresentation.INT8_VECTOR);
    }

    private static List<ValueRepresentation> possibleValueRepresentations(CypherType cypherType) throws UnsupportedOperationException {
        List<ValueRepresentation> representations = TYPE_TO_REPRESENTATIONS.get(cypherType.getClass());
        if (representations != null) {
            return representations;
        }
        if (cypherType instanceof VectorType) {
            VectorType vectorType = (VectorType)cypherType;
            if (vectorType.innerType().isDefined()) {
                CypherType cypherType2 = (CypherType)vectorType.innerType().get();
                Objects.requireNonNull(cypherType2);
                CypherType cypherType3 = cypherType2;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float32Type.class, FloatType.class, Integer8Type.class, Integer16Type.class, Integer32Type.class, IntegerType.class}, (Object)cypherType3, n)) {
                    case 0 -> {
                        Float32Type __ = (Float32Type)cypherType3;
                        yield List.of(ValueRepresentation.FLOAT32_VECTOR);
                    }
                    case 1 -> {
                        FloatType __ = (FloatType)cypherType3;
                        yield List.of(ValueRepresentation.FLOAT64_VECTOR);
                    }
                    case 2 -> {
                        Integer8Type __ = (Integer8Type)cypherType3;
                        yield List.of(ValueRepresentation.INT8_VECTOR);
                    }
                    case 3 -> {
                        Integer16Type __ = (Integer16Type)cypherType3;
                        yield List.of(ValueRepresentation.INT16_VECTOR);
                    }
                    case 4 -> {
                        Integer32Type __ = (Integer32Type)cypherType3;
                        yield List.of(ValueRepresentation.INT32_VECTOR);
                    }
                    case 5 -> {
                        IntegerType __ = (IntegerType)cypherType3;
                        yield List.of(ValueRepresentation.INT64_VECTOR);
                    }
                    default -> throw new UnsupportedOperationException("Unsupported vector coordinate type: " + ((CypherType)vectorType.innerType().get()).getClass().getName());
                };
            }
            return List.of(ValueRepresentation.FLOAT64_VECTOR, ValueRepresentation.FLOAT32_VECTOR, ValueRepresentation.INT64_VECTOR, ValueRepresentation.INT32_VECTOR, ValueRepresentation.INT16_VECTOR, ValueRepresentation.INT8_VECTOR);
        }
        if (cypherType instanceof ListType) {
            ListType listType = (ListType)cypherType;
            CypherType innerType = listType.innerType();
            if (innerType instanceof ClosedDynamicUnionType) {
                ClosedDynamicUnionType closedDynamicUnionType = (ClosedDynamicUnionType)innerType;
                return CypherFunctions.possibleUnionListValueRepresentations(closedDynamicUnionType);
            }
            List<ValueRepresentation> listReps = LIST_INNER_TYPE_TO_REPRESENTATIONS.get(innerType.getClass());
            return listReps != null ? listReps : List.of();
        }
        if (cypherType instanceof ClosedDynamicUnionType) {
            ClosedDynamicUnionType closedDynamicUnionType = (ClosedDynamicUnionType)cypherType;
            return CypherFunctions.possibleUnionValueRepresentations(closedDynamicUnionType);
        }
        throw new UnsupportedOperationException("possibleValueRepresentations not supported on " + cypherType.getClass().getName());
    }

    private static List<ValueRepresentation> possibleUnionValueRepresentations(ClosedDynamicUnionType innerListType) {
        ArrayList<ValueRepresentation> possibleValueRepresentations = new ArrayList<ValueRepresentation>();
        for (CypherType cypherType : CollectionConverters.asJava((Set)innerListType.innerTypes())) {
            List<ValueRepresentation> representations = CypherFunctions.possibleValueRepresentations(cypherType);
            if (representations == null) continue;
            possibleValueRepresentations.addAll(representations);
        }
        return possibleValueRepresentations;
    }

    private static List<ValueRepresentation> possibleUnionListValueRepresentations(ClosedDynamicUnionType innerListType) {
        ArrayList<ValueRepresentation> possibleValueRepresentations = new ArrayList<ValueRepresentation>();
        for (CypherType cypherType : CollectionConverters.asJava((Set)innerListType.innerTypes())) {
            List<ValueRepresentation> representations = LIST_INNER_TYPE_TO_REPRESENTATIONS.get(cypherType.getClass());
            if (representations == null) continue;
            possibleValueRepresentations.addAll(representations);
        }
        return possibleValueRepresentations;
    }

    private static boolean checkInnerListIsTyped(SequenceValue values, ListType typeName) {
        CypherType itemType = typeName.innerType();
        if (values.isEmpty() || !itemType.isNullable() && itemType instanceof AnyType) {
            return true;
        }
        if (itemType instanceof NothingType) {
            return false;
        }
        if (values instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)values;
            return itemType instanceof AnyType || itemType instanceof PropertyValueType || itemType instanceof PropertyValueCypher5Type || typeName.hasValueRepresentation() && CypherFunctions.possibleValueRepresentations((CypherType)typeName).contains(array.valueRepresentation());
        }
        if (values instanceof ListValue) {
            ListValue list = (ListValue)values;
            if (itemType.hasValueRepresentation() && !itemType.isNullable() && list.itemValueRepresentation().valueGroup() != ValueGroup.NUMBER && CypherFunctions.possibleValueRepresentations(itemType).contains(list.itemValueRepresentation())) {
                return true;
            }
            for (AnyValue value : values) {
                if (CypherFunctions.isTyped(value, itemType) != Values.FALSE) continue;
                return false;
            }
        }
        return true;
    }

    public static AnyValue assertIsNode(AnyValue item) {
        if (item == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (item instanceof VirtualNodeValue) {
            return Values.TRUE;
        }
        throw CypherTypeException.expectedNode((String)String.valueOf(item), (String)item.prettyPrint(), (String)CypherTypeValueMapper.valueType(item));
    }

    private static CypherTypeException needsNumbers(String method, AnyValue in) {
        return CypherTypeException.functionArgumentWrongType((String)String.format("%s() requires numbers", method), (String)method, (String)in.prettify(), List.of("INTEGER", "FLOAT"), (String)CypherTypeValueMapper.valueType(in));
    }

    private static CypherTypeException notAString(String method, AnyValue in) {
        return CypherTypeException.functionArgumentWrongType((String)String.format("Expected a string value for `%s`, but got: %s; consider converting it to a string with toString().", method, in), (String)method, (String)in.prettify(), List.of("STRING"), (String)CypherTypeValueMapper.valueType(in));
    }

    private static CypherTypeException notAVector(String method, AnyValue in) {
        return CypherTypeException.functionArgumentWrongType((String)String.format("Expected a vector value for `%s`, but got: %s.", method, in), (String)method, (String)in.prettify(), List.of("VECTOR"), (String)CypherTypeValueMapper.valueType(in));
    }

    private static CypherTypeException notAModeString(String method, AnyValue mode) {
        return CypherTypeException.functionArgumentWrongType((String)String.format("Expected a string value for `%s`, but got: %s.", method, mode), (String)method, (String)mode.prettify(), List.of("STRING"), (String)CypherTypeValueMapper.valueType(mode));
    }

    private static ListValue toIntegerList(FloatingPointArray array) {
        ListValueBuilder converted = ListValueBuilder.newListBuilder((int)array.intSize());
        for (int i = 0; i < array.intSize(); ++i) {
            converted.add((AnyValue)Values.longValue((long)((long)array.doubleValue(i))));
        }
        return converted.build();
    }

    private static ListValue toIntegerList(SequenceValue sequenceValue) {
        ListValueBuilder converted = ListValueBuilder.newListBuilder();
        for (AnyValue value : sequenceValue) {
            converted.add((AnyValue)(value != Values.NO_VALUE ? CypherFunctions.toIntegerOrNull(value) : Values.NO_VALUE));
        }
        return converted.build();
    }

    private static Consumer<RelationshipVisitor> consumer(DbAccess access, RelationshipScanCursor cursor) {
        return relationshipVisitor -> {
            access.singleRelationship(relationshipVisitor.id(), cursor);
            if (cursor.next()) {
                relationshipVisitor.visit(cursor.sourceNodeReference(), cursor.targetNodeReference(), cursor.type());
            }
        };
    }

    public static sealed interface GetSingleDynamicTypeResult {

        public record EmptyDynamicTypeList() implements GetSingleDynamicTypeResult
        {
        }

        public record ConflictingDynamicTypes() implements GetSingleDynamicTypeResult
        {
        }

        public record SingleDynamicType(String value) implements GetSingleDynamicTypeResult
        {
            public String getValue() {
                return this.value;
            }
        }
    }
}

