/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Optional;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.TerminateTransactionsClause$;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TerminateTransactionsCommand$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommandHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.internal.kernel.api.security.UserSegment;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.InternalLog;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\u0010 \u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t;\u0002\u0011\t\u0012)A\u0005\u0013\"Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005h\u0001\tE\t\u0015!\u0003a\u0011!A\u0007A!f\u0001\n\u0003I\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011\u00026\t\u000b=\u0004A\u0011\u00019\t\u000bU\u0004A\u0011\t<\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007\u0002\u0011\u0013!C\u0001\u0003\u000bB\u0011\"a\u0017\u0001#\u0003%\t!!\u0018\t\u0013\u0005\u0005\u0004!%A\u0005\u0002\u0005\r\u0004\"CA4\u0001\u0005\u0005I\u0011IA5\u0011%\tI\bAA\u0001\n\u0003\tY\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00131\u0013\u0005\n\u0003C\u0003\u0011\u0011!C\u0001\u0003GC\u0011\"!,\u0001\u0003\u0003%\t%a,\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CA\\\u0001\u0005\u0005I\u0011IA]\u0011%\tY\fAA\u0001\n\u0003\nilB\u0005\u0002B~\t\t\u0011#\u0001\u0002D\u001aAadHA\u0001\u0012\u0003\t)\r\u0003\u0004p1\u0011\u0005\u00111\u001c\u0005\n\u0003oC\u0012\u0011!C#\u0003sC\u0011\"!8\u0019\u0003\u0003%\t)a8\t\u0013\u0005\u001d\b$!A\u0005\u0002\u0006%\b\"CA~1\u0005\u0005I\u0011BA\u007f\u0005q!VM]7j]\u0006$X\r\u0016:b]N\f7\r^5p]N\u001cu.\\7b]\u0012T!\u0001I\u0011\u0002\u0019MDwn^2p[6\fg\u000eZ:\u000b\u0005\t\u001a\u0013\u0001C2p[6\fg\u000eZ:\u000b\u0005\u0011*\u0013aC5oi\u0016\u0014\bO]3uK\u0012T!AJ\u0014\u0002\u000fI,h\u000e^5nK*\u0011\u0001&K\u0001\tS:$XM\u001d8bY*\u0011!fK\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00051j\u0013!\u00028f_RR'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tTg\u000f\t\u0003eMj\u0011aH\u0005\u0003i}\u0011qaQ8n[\u0006tG\r\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005q\"eBA\u001fC\u001d\tq\u0014)D\u0001@\u0015\t\u0001u&\u0001\u0004=e>|GOP\u0005\u0002q%\u00111iN\u0001\ba\u0006\u001c7.Y4f\u0013\t)eI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Do\u0005Aq-\u001b<f]&#7/F\u0001J!\u0011a$\nT,\n\u0005-3%AB#ji\",'\u000fE\u0002=\u001b>K!A\u0014$\u0003\t1K7\u000f\u001e\t\u0003!Rs!!\u0015*\u0011\u0005y:\u0014BA*8\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M;\u0004C\u0001-\\\u001b\u0005I&B\u0001.\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005qK&AC#yaJ,7o]5p]\u0006Iq-\u001b<f]&#7\u000fI\u0001\bG>dW/\u001c8t+\u0005\u0001\u0007c\u0001\u001fNCB\u0011!-Z\u0007\u0002G*\u0011AmJ\u0001\u0004CN$\u0018B\u00014d\u0005)\u0019\u0006n\\<D_2,XN\\\u0001\tG>dW/\u001c8tA\u0005a\u00110[3mI\u000e{G.^7ogV\t!\u000eE\u0002=\u001b.\u0004\"A\u00197\n\u00055\u001c'!E\"p[6\fg\u000e\u001a*fgVdG/\u0013;f[\u0006i\u00110[3mI\u000e{G.^7og\u0002\na\u0001P5oSRtD\u0003B9sgR\u0004\"A\r\u0001\t\u000b\u001d;\u0001\u0019A%\t\u000by;\u0001\u0019\u00011\t\u000b!<\u0001\u0019\u00016\u0002!=\u0014\u0018nZ5oC2t\u0015-\\3S_^\u001cH#B<\u0002\n\u0005e\u0001c\u0001=zw6\tQ%\u0003\u0002{K\ty1\t\\8tS:<\u0017\n^3sCR|'\u000f\u0005\u0003Qy>s\u0018BA?W\u0005\ri\u0015\r\u001d\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019aK\u0001\u0007m\u0006dW/Z:\n\t\u0005\u001d\u0011\u0011\u0001\u0002\t\u0003:Lh+\u00197vK\"9\u00111\u0002\u0005A\u0002\u00055\u0011!B:uCR,\u0007\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M1%A\u0003qSB,7/\u0003\u0003\u0002\u0018\u0005E!AC)vKJL8\u000b^1uK\"9\u00111\u0004\u0005A\u0002\u0005u\u0011a\u00022bg\u0016\u0014vn\u001e\t\u0004q\u0006}\u0011bAA\u0011K\tI1)\u001f9iKJ\u0014vn^\u0001\rO\u0016$(+Z:vYRl\u0015\r\u001d\u000b\bw\u0006\u001d\u0012\u0011GA\u001b\u0011\u001d\tI#\u0003a\u0001\u0003W\tA\u0001\u001e=JIB\u0019!'!\f\n\u0007\u0005=rDA\u0007Ue\u0006t7/Y2uS>t\u0017\n\u001a\u0005\u0007\u0003gI\u0001\u0019A(\u0002\u0011U\u001cXM\u001d8b[\u0016Da!a\u000e\n\u0001\u0004y\u0015aB7fgN\fw-Z\u0001\u0005G>\u0004\u0018\u0010F\u0004r\u0003{\ty$!\u0011\t\u000f\u001dS\u0001\u0013!a\u0001\u0013\"9aL\u0003I\u0001\u0002\u0004\u0001\u0007b\u00025\u000b!\u0003\u0005\rA[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9EK\u0002J\u0003\u0013Z#!a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+:\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011LA(\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyFK\u0002a\u0003\u0013\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002f)\u001a!.!\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0003k\nAA[1wC&\u0019Q+a\u001c\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0004c\u0001\u001c\u0002\u0000%\u0019\u0011\u0011Q\u001c\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004m\u0005%\u0015bAAFo\t\u0019\u0011I\\=\t\u0013\u0005=\u0005#!AA\u0002\u0005u\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0016B1\u0011qSAO\u0003\u000fk!!!'\u000b\u0007\u0005mu'\u0001\u0006d_2dWm\u0019;j_:LA!a(\u0002\u001a\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)+a+\u0011\u0007Y\n9+C\u0002\u0002*^\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0010J\t\t\u00111\u0001\u0002\b\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY'!-\t\u0013\u0005=5#!AA\u0002\u0005u\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002&\u0006}\u0006\"CAH-\u0005\u0005\t\u0019AAD\u0003q!VM]7j]\u0006$X\r\u0016:b]N\f7\r^5p]N\u001cu.\\7b]\u0012\u0004\"A\r\r\u0014\u000ba\t9-!5\u0011\u0011\u0005%\u0017QZ%aUFl!!a3\u000b\u0005\u0019:\u0014\u0002BAh\u0003\u0017\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t\u0019.!7\u000e\u0005\u0005U'\u0002BAl\u0003g\n!![8\n\u0007\u0015\u000b)\u000e\u0006\u0002\u0002D\u0006)\u0011\r\u001d9msR9\u0011/!9\u0002d\u0006\u0015\b\"B$\u001c\u0001\u0004I\u0005\"\u00020\u001c\u0001\u0004\u0001\u0007\"\u00025\u001c\u0001\u0004Q\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003W\f9\u0010E\u00037\u0003[\f\t0C\u0002\u0002p^\u0012aa\u00149uS>t\u0007C\u0002\u001c\u0002t&\u0003'.C\u0002\u0002v^\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CA}9\u0005\u0005\t\u0019A9\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002\u0000B!\u0011Q\u000eB\u0001\u0013\u0011\u0011\u0019!a\u001c\u0003\r=\u0013'.Z2u\u0001")
public class TerminateTransactionsCommand
extends Command
implements Product,
Serializable {
    private final Either<List<String>, Expression> givenIds;
    private final List<ShowColumn> columns;
    private final List<CommandResultItem> yieldColumns;

    public static Option<Tuple3<Either<List<String>, Expression>, List<ShowColumn>, List<CommandResultItem>>> unapply(TerminateTransactionsCommand x$0) {
        return TerminateTransactionsCommand$.MODULE$.unapply(x$0);
    }

    public static TerminateTransactionsCommand apply(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return TerminateTransactionsCommand$.MODULE$.apply(givenIds, columns, yieldColumns);
    }

    public static Function1<Tuple3<Either<List<String>, Expression>, List<ShowColumn>, List<CommandResultItem>>, TerminateTransactionsCommand> tupled() {
        return TerminateTransactionsCommand$.MODULE$.tupled();
    }

    public static Function1<Either<List<String>, Expression>, Function1<List<ShowColumn>, Function1<List<CommandResultItem>, TerminateTransactionsCommand>>> curried() {
        return TerminateTransactionsCommand$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Either<List<String>, Expression> givenIds() {
        return this.givenIds;
    }

    public List<ShowColumn> columns() {
        return this.columns;
    }

    public List<CommandResultItem> yieldColumns() {
        return this.yieldColumns;
    }

    @Override
    public ClosingIterator<Map<String, AnyValue>> originalNameRows(QueryState state, CypherRow baseRow) {
        List<String> ids = Command$.MODULE$.extractNames(this.givenIds(), state, baseRow, "TERMINATE TRANSACTIONS");
        if (ids.isEmpty()) {
            throw new InvalidSemanticsException("Missing transaction id to terminate, the transaction id can be found using `SHOW TRANSACTIONS`.");
        }
        QueryContext ctx = state.query();
        SecurityContext securityContext = ctx.transactionalContext().securityContext();
        String executingUser = securityContext.subject().executingUser();
        String authenticatedUser = securityContext.subject().authenticatedUser();
        String loggingUser = securityContext.impersonating() ? authenticatedUser + ":" + executingUser : executingUser;
        InternalLog log = state.query().logProvider().getLog(this.getClass());
        log.info("User %s trying to terminate transactions: %s.", new Object[]{loggingUser, ids.mkString("[", ", ", "]")});
        DatabaseContextProvider databaseManager = ctx.getDatabaseContextProvider();
        DatabaseIdRepository databaseIdRepository = databaseManager.databaseIdRepository();
        Tuple2 tuple2 = (Tuple2)ids.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                String idText = (String)tuple2._2();
                if (tuple22 != null) {
                    Map accMap = (Map)tuple22._1();
                    Set accSet = (Set)tuple22._2();
                    TransactionId id = TransactionId$.MODULE$.parse(idText);
                    Optional namedDatabaseId = databaseIdRepository.getByName(id.database());
                    if (namedDatabaseId.isPresent()) {
                        NamedDatabaseId databaseId = (NamedDatabaseId)namedDatabaseId.get();
                        Set transactions = (Set)accMap.getOrElse((Object)databaseId, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                        return new Tuple2((Object)accMap.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)databaseId), (Object)transactions.$plus((Object)id))}))), (Object)accSet);
                    }
                    return new Tuple2((Object)accMap, (Object)accSet.$plus((Object)id));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map transactionsByDatabase = (Map)tuple2._1();
        Set otherTxIds = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transactionsByDatabase, (Object)otherTxIds);
        Map transactionsByDatabase2 = (Map)tuple22._1();
        Set otherTxIds2 = (Set)tuple22._2();
        Iterable rows = (Iterable)transactionsByDatabase2.flatMap((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                NamedDatabaseId databaseId = (NamedDatabaseId)tuple2._1();
                Set txIds = (Set)tuple2._2();
                if (databaseId != null) {
                    NamedDatabaseId namedDatabaseId = databaseId;
                    if (txIds != null) {
                        Map map;
                        Set set = txIds;
                        Optional maybeDatabaseContext = databaseManager.getDatabaseContext(namedDatabaseId);
                        if (maybeDatabaseContext.isPresent()) {
                            String dbName = namedDatabaseId.name();
                            DatabaseContext databaseContext = (DatabaseContext)maybeDatabaseContext.get();
                            AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(dbName);
                            map = ((IterableOnceOps)((IterableOps)TransactionCommandHelper$.MODULE$.getExecutingTransactions(databaseContext).map((Function1 & Serializable)tx -> {
                                TransactionId txIdRepresentation = TransactionId$.MODULE$.apply(dbName, tx.getTransactionSequenceNumber());
                                return new Tuple2((Object)txIdRepresentation, tx);
                            })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TerminateTransactionsCommand.$anonfun$originalNameRows$5(dbScope, securityContext, set, x0$3)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        } else {
                            map = Predef$.MODULE$.Map().empty();
                        }
                        Map allowedTransactions = map;
                        return (Set)set.map((Function1 & Serializable)txId -> {
                            Option txHandle = allowedTransactions.get(txId);
                            Tuple2 tuple2 = (Tuple2)txHandle.map((Function1 & Serializable)x0$4 -> {
                                KernelTransactionHandle kernelTransactionHandle = x0$4;
                                if (kernelTransactionHandle.isClosing()) {
                                    return new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Unable to terminate closing transactions.");
                                }
                                kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated);
                                log.info("User %s terminated transaction %s.", new Object[]{loggingUser, txId.toString()});
                                return new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Transaction terminated.");
                            }).getOrElse((Function0 & Serializable)() -> new Tuple2(null, (Object)"Transaction not found."));
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String username = (String)tuple2._1();
                            String message = (String)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)username, (Object)message);
                            String username2 = (String)tuple22._1();
                            String message2 = (String)tuple22._2();
                            return this.getResultMap((TransactionId)txId, username2, message2);
                        });
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Iterable updatedWithExtraRows = (Iterable)rows.$plus$plus((IterableOnce)otherTxIds2.map((Function1 & Serializable)txId -> this.getResultMap((TransactionId)txId, null, "Transaction not found.")));
        List<Map<String, AnyValue>> updatedColumnNameRows = this.updateRowsWithPotentiallyRenamedColumns((List<Map<String, AnyValue>>)updatedWithExtraRows.toList());
        return ClosingIterator$.MODULE$.apply(updatedColumnNameRows.iterator());
    }

    private Map<String, AnyValue> getResultMap(TransactionId txId, String username, String message) {
        return this.requestedColumnsNames().map((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            String string2 = TerminateTransactionsClause$.MODULE$.transactionIdColumn();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TerminateTransactionsClause$.MODULE$.transactionIdColumn()), (Object)Values.stringValue((String)txId.toString()));
            }
            String string4 = TerminateTransactionsClause$.MODULE$.usernameColumn();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TerminateTransactionsClause$.MODULE$.usernameColumn()), (Object)Values.stringOrNoValue((String)username));
            }
            String string6 = TerminateTransactionsClause$.MODULE$.messageColumn();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TerminateTransactionsClause$.MODULE$.messageColumn()), (Object)Values.stringValue((String)message));
            }
            throw new IllegalStateException("Missing case for column: " + string);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public TerminateTransactionsCommand copy(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return new TerminateTransactionsCommand(givenIds, columns, yieldColumns);
    }

    public Either<List<String>, Expression> copy$default$1() {
        return this.givenIds();
    }

    public List<ShowColumn> copy$default$2() {
        return this.columns();
    }

    public List<CommandResultItem> copy$default$3() {
        return this.yieldColumns();
    }

    public String productPrefix() {
        return "TerminateTransactionsCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.givenIds();
            }
            case 1: {
                return this.columns();
            }
            case 2: {
                return this.yieldColumns();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TerminateTransactionsCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "givenIds";
            }
            case 1: {
                return "columns";
            }
            case 2: {
                return "yieldColumns";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TerminateTransactionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TerminateTransactionsCommand terminateTransactionsCommand = (TerminateTransactionsCommand)x$1;
        Either<List<String>, Expression> either = this.givenIds();
        Either<List<String>, Expression> either2 = terminateTransactionsCommand.givenIds();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        List<ShowColumn> list = this.columns();
        List<ShowColumn> list2 = terminateTransactionsCommand.columns();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<CommandResultItem> list3 = this.yieldColumns();
        List<CommandResultItem> list4 = terminateTransactionsCommand.yieldColumns();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        if (!terminateTransactionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$5(AdminActionOnResource.DatabaseScope dbScope$1, SecurityContext securityContext$1, Set x3$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            AdminActionOnResource action;
            TransactionId txIdRepresentation = (TransactionId)tuple2._1();
            KernelTransactionHandle tx = (KernelTransactionHandle)tuple2._2();
            String username = tx.subject().executingUser();
            return TransactionCommandHelper$.MODULE$.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.TERMINATE_TRANSACTION, dbScope$1, (Segment)new UserSegment(username)), securityContext$1) && x3$1.contains((Object)txIdRepresentation);
        }
        throw new MatchError((Object)tuple2);
    }

    public TerminateTransactionsCommand(Either<List<String>, Expression> givenIds, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        this.givenIds = givenIds;
        this.columns = columns;
        this.yieldColumns = yieldColumns;
        super(columns, yieldColumns);
        Product.$init$((Product)this);
    }
}

