/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.ShowIndexType;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowIndexesCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowSchemaCommandHelper$;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Value;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;

public final class ShowIndexesCommand$
implements Serializable {
    public static final ShowIndexesCommand$ MODULE$ = new ShowIndexesCommand$();

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowIndexesCommand$$createIndexStatement(String name, IndexType indexType, EntityType entityType, List<String> labelsOrTypes, List<String> properties, String providerName, IndexConfig indexConfig, Option<ConstraintDescriptor> maybeConstraint) {
        IndexType indexType2 = indexType;
        if (IndexType.RANGE.equals(indexType2)) {
            ConstraintDescriptor constraint;
            ConstraintDescriptor constraint2;
            ConstraintDescriptor constraint3;
            boolean bl = false;
            Some some = null;
            Option<ConstraintDescriptor> option = maybeConstraint;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                ConstraintDescriptor constraint4 = (ConstraintDescriptor)some.value();
                if (constraint4.isNodeUniquenessConstraint()) {
                    return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
                }
            }
            if (bl && (constraint3 = (ConstraintDescriptor)some.value()).isRelationshipUniquenessConstraint()) {
                return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
            }
            if (bl && (constraint2 = (ConstraintDescriptor)some.value()).isNodeKeyConstraint()) {
                return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS NODE KEY");
            }
            if (bl && (constraint = (ConstraintDescriptor)some.value()).isRelationshipKeyConstraint()) {
                return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS RELATIONSHIP KEY");
            }
            if (bl) {
                throw new IllegalArgumentException("Expected an index or index backed constraint, found another constraint.");
            }
            if (None$.MODULE$.equals(option)) {
                EntityType entityType2 = entityType;
                if (EntityType.NODE.equals(entityType2)) {
                    return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("RANGE", name, labelsOrTypes, properties, ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand$default$5());
                }
                if (EntityType.RELATIONSHIP.equals(entityType2)) {
                    return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("RANGE", name, labelsOrTypes, properties, ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand$default$5());
                }
                throw new IllegalArgumentException("Did not recognize entity type " + entityType);
            }
            throw new MatchError(option);
        }
        if (IndexType.FULLTEXT.equals(indexType2)) {
            String labelsOrTypesWithBars = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.barStringJoiner());
            String fulltextConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable)value -> MODULE$.fullTextConfigValueAsString((Value)value));
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, fulltextConfig);
            EntityType entityType3 = entityType;
            if (EntityType.NODE.equals(entityType3)) {
                String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("FULLTEXT", name, "(n" + labelsOrTypesWithBars + ")", "EACH [" + escapedNodeProperties + "]", (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType3)) {
                String escapedRelProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("FULLTEXT", name, "()-[r" + labelsOrTypesWithBars + "]-()", "EACH [" + escapedRelProperties + "]", (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.TEXT.equals(indexType2)) {
            String optionsString = "{indexConfig: {}, indexProvider: '" + providerName + "'}";
            EntityType entityType4 = entityType;
            if (EntityType.NODE.equals(entityType4)) {
                return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("TEXT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType4)) {
                return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("TEXT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.POINT.equals(indexType2)) {
            String pointConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable)value -> ShowSchemaCommandHelper$.MODULE$.pointConfigValueAsString((Value)value));
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, pointConfig);
            EntityType entityType5 = entityType;
            if (EntityType.NODE.equals(entityType5)) {
                return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("POINT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType5)) {
                return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("POINT", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.VECTOR.equals(indexType2)) {
            String vectorConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable)value -> MODULE$.vectorConfigValueAsString((Value)value));
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, vectorConfig);
            EntityType entityType6 = entityType;
            if (EntityType.NODE.equals(entityType6)) {
                return ShowSchemaCommandHelper$.MODULE$.createNodeIndexCommand("VECTOR", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            if (EntityType.RELATIONSHIP.equals(entityType6)) {
                return ShowSchemaCommandHelper$.MODULE$.createRelIndexCommand("VECTOR", name, labelsOrTypes, properties, (Option<String>)new Some((Object)optionsString));
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.LOOKUP.equals(indexType2)) {
            EntityType entityType7 = entityType;
            if (EntityType.NODE.equals(entityType7)) {
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("LOOKUP", name, "(n)", "EACH labels(n)", ShowSchemaCommandHelper$.MODULE$.createIndexCommand$default$5());
            }
            if (EntityType.RELATIONSHIP.equals(entityType7)) {
                return ShowSchemaCommandHelper$.MODULE$.createIndexCommand("LOOKUP", name, "()-[r]-()", "EACH type(r)", ShowSchemaCommandHelper$.MODULE$.createIndexCommand$default$5());
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        throw new IllegalArgumentException("Did not recognize index type " + indexType);
    }

    private String fullTextConfigValueAsString(Value configValue) {
        Value value = configValue;
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return Boolean.toString(booleanValue.booleanValue());
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return "'" + stringValue.stringValue() + "'";
        }
        throw new IllegalArgumentException("Could not convert config value '" + configValue + "' to config string.");
    }

    private String vectorConfigValueAsString(Value configValue) {
        Value value = configValue;
        if (value instanceof IntValue) {
            IntValue intValue = (IntValue)value;
            return Integer.toString(intValue.intValue());
        }
        if (value instanceof LongValue) {
            LongValue longValue = (LongValue)value;
            return Long.toString(longValue.longValue());
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return "'" + stringValue.stringValue() + "'";
        }
        throw new IllegalArgumentException("Could not convert config value '" + configValue + "' to config string.");
    }

    public ShowIndexesCommand apply(ShowIndexType indexType, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return new ShowIndexesCommand(indexType, columns, yieldColumns);
    }

    public Option<Tuple3<ShowIndexType, List<ShowColumn>, List<CommandResultItem>>> unapply(ShowIndexesCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.indexType(), x$0.columns(), x$0.yieldColumns()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShowIndexesCommand$.class);
    }

    private ShowIndexesCommand$() {
    }
}

