/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.NodeExistsConstraints;
import org.neo4j.cypher.internal.ast.NodeExistsConstraints$;
import org.neo4j.cypher.internal.ast.NodeKeyConstraints$;
import org.neo4j.cypher.internal.ast.NodePropTypeConstraints$;
import org.neo4j.cypher.internal.ast.NodeUniqueConstraints$;
import org.neo4j.cypher.internal.ast.RelExistsConstraints;
import org.neo4j.cypher.internal.ast.RelExistsConstraints$;
import org.neo4j.cypher.internal.ast.RelKeyConstraints$;
import org.neo4j.cypher.internal.ast.RelPropTypeConstraints$;
import org.neo4j.cypher.internal.ast.RelUniqueConstraints$;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.ShowConstraintType;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowConstraintsCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowSchemaCommandHelper$;
import org.neo4j.internal.schema.ConstraintType;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;

public final class ShowConstraintsCommand$
implements Serializable {
    public static final ShowConstraintsCommand$ MODULE$ = new ShowConstraintsCommand$();

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$createConstraintStatement(String name, ShowConstraintType constraintType, List<String> labelsOrTypes, List<String> properties, Option<String> propertyType) {
        ShowConstraintType showConstraintType = constraintType;
        if (NodeUniqueConstraints$.MODULE$.equals(showConstraintType)) {
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
        }
        if (RelUniqueConstraints$.MODULE$.equals(showConstraintType)) {
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS UNIQUE");
        }
        if (NodeKeyConstraints$.MODULE$.equals(showConstraintType)) {
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS NODE KEY");
        }
        if (RelKeyConstraints$.MODULE$.equals(showConstraintType)) {
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS RELATIONSHIP KEY");
        }
        if (showConstraintType instanceof NodeExistsConstraints) {
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS NOT NULL");
        }
        if (showConstraintType instanceof RelExistsConstraints) {
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS NOT NULL");
        }
        if (NodePropTypeConstraints$.MODULE$.equals(showConstraintType)) {
            String typeString = (String)propertyType.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Expected a property type for " + constraintType + " constraint.");
            });
            return ShowSchemaCommandHelper$.MODULE$.createNodeConstraintCommand(name, labelsOrTypes, properties, "IS :: " + typeString);
        }
        if (RelPropTypeConstraints$.MODULE$.equals(showConstraintType)) {
            String typeString = (String)propertyType.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("Expected a property type for " + constraintType + " constraint.");
            });
            return ShowSchemaCommandHelper$.MODULE$.createRelConstraintCommand(name, labelsOrTypes, properties, "IS :: " + typeString);
        }
        throw new IllegalArgumentException("Did not expect constraint type " + constraintType.prettyPrint() + " for constraint create command.");
    }

    public ShowConstraintType org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowConstraintsCommand$$getConstraintType(ConstraintType internalConstraintType, EntityType entityType) {
        Tuple2 tuple2 = new Tuple2((Object)internalConstraintType, (Object)entityType);
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType2 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE.equals(constraintType) && EntityType.NODE.equals(entityType2)) {
                return NodeUniqueConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType3 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType3)) {
                return RelUniqueConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType4 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType4)) {
                return NodeKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType5 = (EntityType)tuple2._2();
            if (ConstraintType.UNIQUE_EXISTS.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType5)) {
                return RelKeyConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType6 = (EntityType)tuple2._2();
            if (ConstraintType.EXISTS.equals(constraintType) && EntityType.NODE.equals(entityType6)) {
                return new NodeExistsConstraints(NodeExistsConstraints$.MODULE$.apply$default$1());
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType7 = (EntityType)tuple2._2();
            if (ConstraintType.EXISTS.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType7)) {
                return new RelExistsConstraints(RelExistsConstraints$.MODULE$.apply$default$1());
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType8 = (EntityType)tuple2._2();
            if (ConstraintType.PROPERTY_TYPE.equals(constraintType) && EntityType.NODE.equals(entityType8)) {
                return NodePropTypeConstraints$.MODULE$;
            }
        }
        if (tuple2 != null) {
            ConstraintType constraintType = (ConstraintType)tuple2._1();
            EntityType entityType9 = (EntityType)tuple2._2();
            if (ConstraintType.PROPERTY_TYPE.equals(constraintType) && EntityType.RELATIONSHIP.equals(entityType9)) {
                return RelPropTypeConstraints$.MODULE$;
            }
        }
        throw new IllegalStateException("Invalid constraint combination: ConstraintType " + internalConstraintType + " and EntityType " + entityType + ".");
    }

    public ShowConstraintsCommand apply(ShowConstraintType constraintType, List<ShowColumn> columns, List<CommandResultItem> yieldColumns) {
        return new ShowConstraintsCommand(constraintType, columns, yieldColumns);
    }

    public Option<Tuple3<ShowConstraintType, List<ShowColumn>, List<CommandResultItem>>> unapply(ShowConstraintsCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.constraintType(), x$0.columns(), x$0.yieldColumns()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShowConstraintsCommand$.class);
    }

    private ShowConstraintsCommand$() {
    }
}

