/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import java.util.function.Consumer;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.RelationshipVisitor;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001B\r\u001b\u0005-B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019y\u0006\u0001)A\u0005%\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00024\u0001A\u0003%!\rC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\u000f5\u0004\u0001\u0019!C\u0005]\"1A\u000f\u0001Q!\n%DQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\u0002qDQ! \u0001\u0005\u0002yDQa \u0001\u0005\u0002qDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\u0012!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011Q\t\u0001\u0005\n\u0005\u001d#\u0001\u0005)bi\"4\u0016\r\\;f\u0005VLG\u000eZ3s\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0010!\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005\u0005\u0012\u0013a\u0002:v]RLW.\u001a\u0006\u0003G\u0011\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003K\u0019\naaY=qQ\u0016\u0014(BA\u0014)\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0013aA8sO\u000e\u00011c\u0001\u0001-iA\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0005Y\u0006twMC\u00012\u0003\u0011Q\u0017M^1\n\u0005Mr#AB(cU\u0016\u001cG\u000fE\u00026uqj\u0011A\u000e\u0006\u0003oa\n\u0001BZ;oGRLwN\u001c\u0006\u0003sA\nA!\u001e;jY&\u00111H\u000e\u0002\t\u0007>t7/^7feB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\bm&\u0014H/^1m\u0015\t\te%\u0001\u0004wC2,Xm]\u0005\u0003\u0007z\u00121CU3mCRLwN\\:iSB4\u0016n]5u_J\fQa\u001d;bi\u0016\u0004\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0010\u0002\u000bAL\u0007/Z:\n\u0005);%AC)vKJL8\u000b^1uK\u00061A(\u001b8jiz\"\"!T(\u0011\u00059\u0003Q\"\u0001\u000e\t\u000b\u0011\u0013\u0001\u0019A#\u0002\u000b9|G-Z:\u0016\u0003I\u00032a\u0015.]\u001b\u0005!&BA+W\u0003\u001diW\u000f^1cY\u0016T!a\u0016-\u0002\u0015\r|G\u000e\\3di&|gNC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tYFKA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA\u001f^\u0013\tqfH\u0001\tWSJ$X/\u00197O_\u0012,g+\u00197vK\u00061an\u001c3fg\u0002\nAA]3mgV\t!\rE\u0002T5\u000e\u0004\"!\u00103\n\u0005\u0015t$\u0001\u0007,jeR,\u0018\r\u001c*fY\u0006$\u0018n\u001c8tQ&\u0004h+\u00197vK\u0006)!/\u001a7tA\u00051a.\u001e7mK\u0012,\u0012!\u001b\t\u0003U.l\u0011\u0001W\u0005\u0003Yb\u0013qAQ8pY\u0016\fg.\u0001\u0006ok2dW\rZ0%KF$\"a\u001c:\u0011\u0005)\u0004\u0018BA9Y\u0005\u0011)f.\u001b;\t\u000fMD\u0011\u0011!a\u0001S\u0006\u0019\u0001\u0010J\u0019\u0002\u000f9,H\u000e\\3eA\u00051!/Z:vYR$\u0012a\u001e\t\u0003qfl\u0011\u0001Q\u0005\u0003u\u0002\u0013\u0001\"\u00118z-\u0006dW/Z\u0001\u0006G2,\u0017M\u001d\u000b\u0002\u001b\u0006a\u0001O]3wS>,8OT8eKV\tA,\u0001\u0006bI\u0012tuNV1mk\u0016\fq!\u00193e\u001d>$W\rF\u0002N\u0003\u000bAa!a\u0002\u000f\u0001\u00049\u0018A\u00038pI\u0016|%OT;mY\u0006y\u0011\r\u001a3SK2\fG/[8og\"L\u0007\u000fF\u0002N\u0003\u001bAa!a\u0004\u0010\u0001\u00049\u0018!\u0003:fY>\u0013h*\u001e7m)\ri\u00151\u0003\u0005\u0007\u0003+\u0001\u0002\u0019A2\u0002\u0007I,G.A\fbI\u0012LenY8nS:<'+\u001a7bi&|gn\u001d5jaR\u0019Q*a\u0007\t\r\u0005=\u0011\u00031\u0001x\u0003]\tG\rZ(vi\u001e|\u0017N\\4SK2\fG/[8og\"L\u0007\u000fF\u0002N\u0003CAa!a\u0004\u0013\u0001\u00049\u0018!G1eIVsG-\u001b:fGR,GMU3mCRLwN\\:iSB$2!TA\u0014\u0011\u0019\tya\u0005a\u0001o\u0006A\u0012\r\u001a3J]\u000e|W.\u001b8h%\u0016d\u0017\r^5p]ND\u0017\u000e]:\u0015\u00075\u000bi\u0003\u0003\u0004\u00020Q\u0001\ra^\u0001\u000be\u0016d7o\u0014:Ok2d\u0017\u0001G1eI>+HoZ8j]\u001e\u0014V\r\\1uS>t7\u000f[5qgR\u0019Q*!\u000e\t\r\u0005=R\u00031\u0001x\u0003i\tG\rZ+oI&\u0014Xm\u0019;fIJ+G.\u0019;j_:\u001c\b.\u001b9t)\ri\u00151\b\u0005\u0007\u0003_1\u0002\u0019A<\u0002\r\u0005\u001c7-\u001a9u)\ry\u0017\u0011\t\u0005\u0007\u0003\u0007:\u0002\u0019\u0001\u001f\u0002\u0003Q\f\u0011B\\;mY\u000eCWmY6\u0016\t\u0005%\u0013q\f\u000b\u0005\u0003\u0017\n9\u0006F\u0002N\u0003\u001bB\u0001\"a\u0014\u0019\t\u0003\u0007\u0011\u0011K\u0001\u0002MB!!.a\u0015N\u0013\r\t)\u0006\u0017\u0002\ty\tLh.Y7f}!9\u0011\u0011\f\rA\u0002\u0005m\u0013!\u0002<bYV,\u0007\u0003BA/\u0003?b\u0001\u0001B\u0004\u0002ba\u0011\r!a\u0019\u0003\u0003\u0005\u000bB!!\u001a\u0002lA\u0019!.a\u001a\n\u0007\u0005%\u0004LA\u0004O_RD\u0017N\\4\u0011\u0007)\fi'C\u0002\u0002pa\u0013a!\u00118z%\u00164\u0007")
public final class PathValueBuilder
implements Consumer<RelationshipVisitor> {
    private final QueryState state;
    private final ArrayBuffer<VirtualNodeValue> nodes;
    private final ArrayBuffer<VirtualRelationshipValue> rels;
    private boolean nulled;

    @Override
    public Consumer<RelationshipVisitor> andThen(Consumer<? super RelationshipVisitor> x$1) {
        return Consumer.super.andThen(x$1);
    }

    private ArrayBuffer<VirtualNodeValue> nodes() {
        return this.nodes;
    }

    private ArrayBuffer<VirtualRelationshipValue> rels() {
        return this.rels;
    }

    private boolean nulled() {
        return this.nulled;
    }

    private void nulled_$eq(boolean x$1) {
        this.nulled = x$1;
    }

    public AnyValue result() {
        if (this.nulled()) {
            return Values.NO_VALUE;
        }
        return VirtualValues.pathReference((VirtualNodeValue[])((VirtualNodeValue[])this.nodes().toArray(ClassTag$.MODULE$.apply(VirtualNodeValue.class))), (VirtualRelationshipValue[])((VirtualRelationshipValue[])this.rels().toArray(ClassTag$.MODULE$.apply(VirtualRelationshipValue.class))));
    }

    public PathValueBuilder clear() {
        this.nodes().clear();
        this.rels().clear();
        this.nulled_$eq(false);
        return this;
    }

    public VirtualNodeValue previousNode() {
        return (VirtualNodeValue)this.nodes().last();
    }

    public PathValueBuilder addNoValue() {
        this.nulled_$eq(true);
        return this;
    }

    public PathValueBuilder addNode(AnyValue nodeOrNull) {
        return this.nullCheck(nodeOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualNodeValue node = (VirtualNodeValue)nodeOrNull;
            this.nodes().append((Object)node);
            return this;
        });
    }

    public PathValueBuilder addRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> this.addRelationship((VirtualRelationshipValue)relOrNull));
    }

    public PathValueBuilder addRelationship(VirtualRelationshipValue rel) {
        this.rels().append((Object)rel);
        return this;
    }

    public PathValueBuilder addIncomingRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            this.rels().append((Object)rel);
            this.nodes().append((Object)VirtualValues.node((long)rel.startNodeId((Consumer)this)));
            return this;
        });
    }

    public PathValueBuilder addOutgoingRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            this.rels().append((Object)rel);
            this.nodes().append((Object)VirtualValues.node((long)rel.endNodeId((Consumer)this)));
            return this;
        });
    }

    public PathValueBuilder addUndirectedRelationship(AnyValue relOrNull) {
        return this.nullCheck(relOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            VirtualRelationshipValue rel = (VirtualRelationshipValue)relOrNull;
            long start = rel.startNodeId((Consumer)this);
            if (start == this.previousNode().id()) {
                return this.addOutgoingRelationship((AnyValue)rel);
            }
            return this.addIncomingRelationship((AnyValue)rel);
        });
    }

    public PathValueBuilder addIncomingRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            ListValue relsToAdd = (ListValue)relsOrNull;
            java.util.Iterator iterator = relsToAdd.iterator();
            while (iterator.hasNext()) {
                this.addIncomingRelationship((AnyValue)((VirtualRelationshipValue)iterator.next()));
            }
            return this;
        });
    }

    public PathValueBuilder addOutgoingRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            ListValue relsToAdd = (ListValue)relsOrNull;
            java.util.Iterator iterator = relsToAdd.iterator();
            while (iterator.hasNext()) {
                this.addOutgoingRelationship((AnyValue)((VirtualRelationshipValue)iterator.next()));
            }
            return this;
        });
    }

    public PathValueBuilder addUndirectedRelationships(AnyValue relsOrNull) {
        return this.nullCheck(relsOrNull, (Function0<PathValueBuilder>)(Function0 & Serializable)() -> {
            block0: {
                ListValue relsToAdd = (ListValue)relsOrNull;
                java.util.Iterator relIterator = relsToAdd.iterator();
                if (!relIterator.hasNext()) break block0;
                VirtualRelationshipValue first = (VirtualRelationshipValue)relIterator.next();
                this.addUndirectedRelationship((AnyValue)first);
                this.consumeIterator$1(CollectionConverters$.MODULE$.IteratorHasAsScala(relIterator).asScala());
            }
            return this;
        });
    }

    @Override
    public void accept(RelationshipVisitor t) {
        RelationshipScanCursor cursor = this.state.cursors().relationshipScanCursor();
        this.state.query().singleRelationship(t.id(), cursor);
        cursor.next();
        t.visit(cursor.sourceNodeReference(), cursor.targetNodeReference(), cursor.type());
    }

    private <A> PathValueBuilder nullCheck(A value, Function0<PathValueBuilder> f) {
        A a = value;
        if (a == null || Values.NO_VALUE == a) {
            this.nulled_$eq(true);
            return this;
        }
        return (PathValueBuilder)f.apply();
    }

    private final void consumeIterator$1(Iterator i) {
        while (i.hasNext()) {
            this.addUndirectedRelationship((AnyValue)((VirtualRelationshipValue)i.next()));
        }
    }

    public PathValueBuilder(QueryState state) {
        this.state = state;
        this.nodes = ArrayBuffer$.MODULE$.empty();
        this.rels = ArrayBuffer$.MODULE$.empty();
        this.nulled = false;
    }
}

