/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.load_csv;

import java.io.Serializable;
import java.net.URL;
import org.neo4j.cypher.internal.runtime.ExpressionCursors;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ResourceManagedCursorPool;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.LoadCsvIteratorWithPeriodicCommit;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.UpdateCounter;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.internal.kernel.api.Cursor;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\b\u0010\u0001yA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005K!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00036\u0001\u0011\u0005a\u0007C\u0004=\u0001\t\u0007I\u0011A\u001f\t\r\u0005\u0003\u0001\u0015!\u0003?\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCqA\u0013\u0001A\u0002\u0013\u00051\n\u0003\u0004R\u0001\u0001\u0006K\u0001\u0012\u0005\u0006%\u0002!\te\u0015\u0005\bw\u0002\t\n\u0011\"\u0001}\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!a\u0005\u0001\t\u0013\t\tBA\u000fM_\u0006$7i\u001d<QKJLw\u000eZ5d\u0007>lW.\u001b;PEN,'O^3s\u0015\t\u0001\u0012#\u0001\u0005m_\u0006$wlY:w\u0015\t\u00112#A\u0006j]R,'\u000f\u001d:fi\u0016$'B\u0001\u000b\u0016\u0003\u001d\u0011XO\u001c;j[\u0016T!AF\f\u0002\u0011%tG/\u001a:oC2T!\u0001G\r\u0002\r\rL\b\u000f[3s\u0015\tQ2$A\u0003oK>$$NC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\n\u0012!\u00029ja\u0016\u001c\u0018B\u0001\u0016(\u0005M)\u0005\u0010^3s]\u0006d7i\u0015,SKN|WO]2f\u00035\u0011\u0017\r^2i%><8i\\;oiB\u0011\u0001%L\u0005\u0003]\u0005\u0012A\u0001T8oO\u0006I!/Z:pkJ\u001cWm]\u0001\rcV,'/_\"p]R,\u0007\u0010\u001e\t\u0003eMj\u0011aE\u0005\u0003iM\u0011A\"U;fef\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003B\u001c:um\u0002\"\u0001\u000f\u0001\u000e\u0003=AQa\u000b\u0003A\u00021BQa\f\u0003A\u0002\u0015BQ\u0001\r\u0003A\u0002E\nQ\"\u001e9eCR,7i\\;oi\u0016\u0014X#\u0001 \u0011\u0005az\u0014B\u0001!\u0010\u00055)\u0006\u000fZ1uK\u000e{WO\u001c;fe\u0006qQ\u000f\u001d3bi\u0016\u001cu.\u001e8uKJ\u0004\u0013\u0001F8vi\u0016\u0014Hj\\1e\u0007N3\u0016\n^3sCR|'/F\u0001E!\r\u0001SiR\u0005\u0003\r\u0006\u0012aa\u00149uS>t\u0007C\u0001\u001dI\u0013\tIuBA\u0011M_\u0006$7i\u001d<Ji\u0016\u0014\u0018\r^8s/&$\b\u000eU3sS>$\u0017nY\"p[6LG/\u0001\rpkR,'\u000fT8bI\u000e\u001bf+\u0013;fe\u0006$xN]0%KF$\"\u0001T(\u0011\u0005\u0001j\u0015B\u0001(\"\u0005\u0011)f.\u001b;\t\u000fAC\u0011\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002+=,H/\u001a:M_\u0006$7i\u0015,Ji\u0016\u0014\u0018\r^8sA\u0005qq-\u001a;DgZLE/\u001a:bi>\u0014HC\u0002+XC>$\u0018\u0010\u0005\u0002'+&\u0011ak\n\u0002\u0010\u0019>\fGmQ:w\u0013R,'/\u0019;pe\")\u0001L\u0003a\u00013\u0006\u0019QO\u001d7\u0011\u0005i{V\"A.\u000b\u0005qk\u0016a\u00018fi*\ta,\u0001\u0003kCZ\f\u0017B\u00011\\\u0005\r)&\u000b\u0014\u0005\u0006E*\u0001\raY\u0001\u0010M&,G\u000e\u001a+fe6Lg.\u0019;peB\u0019\u0001%\u00123\u0011\u0005\u0015dgB\u00014k!\t9\u0017%D\u0001i\u0015\tIW$\u0001\u0004=e>|GOP\u0005\u0003W\u0006\na\u0001\u0015:fI\u00164\u0017BA7o\u0005\u0019\u0019FO]5oO*\u00111.\t\u0005\u0006a*\u0001\r!]\u0001\u0017Y\u0016<\u0017mY=DgZ\fVo\u001c;f\u000bN\u001c\u0017\r]5oOB\u0011\u0001E]\u0005\u0003g\u0006\u0012qAQ8pY\u0016\fg\u000eC\u0003v\u0015\u0001\u0007a/\u0001\u0006ck\u001a4WM]*ju\u0016\u0004\"\u0001I<\n\u0005a\f#aA%oi\"9!P\u0003I\u0001\u0002\u0004\t\u0018a\u00025fC\u0012,'o]\u0001\u0019O\u0016$8i\u001d<Ji\u0016\u0014\u0018\r^8sI\u0011,g-Y;mi\u0012*T#A?+\u0005Et8&A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013\t\u0013AC1o]>$\u0018\r^5p]&!\u0011QBA\u0002\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0007_:tU\r\u001f;\u0015\u00031\u000b!cY8n[&$\u0018I\u001c3SKN$\u0018M\u001d;Uq\u0002")
public class LoadCsvPeriodicCommitObserver
implements ExternalCSVResource {
    private final long batchRowCount;
    private final ExternalCSVResource resources;
    private final QueryContext queryContext;
    private final UpdateCounter updateCounter;
    private Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator;

    public UpdateCounter updateCounter() {
        return this.updateCounter;
    }

    public Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator() {
        return this.outerLoadCSVIterator;
    }

    public void outerLoadCSVIterator_$eq(Option<LoadCsvIteratorWithPeriodicCommit> x$1) {
        this.outerLoadCSVIterator = x$1;
    }

    @Override
    public LoadCsvIterator getCsvIterator(URL url, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        LoadCsvIterator loadCsvIterator;
        LoadCsvIterator innerIterator = this.resources.getCsvIterator(url, fieldTerminator, legacyCsvQuoteEscaping, bufferSize, headers);
        if (this.outerLoadCSVIterator().isEmpty()) {
            if (headers) {
                this.updateCounter().offsetForHeaders();
            }
            LoadCsvIteratorWithPeriodicCommit iterator = new LoadCsvIteratorWithPeriodicCommit(innerIterator, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.onNext());
            this.outerLoadCSVIterator_$eq((Option<LoadCsvIteratorWithPeriodicCommit>)new Some((Object)iterator));
            loadCsvIterator = iterator;
        } else {
            loadCsvIterator = innerIterator;
        }
        return loadCsvIterator;
    }

    @Override
    public boolean getCsvIterator$default$5() {
        return false;
    }

    private void onNext() {
        this.updateCounter().resetIfPastLimit(this.batchRowCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.commitAndRestartTx());
        this.updateCounter().$plus$eq(1L);
    }

    private void commitAndRestartTx() {
        ArrayBuffer trackedResources = new ArrayBuffer();
        this.queryContext.resources().allResources().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            AutoCloseablePlus autoCloseablePlus = x0$1;
            if (autoCloseablePlus instanceof Cursor) {
                Cursor cursor = (Cursor)autoCloseablePlus;
                cursor.closeInternal();
                boxedUnit = BoxedUnit.UNIT;
            } else if (autoCloseablePlus instanceof ExpressionCursors) {
                ExpressionCursors expressionCursors = (ExpressionCursors)autoCloseablePlus;
                expressionCursors.closeInternal();
                boxedUnit = BoxedUnit.UNIT;
            } else if (autoCloseablePlus instanceof ResourceManagedCursorPool) {
                AutoCloseablePlus autoCloseablePlus2 = autoCloseablePlus;
                ((ResourceManagedCursorPool)autoCloseablePlus2).closeCursors();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = trackedResources.$plus$eq((Object)autoCloseablePlus);
            }
            return boxedUnit;
        });
        ResourceManager resourceManager = this.queryContext.resources();
        trackedResources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            resourceManager.untrace(resource);
            return BoxedUnit.UNIT;
        });
        this.queryContext.transactionalContext().commitAndRestartTx();
        ResourceManager resourceManager2 = this.queryContext.resources();
        trackedResources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            resourceManager2.trace(resource);
            return BoxedUnit.UNIT;
        });
        this.outerLoadCSVIterator().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.notifyCommit();
            return BoxedUnit.UNIT;
        });
    }

    public LoadCsvPeriodicCommitObserver(long batchRowCount, ExternalCSVResource resources, QueryContext queryContext) {
        this.batchRowCount = batchRowCount;
        this.resources = resources;
        this.queryContext = queryContext;
        this.updateCounter = new UpdateCounter();
        this.outerLoadCSVIterator = None$.MODULE$;
    }
}

