/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.util.Comparator;
import org.neo4j.cypher.internal.collection.DefaultComparatorTopTable;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NumericHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TopNPipe$;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.NumberValue;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001\u0002\u0011\"\u0001BB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005O\u0001\tE\t\u0015!\u0003G\u0011!y\u0005A!f\u0001\n\u0003\u0001\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011B)\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006a\u0002!\t&\u001d\u0005\t\u007f\u0002\t\t\u0011\"\u0001\u0002\u0002!I\u0011Q\u0002\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003K\u0001\u0011\u0013!C\u0001\u0003OA\u0011\"a\u000b\u0001#\u0003%\t!!\f\t\u0013\u0005E\u0002!!A\u0005B\u0005M\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\tY\u0005AA\u0001\n\u0003\ti\u0005C\u0005\u0002Z\u0001\t\t\u0011\"\u0011\u0002\\!I\u0011\u0011\u000e\u0001\u0002\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003k\u0002\u0011\u0011!C!\u0003oB\u0011\"!\u001f\u0001\u0003\u0003%\t%a\u001f\t\u0013\u0005u\u0004!!A\u0005B\u0005}t!CABC\u0005\u0005\t\u0012AAC\r!\u0001\u0013%!A\t\u0002\u0005\u001d\u0005B\u00025\u0019\t\u0003\ty\tC\u0005\u0002za\t\t\u0011\"\u0012\u0002|!I\u0011\u0011\u0013\r\u0002\u0002\u0013\u0005\u00151\u0013\u0005\n\u0003?C\u0012\u0013!C\u0001\u0003CC\u0011\"a+\u0019\u0003\u0003%\t)!,\t\u0013\u0005}\u0006$%A\u0005\u0002\u0005\u0005\u0007\"CAe1\u0005\u0005I\u0011BAf\u0005!!v\u000e\u001d(QSB,'B\u0001\u0012$\u0003\u0015\u0001\u0018\u000e]3t\u0015\t!S%A\u0006j]R,'\u000f\u001d:fi\u0016$'B\u0001\u0014(\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001K\u0015\u0002\u0011%tG/\u001a:oC2T!AK\u0016\u0002\r\rL\b\u000f[3s\u0015\taS&A\u0003oK>$$NC\u0001/\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011'N\u001e\u0011\u0005I\u001aT\"A\u0011\n\u0005Q\n#A\u0004)ja\u0016<\u0016\u000e\u001e5T_V\u00148-\u001a\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\t1D(\u0003\u0002>o\ta1+\u001a:jC2L'0\u00192mK\u000611o\\;sG\u0016,\u0012\u0001\u0011\t\u0003e\u0005K!AQ\u0011\u0003\tAK\u0007/Z\u0001\bg>,(oY3!\u0003=\u0019w.\u001e8u\u000bb\u0004(/Z:tS>tW#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015aC3yaJ,7o]5p]NT!aS\u0012\u0002\u0011\r|W.\\1oINL!!\u0014%\u0003\u0015\u0015C\bO]3tg&|g.\u0001\td_VtG/\u0012=qe\u0016\u001c8/[8oA\u0005Q1m\\7qCJ\fGo\u001c:\u0016\u0003E\u00032AU,Z\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\bC\u0001.\\\u001b\u0005)\u0013B\u0001/&\u0005-\u0011V-\u00193bE2,'k\\<\u0002\u0017\r|W\u000e]1sCR|'\u000fI\u0001\u0003S\u0012,\u0012\u0001\u0019\t\u0003C\u0016l\u0011A\u0019\u0006\u0003G\u0012\f1\"\u0019;ue&\u0014W\u000f^5p]*\u0011AkJ\u0005\u0003M\n\u0014!!\u00133\u0002\u0007%$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005U6tw\u000e\u0006\u0002lYB\u0011!\u0007\u0001\u0005\b=&\u0001\n\u00111\u0001a\u0011\u0015q\u0014\u00021\u0001A\u0011\u0015!\u0015\u00021\u0001G\u0011\u0015y\u0015\u00021\u0001R\u0003UIg\u000e^3s]\u0006d7I]3bi\u0016\u0014Vm];miN$2A\u001d={!\rQ6/^\u0005\u0003i\u0016\u0012qb\u00117pg&tw-\u0013;fe\u0006$xN\u001d\t\u00035ZL!a^\u0013\u0003\u0013\rK\b\u000f[3s%><\b\"B=\u000b\u0001\u0004\u0011\u0018!B5oaV$\b\"B>\u000b\u0001\u0004a\u0018!B:uCR,\u0007C\u0001\u001a~\u0013\tq\u0018E\u0001\u0006Rk\u0016\u0014\u0018p\u0015;bi\u0016\fAaY8qsRA\u00111AA\u0004\u0003\u0013\tY\u0001F\u0002l\u0003\u000bAQAX\u0006A\u0002\u0001DqAP\u0006\u0011\u0002\u0003\u0007\u0001\tC\u0004E\u0017A\u0005\t\u0019\u0001$\t\u000f=[\u0001\u0013!a\u0001#\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\tU\r\u0001\u00151C\u0016\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0005v]\u000eDWmY6fI*\u0019\u0011qD\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0005e!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0015U\r1\u00151C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyCK\u0002R\u0003'\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e+\u0006!A.\u00198h\u0013\u0011\ty$!\u000f\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0005E\u00027\u0003\u000fJ1!!\u00138\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty%!\u0016\u0011\u0007Y\n\t&C\u0002\u0002T]\u00121!\u00118z\u0011%\t9&EA\u0001\u0002\u0004\t)%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003;\u0002b!a\u0018\u0002f\u0005=SBAA1\u0015\r\t\u0019gN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA4\u0003C\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QNA:!\r1\u0014qN\u0005\u0004\u0003c:$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003/\u001a\u0012\u0011!a\u0001\u0003\u001f\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003k\ta!Z9vC2\u001cH\u0003BA7\u0003\u0003C\u0011\"a\u0016\u0017\u0003\u0003\u0005\r!a\u0014\u0002\u0011Q{\u0007O\u0014)ja\u0016\u0004\"A\r\r\u0014\ta\tIi\u000f\t\u0004m\u0005-\u0015bAAGo\t1\u0011I\\=SK\u001a$\"!!\"\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005U\u0015\u0011TAN\u0003;#2a[AL\u0011\u001dq6\u0004%AA\u0002\u0001DQAP\u000eA\u0002\u0001CQ\u0001R\u000eA\u0002\u0019CQaT\u000eA\u0002E\u000bq\"\u00199qYf$C-\u001a4bk2$H\u0005\u000e\u000b\t\u0003G\u000b)+a*\u0002**\u001a\u0001-a\u0005\t\u000byb\u0002\u0019\u0001!\t\u000b\u0011c\u0002\u0019\u0001$\t\u000b=c\u0002\u0019A)\u0002\u000fUt\u0017\r\u001d9msR!\u0011qVA^!\u00151\u0014\u0011WA[\u0013\r\t\u0019l\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rY\n9\f\u0011$R\u0013\r\tIl\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005uV$!AA\u0002-\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iQA\u00111UAb\u0003\u000b\f9\rC\u0003?=\u0001\u0007\u0001\tC\u0003E=\u0001\u0007a\tC\u0003P=\u0001\u0007\u0011+A\u0006sK\u0006$'+Z:pYZ,GCAAg!\u0011\t9$a4\n\t\u0005E\u0017\u0011\b\u0002\u0007\u001f\nTWm\u0019;")
public class TopNPipe
extends PipeWithSource
implements Product,
Serializable {
    private final Pipe source;
    private final Expression countExpression;
    private final Comparator<ReadableRow> comparator;
    private final int id;

    public static int $lessinit$greater$default$4(Pipe pipe, Expression expression, Comparator comparator) {
        return TopNPipe$.MODULE$.$lessinit$greater$default$4(pipe, expression, comparator);
    }

    public static Option<Tuple3<Pipe, Expression, Comparator<ReadableRow>>> unapply(TopNPipe topNPipe) {
        return TopNPipe$.MODULE$.unapply(topNPipe);
    }

    public static int apply$default$4(Pipe pipe, Expression expression, Comparator comparator) {
        return TopNPipe$.MODULE$.apply$default$4(pipe, expression, comparator);
    }

    public static TopNPipe apply(Pipe pipe, Expression expression, Comparator<ReadableRow> comparator, int n) {
        return TopNPipe$.MODULE$.apply(pipe, expression, comparator, n);
    }

    public Pipe source() {
        return this.source;
    }

    public Expression countExpression() {
        return this.countExpression;
    }

    public Comparator<ReadableRow> comparator() {
        return this.comparator;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        NumberValue limitNumber = NumericHelper$.MODULE$.evaluateStaticallyKnownNumber(this.countExpression(), state);
        if (limitNumber instanceof FloatingPointValue) {
            double limit = limitNumber.doubleValue();
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        long limit = limitNumber.longValue();
        if (limit < 0L) {
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        if (limit == 0L || input.isEmpty()) {
            return ClosingIterator$.MODULE$.empty();
        }
        MemoryTracker scopedMemoryTracker = state.memoryTracker().memoryTrackerForOperator(this.id()).getScopedMemoryTracker();
        DefaultComparatorTopTable topTable = new DefaultComparatorTopTable(this.comparator(), limit, scopedMemoryTracker);
        state.query().resources().trace((AutoCloseablePlus)topTable);
        long i = 1L;
        while (input.hasNext()) {
            CypherRow evictedRow;
            CypherRow row = (CypherRow)input.next();
            if (row != (evictedRow = (CypherRow)topTable.addAndGetEvicted((Object)row))) {
                scopedMemoryTracker.allocateHeap(row.estimatedHeapUsage());
                if (evictedRow != null) {
                    scopedMemoryTracker.releaseHeap(evictedRow.estimatedHeapUsage());
                }
            }
            ++i;
        }
        topTable.sort();
        return ClosingIterator$.MODULE$.apply((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(topTable.autoClosingIterator((AutoCloseable)scopedMemoryTracker)).asScala()).closing((AutoCloseable)topTable);
    }

    public TopNPipe copy(Pipe source, Expression countExpression, Comparator<ReadableRow> comparator, int id) {
        return new TopNPipe(source, countExpression, comparator, id);
    }

    public Pipe copy$default$1() {
        return this.source();
    }

    public Expression copy$default$2() {
        return this.countExpression();
    }

    public Comparator<ReadableRow> copy$default$3() {
        return this.comparator();
    }

    public String productPrefix() {
        return "TopNPipe";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Comparator<ReadableRow> comparator;
        int n = x$1;
        switch (n) {
            case 0: {
                comparator = this.source();
                break;
            }
            case 1: {
                comparator = this.countExpression();
                break;
            }
            case 2: {
                comparator = this.comparator();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return comparator;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopNPipe;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopNPipe)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopNPipe topNPipe = (TopNPipe)x$1;
        Pipe pipe = this.source();
        Pipe pipe2 = topNPipe.source();
        if (pipe == null) {
            if (pipe2 != null) {
                return false;
            }
        } else if (!pipe.equals(pipe2)) return false;
        Expression expression = this.countExpression();
        Expression expression2 = topNPipe.countExpression();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Comparator<ReadableRow> comparator = this.comparator();
        Comparator<ReadableRow> comparator2 = topNPipe.comparator();
        if (comparator == null) {
            if (comparator2 != null) {
                return false;
            }
        } else if (!((Object)comparator).equals(comparator2)) return false;
        if (!topNPipe.canEqual(this)) return false;
        return true;
    }

    public TopNPipe(Pipe source, Expression countExpression, Comparator<ReadableRow> comparator, int id) {
        this.source = source;
        this.countExpression = countExpression;
        this.comparator = comparator;
        this.id = id;
        super(source);
        Product.$init$((Product)this);
    }
}

