/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.profiler;

import java.io.Serializable;
import org.neo4j.common.Edition;
import org.neo4j.cypher.internal.profiling.KernelStatisticProvider;
import org.neo4j.cypher.internal.runtime.ExecutionContext;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeDecorator;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.InterpretedProfileInformation;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.PageCacheStats;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.ProfilingIterator;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.ProfilingPipeQueryContext;
import org.neo4j.cypher.internal.v4_0.util.AssertionRunner;
import org.neo4j.cypher.internal.v4_0.util.attribution.Id;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001E\u0011\u0001\u0002\u0015:pM&dWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pM&dWM\u001d\u0006\u0003\u000b\u0019\t1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005)\u0001/\u001b9fg&\u0011QD\u0007\u0002\u000e!&\u0004X\rR3d_J\fGo\u001c:\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\nA\u0002Z1uC\n\f7/Z%oM>\u0004\"!\t\u0015\u000e\u0003\tR!a\t\u0013\u0002\u000f\u0019\f7\r^8ss*\u0011QEJ\u0001\u0005S6\u0004HN\u0003\u0002(\u0019\u000511.\u001a:oK2L!!\u000b\u0012\u0003\u0019\u0011\u000bG/\u00192bg\u0016LeNZ8\t\u0011-\u0002!\u0011!Q\u0001\n1\nQa\u001d;biN\u0004\"!\f\u0018\u000e\u0003\tI!a\f\u0002\u0003;%sG/\u001a:qe\u0016$X\r\u001a)s_\u001aLG.Z%oM>\u0014X.\u0019;j_:DQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtDcA\u001a5kA\u0011Q\u0006\u0001\u0005\u0006?A\u0002\r\u0001\t\u0005\u0006WA\u0002\r\u0001\f\u0005\bo\u0001\u0001\r\u0011\"\u00039\u0003)\u0001\u0018M]3oiBK\u0007/Z\u000b\u0002sA\u00191C\u000f\u001f\n\u0005m\"\"AB(qi&|g\u000e\u0005\u0002\u001a{%\u0011aH\u0007\u0002\u0005!&\u0004X\rC\u0004A\u0001\u0001\u0007I\u0011B!\u0002\u001dA\f'/\u001a8u!&\u0004Xm\u0018\u0013fcR\u0011!)\u0012\t\u0003'\rK!\u0001\u0012\u000b\u0003\tUs\u0017\u000e\u001e\u0005\b\r~\n\t\u00111\u0001:\u0003\rAH%\r\u0005\u0007\u0011\u0002\u0001\u000b\u0015B\u001d\u0002\u0017A\f'/\u001a8u!&\u0004X\r\t\u0005\b\u0015\u0002\u0001\r\u0011\"\u0003L\u0003-\u0001H.\u00198JIN#\u0018mY6\u0016\u00031\u00032!T+Y\u001d\tq5K\u0004\u0002P%6\t\u0001K\u0003\u0002R!\u00051AH]8pizJ\u0011!F\u0005\u0003)R\tq\u0001]1dW\u0006<W-\u0003\u0002W/\n!A*[:u\u0015\t!F\u0003\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006Y\u0011\r\u001e;sS\n,H/[8o\u0015\tif,\u0001\u0003vi&d'BA0\t\u0003\u00111Hg\u0018\u0019\n\u0005\u0005T&AA%e\u0011\u001d\u0019\u0007\u00011A\u0005\n\u0011\fq\u0002\u001d7b]&#7\u000b^1dW~#S-\u001d\u000b\u0003\u0005\u0016DqA\u00122\u0002\u0002\u0003\u0007A\n\u0003\u0004h\u0001\u0001\u0006K\u0001T\u0001\ra2\fg.\u00133Ti\u0006\u001c7\u000e\t\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0003Ea\u0017m\u001d;PEN,'O^3e'R\fGo]\u000b\u0002WB\u0011Q\u0006\\\u0005\u0003[\n\u0011a\u0002U1hK\u000e\u000b7\r[3Ti\u0006$8\u000fC\u0004p\u0001\u0001\u0007I\u0011\u00029\u0002+1\f7\u000f^(cg\u0016\u0014h/\u001a3Ti\u0006$8o\u0018\u0013fcR\u0011!)\u001d\u0005\b\r:\f\t\u00111\u0001l\u0011\u0019\u0019\b\u0001)Q\u0005W\u0006\u0011B.Y:u\u001f\n\u001cXM\u001d<fIN#\u0018\r^:!\u0011\u0015)\b\u0001\"\u0003w\u0003\u0001\u001aH/\u0019:u\u0003\u000e\u001cw.\u001e8uS:<\u0007+Y4f\u0007\u0006\u001c\u0007.Z*uCR\u001chi\u001c:\u0015\u0007\t;x\u0010C\u0003yi\u0002\u0007\u00110A\tti\u0006$\u0018n\u001d;jGB\u0013xN^5eKJ\u0004\"A_?\u000e\u0003mT!\u0001 \u0005\u0002\u0013A\u0014xNZ5mS:<\u0017B\u0001@|\u0005]YUM\u001d8fYN#\u0018\r^5ti&\u001c\u0007K]8wS\u0012,'\u000f\u0003\u0004\u0002\u0002Q\u0004\r\u0001W\u0001\u0003S\u0012Dq!!\u0002\u0001\t\u0013\t9!A\u0010ti>\u0004\u0018iY2pk:$\u0018N\\4QC\u001e,7)Y2iKN#\u0018\r^:G_J$RAQA\u0005\u0003\u0017Aa\u0001_A\u0002\u0001\u0004I\bbBA\u0001\u0003\u0007\u0001\r\u0001\u0017\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0003e)\b\u000fZ1uKB\u000bw-Z\"bG\",7\u000b^1uSN$\u0018nY:\u0015\u000b\t\u000b\u0019\"a\u0006\t\u000f\u0005U\u0011Q\u0002a\u00011\u00061\u0001/\u001b9f\u0013\u0012D\u0001\"!\u0007\u0002\u000e\u0001\u0007\u00111D\u0001\u0002MB11#!\bz1\nK1!a\b\u0015\u0005%1UO\\2uS>t'\u0007C\u0004\u0002$\u0001!\t!!\n\u0002\u0011\u0011,7m\u001c:bi\u0016$b!a\n\u00026\u0005e\u0002#B'\u0002*\u00055\u0012bAA\u0016/\nA\u0011\n^3sCR|'\u000f\u0005\u0003\u00020\u0005ER\"\u0001\u0004\n\u0007\u0005MbA\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"9\u0011qGA\u0011\u0001\u0004a\u0014\u0001\u00029ja\u0016D\u0001\"a\u000f\u0002\"\u0001\u0007\u0011qE\u0001\u0005SR,'\u000fC\u0004\u0002$\u0001!\t!a\u0010\u0015\r\u0005\u0005\u0013qIA%!\rI\u00121I\u0005\u0004\u0003\u000bR\"AC)vKJL8\u000b^1uK\"9\u0011qGA\u001f\u0001\u0004a\u0004\u0002CA&\u0003{\u0001\r!!\u0011\u0002\u000bM$\u0018\r^3\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R\u0005\u0011\u0012M\u001a;fe\u000e\u0013X-\u0019;f%\u0016\u001cX\u000f\u001c;t)\u0015\u0011\u00151KA+\u0011\u001d\t9$!\u0014A\u0002qB\u0001\"a\u0013\u0002N\u0001\u0007\u0011\u0011\t\u0005\b\u00033\u0002A\u0011BA.\u0003M!(/Y2l!\u0006<WmQ1dQ\u0016\u001cF/\u0019;t+\t\ti\u0006E\u0002\u0014\u0003?J1!!\u0019\u0015\u0005\u001d\u0011un\u001c7fC:Dq!!\u001a\u0001\t\u0003\t9'\u0001\bj]:,'\u000fR3d_J\fGo\u001c:\u0015\u0007a\tI\u0007C\u0004\u0002l\u0005\r\u0004\u0019\u0001\u001f\u0002\u0015=<h.\u001b8h!&\u0004X\rC\u0004\u0002p\u0001!\t!!\u001d\u0002%I,w-[:uKJ\u0004\u0016M]3oiBK\u0007/\u001a\u000b\u0004\u0005\u0006M\u0004bBA\u001c\u0003[\u0002\r\u0001\u0010")
public class Profiler
implements PipeDecorator {
    private final DatabaseInfo databaseInfo;
    private final InterpretedProfileInformation stats;
    private Option<Pipe> parentPipe;
    private List<Id> planIdStack;
    private PageCacheStats lastObservedStats;

    @Override
    public Iterator<ExecutionContext> decorate(Pipe pipe, Iterator<ExecutionContext> iter, Iterator<ExecutionContext> sourceIter) {
        return PipeDecorator.decorate$((PipeDecorator)this, pipe, iter, sourceIter);
    }

    @Override
    public Iterator<ExecutionContext> decorate(Pipe pipe, Iterator<ExecutionContext> iter, Function0<Option<ExecutionContext>> previousContextSupplier) {
        return PipeDecorator.decorate$((PipeDecorator)this, pipe, iter, previousContextSupplier);
    }

    private Option<Pipe> parentPipe() {
        return this.parentPipe;
    }

    private void parentPipe_$eq(Option<Pipe> x$1) {
        this.parentPipe = x$1;
    }

    private List<Id> planIdStack() {
        return this.planIdStack;
    }

    private void planIdStack_$eq(List<Id> x$1) {
        this.planIdStack = x$1;
    }

    private PageCacheStats lastObservedStats() {
        return this.lastObservedStats;
    }

    private void lastObservedStats_$eq(PageCacheStats x$1) {
        this.lastObservedStats = x$1;
    }

    private void startAccountingPageCacheStatsFor(KernelStatisticProvider statisticProvider, int id) {
        PageCacheStats currentStats = new PageCacheStats(statisticProvider.getPageCacheHits(), statisticProvider.getPageCacheMisses());
        this.planIdStack().headOption().foreach((Function1 & Serializable & scala.Serializable)previousId -> {
            Profiler.$anonfun$startAccountingPageCacheStatsFor$1(this, currentStats, ((Id)previousId).x());
            return BoxedUnit.UNIT;
        });
        this.planIdStack_$eq((List<Id>)this.planIdStack().$colon$colon((Object)new Id(id)));
        this.lastObservedStats_$eq(currentStats);
    }

    private void stopAccountingPageCacheStatsFor(KernelStatisticProvider statisticProvider, int id) {
        List<Id> list = this.planIdStack();
        if (!(list instanceof .colon.colon)) {
            throw new MatchError(list);
        }
        .colon.colon colon2 = (.colon.colon)list;
        int head = ((Id)colon2.head()).x();
        List rest = colon2.tl$access$1();
        Tuple2 tuple2 = new Tuple2((Object)new Id(head), (Object)rest);
        Tuple2 tuple22 = tuple2;
        int head2 = ((Id)tuple22._1()).x();
        List rest2 = (List)tuple22._2();
        if (AssertionRunner.isAssertionsEnabled() && head2 != id) {
            throw new IllegalStateException(new StringBuilder(98).append("We messed up accounting the page cache statistics. Expected to pop ").append(new Id(id)).append(" but popped ").append(new Id(head2)).append(". Remaining stack: ").append(this.planIdStack()).toString());
        }
        PageCacheStats currentStats = new PageCacheStats(statisticProvider.getPageCacheHits(), statisticProvider.getPageCacheMisses());
        this.stats.pageCacheMap().update((Object)new Id(id), (Object)((PageCacheStats)this.stats.pageCacheMap().apply((Object)new Id(id))).$plus(currentStats.$minus(this.lastObservedStats())));
        this.planIdStack_$eq((List<Id>)rest2);
        this.lastObservedStats_$eq(currentStats);
    }

    private void updatePageCacheStatistics(int pipeId, Function2<KernelStatisticProvider, Id, BoxedUnit> f) {
        ProfilingPipeQueryContext context = (ProfilingPipeQueryContext)this.stats.dbHitsMap().apply((Object)new Id(pipeId));
        KernelStatisticProvider statisticProvider = context.transactionalContext().kernelStatisticProvider();
        f.apply((Object)statisticProvider, (Object)new Id(pipeId));
    }

    @Override
    public Iterator<ExecutionContext> decorate(Pipe pipe, Iterator<ExecutionContext> iter) {
        long oldCount = BoxesRunTime.unboxToLong((Object)this.stats.rowMap().get((Object)new Id(pipe.id())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.count())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        ProfilingIterator resultIter = new ProfilingIterator(iter, oldCount, pipe.id(), (Function1<Id, BoxedUnit>)(this.trackPageCacheStats() ? (Function1 & Serializable & scala.Serializable)x$3 -> {
            this.updatePageCacheStatistics(((Id)x$3).x(), (Function2<KernelStatisticProvider, Id, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(statisticProvider, id) -> {
                $this.startAccountingPageCacheStatsFor(statisticProvider, ((Id)id).x());
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)x$4 -> {
            Profiler.$anonfun$decorate$5(((Id)x$4).x());
            return BoxedUnit.UNIT;
        }), (Function1<Id, BoxedUnit>)(this.trackPageCacheStats() ? (Function1 & Serializable & scala.Serializable)x$5 -> {
            this.updatePageCacheStatistics(((Id)x$5).x(), (Function2<KernelStatisticProvider, Id, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(statisticProvider, id) -> {
                $this.stopAccountingPageCacheStatsFor(statisticProvider, ((Id)id).x());
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)x$6 -> {
            Profiler.$anonfun$decorate$8(((Id)x$6).x());
            return BoxedUnit.UNIT;
        }));
        this.stats.rowMap().update((Object)new Id(pipe.id()), (Object)resultIter);
        return resultIter;
    }

    @Override
    public QueryState decorate(Pipe pipe, QueryState state) {
        ProfilingPipeQueryContext decoratedContext;
        block0: {
            decoratedContext = (ProfilingPipeQueryContext)this.stats.dbHitsMap().getOrElseUpdate((Object)new Id(pipe.id()), (Function0 & Serializable & scala.Serializable)() -> {
                ProfilingPipeQueryContext profilingPipeQueryContext;
                QueryContext queryContext = state.query();
                if (queryContext instanceof ProfilingPipeQueryContext) {
                    ProfilingPipeQueryContext profilingPipeQueryContext2 = (ProfilingPipeQueryContext)queryContext;
                    profilingPipeQueryContext = new ProfilingPipeQueryContext(profilingPipeQueryContext2.inner(), pipe);
                } else {
                    profilingPipeQueryContext = new ProfilingPipeQueryContext(state.query(), pipe);
                }
                return profilingPipeQueryContext;
            });
            if (!this.trackPageCacheStats()) break block0;
            this.startAccountingPageCacheStatsFor(decoratedContext.transactionalContext().kernelStatisticProvider(), pipe.id());
        }
        return state.withQueryContext(decoratedContext);
    }

    @Override
    public void afterCreateResults(Pipe pipe, QueryState state) {
        block0: {
            if (!this.trackPageCacheStats()) break block0;
            this.stopAccountingPageCacheStatsFor(state.query().transactionalContext().kernelStatisticProvider(), pipe.id());
        }
    }

    private boolean trackPageCacheStats() {
        Edition edition = this.databaseInfo.edition;
        Edition edition2 = Edition.COMMUNITY;
        return edition == null ? edition2 != null : !edition.equals(edition2);
    }

    @Override
    public PipeDecorator innerDecorator(Pipe owningPipe) {
        return new PipeDecorator(this, owningPipe){
            private final /* synthetic */ Profiler $outer;
            private final Pipe owningPipe$1;

            public Iterator<ExecutionContext> decorate(Pipe pipe, Iterator<ExecutionContext> iter, Iterator<ExecutionContext> sourceIter) {
                return PipeDecorator.decorate$((PipeDecorator)this, pipe, iter, sourceIter);
            }

            public Iterator<ExecutionContext> decorate(Pipe pipe, Iterator<ExecutionContext> iter, Function0<Option<ExecutionContext>> previousContextSupplier) {
                return PipeDecorator.decorate$((PipeDecorator)this, pipe, iter, previousContextSupplier);
            }

            public PipeDecorator innerDecorator(Pipe pipe) {
                return this;
            }

            public QueryState decorate(Pipe pipe, QueryState state) {
                return this.$outer.decorate(this.owningPipe$1, state);
            }

            public Iterator<ExecutionContext> decorate(Pipe pipe, Iterator<ExecutionContext> iter) {
                return iter;
            }

            public void afterCreateResults(Pipe pipe, QueryState state) {
                this.$outer.afterCreateResults(this.owningPipe$1, state);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.owningPipe$1 = owningPipe$1;
                PipeDecorator.$init$(this);
            }
        };
    }

    public void registerParentPipe(Pipe pipe) {
        this.parentPipe_$eq((Option<Pipe>)new Some((Object)pipe));
    }

    public static final /* synthetic */ void $anonfun$startAccountingPageCacheStatsFor$1(Profiler $this, PageCacheStats currentStats$1, int previousId) {
        $this.stats.pageCacheMap().update((Object)new Id(previousId), (Object)((PageCacheStats)$this.stats.pageCacheMap().apply((Object)new Id(previousId))).$plus(currentStats$1.$minus($this.lastObservedStats())));
    }

    public static final /* synthetic */ void $anonfun$decorate$5(int x$4) {
    }

    public static final /* synthetic */ void $anonfun$decorate$8(int x$6) {
    }

    public Profiler(DatabaseInfo databaseInfo, InterpretedProfileInformation stats) {
        this.databaseInfo = databaseInfo;
        this.stats = stats;
        PipeDecorator.$init$(this);
        this.parentPipe = None$.MODULE$;
        this.planIdStack = Nil$.MODULE$;
        this.lastObservedStats = new PageCacheStats(0L, 0L);
    }
}

