/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import org.neo4j.cypher.internal.runtime.CRS$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.DistanceCalculator;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.DistanceCalculator$class;
import org.neo4j.values.virtual.PointValue;
import scala.Option;

public final class HaversinCalculator$
implements DistanceCalculator {
    public static final HaversinCalculator$ MODULE$;
    private final double EARTH_RADIUS_METERS;

    static {
        new HaversinCalculator$();
    }

    @Override
    public Option<Object> apply(PointValue p1, PointValue p2) {
        return DistanceCalculator$class.apply(this, p1, p2);
    }

    private double EARTH_RADIUS_METERS() {
        return this.EARTH_RADIUS_METERS;
    }

    @Override
    public boolean isDefinedAt(PointValue p1, PointValue p2) {
        return p1.getCoordinateReferenceSystem().code() == CRS$.MODULE$.WGS84().code() && p2.getCoordinateReferenceSystem().code == CRS$.MODULE$.WGS84().code();
    }

    @Override
    public double calculateDistance(PointValue p1, PointValue p2) {
        double[] c1Coord = p1.coordinates();
        double[] c2Coord = p2.coordinates();
        double[] c1 = new double[]{Math.toRadians(c1Coord[0]), Math.toRadians(c1Coord[1])};
        double[] c2 = new double[]{Math.toRadians(c2Coord[0]), Math.toRadians(c2Coord[1])};
        double dx = c2[0] - c1[0];
        double dy = c2[1] - c1[1];
        double a = Math.pow(Math.sin(dy / (double)2), 2.0) + Math.cos(c1[1]) * Math.cos(c2[1]) * Math.pow(Math.sin(dx / 2.0), 2.0);
        double greatCircleDistance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return this.EARTH_RADIUS_METERS() * greatCircleDistance;
    }

    private HaversinCalculator$() {
        MODULE$ = this;
        DistanceCalculator$class.$init$(this);
        this.EARTH_RADIUS_METERS = 6378140.0;
    }
}

