/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted;

import org.neo4j.cypher.internal.planner.v3_4.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.v3_4.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.v3_4.spi.StatisticsCompletingGraphStatistics;
import org.neo4j.cypher.internal.runtime.interpreted.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.runtime.interpreted.IndexDescriptorCompatibility$class;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundGraphStatistics$;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundTokenContext;
import org.neo4j.cypher.internal.util.v3_4.Cardinality;
import org.neo4j.cypher.internal.util.v3_4.Cardinality$;
import org.neo4j.cypher.internal.util.v3_4.LabelId;
import org.neo4j.cypher.internal.util.v3_4.NameId;
import org.neo4j.cypher.internal.util.v3_4.NameId$;
import org.neo4j.cypher.internal.util.v3_4.RelTypeId;
import org.neo4j.cypher.internal.util.v3_4.Selectivity;
import org.neo4j.cypher.internal.util.v3_4.Selectivity$;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import scala.None$;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m<Q!\u0001\u0002\t\u0002=\tq\u0004\u0016:b]N\f7\r^5p]\n{WO\u001c3He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0015\t\u0019A!A\u0006j]R,'\u000f\u001d:fi\u0016$'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u0011%tG/\u001a:oC2T!!\u0003\u0006\u0002\r\rL\b\u000f[3s\u0015\tYA\"A\u0003oK>$$NC\u0001\u000e\u0003\ry'oZ\u0002\u0001!\t\u0001\u0012#D\u0001\u0003\r\u0015\u0011\"\u0001#\u0001\u0014\u0005}!&/\u00198tC\u000e$\u0018n\u001c8C_VtGm\u0012:ba\"\u001cF/\u0019;jgRL7m]\n\u0003#Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0012\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u0015q\u0012\u0003\"\u0001 \u0003\u0015\t\u0007\u000f\u001d7z)\t\u0001#\u0006\u0005\u0002\"Q5\t!E\u0003\u0002$I\u0005\u00191\u000f]5\u000b\u0005\u00152\u0013\u0001\u0002<4?RR!a\n\u0004\u0002\u000fAd\u0017M\u001c8fe&\u0011\u0011F\t\u0002$'R\fG/[:uS\u000e\u001c8i\\7qY\u0016$\u0018N\\4He\u0006\u0004\bn\u0015;bi&\u001cH/[2t\u0011\u0015YS\u00041\u0001-\u0003\ry\u0007o\u001d\t\u0003[Ij\u0011A\f\u0006\u0003_A\n1!\u00199j\u0015\t\t$\"\u0001\u0004lKJtW\r\\\u0005\u0003g9\u0012aBU3bI>\u0003XM]1uS>t7O\u0002\u00036#\u00111$a\t\"bg\u0016$&/\u00198tC\u000e$\u0018n\u001c8C_VtGm\u0012:ba\"\u001cF/\u0019;jgRL7m]\n\u0005iQ9$\b\u0005\u0002\"q%\u0011\u0011H\t\u0002\u0010\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dgB\u0011\u0001cO\u0005\u0003y\t\u0011A$\u00138eKb$Um]2sSB$xN]\"p[B\fG/\u001b2jY&$\u0018\u0010\u0003\u0005?i\t\u0005\t\u0015!\u0003-\u0003)y\u0007/\u001a:bi&|gn\u001d\u0005\u00067Q\"\t\u0001\u0011\u000b\u0003\u0003\u000e\u0003\"A\u0011\u001b\u000e\u0003EAQAP A\u00021BQ!\u0012\u001b\u0005\u0002\u0019\u000b\u0001#\u001b8eKb\u001cV\r\\3di&4\u0018\u000e^=\u0015\u0005\u001d\u000b\u0006cA\u000bI\u0015&\u0011\u0011J\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-{U\"\u0001'\u000b\u0005\u0015j%B\u0001(\u0007\u0003\u0011)H/\u001b7\n\u0005Ac%aC*fY\u0016\u001cG/\u001b<jifDQA\u0015#A\u0002M\u000bQ!\u001b8eKb\u0004\"!\t+\n\u0005U\u0013#aD%oI\u0016DH)Z:de&\u0004Ho\u001c:\t\u000b]#D\u0011\u0001-\u0002=%tG-\u001a=Qe>\u0004XM\u001d;z\u000bbL7\u000f^:TK2,7\r^5wSRLHCA$Z\u0011\u0015\u0011f\u000b1\u0001T\u0011\u0015YF\u0007\"\u0001]\u0003eqw\u000eZ3t/&$\b\u000eT1cK2\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=\u0015\u0005u\u0003\u0007CA&_\u0013\tyFJA\u0006DCJ$\u0017N\\1mSRL\b\"B1[\u0001\u0004\u0011\u0017a\u00027bE\u0016d\u0017\n\u001a\t\u0004+!\u001b\u0007CA&e\u0013\t)GJA\u0004MC\n,G.\u00133\t\u000b\u001d$D\u0011\u00015\u0002M\r\f'\u000fZ5oC2LG/\u001f\"z\u0019\u0006\u0014W\r\\:B]\u0012\u0014V\r\\1uS>t7\u000f[5q)f\u0004X\r\u0006\u0003^S.\f\b\"\u00026g\u0001\u0004\u0011\u0017!\u00034s_6d\u0015MY3m\u0011\u0015ag\r1\u0001n\u0003%\u0011X\r\u001c+za\u0016LE\rE\u0002\u0016\u0011:\u0004\"aS8\n\u0005Ad%!\u0003*fYRK\b/Z%e\u0011\u0015\u0011h\r1\u0001c\u0003\u001d!x\u000eT1cK2DQ\u0001\u001e\u001b\u0005\nU\f!\"\u0019;MK\u0006\u001cHo\u00148f)\tif\u000fC\u0003xg\u0002\u0007\u00010A\u0003d_VtG\u000f\u0005\u0002\u0016s&\u0011!P\u0006\u0002\u0007\t>,(\r\\3")
public final class TransactionBoundGraphStatistics {
    public static StatisticsCompletingGraphStatistics apply(ReadOperations readOperations) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(readOperations);
    }

    public static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics,
    IndexDescriptorCompatibility {
        private final ReadOperations operations;

        @Override
        public org.neo4j.kernel.api.schema.index.IndexDescriptor cypherToKernel(IndexDescriptor index) {
            return IndexDescriptorCompatibility$class.cypherToKernel(this, index);
        }

        @Override
        public IndexDescriptor kernelToCypher(org.neo4j.kernel.api.schema.index.IndexDescriptor index) {
            return IndexDescriptorCompatibility$class.kernelToCypher(this, index);
        }

        @Override
        public LabelSchemaDescriptor cypherToKernelSchema(IndexDescriptor index) {
            return IndexDescriptorCompatibility$class.cypherToKernelSchema(this, index);
        }

        @Override
        public LabelSchemaDescriptor toLabelSchemaDescriptor(int labelId, Seq<Object> propertyKeyIds) {
            return IndexDescriptorCompatibility$class.toLabelSchemaDescriptor(this, labelId, propertyKeyIds);
        }

        @Override
        public LabelSchemaDescriptor toLabelSchemaDescriptor(TransactionBoundTokenContext tc, String labelName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility$class.toLabelSchemaDescriptor(this, tc, labelName, propertyKeys);
        }

        public Option<Selectivity> indexSelectivity(IndexDescriptor index) {
            None$ none$;
            try {
                double labeledNodes = this.operations.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)index.label()));
                double indexEntrySelectivity = this.operations.indexUniqueValuesSelectivity(this.cypherToKernel(index));
                double frequencyOfNodesWithSameValue = 1.0 / indexEntrySelectivity;
                double indexSelectivity = frequencyOfNodesWithSameValue / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Option<Selectivity> indexPropertyExistsSelectivity(IndexDescriptor index) {
            None$ none$;
            try {
                double labeledNodes = this.operations.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode((NameId)index.label()));
                long indexSize = this.operations.indexSize(this.cypherToKernel(index));
                double indexSelectivity = (double)indexSize / labeledNodes;
                none$ = Selectivity$.MODULE$.of(indexSelectivity);
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> labelId) {
            return this.atLeastOne(this.operations.countsForNodeWithoutTxState(NameId$.MODULE$.toKernelEncode(labelId)));
        }

        public Cardinality cardinalityByLabelsAndRelationshipType(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return this.atLeastOne(this.operations.countsForRelationshipWithoutTxState(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        private Cardinality atLeastOne(double count) {
            return count < 1.0 ? Cardinality$.MODULE$.SINGLE() : new Cardinality(count);
        }

        public BaseTransactionBoundGraphStatistics(ReadOperations operations) {
            this.operations = operations;
            IndexDescriptorCompatibility$class.$init$(this);
        }
    }
}

