/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class GraphDatabaseCypherService
implements GraphDatabaseQueryService {
    private final GraphDatabaseFacade graph;
    private final DbmsOperations dbmsOperations;

    public GraphDatabaseCypherService(GraphDatabaseService graph) {
        this.graph = (GraphDatabaseFacade)graph;
        this.dbmsOperations = (DbmsOperations)this.getDependencyResolver().resolveDependency(DbmsOperations.class);
    }

    public DependencyResolver getDependencyResolver() {
        return this.graph.getDependencyResolver();
    }

    public Node createNode() {
        return this.graph.createNode();
    }

    public Long createNodeId() {
        return this.graph.createNodeId();
    }

    public Node createNode(Label ... labels2) {
        return this.graph.createNode(labels2);
    }

    public Node getNodeById(long id) {
        return this.graph.getNodeById(id);
    }

    public Relationship getRelationshipById(long id) {
        return this.graph.getRelationshipById(id);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, SecurityContext securityContext) {
        return this.graph.beginTransaction(type, securityContext);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, SecurityContext securityContext, long timeout, TimeUnit unit) {
        return this.graph.beginTransaction(type, securityContext, timeout, unit);
    }

    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.graph.validateURLAccess(url);
    }

    public DbmsOperations getDbmsOperations() {
        return this.dbmsOperations;
    }

    public GraphDatabaseFacade getGraphDatabaseService() {
        return this.graph;
    }
}

