/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.INTERNAL, since="1.0")
public abstract class TypedSubtree<T extends Visitable>
implements Visitable {
    protected final List<T> children;

    @SafeVarargs
    protected TypedSubtree(T ... children) {
        this.children = Arrays.asList(children);
    }

    protected TypedSubtree(Collection<T> children) {
        this.children = new ArrayList<T>(children);
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.enter(this);
        this.children.forEach(child -> this.prepareVisit(child).accept(visitor));
        visitor.leave(this);
    }

    protected Visitable prepareVisit(T child) {
        return child;
    }
}

