/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.HasLabelCondition;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.ParameterCollectingVisitor;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyContainer;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.StatementCatalog;
import org.neo4j.cypherdsl.core.StatementContext;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.ReflectiveVisitor;
import org.neo4j.cypherdsl.core.internal.ScopingStrategy;

@RegisterForReflection
class StatementCatalogBuildingVisitor
extends ReflectiveVisitor {
    private static final String TYPE_OF_COMPOUND_CONDITION = "org.neo4j.cypherdsl.core.CompoundCondition";
    private final AtomicReference<StatementCatalog.Clause> currentClause = new AtomicReference<StatementCatalog.Clause>(StatementCatalog.Clause.UNKNOWN);
    private final Deque<PatternElement> currentPatternElement = new ArrayDeque<PatternElement>();
    private final Set<StatementCatalog.Token> tokens = new HashSet<StatementCatalog.Token>();
    private final Set<StatementCatalog.Property> properties = new HashSet<StatementCatalog.Property>();
    private final Set<StatementCatalog.LabelFilter> labelFilters = new HashSet<StatementCatalog.LabelFilter>();
    private final Map<StatementCatalog.Property, Set<StatementCatalog.PropertyFilter>> propertyFilters = new HashMap<StatementCatalog.Property, Set<StatementCatalog.PropertyFilter>>();
    private final Deque<Map<SymbolicName, PatternElement>> patternLookup = new ArrayDeque<Map<SymbolicName, PatternElement>>();
    private final Deque<Condition> currentConditions = new ArrayDeque<Condition>();
    private final AtomicReference<Set<StatementCatalog.Token>> currentHasLabelCondition = new AtomicReference();
    private final StatementContext statementContext;
    private final boolean renderConstantsAsParameters;
    private final ScopingStrategy scopingStrategy;
    private final ParameterCollectingVisitor allParameters;

    StatementCatalogBuildingVisitor(StatementContext statementContext, boolean renderConstantsAsParameters) {
        this.statementContext = statementContext;
        this.renderConstantsAsParameters = renderConstantsAsParameters;
        this.scopingStrategy = ScopingStrategy.create(List.of((cause, imports) -> this.patternLookup.push(this.createNewScope((Collection<IdentifiableElement>)imports))), List.of((cause, exports) -> this.importIntoCurrentScope((Collection<IdentifiableElement>)exports)));
        this.patternLookup.push(new HashMap());
        this.allParameters = new ParameterCollectingVisitor(statementContext, renderConstantsAsParameters);
    }

    private Map<SymbolicName, PatternElement> createNewScope(Collection<IdentifiableElement> imports) {
        Map<SymbolicName, PatternElement> currentScope = this.patternLookup.isEmpty() ? Collections.emptyMap() : this.patternLookup.peek();
        HashMap<SymbolicName, PatternElement> newScope = new HashMap<SymbolicName, PatternElement>();
        StatementCatalogBuildingVisitor.copyIdentifiableElements(imports, currentScope, newScope);
        return newScope;
    }

    private void importIntoCurrentScope(Collection<IdentifiableElement> exports) {
        Map<SymbolicName, PatternElement> previousScope = this.patternLookup.pop();
        HashMap<SymbolicName, PatternElement> currentScope = this.patternLookup.isEmpty() ? new HashMap() : this.patternLookup.peek();
        StatementCatalogBuildingVisitor.copyIdentifiableElements(exports, previousScope, currentScope);
    }

    private static void copyIdentifiableElements(Collection<IdentifiableElement> elements, Map<SymbolicName, PatternElement> source, Map<SymbolicName, PatternElement> target) {
        for (IdentifiableElement e : elements) {
            SymbolicName s;
            if (e instanceof SymbolicName && source.containsKey(s = (SymbolicName)e)) {
                target.put(s, source.get(s));
                continue;
            }
            if (!(e instanceof Named)) continue;
            Named n = (Named)e;
            if (!(e instanceof PatternElement)) continue;
            PatternElement p = (PatternElement)((Object)e);
            target.put(n.getRequiredSymbolicName(), p);
        }
    }

    StatementCatalog getResult() {
        ParameterCollectingVisitor.ParameterInformation parameterInformation = this.allParameters.getResult();
        return new DefaultStatementCatalog(this.tokens, this.labelFilters, this.properties, this.propertyFilters, this.scopingStrategy.getIdentifiables(), parameterInformation);
    }

    @Override
    protected boolean preEnter(Visitable visitable) {
        this.scopingStrategy.doEnter(visitable);
        return true;
    }

    @Override
    protected void postLeave(Visitable visitable) {
        this.scopingStrategy.doLeave(visitable);
    }

    void enter(Match match) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.MATCH);
    }

    void leave(Match match) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.MATCH, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Create create) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.CREATE);
    }

    void leave(Create create) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.CREATE, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Merge merge) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.MERGE);
    }

    void leave(Merge merge) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.MERGE, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Delete delete) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.DELETE);
    }

    void leave(Delete delete) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.DELETE, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(With with) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.WITH);
    }

    void leave(With with) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.WITH, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Node node) {
        node.getSymbolicName().ifPresent(s -> this.store((SymbolicName)s, node));
        this.currentPatternElement.push(node);
    }

    void enter(KeyValueMapEntry mapEntry) {
        StatementCatalog.Property property;
        PatternElement owner = this.currentPatternElement.peek();
        if (owner == null) {
            return;
        }
        if (owner instanceof Node) {
            Node node = (Node)owner;
            property = new StatementCatalog.Property(node.getLabels().stream().map(StatementCatalog.Token::label).collect(Collectors.toSet()), mapEntry.getKey());
        } else if (owner instanceof Relationship) {
            Relationship relationship = (Relationship)owner;
            property = new StatementCatalog.Property(relationship.getDetails().getTypes().stream().map(StatementCatalog.Token::type).collect(Collectors.toSet()), mapEntry.getKey());
        } else {
            property = null;
        }
        if (property == null) {
            return;
        }
        this.properties.add(property);
        Expression left = ((PropertyContainer)((Object)owner)).getSymbolicName().isPresent() ? ((PropertyContainer)((Object)owner)).property(mapEntry.getKey()) : PropertyLookup.forName(mapEntry.getKey());
        ParameterCollectingVisitor.ParameterInformation parameterInformation = this.extractParameters(mapEntry.getValue());
        this.propertyFilters.computeIfAbsent(property, ignored -> new HashSet()).add(new StatementCatalog.PropertyFilter(this.currentClause.get(), left, Operator.EQUALITY, mapEntry.getValue(), parameterInformation.names, parameterInformation.values));
    }

    void leave(Node node) {
        this.currentPatternElement.removeFirstOccurrence(node);
    }

    void enter(Relationship relationship) {
        relationship.getSymbolicName().ifPresent(s -> this.store((SymbolicName)s, relationship));
        this.currentPatternElement.push(relationship);
    }

    void leave(Relationship relationship) {
        this.currentPatternElement.removeFirstOccurrence(relationship);
    }

    void enter(Property property) {
        StatementCatalog.Property newProperty;
        if (property.getNames().size() != 1) {
            return;
        }
        PropertyLookup lookup = property.getNames().get(0);
        if (lookup.isDynamicLookup()) {
            return;
        }
        Expression expression = property.getContainerReference();
        if (!(expression instanceof SymbolicName)) {
            return;
        }
        SymbolicName s = (SymbolicName)expression;
        AtomicReference propertyName = new AtomicReference();
        lookup.accept(segment -> {
            if (segment instanceof SymbolicName) {
                SymbolicName name = (SymbolicName)segment;
                propertyName.compareAndSet(null, name.getValue());
            }
        });
        PatternElement patternElement = this.lookup(s);
        if (patternElement instanceof Node) {
            Node node = (Node)patternElement;
            newProperty = new StatementCatalog.Property(node.getLabels().stream().map(NodeLabel::getValue).map(StatementCatalog.Token::label).collect(Collectors.toSet()), (String)propertyName.get());
        } else if (patternElement instanceof Relationship) {
            Relationship relationship = (Relationship)patternElement;
            newProperty = new StatementCatalog.Property(relationship.getDetails().getTypes().stream().map(StatementCatalog.Token::type).collect(Collectors.toSet()), (String)propertyName.get());
        } else {
            return;
        }
        this.properties.add(newProperty);
        if (this.inCurrentCondition(property)) {
            this.propertyFilters.computeIfAbsent(newProperty, ignored -> new HashSet()).add(this.extractPropertyCondition(newProperty, this.currentConditions.peek()));
        }
    }

    void enter(Parameter<?> parameter) {
        this.allParameters.enter(parameter);
    }

    private boolean inCurrentCondition(Property property) {
        Condition currentCondition = this.currentConditions.peek();
        if (currentCondition == null) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean();
        currentCondition.accept(segment -> {
            if (segment == property) {
                result.compareAndSet(false, true);
            }
        });
        return result.get();
    }

    private StatementCatalog.PropertyFilter extractPropertyCondition(StatementCatalog.Property property, Condition condition) {
        final AtomicReference left = new AtomicReference();
        final AtomicReference op = new AtomicReference();
        final AtomicReference right = new AtomicReference();
        condition.accept(new Visitor(){
            int cnt;

            @Override
            public void enter(Visitable segment) {
                Expression expression;
                if (++this.cnt != 2) {
                    return;
                }
                if (segment instanceof Operator) {
                    Operator operator = (Operator)segment;
                    op.compareAndSet(null, operator);
                } else if (segment instanceof Expression && !left.compareAndSet(null, expression = (Expression)segment)) {
                    right.compareAndSet(null, expression);
                }
            }

            @Override
            public void leave(Visitable segment) {
                --this.cnt;
            }
        });
        ParameterCollectingVisitor.ParameterInformation parameterInformation = this.extractParameters((Expression)left.get(), (Expression)right.get());
        return new StatementCatalog.PropertyFilter(this.currentClause.get(), (Expression)left.get(), (Operator)op.get(), (Expression)right.get(), parameterInformation.names, parameterInformation.values);
    }

    void enter(NodeLabel label) {
        this.tokens.add(new StatementCatalog.Token(StatementCatalog.Token.Type.NODE_LABEL, label.getValue()));
        Condition currentCondition = this.currentConditions.peek();
        if (currentCondition instanceof HasLabelCondition) {
            HasLabelCondition hasLabelCondition = (HasLabelCondition)currentCondition;
            this.currentHasLabelCondition.get().add(StatementCatalog.Token.label(label));
        }
    }

    void enter(Relationship.Details details) {
        details.getTypes().stream().map(StatementCatalog.Token::type).forEach(this.tokens::add);
    }

    PatternElement lookup(SymbolicName s) {
        if (this.patternLookup.isEmpty()) {
            throw new IllegalStateException("Invalid scope");
        }
        return this.patternLookup.peek().get(s);
    }

    void enter(Condition condition) {
        if (TYPE_OF_COMPOUND_CONDITION.equals(condition.getClass().getName())) {
            return;
        }
        this.currentConditions.push(condition);
        if (condition instanceof HasLabelCondition) {
            this.currentHasLabelCondition.compareAndSet(null, new TreeSet());
        }
    }

    void leave(Condition condition) {
        if (TYPE_OF_COMPOUND_CONDITION.equals(condition.getClass().getName())) {
            return;
        }
        this.currentConditions.pop();
        Set setOfRequiredTokens = this.currentHasLabelCondition.getAndSet(null);
        if (condition instanceof HasLabelCondition) {
            HasLabelCondition hasLabelCondition = (HasLabelCondition)condition;
            if (setOfRequiredTokens != null) {
                AtomicReference symbolicName = new AtomicReference();
                hasLabelCondition.accept(segment -> {
                    if (segment instanceof SymbolicName) {
                        SymbolicName s = (SymbolicName)segment;
                        symbolicName.compareAndSet(null, s.getValue());
                    }
                });
                this.labelFilters.add(new StatementCatalog.LabelFilter((String)symbolicName.get(), setOfRequiredTokens));
            }
        }
    }

    void store(SymbolicName s, PatternElement patternElement) {
        if (this.patternLookup.isEmpty()) {
            throw new IllegalStateException("Invalid scope");
        }
        Map<SymbolicName, PatternElement> currentScope = this.patternLookup.peek();
        if (currentScope.containsKey(s) && this.scopingStrategy.getCurrentImports().contains(s)) {
            return;
        }
        currentScope.put(s, patternElement);
    }

    private ParameterCollectingVisitor.ParameterInformation extractParameters(Expression ... expressions) {
        ParameterCollectingVisitor parameterCollectingVisitor = new ParameterCollectingVisitor(this.statementContext, this.renderConstantsAsParameters);
        for (Expression expression : expressions) {
            if (expression == null) continue;
            expression.accept(parameterCollectingVisitor);
        }
        return parameterCollectingVisitor.getResult();
    }

    static final class DefaultStatementCatalog
    implements StatementCatalog {
        private final Set<StatementCatalog.Token> tokens;
        private final Set<StatementCatalog.Property> properties;
        private final Collection<StatementCatalog.LabelFilter> labelFilters;
        private final Map<StatementCatalog.Property, Collection<StatementCatalog.PropertyFilter>> propertyFilters;
        private final Set<Expression> identifiableExpressions;
        private final ParameterCollectingVisitor.ParameterInformation parameterInformation;

        DefaultStatementCatalog(Set<StatementCatalog.Token> tokens, Set<StatementCatalog.LabelFilter> labelFilters, Set<StatementCatalog.Property> properties, Map<StatementCatalog.Property, Set<StatementCatalog.PropertyFilter>> propertyFilters, Collection<Expression> identifiableExpressions, ParameterCollectingVisitor.ParameterInformation parameterInformation) {
            this.tokens = Set.copyOf(tokens);
            this.labelFilters = Set.copyOf(labelFilters);
            this.properties = Set.copyOf(properties);
            this.propertyFilters = propertyFilters.entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, e -> Set.copyOf((Collection)e.getValue())), Map::copyOf));
            this.identifiableExpressions = Set.copyOf(identifiableExpressions);
            this.parameterInformation = parameterInformation;
        }

        public Set<StatementCatalog.Token> getAllTokens() {
            return this.tokens;
        }

        public Set<StatementCatalog.Property> getProperties() {
            return this.properties;
        }

        @Override
        public Collection<StatementCatalog.LabelFilter> getAllLabelFilters() {
            return this.labelFilters;
        }

        @Override
        public Map<StatementCatalog.Property, Collection<StatementCatalog.PropertyFilter>> getAllPropertyFilters() {
            return this.propertyFilters;
        }

        public Set<Expression> getIdentifiableExpressions() {
            return this.identifiableExpressions;
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameterInformation.values;
        }

        @Override
        public Collection<String> getParameterNames() {
            return this.parameterInformation.names;
        }

        @Override
        public Map<String, String> getRenamedParameters() {
            return this.parameterInformation.renames;
        }
    }
}

