/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.annotations.CheckReturnValue;

@API(status=API.Status.STABLE, since="2020.0.1")
public interface ExposesCall<T> {
    @NotNull
    @CheckReturnValue
    public T call(String ... var1);

    public static interface ExposesYield<T> {
        @NotNull
        @CheckReturnValue
        default public T yield(String ... yieldedItems) {
            SymbolicName[] names = new SymbolicName[]{};
            if (yieldedItems != null) {
                names = (SymbolicName[])Arrays.stream(yieldedItems).map(SymbolicName::of).toArray(SymbolicName[]::new);
            }
            return this.yield(names);
        }

        @NotNull
        @CheckReturnValue
        default public T yield(Named ... yieldedItems) {
            SymbolicName[] names = new SymbolicName[]{};
            if (yieldedItems != null) {
                names = (SymbolicName[])Arrays.stream(yieldedItems).map(Named::getRequiredSymbolicName).toArray(SymbolicName[]::new);
            }
            return this.yield(names);
        }

        @NotNull
        @CheckReturnValue
        public T yield(SymbolicName ... var1);

        @NotNull
        @CheckReturnValue
        public T yield(AliasedExpression ... var1);
    }

    public static interface AsFunction {
        @NotNull
        @Contract(pure=true)
        default public Expression asFunction() {
            return this.asFunction(false);
        }

        @NotNull
        @Contract(pure=true)
        public Expression asFunction(boolean var1);
    }

    public static interface ExposesWithArgs<T> {
        @NotNull
        @CheckReturnValue
        public T withArgs(Expression ... var1);
    }
}

