/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class ExecutorBasedCaffeineCacheFactory$ {
    public static final ExecutorBasedCaffeineCacheFactory$ MODULE$ = new ExecutorBasedCaffeineCacheFactory$();

    public <K, V> Cache<K, V> createCache(Executor executor, int size) {
        return Caffeine.newBuilder().executor(executor).maximumSize((long)size).build();
    }

    public <K, V> Cache<K, V> createCache(Executor executor, RemovalListener<K, V> removalListener, int size) {
        return Caffeine.newBuilder().executor(executor).maximumSize((long)size).evictionListener(removalListener).build();
    }

    public <K, V> Cache<K, V> createCache(Executor executor, int size, long ttlAfterAccess) {
        return Caffeine.newBuilder().executor(executor).maximumSize((long)size).expireAfterAccess(ttlAfterAccess, TimeUnit.MILLISECONDS).build();
    }

    public <K, V> Cache<K, V> createCache(Executor executor, Ticker ticker, long ttlAfterWrite, int size) {
        return Caffeine.newBuilder().executor(executor).maximumSize((long)size).ticker(ticker).expireAfterWrite(ttlAfterWrite, TimeUnit.MILLISECONDS).build();
    }

    private ExecutorBasedCaffeineCacheFactory$() {
    }
}

