/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;

public class Extractors {
    private final Map<String, Extractor<?>> instances = new HashMap();
    private final Extractor<String> string;
    private final LongExtractor long_;
    private final IntExtractor int_;
    private final CharExtractor char_;
    private final ShortExtractor short_;
    private final ByteExtractor byte_;
    private final BooleanExtractor boolean_;
    private final FloatExtractor float_;
    private final DoubleExtractor double_;
    private final Extractor<String[]> stringArray;
    private final Extractor<boolean[]> booleanArray;
    private final Extractor<byte[]> byteArray;
    private final Extractor<short[]> shortArray;
    private final Extractor<int[]> intArray;
    private final Extractor<long[]> longArray;
    private final Extractor<float[]> floatArray;
    private final Extractor<double[]> doubleArray;
    private static final char[] BOOLEAN_MATCH = new char[Boolean.TRUE.toString().length()];
    private static final char[] BOOLEAN_TRUE_CHARACTERS;

    public Extractors(char arrayDelimiter) {
        this(arrayDelimiter, Configuration.DEFAULT.emptyQuotedStringsAsNull(), Configuration.DEFAULT.trimStrings());
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull) {
        this(arrayDelimiter, emptyStringsAsNull, Configuration.DEFAULT.trimStrings());
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull, boolean trimStrings) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (!Modifier.isStatic(field.getModifiers()) || !((value = field.get(null)) instanceof Extractor)) continue;
                this.instances.put(field.getName(), (Extractor)value);
            }
            this.string = new StringExtractor(emptyStringsAsNull, trimStrings);
            this.add(this.string);
            this.long_ = new LongExtractor();
            this.add(this.long_);
            this.int_ = new IntExtractor();
            this.add(this.int_);
            this.char_ = new CharExtractor();
            this.add(this.char_);
            this.short_ = new ShortExtractor();
            this.add(this.short_);
            this.byte_ = new ByteExtractor();
            this.add(this.byte_);
            this.boolean_ = new BooleanExtractor();
            this.add(this.boolean_);
            this.float_ = new FloatExtractor();
            this.add(this.float_);
            this.double_ = new DoubleExtractor();
            this.add(this.double_);
            this.stringArray = new StringArrayExtractor(arrayDelimiter, trimStrings);
            this.add(this.stringArray);
            this.booleanArray = new BooleanArrayExtractor(arrayDelimiter);
            this.add(this.booleanArray);
            this.byteArray = new ByteArrayExtractor(arrayDelimiter);
            this.add(this.byteArray);
            this.shortArray = new ShortArrayExtractor(arrayDelimiter);
            this.add(this.shortArray);
            this.intArray = new IntArrayExtractor(arrayDelimiter);
            this.add(this.intArray);
            this.longArray = new LongArrayExtractor(arrayDelimiter);
            this.add(this.longArray);
            this.floatArray = new FloatArrayExtractor(arrayDelimiter);
            this.add(this.floatArray);
            this.doubleArray = new DoubleArrayExtractor(arrayDelimiter);
            this.add(this.doubleArray);
        }
        catch (IllegalAccessException e) {
            throw new Error("Bug in reflection code gathering all extractors");
        }
    }

    public void add(Extractor<?> extractor) {
        this.instances.put(extractor.toString().toUpperCase(), extractor);
    }

    public Extractor<?> valueOf(String name) {
        Extractor<?> instance = this.instances.get(name.toUpperCase());
        if (instance == null) {
            throw new IllegalArgumentException("'" + name + "'");
        }
        return instance;
    }

    public Extractor<String> string() {
        return this.string;
    }

    public LongExtractor long_() {
        return this.long_;
    }

    public IntExtractor int_() {
        return this.int_;
    }

    public CharExtractor char_() {
        return this.char_;
    }

    public ShortExtractor short_() {
        return this.short_;
    }

    public ByteExtractor byte_() {
        return this.byte_;
    }

    public BooleanExtractor boolean_() {
        return this.boolean_;
    }

    public FloatExtractor float_() {
        return this.float_;
    }

    public DoubleExtractor double_() {
        return this.double_;
    }

    public Extractor<String[]> stringArray() {
        return this.stringArray;
    }

    public Extractor<boolean[]> booleanArray() {
        return this.booleanArray;
    }

    public Extractor<byte[]> byteArray() {
        return this.byteArray;
    }

    public Extractor<short[]> shortArray() {
        return this.shortArray;
    }

    public Extractor<int[]> intArray() {
        return this.intArray;
    }

    public Extractor<long[]> longArray() {
        return this.longArray;
    }

    public Extractor<float[]> floatArray() {
        return this.floatArray;
    }

    public Extractor<double[]> doubleArray() {
        return this.doubleArray;
    }

    private static long extractLong(char[] data, int originalOffset, int fullLength) {
        int length;
        long result = 0L;
        boolean negate = false;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length > 0 && data[offset] == '-') {
            negate = true;
            ++offset;
            --length;
        }
        if (length < 1) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        try {
            for (int i = 0; i < length; ++i) {
                result = result * 10L + (long)Extractors.digit(data[offset + i]);
            }
        }
        catch (NumberFormatException ignored) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        return negate ? -result : result;
    }

    private static int digit(char ch) {
        int digit = ch - 48;
        if (digit < 0 || digit > 9) {
            throw new NumberFormatException();
        }
        return digit;
    }

    private static boolean extractBoolean(char[] data, int originalOffset, int fullLength) {
        int length;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length != BOOLEAN_TRUE_CHARACTERS.length) {
            return false;
        }
        for (int i = 0; i < BOOLEAN_TRUE_CHARACTERS.length && i < length; ++i) {
            if (data[offset + i] == BOOLEAN_TRUE_CHARACTERS[i]) continue;
            return false;
        }
        return true;
    }

    private static int safeCastLongToInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (int)value;
    }

    private static short safeCastLongToShort(long value) {
        if (value > 32767L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (short)value;
    }

    private static byte safeCastLongToByte(long value) {
        if (value > 127L) {
            throw new UnsupportedOperationException("Not supported a.t.m");
        }
        return (byte)value;
    }

    static {
        Boolean.TRUE.toString().getChars(0, BOOLEAN_MATCH.length, BOOLEAN_MATCH, 0);
        BOOLEAN_TRUE_CHARACTERS = new char[Boolean.TRUE.toString().length()];
        Boolean.TRUE.toString().getChars(0, BOOLEAN_TRUE_CHARACTERS.length, BOOLEAN_TRUE_CHARACTERS, 0);
    }

    private static class BooleanArrayExtractor
    extends ArrayExtractor<boolean[]> {
        private static final boolean[] EMPTY = new boolean[0];

        BooleanArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Boolean.TYPE);
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new boolean[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((boolean[])this.value)[arrayIndex] = Extractors.extractBoolean(data, offset + charIndex, numberOfChars);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class DoubleArrayExtractor
    extends ArrayExtractor<double[]> {
        private static final double[] EMPTY = new double[0];

        DoubleArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Double.TYPE);
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new double[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((double[])this.value)[arrayIndex] = Double.parseDouble(String.valueOf(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class FloatArrayExtractor
    extends ArrayExtractor<float[]> {
        private static final float[] EMPTY = new float[0];

        FloatArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Float.TYPE);
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new float[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((float[])this.value)[arrayIndex] = Float.parseFloat(String.valueOf(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class LongArrayExtractor
    extends ArrayExtractor<long[]> {
        LongArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Long.TYPE);
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new long[numberOfValues] : PrimitiveLongCollections.EMPTY_LONG_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((long[])this.value)[arrayIndex] = Extractors.extractLong(data, offset + charIndex, numberOfChars);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class IntArrayExtractor
    extends ArrayExtractor<int[]> {
        private static final int[] EMPTY = new int[0];

        IntArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Integer.TYPE);
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new int[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((int[])this.value)[arrayIndex] = Extractors.safeCastLongToInt(Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class ShortArrayExtractor
    extends ArrayExtractor<short[]> {
        private static final short[] EMPTY = new short[0];

        ShortArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Short.TYPE);
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new short[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((short[])this.value)[arrayIndex] = Extractors.safeCastLongToShort(Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class ByteArrayExtractor
    extends ArrayExtractor<byte[]> {
        private static final byte[] EMPTY = new byte[0];

        ByteArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Byte.TYPE);
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new byte[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((byte[])this.value)[arrayIndex] = Extractors.safeCastLongToByte(Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class StringArrayExtractor
    extends ArrayExtractor<String[]> {
        private static final String[] EMPTY = new String[0];
        private final boolean trimStrings;

        StringArrayExtractor(char arrayDelimiter, boolean trimStrings) {
            super(arrayDelimiter, String.class);
            this.trimStrings = trimStrings;
        }

        @Override
        protected void extract0(char[] data, int offset, int length) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new String[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((String[])this.value)[arrayIndex] = new String(data, offset + charIndex, numberOfChars);
                if (this.trimStrings) {
                    ((String[])this.value)[arrayIndex] = ((String[])this.value)[arrayIndex].trim();
                }
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static abstract class ArrayExtractor<T>
    extends AbstractExtractor<T> {
        protected final char arrayDelimiter;
        protected T value;

        ArrayExtractor(char arrayDelimiter, Class<?> componentType) {
            super(componentType.getSimpleName() + "[]");
            this.arrayDelimiter = arrayDelimiter;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public boolean extract(char[] data, int offset, int length, boolean skippedChars) {
            this.extract0(data, offset, length);
            return true;
        }

        protected abstract void extract0(char[] var1, int var2, int var3);

        protected int charsToNextDelimiter(char[] data, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                return i;
            }
            return length;
        }

        protected int numberOfValues(char[] data, int offset, int length) {
            int count = length > 0 ? 1 : 0;
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                ++count;
            }
            return count;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return this.getClass().equals(obj.getClass());
        }
    }

    public static class DoubleExtractor
    extends AbstractSingleValueExtractor<Double> {
        private double value;

        DoubleExtractor() {
            super(Double.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = 0.0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            try {
                this.value = Double.parseDouble(String.valueOf(data, offset, length));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
            return true;
        }

        @Override
        public Double value() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }
    }

    public static class FloatExtractor
    extends AbstractSingleValueExtractor<Float> {
        private float value;

        FloatExtractor() {
            super(Float.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = 0.0f;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            try {
                this.value = Float.parseFloat(String.valueOf(data, offset, length));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
            return true;
        }

        @Override
        public Float value() {
            return Float.valueOf(this.value);
        }

        public float floatValue() {
            return this.value;
        }
    }

    public static class CharExtractor
    extends AbstractSingleValueExtractor<Character> {
        private char value;

        CharExtractor() {
            super(Character.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = '\u0000';
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            if (length > 1) {
                throw new IllegalStateException("Was told to extract a character, but length:" + length);
            }
            this.value = data[offset];
            return true;
        }

        @Override
        public Character value() {
            return Character.valueOf(this.value);
        }

        public char charValue() {
            return this.value;
        }
    }

    public static class BooleanExtractor
    extends AbstractSingleValueExtractor<Boolean> {
        private boolean value;

        BooleanExtractor() {
            super(Boolean.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = false;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            this.value = Extractors.extractBoolean(data, offset, length);
            return true;
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        public boolean booleanValue() {
            return this.value;
        }
    }

    public static class ByteExtractor
    extends AbstractSingleValueExtractor<Byte> {
        private byte value;

        ByteExtractor() {
            super(Byte.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = 0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            this.value = Extractors.safeCastLongToByte(Extractors.extractLong(data, offset, length));
            return true;
        }

        @Override
        public Byte value() {
            return this.value;
        }

        public int byteValue() {
            return this.value;
        }
    }

    public static class ShortExtractor
    extends AbstractSingleValueExtractor<Short> {
        private short value;

        ShortExtractor() {
            super(Short.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = 0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            this.value = Extractors.safeCastLongToShort(Extractors.extractLong(data, offset, length));
            return true;
        }

        @Override
        public Short value() {
            return this.value;
        }

        public short shortValue() {
            return this.value;
        }
    }

    public static class IntExtractor
    extends AbstractSingleValueExtractor<Integer> {
        private int value;

        IntExtractor() {
            super(Integer.TYPE.toString());
        }

        @Override
        protected void clear() {
            this.value = 0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            this.value = Extractors.safeCastLongToInt(Extractors.extractLong(data, offset, length));
            return true;
        }

        @Override
        public Integer value() {
            return this.value;
        }

        public int intValue() {
            return this.value;
        }
    }

    public static class LongExtractor
    extends AbstractSingleValueExtractor<Long> {
        private long value;

        LongExtractor() {
            super(Long.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = 0L;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            this.value = Extractors.extractLong(data, offset, length);
            return true;
        }

        @Override
        public Long value() {
            return this.value;
        }

        public long longValue() {
            return this.value;
        }
    }

    public static class StringExtractor
    extends AbstractSingleValueExtractor<String> {
        private String value;
        private final boolean emptyStringsAsNull;
        private final boolean trimStrings;

        public StringExtractor(boolean emptyStringsAsNull, boolean trimStrings) {
            super(String.class.getSimpleName());
            this.emptyStringsAsNull = emptyStringsAsNull;
            this.trimStrings = trimStrings;
        }

        @Override
        protected void clear() {
            this.value = null;
        }

        @Override
        protected boolean nullValue(int length, boolean skippedChars) {
            return length == 0 && (!skippedChars || this.emptyStringsAsNull);
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length) {
            this.value = new String(data, offset, length);
            if (this.trimStrings) {
                this.value = this.value.trim();
            }
            return true;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    private static abstract class AbstractSingleValueExtractor<T>
    extends AbstractExtractor<T> {
        AbstractSingleValueExtractor(String toString) {
            super(toString);
        }

        @Override
        public final boolean extract(char[] data, int offset, int length, boolean skippedChars) {
            if (this.nullValue(length, skippedChars)) {
                this.clear();
                return false;
            }
            return this.extract0(data, offset, length);
        }

        protected boolean nullValue(int length, boolean skippedChars) {
            return length == 0;
        }

        protected abstract void clear();

        protected abstract boolean extract0(char[] var1, int var2, int var3);
    }

    private static abstract class AbstractExtractor<T>
    implements Extractor<T> {
        private final String toString;

        AbstractExtractor(String toString) {
            this.toString = toString;
        }

        @Override
        public String toString() {
            return this.toString;
        }

        @Override
        public Extractor<T> clone() {
            try {
                return (Extractor)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError(Extractor.class.getName() + " implements " + Cloneable.class.getSimpleName() + ", at least this implementation assumes that. This doesn't seem to be the case anymore", e);
            }
        }
    }
}

