/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.neo4j.collection.RawIterator;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.MultiReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.function.IOFunction;
import org.neo4j.function.RawFunction;

public class Readables {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int GZIP_MAGIC = 8075;
    public static final CharReadable EMPTY = new CharReadable.Adapter(){

        @Override
        public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
            return buffer;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public String sourceDescription() {
            return "EMPTY";
        }
    };
    private static final IOFunction<File, Reader> FROM_FILE = new IOFunction<File, Reader>(){

        public Reader apply(final File file) throws IOException {
            int magic = this.magic(file);
            if (magic == 1347093252) {
                ZipFile zipFile = new ZipFile(file);
                ZipEntry entry = this.getSingleSuitableEntry(zipFile);
                return new InputStreamReader(zipFile.getInputStream(entry)){

                    public String toString() {
                        return file.getPath();
                    }
                };
            }
            if (magic >>> 16 == 8075) {
                GZIPInputStream zipStream = new GZIPInputStream(new FileInputStream(file));
                return new InputStreamReader(zipStream){

                    public String toString() {
                        return file.getPath();
                    }
                };
            }
            return new FileReader(file){

                public String toString() {
                    return file.getPath();
                }
            };
        }

        private ZipEntry getSingleSuitableEntry(ZipFile zipFile) throws IOException {
            ArrayList<String> unsuitableEntries = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry found = null;
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.isDirectory() || Readables.invalidZipEntry(entry.getName())) {
                    unsuitableEntries.add(entry.getName());
                    continue;
                }
                if (found != null) {
                    throw new IOException("Multiple suitable files found in zip file " + zipFile.getName() + ", at least " + found.getName() + " and " + entry.getName() + ". Only a single file per zip file is supported");
                }
                found = entry;
            }
            if (found == null) {
                throw new IOException("No suitable file found in zip file " + zipFile.getName() + "." + (!unsuitableEntries.isEmpty() ? " Although found these unsuitable entries " + unsuitableEntries : ""));
            }
            return found;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int magic(File file) throws IOException {
            try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
                int n = in.readInt();
                return n;
            }
            catch (EOFException e) {
                return -1;
            }
        }
    };
    private static final IOFunction<Reader, Reader> IDENTITY = new IOFunction<Reader, Reader>(){

        public Reader apply(Reader in) {
            return in;
        }
    };

    private Readables() {
        throw new AssertionError((Object)"No instances allowed");
    }

    public static CharReadable wrap(final Reader reader) {
        return new CharReadable.Adapter(){
            private long position;
            private final String sourceDescription;
            {
                this.sourceDescription = reader.toString();
            }

            @Override
            public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
                buffer.compact(buffer, from);
                buffer.readFrom(reader);
                this.position += (long)buffer.available();
                return buffer;
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }

            @Override
            public long position() {
                return this.position;
            }

            @Override
            public String sourceDescription() {
                return this.sourceDescription;
            }
        };
    }

    private static boolean invalidZipEntry(String name) {
        return name.contains("__MACOSX") || name.startsWith(".") || name.contains("/.");
    }

    public static CharReadable file(File file) throws IOException {
        return Readables.wrap((Reader)FROM_FILE.apply((Object)file));
    }

    public static CharReadable multipleFiles(File ... files) throws IOException {
        return new MultiReadable(Readables.iterator(files, FROM_FILE));
    }

    public static CharReadable multipleSources(Reader ... sources) throws IOException {
        return new MultiReadable(Readables.iterator(sources, IDENTITY));
    }

    public static CharReadable multipleFiles(Iterator<File> files) throws IOException {
        return new MultiReadable(Readables.iterator(files, FROM_FILE));
    }

    public static CharReadable multipleSources(RawIterator<Reader, IOException> sources) throws IOException {
        return new MultiReadable(sources);
    }

    private static <IN, OUT> RawIterator<OUT, IOException> iterator(final Iterator<IN> items, final RawFunction<IN, OUT, IOException> converter) {
        return new RawIterator<OUT, IOException>(){

            public boolean hasNext() {
                return items.hasNext();
            }

            public OUT next() throws IOException {
                return converter.apply(items.next());
            }

            public void remove() {
                items.remove();
            }
        };
    }

    private static <IN, OUT> RawIterator<OUT, IOException> iterator(final IN[] items, final RawFunction<IN, OUT, IOException> converter) {
        if (items.length == 0) {
            throw new IllegalStateException("No source items specified");
        }
        return new RawIterator<OUT, IOException>(){
            private int cursor;

            public boolean hasNext() {
                return this.cursor < items.length;
            }

            public OUT next() throws IOException {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                return converter.apply(items[this.cursor++]);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

